/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.tools.development.BackgroundThreadFactory;
import com.google.appengine.tools.development.RequestEndListener;
import com.google.appengine.tools.development.RequestThreadFactory;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.config.AppEngineWebXml;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class LocalEnvironment
implements ApiProxy.Environment {
    private static final Logger logger = Logger.getLogger(LocalEnvironment.class.getName());
    private static final String APPS_NAMESPACE_KEY = NamespaceManager.class.getName() + ".appsNamespace";
    static final String API_CALL_SEMAPHORE = "com.google.appengine.tools.development.api_call_semaphore";
    public static final String REQUEST_ID = "com.google.appengine.tools.development.request_id";
    public static final String START_TIME_ATTR = "com.google.appengine.tools.development.start_time";
    public static final String REQUEST_END_LISTENERS = "com.google.appengine.tools.development.request_end_listeners";
    private static final String REQUEST_THREAD_FACTORY_ATTR = "com.google.appengine.api.ThreadManager.REQUEST_THREAD_FACTORY";
    private static final String BACKGROUND_THREAD_FACTORY_ATTR = "com.google.appengine.api.ThreadManager.BACKGROUND_THREAD_FACTORY";
    private final AppEngineWebXml appEngineWebXml;
    private final Collection<RequestEndListener> requestEndListeners;
    protected final ConcurrentMap<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private static final String REQUEST_ID_PREFIX = "" + System.currentTimeMillis();
    private static AtomicInteger requestID = new AtomicInteger();

    protected LocalEnvironment(AppEngineWebXml appEngineWebXml) {
        this.appEngineWebXml = appEngineWebXml;
        this.requestEndListeners = Collections.newSetFromMap(new ConcurrentHashMap(10));
        this.attributes.put(REQUEST_ID, this.generateRequestId());
        this.attributes.put(REQUEST_END_LISTENERS, this.requestEndListeners);
        this.attributes.put(START_TIME_ATTR, new Date());
        this.attributes.put(REQUEST_THREAD_FACTORY_ATTR, new RequestThreadFactory());
        this.attributes.put(BACKGROUND_THREAD_FACTORY_ATTR, new BackgroundThreadFactory(appEngineWebXml));
    }

    private String generateRequestId() {
        return REQUEST_ID_PREFIX + "," + requestID.getAndIncrement();
    }

    public String getAppId() {
        return this.appEngineWebXml.getAppId();
    }

    public String getVersionId() {
        return this.appEngineWebXml.getMajorVersionId() + ".1";
    }

    public String getAuthDomain() {
        return "gmail.com";
    }

    @Deprecated
    public final String getRequestNamespace() {
        String appsNamespace = (String)this.getAttributes().get(APPS_NAMESPACE_KEY);
        return appsNamespace == null ? "" : appsNamespace;
    }

    public ConcurrentMap<String, Object> getAttributes() {
        return this.attributes;
    }

    void callRequestEndListeners() {
        for (RequestEndListener listener : this.requestEndListeners) {
            try {
                listener.onRequestEnd(this);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Exception while attempting to invoke RequestEndListener " + listener.getClass() + ": ", ex);
            }
        }
    }
}

