/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.net.sourceforge.yamlbeans.YamlException;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.YamlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.QueueXml;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class QueueYamlReader {
    private static final String FILENAME = "queue.yaml";
    private String appDir;

    public QueueYamlReader(String appDir) {
        if (appDir.length() > 0 && appDir.charAt(appDir.length() - 1) != File.separatorChar) {
            appDir = appDir + File.separatorChar;
        }
        this.appDir = appDir;
    }

    public String getFilename() {
        return this.appDir + FILENAME;
    }

    public QueueXml parse() {
        if (new File(this.getFilename()).exists()) {
            try {
                return QueueYamlReader.parse(new FileReader(this.getFilename()));
            }
            catch (FileNotFoundException ex) {
                throw new AppEngineConfigException("Cannot find file " + this.getFilename(), ex);
            }
        }
        return null;
    }

    public static QueueXml parse(Reader yaml) {
        YamlReader reader = new YamlReader(yaml);
        reader.getConfig().setPropertyElementType(QueueYaml.class, "queue", QueueYaml.Entry.class);
        reader.getConfig().setPropertyElementType(QueueYaml.Entry.class, "acl", QueueYaml.AclEntry.class);
        try {
            QueueYaml queueYaml = reader.read(QueueYaml.class);
            if (queueYaml == null) {
                throw new AppEngineConfigException("Empty queue configuration.");
            }
            return queueYaml.toXml();
        }
        catch (YamlException ex) {
            throw new AppEngineConfigException(ex.getMessage(), ex);
        }
    }

    public static QueueXml parse(String yaml) {
        return QueueYamlReader.parse(new StringReader(yaml));
    }

    public static class QueueYaml {
        private List<Entry> entries;
        public String total_storage_limit;

        public List<Entry> getQueue() {
            return this.entries;
        }

        public void setQueue(List<Entry> entries) {
            this.entries = entries;
        }

        public QueueXml toXml() {
            QueueXml xml = new QueueXml();
            if (this.total_storage_limit != null) {
                xml.setTotalStorageLimit(this.total_storage_limit);
            }
            if (this.entries != null) {
                for (Entry entry : this.entries) {
                    xml.addEntry(entry.toXml());
                }
            }
            return xml;
        }

        public static class Entry {
            private QueueXml.Entry entry = new QueueXml.Entry();
            private RetryParameters retryParameters;
            private List<AclEntry> acl;

            public void setName(String name) {
                this.entry.setName(name);
            }

            public String getName() {
                return this.entry.getName();
            }

            public void setRate(String rate) {
                this.entry.setRate(rate);
            }

            public String getRate() {
                return this.entry.getRate() + "/" + this.entry.getRateUnit().getIdent();
            }

            public void setBucket_size(int size) {
                this.entry.setBucketSize(size);
            }

            public int getBucket_size() {
                return this.entry.getBucketSize();
            }

            public void setMax_concurrent_requests(int size) {
                this.entry.setMaxConcurrentRequests(size);
            }

            public int getMax_concurrent_requests() {
                return this.entry.getMaxConcurrentRequests();
            }

            public void setRetry_parameters(RetryParameters retryParameters) {
                this.retryParameters = retryParameters;
                if (retryParameters != null) {
                    this.entry.setRetryParameters(retryParameters.toXml());
                } else {
                    this.entry.setRetryParameters(new QueueXml.RetryParameters());
                }
            }

            public RetryParameters getRetry_parameters() {
                return this.retryParameters;
            }

            public void setTarget(String target) {
                this.entry.setTarget(target);
            }

            public String getTarget() {
                return this.entry.getTarget();
            }

            public void setMode(String mode) {
                this.entry.setMode(mode);
            }

            public String getMode() {
                return this.entry.getMode();
            }

            public void setAcl(List<AclEntry> acl) {
                this.acl = acl;
                this.entry.setAcl(new ArrayList<QueueXml.AclEntry>());
                if (acl != null) {
                    for (int i = 0; i < acl.size(); ++i) {
                        AclEntry aclEntry = acl.get(i);
                        this.entry.addAcl(aclEntry.toXml());
                    }
                }
            }

            public List<AclEntry> getAcl() {
                return this.acl;
            }

            public QueueXml.Entry toXml() {
                return this.entry;
            }
        }

        public static class AclEntry {
            QueueXml.AclEntry acl = new QueueXml.AclEntry();

            public void setUser_email(String userEmail) {
                this.acl.setUserEmail(userEmail);
            }

            public String getUser_email() {
                return this.acl.getUserEmail();
            }

            public QueueXml.AclEntry toXml() {
                return this.acl;
            }
        }

        public static class RetryParameters {
            private QueueXml.RetryParameters retryParameters = new QueueXml.RetryParameters();

            public void setTask_retry_limit(int limit) {
                this.retryParameters.setRetryLimit(limit);
            }

            public int getTask_retry_limit() {
                return this.retryParameters.getRetryLimit();
            }

            public void setTask_age_limit(String ageLimit) {
                this.retryParameters.setAgeLimitSec(ageLimit);
            }

            public String getTask_age_limit() {
                return this.retryParameters.getAgeLimitSec().toString() + "s";
            }

            public void setMin_backoff_seconds(double backoff) {
                this.retryParameters.setMinBackoffSec(backoff);
            }

            public double getMin_backoff_seconds() {
                return this.retryParameters.getMinBackoffSec();
            }

            public void setMax_backoff_seconds(double backoff) {
                this.retryParameters.setMaxBackoffSec(backoff);
            }

            public double getMax_backoff_seconds() {
                return this.retryParameters.getMaxBackoffSec();
            }

            public void setMax_doublings(int doublings) {
                this.retryParameters.setMaxDoublings(doublings);
            }

            public int getMax_doublings() {
                return this.retryParameters.getMaxDoublings();
            }

            public QueueXml.RetryParameters toXml() {
                return this.retryParameters;
            }
        }
    }
}

