/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.remoteapi;

import com.google.apphosting.api.ApiProxy;
import java.util.List;
import java.util.concurrent.Future;

class ThreadLocalDelegate<E extends ApiProxy.Environment>
implements ApiProxy.Delegate<E> {
    private final ApiProxy.Delegate<E> globalDelegate;
    private final ThreadLocal<ApiProxy.Delegate<E>> threadLocalDelegate;

    ThreadLocalDelegate(ApiProxy.Delegate<E> globalDelegate, ApiProxy.Delegate<E> threadDelegate) {
        this.globalDelegate = globalDelegate;
        this.threadLocalDelegate = new ThreadLocal();
        this.threadLocalDelegate.set(threadDelegate);
    }

    ApiProxy.Delegate<E> getDelegate() {
        ApiProxy.Delegate<E> result = this.threadLocalDelegate.get();
        if (result == null) {
            result = this.globalDelegate;
        }
        return result;
    }

    public byte[] makeSyncCall(E environment, String pkg, String method, byte[] bytes) throws ApiProxy.ApiProxyException {
        return this.getDelegate().makeSyncCall(environment, pkg, method, bytes);
    }

    public Future<byte[]> makeAsyncCall(E environment, String pkg, String method, byte[] bytes, ApiProxy.ApiConfig apiConfig) {
        return this.getDelegate().makeAsyncCall(environment, pkg, method, bytes, apiConfig);
    }

    public void log(E environment, ApiProxy.LogRecord logRecord) {
        this.getDelegate().log(environment, logRecord);
    }

    public void flushLogs(E environment) {
        this.getDelegate().flushLogs(environment);
    }

    public List<Thread> getRequestThreads(E environment) {
        return this.getDelegate().getRequestThreads(environment);
    }

    ApiProxy.Delegate<E> getDelegateForThread() {
        return this.threadLocalDelegate.get();
    }

    void setDelegateForThread(ApiProxy.Delegate<E> delegate) {
        this.threadLocalDelegate.set(delegate);
    }

    void clearThreadDelegate() {
        this.threadLocalDelegate.remove();
    }
}

