/*
 * Decompiled with CFR 0.152.
 */
package play.modules.googleclosure;

import com.google.template.soy.SoyFileSet;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.modules.googleclosure.ClosureTemplate;
import play.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClosurePlugin
extends PlayPlugin {
    private Map<String, ClosureTemplate> templates = new HashMap<String, ClosureTemplate>();

    private void scanSoyPath(VirtualFile path, List<ClosureTemplate> modifiedTemplates) {
        if (path.isDirectory()) {
            for (VirtualFile subpath : path.list()) {
                this.scanSoyPath(subpath, modifiedTemplates);
            }
        } else if (path.getName().endsWith(".soy") && !path.getName().startsWith(".")) {
            ClosureTemplate tpl = this.templates.get(path.getName());
            if (tpl != null) {
                if (tpl.timestamp < path.lastModified()) {
                    modifiedTemplates.add(tpl);
                }
            } else {
                tpl = new ClosureTemplate(path.getName(), path);
                tpl.timestamp = path.lastModified();
                this.templates.put(path.getName(), tpl);
                modifiedTemplates.add(tpl);
            }
        }
    }

    private List<ClosureTemplate> scanSoyPaths() {
        ArrayList<ClosureTemplate> modifiedTemplates = new ArrayList<ClosureTemplate>();
        for (VirtualFile path : Play.templatesPath) {
            this.scanSoyPath(path, modifiedTemplates);
        }
        return modifiedTemplates;
    }

    private void compileSoyTemplates(List<ClosureTemplate> sourceTemplates) {
        SoyFileSet.Builder builder = new SoyFileSet.Builder();
        for (ClosureTemplate tpl : sourceTemplates) {
            VirtualFile tplFile = tpl.templateFile;
            VirtualFile tplJs = VirtualFile.open((String)("public/javascripts/" + tplFile.getName().substring(0, tplFile.getName().lastIndexOf(".soy")) + ".js"));
            builder.add(tplFile.getRealFile());
            tpl.jsFile = tplJs;
        }
        SoyFileSet soyFileSet = builder.build();
        SoyJsSrcOptions options = new SoyJsSrcOptions();
        List res = soyFileSet.compileToJsSrc(options, null);
        for (int i = 0; i < sourceTemplates.size(); ++i) {
            try {
                ClosureTemplate tpl = sourceTemplates.get(i);
                File f = tpl.jsFile.getRealFile();
                f.getParentFile().mkdirs();
                Logger.debug((String)"ClosurePlugin : Soy2JS compiled %s into %s", (Object[])new Object[]{tpl.templateFile.relativePath(), tpl.jsFile.relativePath()});
                FileWriter fw = new FileWriter(f);
                fw.write((String)res.get(i));
                fw.close();
                tpl.timestamp = tpl.jsFile.lastModified();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void scan() {
        List<ClosureTemplate> modifiedTemplates = this.scanSoyPaths();
        if (modifiedTemplates != null && modifiedTemplates.size() != 0) {
            Logger.debug((String)"ClosurePlugin : change detected", (Object[])new Object[0]);
            this.compileSoyTemplates(modifiedTemplates);
        }
    }

    public void onLoad() {
        Logger.debug((String)"ClosurePlugin : onLoad", (Object[])new Object[0]);
        if (Play.mode != Play.Mode.PROD) {
            this.scan();
        }
    }

    public void detectChange() {
        if (Play.mode != Play.Mode.PROD) {
            this.scan();
        }
    }
}

