/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.Reader;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptRuntime;

class TokenStream {
    private static final int EOF_CHAR = -1;
    private boolean dirtyLine;
    String regExpFlags;
    private String string = "";
    private double number;
    private char[] stringBuffer = new char[128];
    private int stringBufferTop;
    private ObjToIntMap allStrings = new ObjToIntMap(50);
    private final int[] ungetBuffer = new int[3];
    private int ungetCursor;
    private boolean hitEOF = false;
    private int lineStart = 0;
    private int lineno;
    private int lineEndChar = -1;
    private String sourceString;
    private Reader sourceReader;
    private char[] sourceBuffer;
    private int sourceEnd;
    private int sourceCursor;
    private boolean xmlIsAttribute;
    private boolean xmlIsTagContent;
    private int xmlOpenTagsCount;
    private Parser parser;

    TokenStream(Parser parser, Reader sourceReader, String sourceString, int lineno) {
        this.parser = parser;
        this.lineno = lineno;
        if (sourceReader != null) {
            if (sourceString != null) {
                Kit.codeBug();
            }
            this.sourceReader = sourceReader;
            this.sourceBuffer = new char[512];
            this.sourceEnd = 0;
        } else {
            if (sourceString == null) {
                Kit.codeBug();
            }
            this.sourceString = sourceString;
            this.sourceEnd = sourceString.length();
        }
        this.sourceCursor = 0;
    }

    String tokenToString(int token) {
        return "";
    }

    static boolean isKeyword(String s) {
        return 0 != TokenStream.stringToKeyword(s);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int stringToKeyword(String name) {
        int Id_break = 116;
        int Id_case = 111;
        int Id_continue = 117;
        int Id_default = 112;
        int Id_delete = 31;
        int Id_do = 114;
        int Id_else = 109;
        int Id_export = 106;
        int Id_false = 43;
        int Id_for = 115;
        int Id_function = 105;
        int Id_if = 108;
        int Id_in = 51;
        int Id_new = 30;
        int Id_null = 41;
        int Id_return = 4;
        int Id_switch = 110;
        int Id_this = 42;
        int Id_true = 44;
        int Id_typeof = 32;
        int Id_var = 118;
        int Id_void = 122;
        int Id_while = 113;
        int Id_with = 119;
        int Id_abstract = 123;
        int Id_boolean = 123;
        int Id_byte = 123;
        int Id_catch = 120;
        int Id_char = 123;
        int Id_class = 123;
        int Id_const = 149;
        int Id_debugger = 123;
        int Id_double = 123;
        int Id_enum = 123;
        int Id_extends = 123;
        int Id_final = 123;
        int Id_finally = 121;
        int Id_float = 123;
        int Id_goto = 123;
        int Id_implements = 123;
        int Id_import = 107;
        int Id_instanceof = 52;
        int Id_int = 123;
        int Id_interface = 123;
        int Id_long = 123;
        int Id_native = 123;
        int Id_package = 123;
        int Id_private = 123;
        int Id_protected = 123;
        int Id_public = 123;
        int Id_short = 123;
        int Id_static = 123;
        int Id_super = 123;
        int Id_synchronized = 123;
        int Id_throw = 49;
        int Id_throws = 123;
        int Id_transient = 123;
        int Id_try = 77;
        int Id_volatile = 123;
        String s = name;
        int id = 0;
        String X = null;
        block0 : switch (s.length()) {
            case 2: {
                char c = s.charAt(1);
                if (c == 'f') {
                    if (s.charAt(0) != 'i') break;
                    return 108;
                }
                if (c == 'n') {
                    if (s.charAt(0) != 'i') break;
                    return 51;
                }
                if (c != 'o' || s.charAt(0) != 'd') break;
                return 114;
            }
            case 3: {
                switch (s.charAt(0)) {
                    case 'f': {
                        if (s.charAt(2) != 'r' || s.charAt(1) != 'o') break;
                        return 115;
                    }
                    case 'i': {
                        if (s.charAt(2) != 't' || s.charAt(1) != 'n') break;
                        return 123;
                    }
                    case 'n': {
                        if (s.charAt(2) != 'w' || s.charAt(1) != 'e') break;
                        return 30;
                    }
                    case 't': {
                        if (s.charAt(2) != 'y' || s.charAt(1) != 'r') break;
                        return 77;
                    }
                    case 'v': {
                        if (s.charAt(2) != 'r' || s.charAt(1) != 'a') break;
                        return 118;
                    }
                }
                break;
            }
            case 4: {
                switch (s.charAt(0)) {
                    case 'b': {
                        X = "byte";
                        id = 123;
                        break;
                    }
                    case 'c': {
                        char c = s.charAt(3);
                        if (c == 'e') {
                            if (s.charAt(2) != 's' || s.charAt(1) != 'a') break;
                            return 111;
                        }
                        if (c != 'r' || s.charAt(2) != 'a' || s.charAt(1) != 'h') break;
                        return 123;
                    }
                    case 'e': {
                        char c = s.charAt(3);
                        if (c == 'e') {
                            if (s.charAt(2) != 's' || s.charAt(1) != 'l') break;
                            return 109;
                        }
                        if (c != 'm' || s.charAt(2) != 'u' || s.charAt(1) != 'n') break;
                        return 123;
                    }
                    case 'g': {
                        X = "goto";
                        id = 123;
                        break;
                    }
                    case 'l': {
                        X = "long";
                        id = 123;
                        break;
                    }
                    case 'n': {
                        X = "null";
                        id = 41;
                        break;
                    }
                    case 't': {
                        char c = s.charAt(3);
                        if (c == 'e') {
                            if (s.charAt(2) != 'u' || s.charAt(1) != 'r') break;
                            return 44;
                        }
                        if (c != 's' || s.charAt(2) != 'i' || s.charAt(1) != 'h') break;
                        return 42;
                    }
                    case 'v': {
                        X = "void";
                        id = 122;
                        break;
                    }
                    case 'w': {
                        X = "with";
                        id = 119;
                        break;
                    }
                }
                break;
            }
            case 5: {
                switch (s.charAt(2)) {
                    case 'a': {
                        X = "class";
                        id = 123;
                        break;
                    }
                    case 'e': {
                        X = "break";
                        id = 116;
                        break;
                    }
                    case 'i': {
                        X = "while";
                        id = 113;
                        break;
                    }
                    case 'l': {
                        X = "false";
                        id = 43;
                        break;
                    }
                    case 'n': {
                        char c = s.charAt(0);
                        if (c == 'c') {
                            X = "const";
                            id = 149;
                            break;
                        }
                        if (c != 'f') break;
                        X = "final";
                        id = 123;
                        break;
                    }
                    case 'o': {
                        char c = s.charAt(0);
                        if (c == 'f') {
                            X = "float";
                            id = 123;
                            break;
                        }
                        if (c != 's') break;
                        X = "short";
                        id = 123;
                        break;
                    }
                    case 'p': {
                        X = "super";
                        id = 123;
                        break;
                    }
                    case 'r': {
                        X = "throw";
                        id = 49;
                        break;
                    }
                    case 't': {
                        X = "catch";
                        id = 120;
                        break;
                    }
                }
                break;
            }
            case 6: {
                switch (s.charAt(1)) {
                    case 'a': {
                        X = "native";
                        id = 123;
                        break;
                    }
                    case 'e': {
                        char c = s.charAt(0);
                        if (c == 'd') {
                            X = "delete";
                            id = 31;
                            break;
                        }
                        if (c != 'r') break;
                        X = "return";
                        id = 4;
                        break;
                    }
                    case 'h': {
                        X = "throws";
                        id = 123;
                        break;
                    }
                    case 'm': {
                        X = "import";
                        id = 107;
                        break;
                    }
                    case 'o': {
                        X = "double";
                        id = 123;
                        break;
                    }
                    case 't': {
                        X = "static";
                        id = 123;
                        break;
                    }
                    case 'u': {
                        X = "public";
                        id = 123;
                        break;
                    }
                    case 'w': {
                        X = "switch";
                        id = 110;
                        break;
                    }
                    case 'x': {
                        X = "export";
                        id = 106;
                        break;
                    }
                    case 'y': {
                        X = "typeof";
                        id = 32;
                        break;
                    }
                }
                break;
            }
            case 7: {
                switch (s.charAt(1)) {
                    case 'a': {
                        X = "package";
                        id = 123;
                        break block0;
                    }
                    case 'e': {
                        X = "default";
                        id = 112;
                        break block0;
                    }
                    case 'i': {
                        X = "finally";
                        id = 121;
                        break block0;
                    }
                    case 'o': {
                        X = "boolean";
                        id = 123;
                        break block0;
                    }
                    case 'r': {
                        X = "private";
                        id = 123;
                        break block0;
                    }
                    case 'x': {
                        X = "extends";
                        id = 123;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                switch (s.charAt(0)) {
                    case 'a': {
                        X = "abstract";
                        id = 123;
                        break block0;
                    }
                    case 'c': {
                        X = "continue";
                        id = 117;
                        break block0;
                    }
                    case 'd': {
                        X = "debugger";
                        id = 123;
                        break block0;
                    }
                    case 'f': {
                        X = "function";
                        id = 105;
                        break block0;
                    }
                    case 'v': {
                        X = "volatile";
                        id = 123;
                        break block0;
                    }
                }
                break;
            }
            case 9: {
                char c = s.charAt(0);
                if (c == 'i') {
                    X = "interface";
                    id = 123;
                    break;
                }
                if (c == 'p') {
                    X = "protected";
                    id = 123;
                    break;
                }
                if (c != 't') break;
                X = "transient";
                id = 123;
                break;
            }
            case 10: {
                char c = s.charAt(1);
                if (c == 'm') {
                    X = "implements";
                    id = 123;
                    break;
                }
                if (c != 'n') break;
                X = "instanceof";
                id = 52;
                break;
            }
            case 12: {
                X = "synchronized";
                id = 123;
            }
        }
        if (X != null && X != s && !X.equals(s)) {
            return 0;
        }
        if (id != 0) return id & 0xFF;
        return 0;
    }

    final int getLineno() {
        return this.lineno;
    }

    final String getString() {
        return this.string;
    }

    final double getNumber() {
        return this.number;
    }

    final boolean eof() {
        return this.hitEOF;
    }

    final int getToken() throws IOException {
        block32: while (true) {
            boolean identifierStart;
            int c;
            if ((c = this.getChar()) == -1) {
                return 0;
            }
            if (c == 10) {
                this.dirtyLine = false;
                return 1;
            }
            if (TokenStream.isJSSpace(c)) continue;
            if (c != 45) {
                this.dirtyLine = true;
            }
            if (c == 64) {
                return 143;
            }
            boolean isUnicodeEscapeStart = false;
            if (c == 92) {
                c = this.getChar();
                if (c == 117) {
                    identifierStart = true;
                    isUnicodeEscapeStart = true;
                    this.stringBufferTop = 0;
                } else {
                    identifierStart = false;
                    this.ungetChar(c);
                    c = 92;
                }
            } else {
                identifierStart = Character.isJavaIdentifierStart((char)c);
                if (identifierStart) {
                    this.stringBufferTop = 0;
                    this.addToString(c);
                }
            }
            if (identifierStart) {
                int result;
                boolean containsEscape = isUnicodeEscapeStart;
                while (true) {
                    if (isUnicodeEscapeStart) {
                        int escapeVal = 0;
                        for (int i = 0; i != 4 && (escapeVal = Kit.xDigitToInt(c = this.getChar(), escapeVal)) >= 0; ++i) {
                        }
                        if (escapeVal < 0) {
                            this.parser.addError("msg.invalid.escape");
                            return -1;
                        }
                        this.addToString(escapeVal);
                        isUnicodeEscapeStart = false;
                        continue;
                    }
                    c = this.getChar();
                    if (c == 92) {
                        c = this.getChar();
                        if (c == 117) {
                            isUnicodeEscapeStart = true;
                            containsEscape = true;
                            continue;
                        }
                        this.parser.addError("msg.illegal.character");
                        return -1;
                    }
                    if (c == -1 || !Character.isJavaIdentifierPart((char)c)) break;
                    this.addToString(c);
                }
                this.ungetChar(c);
                String str = this.getStringFromBuffer();
                if (!containsEscape && (result = TokenStream.stringToKeyword(str)) != 0) {
                    if (result != 123) {
                        return result;
                    }
                    if (!this.parser.compilerEnv.isReservedKeywordAsIdentifier()) {
                        return result;
                    }
                    this.parser.addWarning("msg.reserved.keyword", str);
                }
                this.string = (String)this.allStrings.intern(str);
                return 38;
            }
            if (TokenStream.isDigit(c) || c == 46 && TokenStream.isDigit(this.peekChar())) {
                double dval;
                this.stringBufferTop = 0;
                int base = 10;
                if (c == 48) {
                    c = this.getChar();
                    if (c == 120 || c == 88) {
                        base = 16;
                        c = this.getChar();
                    } else if (TokenStream.isDigit(c)) {
                        base = 8;
                    } else {
                        this.addToString(48);
                    }
                }
                if (base == 16) {
                    while (0 <= Kit.xDigitToInt(c, 0)) {
                        this.addToString(c);
                        c = this.getChar();
                    }
                } else {
                    while (48 <= c && c <= 57) {
                        if (base == 8 && c >= 56) {
                            this.parser.addWarning("msg.bad.octal.literal", c == 56 ? "8" : "9");
                            base = 10;
                        }
                        this.addToString(c);
                        c = this.getChar();
                    }
                }
                boolean isInteger = true;
                if (base == 10 && (c == 46 || c == 101 || c == 69)) {
                    isInteger = false;
                    if (c == 46) {
                        do {
                            this.addToString(c);
                        } while (TokenStream.isDigit(c = this.getChar()));
                    }
                    if (c == 101 || c == 69) {
                        this.addToString(c);
                        c = this.getChar();
                        if (c == 43 || c == 45) {
                            this.addToString(c);
                            c = this.getChar();
                        }
                        if (!TokenStream.isDigit(c)) {
                            this.parser.addError("msg.missing.exponent");
                            return -1;
                        }
                        do {
                            this.addToString(c);
                        } while (TokenStream.isDigit(c = this.getChar()));
                    }
                }
                this.ungetChar(c);
                String numString = this.getStringFromBuffer();
                if (base == 10 && !isInteger) {
                    try {
                        dval = Double.valueOf(numString);
                    }
                    catch (NumberFormatException ex) {
                        this.parser.addError("msg.caught.nfe");
                        return -1;
                    }
                } else {
                    dval = ScriptRuntime.stringToNumber(numString, 0, base);
                }
                this.number = dval;
                return 39;
            }
            if (c == 34 || c == 39) {
                int quoteChar = c;
                this.stringBufferTop = 0;
                c = this.getChar();
                while (c != quoteChar) {
                    if (c == 10 || c == -1) {
                        this.ungetChar(c);
                        this.parser.addError("msg.unterminated.string.lit");
                        return -1;
                    }
                    if (c == 92) {
                        c = this.getChar();
                        switch (c) {
                            case 92: 
                            case 98: 
                            case 100: 
                            case 102: 
                            case 110: 
                            case 114: 
                            case 116: 
                            case 117: 
                            case 118: 
                            case 120: {
                                this.addToString(92);
                                this.addToString(c);
                                break;
                            }
                            case 10: {
                                break;
                            }
                            default: {
                                if (TokenStream.isDigit(c)) {
                                    this.addToString(92);
                                }
                                this.addToString(c);
                                break;
                            }
                        }
                    } else {
                        this.addToString(c);
                    }
                    c = this.getChar();
                }
                String str = this.getStringFromBuffer();
                this.string = (String)this.allStrings.intern(str);
                return 40;
            }
            switch (c) {
                case 59: {
                    return 78;
                }
                case 91: {
                    return 79;
                }
                case 93: {
                    return 80;
                }
                case 123: {
                    return 81;
                }
                case 125: {
                    return 82;
                }
                case 40: {
                    return 83;
                }
                case 41: {
                    return 84;
                }
                case 44: {
                    return 85;
                }
                case 63: {
                    return 98;
                }
                case 58: {
                    if (this.matchChar(58)) {
                        return 140;
                    }
                    return 99;
                }
                case 46: {
                    if (this.matchChar(46)) {
                        return 139;
                    }
                    if (this.matchChar(40)) {
                        return 142;
                    }
                    return 104;
                }
                case 124: {
                    if (this.matchChar(124)) {
                        return 100;
                    }
                    if (this.matchChar(61)) {
                        return 87;
                    }
                    return 9;
                }
                case 94: {
                    if (this.matchChar(61)) {
                        return 88;
                    }
                    return 10;
                }
                case 38: {
                    if (this.matchChar(38)) {
                        return 101;
                    }
                    if (this.matchChar(61)) {
                        return 89;
                    }
                    return 11;
                }
                case 61: {
                    if (this.matchChar(61)) {
                        if (this.matchChar(61)) {
                            return 45;
                        }
                        return 12;
                    }
                    return 86;
                }
                case 33: {
                    if (this.matchChar(61)) {
                        if (this.matchChar(61)) {
                            return 46;
                        }
                        return 13;
                    }
                    return 26;
                }
                case 60: {
                    if (this.matchChar(33)) {
                        if (this.matchChar(45)) {
                            if (this.matchChar(45)) {
                                this.skipLine();
                                continue block32;
                            }
                            this.ungetChar(45);
                        }
                        this.ungetChar(33);
                    }
                    if (this.matchChar(60)) {
                        if (this.matchChar(61)) {
                            return 90;
                        }
                        return 18;
                    }
                    if (this.matchChar(61)) {
                        return 15;
                    }
                    return 14;
                }
                case 62: {
                    if (this.matchChar(62)) {
                        if (this.matchChar(62)) {
                            if (this.matchChar(61)) {
                                return 92;
                            }
                            return 20;
                        }
                        if (this.matchChar(61)) {
                            return 91;
                        }
                        return 19;
                    }
                    if (this.matchChar(61)) {
                        return 17;
                    }
                    return 16;
                }
                case 42: {
                    if (this.matchChar(61)) {
                        return 95;
                    }
                    return 23;
                }
                case 47: {
                    if (this.matchChar(47)) {
                        this.skipLine();
                        continue block32;
                    }
                    if (this.matchChar(42)) {
                        boolean lookForSlash = false;
                        StringBuffer sb = new StringBuffer();
                        while (true) {
                            if ((c = this.getChar()) == -1) {
                                this.parser.addError("msg.unterminated.comment");
                                return -1;
                            }
                            sb.append((char)c);
                            if (c == 42) {
                                lookForSlash = true;
                                continue;
                            }
                            if (c == 47) {
                                if (!lookForSlash) continue;
                                sb.delete(sb.length() - 2, sb.length());
                                String s1 = sb.toString();
                                String s2 = s1.trim();
                                if (s1.startsWith("!")) {
                                    this.string = s1.substring(1);
                                    return 153;
                                }
                                if (!s2.startsWith("@cc_on") && !s2.startsWith("@if") && !s2.startsWith("@elif") && !s2.startsWith("@else") && !s2.startsWith("@end")) continue block32;
                                this.string = s1;
                                return 152;
                            }
                            lookForSlash = false;
                        }
                    }
                    if (this.matchChar(61)) {
                        return 96;
                    }
                    return 24;
                }
                case 37: {
                    if (this.matchChar(61)) {
                        return 97;
                    }
                    return 25;
                }
                case 126: {
                    return 27;
                }
                case 43: {
                    if (this.matchChar(61)) {
                        return 93;
                    }
                    if (this.matchChar(43)) {
                        return 102;
                    }
                    return 21;
                }
                case 45: {
                    if (this.matchChar(61)) {
                        c = 94;
                    } else if (this.matchChar(45)) {
                        if (!this.dirtyLine && this.matchChar(62)) {
                            this.skipLine();
                            continue block32;
                        }
                        c = 103;
                    } else {
                        c = 22;
                    }
                    this.dirtyLine = true;
                    return c;
                }
            }
            break;
        }
        this.parser.addError("msg.illegal.character");
        return -1;
    }

    private static boolean isAlpha(int c) {
        if (c <= 90) {
            return 65 <= c;
        }
        return 97 <= c && c <= 122;
    }

    static boolean isDigit(int c) {
        return 48 <= c && c <= 57;
    }

    static boolean isJSSpace(int c) {
        if (c <= 127) {
            return c == 32 || c == 9 || c == 12 || c == 11;
        }
        return c == 160 || Character.getType((char)c) == 12;
    }

    private static boolean isJSFormatChar(int c) {
        return c > 127 && Character.getType((char)c) == 16;
    }

    void readRegExp(int startToken) throws IOException {
        int c;
        this.stringBufferTop = 0;
        if (startToken == 96) {
            this.addToString(61);
        } else if (startToken != 24) {
            Kit.codeBug();
        }
        boolean inClass = false;
        while ((c = this.getChar()) != 47 || inClass) {
            if (c == 10 || c == -1) {
                this.ungetChar(c);
                throw this.parser.reportError("msg.unterminated.re.lit");
            }
            if (c == 92) {
                this.addToString(c);
                c = this.getChar();
            } else if (c == 91) {
                inClass = true;
            } else if (c == 93) {
                inClass = false;
            }
            this.addToString(c);
        }
        int reEnd = this.stringBufferTop;
        while (true) {
            if (this.matchChar(103)) {
                this.addToString(103);
                continue;
            }
            if (this.matchChar(105)) {
                this.addToString(105);
                continue;
            }
            if (!this.matchChar(109)) break;
            this.addToString(109);
        }
        if (TokenStream.isAlpha(this.peekChar())) {
            throw this.parser.reportError("msg.invalid.re.flag");
        }
        this.string = new String(this.stringBuffer, 0, reEnd);
        this.regExpFlags = new String(this.stringBuffer, reEnd, this.stringBufferTop - reEnd);
    }

    boolean isXMLAttribute() {
        return this.xmlIsAttribute;
    }

    int getFirstXMLToken() throws IOException {
        this.xmlOpenTagsCount = 0;
        this.xmlIsAttribute = false;
        this.xmlIsTagContent = false;
        this.ungetChar(60);
        return this.getNextXMLToken();
    }

    int getNextXMLToken() throws IOException {
        this.stringBufferTop = 0;
        int c = this.getChar();
        while (c != -1) {
            if (this.xmlIsTagContent) {
                switch (c) {
                    case 62: {
                        this.addToString(c);
                        this.xmlIsTagContent = false;
                        this.xmlIsAttribute = false;
                        break;
                    }
                    case 47: {
                        this.addToString(c);
                        if (this.peekChar() != 62) break;
                        c = this.getChar();
                        this.addToString(c);
                        this.xmlIsTagContent = false;
                        --this.xmlOpenTagsCount;
                        break;
                    }
                    case 123: {
                        this.ungetChar(c);
                        this.string = this.getStringFromBuffer();
                        return 141;
                    }
                    case 34: 
                    case 39: {
                        this.addToString(c);
                        if (this.readQuotedString(c)) break;
                        return -1;
                    }
                    case 61: {
                        this.addToString(c);
                        this.xmlIsAttribute = true;
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        this.addToString(c);
                        break;
                    }
                    default: {
                        this.addToString(c);
                        this.xmlIsAttribute = false;
                    }
                }
                if (!this.xmlIsTagContent && this.xmlOpenTagsCount == 0) {
                    this.string = this.getStringFromBuffer();
                    return 144;
                }
            } else {
                block8 : switch (c) {
                    case 60: {
                        this.addToString(c);
                        c = this.peekChar();
                        switch (c) {
                            case 33: {
                                c = this.getChar();
                                this.addToString(c);
                                c = this.peekChar();
                                switch (c) {
                                    case 45: {
                                        c = this.getChar();
                                        this.addToString(c);
                                        c = this.getChar();
                                        if (c == 45) {
                                            this.addToString(c);
                                            if (this.readXmlComment()) break block8;
                                            return -1;
                                        }
                                        this.stringBufferTop = 0;
                                        this.string = null;
                                        this.parser.addError("msg.XML.bad.form");
                                        return -1;
                                    }
                                    case 91: {
                                        c = this.getChar();
                                        this.addToString(c);
                                        if (this.getChar() == 67 && this.getChar() == 68 && this.getChar() == 65 && this.getChar() == 84 && this.getChar() == 65 && this.getChar() == 91) {
                                            this.addToString(67);
                                            this.addToString(68);
                                            this.addToString(65);
                                            this.addToString(84);
                                            this.addToString(65);
                                            this.addToString(91);
                                            if (this.readCDATA()) break block8;
                                            return -1;
                                        }
                                        this.stringBufferTop = 0;
                                        this.string = null;
                                        this.parser.addError("msg.XML.bad.form");
                                        return -1;
                                    }
                                    default: {
                                        if (this.readEntity()) break block8;
                                        return -1;
                                    }
                                }
                            }
                            case 63: {
                                c = this.getChar();
                                this.addToString(c);
                                if (this.readPI()) break block8;
                                return -1;
                            }
                            case 47: {
                                c = this.getChar();
                                this.addToString(c);
                                if (this.xmlOpenTagsCount == 0) {
                                    this.stringBufferTop = 0;
                                    this.string = null;
                                    this.parser.addError("msg.XML.bad.form");
                                    return -1;
                                }
                                this.xmlIsTagContent = true;
                                --this.xmlOpenTagsCount;
                                break;
                            }
                            default: {
                                this.xmlIsTagContent = true;
                                ++this.xmlOpenTagsCount;
                                break;
                            }
                        }
                        break;
                    }
                    case 123: {
                        this.ungetChar(c);
                        this.string = this.getStringFromBuffer();
                        return 141;
                    }
                    default: {
                        this.addToString(c);
                    }
                }
            }
            c = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return -1;
    }

    private boolean readQuotedString(int quote) throws IOException {
        int c = this.getChar();
        while (c != -1) {
            this.addToString(c);
            if (c == quote) {
                return true;
            }
            c = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private boolean readXmlComment() throws IOException {
        int c = this.getChar();
        while (c != -1) {
            this.addToString(c);
            if (c == 45 && this.peekChar() == 45) {
                c = this.getChar();
                this.addToString(c);
                if (this.peekChar() != 62) continue;
                c = this.getChar();
                this.addToString(c);
                return true;
            }
            c = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private boolean readCDATA() throws IOException {
        int c = this.getChar();
        while (c != -1) {
            this.addToString(c);
            if (c == 93 && this.peekChar() == 93) {
                c = this.getChar();
                this.addToString(c);
                if (this.peekChar() != 62) continue;
                c = this.getChar();
                this.addToString(c);
                return true;
            }
            c = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private boolean readEntity() throws IOException {
        int declTags = 1;
        int c = this.getChar();
        while (c != -1) {
            this.addToString(c);
            switch (c) {
                case 60: {
                    ++declTags;
                    break;
                }
                case 62: {
                    if (--declTags != 0) break;
                    return true;
                }
            }
            c = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private boolean readPI() throws IOException {
        int c = this.getChar();
        while (c != -1) {
            this.addToString(c);
            if (c == 63 && this.peekChar() == 62) {
                c = this.getChar();
                this.addToString(c);
                return true;
            }
            c = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private String getStringFromBuffer() {
        return new String(this.stringBuffer, 0, this.stringBufferTop);
    }

    private void addToString(int c) {
        int N = this.stringBufferTop;
        if (N == this.stringBuffer.length) {
            char[] tmp = new char[this.stringBuffer.length * 2];
            System.arraycopy(this.stringBuffer, 0, tmp, 0, N);
            this.stringBuffer = tmp;
        }
        this.stringBuffer[N] = (char)c;
        this.stringBufferTop = N + 1;
    }

    private void ungetChar(int c) {
        if (this.ungetCursor != 0 && this.ungetBuffer[this.ungetCursor - 1] == 10) {
            Kit.codeBug();
        }
        this.ungetBuffer[this.ungetCursor++] = c;
    }

    private boolean matchChar(int test) throws IOException {
        int c = this.getChar();
        if (c == test) {
            return true;
        }
        this.ungetChar(c);
        return false;
    }

    private int peekChar() throws IOException {
        int c = this.getChar();
        this.ungetChar(c);
        return c;
    }

    private int getChar() throws IOException {
        int c;
        block11: {
            if (this.ungetCursor != 0) {
                return this.ungetBuffer[--this.ungetCursor];
            }
            while (true) {
                if (this.sourceString != null) {
                    if (this.sourceCursor == this.sourceEnd) {
                        this.hitEOF = true;
                        return -1;
                    }
                    c = this.sourceString.charAt(this.sourceCursor++);
                } else {
                    if (this.sourceCursor == this.sourceEnd && !this.fillSourceBuffer()) {
                        this.hitEOF = true;
                        return -1;
                    }
                    c = this.sourceBuffer[this.sourceCursor++];
                }
                if (this.lineEndChar >= 0) {
                    if (this.lineEndChar == 13 && c == 10) {
                        this.lineEndChar = 10;
                        continue;
                    }
                    this.lineEndChar = -1;
                    this.lineStart = this.sourceCursor - 1;
                    ++this.lineno;
                }
                if (c <= 127) {
                    if (c == 10 || c == 13) {
                        this.lineEndChar = c;
                        c = 10;
                    }
                    break block11;
                }
                if (!TokenStream.isJSFormatChar(c)) break;
            }
            if (ScriptRuntime.isJSLineTerminator(c)) {
                this.lineEndChar = c;
                c = 10;
            }
        }
        return c;
    }

    private void skipLine() throws IOException {
        int c;
        while ((c = this.getChar()) != -1 && c != 10) {
        }
        this.ungetChar(c);
    }

    final int getOffset() {
        int n = this.sourceCursor - this.lineStart;
        if (this.lineEndChar >= 0) {
            --n;
        }
        return n;
    }

    final String getLine() {
        if (this.sourceString != null) {
            int lineEnd;
            if (this.lineEndChar >= 0) {
                --lineEnd;
            } else {
                char c;
                for (lineEnd = this.sourceCursor; lineEnd != this.sourceEnd && !ScriptRuntime.isJSLineTerminator(c = this.sourceString.charAt(lineEnd)); ++lineEnd) {
                }
            }
            return this.sourceString.substring(this.lineStart, lineEnd);
        }
        int lineLength = this.sourceCursor - this.lineStart;
        if (this.lineEndChar >= 0) {
            --lineLength;
        } else {
            while (true) {
                char c;
                int i;
                if ((i = this.lineStart + lineLength) == this.sourceEnd) {
                    try {
                        if (!this.fillSourceBuffer()) {
                        }
                    }
                    catch (IOException ioe) {}
                    break;
                    i = this.lineStart + lineLength;
                }
                if (ScriptRuntime.isJSLineTerminator(c = this.sourceBuffer[i])) break;
                ++lineLength;
            }
        }
        return new String(this.sourceBuffer, this.lineStart, lineLength);
    }

    private boolean fillSourceBuffer() throws IOException {
        int n;
        if (this.sourceString != null) {
            Kit.codeBug();
        }
        if (this.sourceEnd == this.sourceBuffer.length) {
            if (this.lineStart != 0) {
                System.arraycopy(this.sourceBuffer, this.lineStart, this.sourceBuffer, 0, this.sourceEnd - this.lineStart);
                this.sourceEnd -= this.lineStart;
                this.sourceCursor -= this.lineStart;
                this.lineStart = 0;
            } else {
                char[] tmp = new char[this.sourceBuffer.length * 2];
                System.arraycopy(this.sourceBuffer, 0, tmp, 0, this.sourceEnd);
                this.sourceBuffer = tmp;
            }
        }
        if ((n = this.sourceReader.read(this.sourceBuffer, this.sourceEnd, this.sourceBuffer.length - this.sourceEnd)) < 0) {
            return false;
        }
        this.sourceEnd += n;
        return true;
    }
}

