/*
 * Decompiled with CFR 0.152.
 */
package play.modules.greenscript.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import play.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyManager {
    public static DependencyManager JS_DEP_MGR = new DependencyManager();
    public static DependencyManager CSS_DEP_MGR = new DependencyManager();
    private Map<String, Set<String>> deps_ = new HashMap<String, Set<String>>();
    private Map<String, Integer> weight_ = new HashMap<String, Integer>();

    private static void configDependencies_(DependencyManager dm, Configuration conf) {
        Iterator itr = conf.getKeys();
        while (itr.hasNext()) {
            String name = (String)itr.next();
            dm.createDependency(name, new HashSet<String>(conf.getList(name)));
        }
    }

    public static void configDependencies(Configuration jsConf, Configuration cssConf) {
        DependencyManager.configDependencies_(JS_DEP_MGR, jsConf);
        DependencyManager.configDependencies_(CSS_DEP_MGR, cssConf);
    }

    public void createDependency(String dependant, Set<String> dependOn) {
        this.deps_.put(dependant, dependOn);
        this.setWeight_(dependant, dependOn);
    }

    private void setWeight_(String dependant, Set<String> dependOn) {
        if (!this.weight_.containsKey(dependant)) {
            Logger.trace((String)String.format("%1$s weight %2$s", dependant, 1), (Object[])new Object[0]);
            this.weight_.put(dependant, 1);
        }
        int w = this.weight_.get(dependant);
        for (String s : dependOn) {
            int w2 = !this.weight_.containsKey(s) ? 10 : this.weight_.get(s) + 10 * w;
            Logger.trace((String)String.format("%1$s weight %2$s", s, w2), (Object[])new Object[0]);
            this.weight_.put(s, w2);
            Set<String> set = this.deps_.get(s);
            if (set == null) continue;
            this.setWeight_(s, set);
        }
    }

    private Set allDepends_(String dependant) {
        HashSet<String> all = new HashSet<String>();
        if (!this.deps_.containsKey(dependant)) {
            all.add(dependant);
            return all;
        }
        for (String s : this.deps_.get(dependant)) {
            all.addAll(this.allDepends_(s));
        }
        all.add(dependant);
        return all;
    }

    private boolean isDependant_(String dependant, String something) {
        Set set = this.allDepends_(dependant);
        return set.contains(something);
    }

    public List sort(Collection<String> list) {
        String[] names = list.toArray(new String[0]);
        Arrays.sort(names, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int w1 = DependencyManager.this.weight_.containsKey(o1) ? (Integer)DependencyManager.this.weight_.get(o1) : -1;
                int w2 = DependencyManager.this.weight_.containsKey(o2) ? (Integer)DependencyManager.this.weight_.get(o2) : -1;
                return w2 - w1;
            }
        });
        return Arrays.asList(names);
    }

    public List<String> comprehend(Collection<String> set) {
        HashSet<String> ret = new HashSet<String>();
        for (String s : set) {
            ret.addAll(this.allDepends_(s));
        }
        return this.sort(ret);
    }
}

