/*
 * Decompiled with CFR 0.152.
 */
package play.modules.greenscript;

import java.lang.reflect.Method;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.exceptions.UnexpectedException;
import play.modules.greenscript.utils.DependencyManager;
import play.modules.greenscript.utils.Minimizor;
import play.modules.greenscript.utils.SessionManager;
import play.mvc.Scope;

public class GreenScriptPlugin
extends PlayPlugin {
    private static GreenScriptPlugin instance_ = null;
    private static String jsDir_ = "js";
    private static String cssDir_ = "css";
    private Configuration conf_ = null;
    private static boolean minimize_ = false;

    public static GreenScriptPlugin getInstance() {
        return instance_;
    }

    public static String getJsDir() {
        return jsDir_;
    }

    public static String getCssDir() {
        return cssDir_;
    }

    public void configure(Configuration conf) {
        this.conf_ = conf;
        this.configure_(conf);
    }

    public Configuration getConfiguration() {
        return this.conf_;
    }

    private void configure_(Configuration c) {
        Configuration jsConf = c.subset("js");
        Configuration cssConf = c.subset("css");
        DependencyManager.configDependencies(jsConf, cssConf);
        minimize_ = c.getBoolean("gs.minimize.enabled", true);
        jsDir_ = c.getString("gs.dir.js", "js");
        cssDir_ = c.getString("gs.dir.css", "css");
        if (!minimize_) {
            Logger.warn((String)"GreenScript minimizing disabled", (Object[])new Object[0]);
        } else {
            Logger.info((String)"GreenScript minimizing enabled", (Object[])new Object[0]);
        }
        boolean nocache = Play.mode == Play.Mode.DEV && c.getBoolean("gs.nocache", false);
        Minimizor.setNoCache(nocache);
        boolean compress = c.getBoolean("gs.compress", true);
        Minimizor.setCompress(compress);
    }

    public void onConfigurationRead() {
        instance_ = this;
        PropertiesConfiguration c = null;
        try {
            c = new PropertiesConfiguration("greenscript.conf");
        }
        catch (ConfigurationException e) {
            throw new UnexpectedException((Throwable)e);
        }
        for (Object key : Play.configuration.keySet()) {
            String ks = (String)key;
            if (!ks.startsWith("gs.")) continue;
            String v = Play.configuration.getProperty(ks);
            Logger.debug((String)"[GreenScript]Loading application configuration: %1$s = %2$s", (Object[])new Object[]{ks, v});
            c.setProperty(ks, (Object)v);
        }
        this.configure((Configuration)c);
        Logger.info((String)"GreenScript module initialized", (Object[])new Object[0]);
    }

    public void beforeActionInvocation(Method actionMethod) {
        Scope.RenderArgs.current().put("gsSM", (Object)new SessionManager(jsDir_, cssDir_, minimize_));
    }
}

