/*
 * Decompiled with CFR 0.152.
 */
package play.modules.greenscript.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.configuration.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyManager {
    public static DependencyManager JS_DEP_MGR = new DependencyManager();
    public static DependencyManager CSS_DEP_MGR = new DependencyManager();
    private Map<String, Node> deps_ = new HashMap<String, Node>();

    private static void configDependencies_(DependencyManager dm, Configuration conf) {
        dm.clearCache_();
        Iterator itr = conf.getKeys();
        while (itr.hasNext()) {
            String name = (String)itr.next();
            dm.createDependency(name, new HashSet<String>(conf.getList(name)));
        }
        dm.refresh();
    }

    public static void configDependencies(Configuration jsConf, Configuration cssConf) {
        DependencyManager.configDependencies_(JS_DEP_MGR, jsConf);
        DependencyManager.configDependencies_(CSS_DEP_MGR, cssConf);
    }

    public void createDependency(String dependant, Set<String> dependOns) {
        Node.createNode(dependant, dependOns, this.deps_);
    }

    private void clearCache_() {
        this.deps_.clear();
    }

    public void refresh() {
        for (Node node : this.deps_.values()) {
            this.refreshUp_(node);
            this.calcWeight_(node);
        }
    }

    private void refreshUp_(Node node) {
        for (Node up : new HashSet<Node>(node.ups.values())) {
            this.refreshUp_(up);
        }
        for (Node up : new HashSet<Node>(node.ups.values())) {
            node.ups.putAll(up.ups);
        }
    }

    private void calcWeight_(Node node) {
        node.refreshUpWeights();
    }

    private Set<Node> allDepends_(String dependant) {
        HashSet<Node> all = new HashSet<Node>();
        Node node = this.deps_.get(dependant);
        if (null == node) {
            return all;
        }
        all.addAll(node.ups.values());
        all.add(node);
        return all;
    }

    public List<String> comprehend(Collection<String> set) {
        return this.comprehend(set, false);
    }

    public List<String> comprehend(Collection<String> set, boolean withDefaults) {
        ArrayList<String> ret = new ArrayList<String>();
        TreeSet<Node> nodes = new TreeSet<Node>();
        for (String s : set) {
            nodes.addAll(this.allDepends_(s));
        }
        if (withDefaults) {
            nodes.addAll(this.allDepends_("default"));
        }
        for (Node n : nodes) {
            ret.add(n.name);
        }
        for (String s : set) {
            if (ret.contains(s)) continue;
            ret.add(s);
        }
        ret.remove("default");
        return ret;
    }

    public List<String> getDefaultList() {
        Set<Node> defSet = this.allDepends_("default");
        ArrayList<String> ret = new ArrayList<String>();
        for (Node n : defSet) {
            ret.add(n.name);
        }
        ret.remove("default");
        return this.comprehend(ret);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node
    implements Comparable {
        String name;
        Map<String, Node> ups;
        int weight = 1;
        static final int STEP = 100;

        Node(String name) {
            this.name = name;
            this.ups = new HashMap<String, Node>();
        }

        void refreshUpWeights() {
            this.increaseWeightOn(null);
        }

        void increaseWeightOn(Node node) {
            if (null != node) {
                this.weight += node.weight + 100;
            }
            for (Node up : this.ups.values()) {
                up.increaseWeightOn(this);
            }
        }

        void addUp(Node up) {
            this.ups.put(up.name, up);
        }

        static Node createNode(String name, Set<String> dependsOns, Map<String, Node> repo) {
            if (null == name) {
                throw new NullPointerException();
            }
            Node node = repo.get(name);
            if (null == node) {
                node = new Node(name);
            }
            for (String s : dependsOns) {
                Node up = Node.createNode(s, new HashSet<String>(), repo);
                node.addUp(up);
            }
            repo.put(name, node);
            return node;
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            if (!(that instanceof Node)) {
                return false;
            }
            return this.name.equals(((Node)that).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public int compareTo(Object o) {
            if (null == o) {
                return -1;
            }
            if (o.equals(this)) {
                return 0;
            }
            Node n = (Node)o;
            if (this.weight == n.weight) {
                return n.name.compareTo(this.name);
            }
            return n.weight - this.weight;
        }

        public String toString() {
            return this.name;
        }
    }
}

