/*
 * Decompiled with CFR 0.152.
 */
package play.modules.greenscript.utils;

import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import play.Logger;
import play.Play;
import play.exceptions.UnexpectedException;
import play.modules.greenscript.GreenScriptPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Minimizor {
    private static Map<List<String>, String> jsBag_ = new HashMap<List<String>, String>();
    private static Map<List<String>, String> cssBag_ = new HashMap<List<String>, String>();
    private static boolean noCache_ = false;
    private static boolean compress_ = true;
    private static String jsPath_ = null;
    private static String cssPath_ = null;
    private static ErrorReporter er_ = new ErrorReporter(){

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0) {
                Logger.warn((String)("[MINIMIZOR.WARNING] " + message), (Object[])new Object[0]);
            } else {
                Logger.warn((String)"[MINIMIZOR.WARNING] %1$s: %2$s: %3$s", (Object[])new Object[]{line, lineOffset, message});
            }
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0) {
                Logger.error((String)("[MINIMIZOR.ERROR] " + message), (Object[])new Object[0]);
            } else {
                Logger.error((String)"[MINIMIZOR.ERROR] %1$s: %2$s: %3$s", (Object[])new Object[]{line, lineOffset, message});
            }
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            this.error(message, sourceName, line, lineSource, lineOffset);
            return new EvaluatorException(message);
        }
    };

    public static void setNoCache(boolean noCache) {
        noCache_ = noCache;
    }

    public static void setCompress(boolean compress) {
        compress_ = compress;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String minimizeJs(List<String> jsNames) {
        String fn;
        block12: {
            if (jsNames.size() == 0) {
                return "";
            }
            String name = jsBag_.get(jsNames);
            if (null != name) {
                if (Play.mode != Play.Mode.DEV) return name;
                File f = Play.getFile((String)("/public/gs/" + name));
                if (!noCache_ && f.exists()) {
                    return name;
                }
            }
            File outFile = Minimizor.randomFile(".js");
            fn = outFile.getName();
            Writer out = null;
            try {
                out = new BufferedWriter(new FileWriter(outFile, true));
                for (String s : jsNames) {
                    Minimizor.compressJs_(s, out);
                }
                if (out == null) break block12;
            }
            catch (IOException e) {
                try {
                    throw new UnexpectedException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (out == null) throw throwable;
                    try {
                        out.close();
                        throw throwable;
                    }
                    catch (IOException e2) {
                        Logger.warn((String)"cannot close output in minimizor", (Object[])new Object[]{e2});
                    }
                    throw throwable;
                }
            }
            try {
                out.close();
            }
            catch (IOException e) {
                Logger.warn((String)"cannot close output in minimizor", (Object[])new Object[]{e});
            }
        }
        jsBag_.put(jsNames, fn);
        return fn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String minimizeCss(List<String> cssNames) {
        String fn;
        block11: {
            String name = cssBag_.get(cssNames);
            if (null != name) {
                if (Play.mode != Play.Mode.DEV) return name;
                File f = Play.getFile((String)("/public/gs/" + name));
                if (!noCache_ && f.exists()) {
                    return name;
                }
            }
            File outFile = Minimizor.randomFile(".css");
            fn = outFile.getName();
            Writer out = null;
            try {
                out = new BufferedWriter(new FileWriter(outFile, true));
                for (String s : cssNames) {
                    Minimizor.compressCss_(s, out);
                }
                if (out == null) break block11;
            }
            catch (IOException e) {
                try {
                    throw new UnexpectedException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (out == null) throw throwable;
                    try {
                        out.close();
                        throw throwable;
                    }
                    catch (IOException e2) {
                        Logger.warn((String)"cannot close output in minimizor", (Object[])new Object[]{e2});
                    }
                    throw throwable;
                }
            }
            try {
                out.close();
            }
            catch (IOException e) {
                Logger.warn((String)"cannot close output in minimizor", (Object[])new Object[]{e});
            }
        }
        cssBag_.put(cssNames, fn);
        return fn;
    }

    private static String getJsPath_() {
        if (null == jsPath_) {
            jsPath_ = "/public/" + GreenScriptPlugin.getJsDir() + "/";
        }
        return jsPath_;
    }

    private static String getCssPath_() {
        if (null == cssPath_) {
            cssPath_ = "/public/" + GreenScriptPlugin.getCssDir() + "/";
        }
        return cssPath_;
    }

    private static void compressJs_(String fn, Writer out) {
        try {
            Logger.debug((String)"minizing... %1$s.js", (Object[])new Object[]{fn});
            File inFile = Play.getFile((String)(Minimizor.getJsPath_() + fn + ".js"));
            BufferedReader in = new BufferedReader(new FileReader(inFile));
            if (compress_) {
                try {
                    JavaScriptCompressor compressor = new JavaScriptCompressor((Reader)in, er_);
                    compressor.compress(out, -1, true, false, false, false);
                }
                catch (Exception e) {
                    Logger.error((String)"error minimizing javascript file %1$s", (Object[])new Object[]{fn});
                    in = new BufferedReader(new FileReader(inFile));
                    Minimizor.copyJs_(in, out, fn);
                }
            } else {
                Minimizor.copyJs_(in, out, fn);
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e, (String)"error processing javascript file file %1$s", (Object[])new Object[]{fn});
        }
    }

    private static void copyJs_(BufferedReader in, Writer out, String fn) throws IOException {
        String line = null;
        PrintWriter writer = new PrintWriter(out);
        while ((line = in.readLine()) != null) {
            writer.println(line);
        }
    }

    private static void compressCss_(String fn, Writer out) {
        try {
            Logger.debug((String)"minizing... %1$s.css", (Object[])new Object[]{fn});
            File inFile = Play.getFile((String)(Minimizor.getCssPath_() + fn + ".css"));
            BufferedReader in = new BufferedReader(new FileReader(inFile));
            CssCompressor compressor = new CssCompressor((Reader)in);
            compressor.compress(out, -1);
        }
        catch (IOException e) {
            Logger.error((Throwable)e, (String)"error processing css file %1$s", (Object[])new Object[]{fn});
        }
    }

    private static File tmpDir() {
        File gsDir = Play.getFile((String)"public/gs");
        if (!gsDir.exists()) {
            gsDir.mkdir();
        }
        return gsDir;
    }

    private static File randomFile(String suffix) {
        try {
            return File.createTempFile("gstmp", suffix, Minimizor.tmpDir());
        }
        catch (IOException e) {
            String msg = "Error create temp file for minimizor";
            throw new UnexpectedException(msg, (Throwable)e);
        }
    }
}

