/*
 * Decompiled with CFR 0.152.
 */
package play.modules.greenscript.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import play.modules.greenscript.utils.DependencyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionManager {
    private Set<String> jsLoaded_ = new HashSet<String>();
    private Set<String> jsGlobalLoaded_ = new HashSet<String>();
    private Set<String> jsMissing_ = new HashSet<String>();
    private List<String> cssScrn_ = new ArrayList<String>();
    private List<String> cssPrit_ = new ArrayList<String>();
    private boolean minimize_ = false;
    private String jsDir_ = "js";
    private String cssDir_ = "css";

    public SessionManager(String jsDir, String cssDir, boolean minimize) {
        this.jsDir_ = jsDir;
        this.cssDir_ = cssDir;
        this.minimize_ = minimize;
    }

    public String jsDir() {
        return this.jsDir_;
    }

    public String cssDir() {
        return this.cssDir_;
    }

    public boolean minimize() {
        return this.minimize_;
    }

    protected boolean addCss(List<String> list, String name) {
        for (String s : list) {
            if (!s.equalsIgnoreCase(name)) continue;
            return false;
        }
        list.add(name);
        return true;
    }

    public boolean addCss(String name, String media) {
        return "print".equalsIgnoreCase(media) ? this.addPrintCss(name) : this.addScreenCss(name);
    }

    public boolean addJsLoaded(String name) {
        this.jsGlobalLoaded_.add(name);
        if (this.jsLoaded_.add(name)) {
            this.jsMissing_.remove(name);
            return true;
        }
        return false;
    }

    public void clearLoaded() {
        this.jsLoaded_.clear();
    }

    public void addJsMissings(Collection<String> missings) {
        this.jsMissing_.addAll(missings);
        this.jsMissing_.removeAll(this.jsGlobalLoaded_);
    }

    public void addJsMissing(String name) {
        this.jsMissing_.add(name);
        this.jsMissing_.removeAll(this.jsGlobalLoaded_);
    }

    public List<String> getJsMissings() {
        List<String> ret = DependencyManager.JS_DEP_MGR.comprehend(this.jsMissing_, true);
        return ret;
    }

    public boolean addCss(String name) {
        return this.addScreenCss(name);
    }

    public boolean addScreenCss(String name) {
        return this.addCss(this.cssScrn_, name);
    }

    public boolean addPrintCss(String name) {
        return this.addCss(this.cssPrit_, name);
    }

    public List<String> getCssList(String media) {
        List<String> l = this.comprehend_(media);
        return l;
    }

    private List<String> comprehend_(String media) {
        return "print".equalsIgnoreCase(media) ? DependencyManager.CSS_DEP_MGR.comprehend(this.cssPrit_) : DependencyManager.CSS_DEP_MGR.comprehend(this.cssScrn_);
    }
}

