/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.plist;

import java.io.File;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.configuration.AbstractHierarchicalFileConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.digester.AbstractObjectCreationFactory;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ObjectCreateRule;
import org.apache.commons.digester.ObjectCreationFactory;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.SetNextRule;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class XMLPropertyListConfiguration
extends AbstractHierarchicalFileConfiguration {
    private static final int INDENT_SIZE = 4;
    static /* synthetic */ Class class$org$apache$commons$configuration$plist$XMLPropertyListConfiguration$PListNode;
    static /* synthetic */ Class class$org$apache$commons$configuration$plist$XMLPropertyListConfiguration$ArrayNode;

    public XMLPropertyListConfiguration() {
    }

    public XMLPropertyListConfiguration(String fileName) throws ConfigurationException {
        super(fileName);
    }

    public XMLPropertyListConfiguration(File file) throws ConfigurationException {
        super(file);
    }

    public XMLPropertyListConfiguration(URL url) throws ConfigurationException {
        super(url);
    }

    public void load(Reader in) throws ConfigurationException {
        Digester digester = new Digester();
        digester.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) {
                return new InputSource(this.getClass().getClassLoader().getResourceAsStream("PropertyList-1.0.dtd"));
            }
        });
        digester.setValidating(true);
        digester.addRule("*/key", (Rule)new ObjectCreateRule(class$org$apache$commons$configuration$plist$XMLPropertyListConfiguration$PListNode == null ? (class$org$apache$commons$configuration$plist$XMLPropertyListConfiguration$PListNode = XMLPropertyListConfiguration.class$("org.apache.commons.configuration.plist.XMLPropertyListConfiguration$PListNode")) : class$org$apache$commons$configuration$plist$XMLPropertyListConfiguration$PListNode){

            public void end() throws Exception {
            }
        });
        digester.addCallMethod("*/key", "setName", 0);
        digester.addRule("*/dict/string", (Rule)new SetNextAndPopRule("addChild"));
        digester.addRule("*/dict/data", (Rule)new SetNextAndPopRule("addChild"));
        digester.addRule("*/dict/integer", (Rule)new SetNextAndPopRule("addChild"));
        digester.addRule("*/dict/real", (Rule)new SetNextAndPopRule("addChild"));
        digester.addRule("*/dict/true", (Rule)new SetNextAndPopRule("addChild"));
        digester.addRule("*/dict/false", (Rule)new SetNextAndPopRule("addChild"));
        digester.addRule("*/dict/date", (Rule)new SetNextAndPopRule("addChild"));
        digester.addRule("*/dict/dict", (Rule)new SetNextAndPopRule("addChild"));
        digester.addCallMethod("*/dict/string", "addValue", 0);
        digester.addCallMethod("*/dict/data", "addDataValue", 0);
        digester.addCallMethod("*/dict/integer", "addIntegerValue", 0);
        digester.addCallMethod("*/dict/real", "addRealValue", 0);
        digester.addCallMethod("*/dict/true", "addTrueValue");
        digester.addCallMethod("*/dict/false", "addFalseValue");
        digester.addCallMethod("*/dict/date", "addDateValue", 0);
        digester.addRule("*/dict/array", (Rule)new SetNextAndPopRule("addChild"));
        digester.addRule("*/dict/array", (Rule)new ObjectCreateRule(class$org$apache$commons$configuration$plist$XMLPropertyListConfiguration$ArrayNode == null ? (class$org$apache$commons$configuration$plist$XMLPropertyListConfiguration$ArrayNode = XMLPropertyListConfiguration.class$("org.apache.commons.configuration.plist.XMLPropertyListConfiguration$ArrayNode")) : class$org$apache$commons$configuration$plist$XMLPropertyListConfiguration$ArrayNode));
        digester.addSetNext("*/dict/array", "addList");
        digester.addRule("*/array/array", (Rule)new ObjectCreateRule(class$org$apache$commons$configuration$plist$XMLPropertyListConfiguration$ArrayNode == null ? (class$org$apache$commons$configuration$plist$XMLPropertyListConfiguration$ArrayNode = XMLPropertyListConfiguration.class$("org.apache.commons.configuration.plist.XMLPropertyListConfiguration$ArrayNode")) : class$org$apache$commons$configuration$plist$XMLPropertyListConfiguration$ArrayNode));
        digester.addSetNext("*/array/array", "addList");
        digester.addCallMethod("*/array/string", "addValue", 0);
        digester.addCallMethod("*/array/data", "addDataValue", 0);
        digester.addCallMethod("*/array/integer", "addIntegerValue", 0);
        digester.addCallMethod("*/array/real", "addRealValue", 0);
        digester.addCallMethod("*/array/true", "addTrueValue");
        digester.addCallMethod("*/array/false", "addFalseValue");
        digester.addCallMethod("*/array/date", "addDateValue", 0);
        digester.addFactoryCreate("*/array/dict", (ObjectCreationFactory)new AbstractObjectCreationFactory(){

            public Object createObject(Attributes attributes) throws Exception {
                XMLPropertyListConfiguration config = new XMLPropertyListConfiguration();
                ArrayNode node = (ArrayNode)this.getDigester().peek();
                node.addValue(config);
                return config.getRoot();
            }
        });
        digester.push((Object)this.getRoot());
        try {
            digester.parse(in);
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to parse the configuration file", e);
        }
    }

    public void save(Writer out) throws ConfigurationException {
        PrintWriter writer = new PrintWriter(out);
        if (this.getEncoding() != null) {
            writer.println("<?xml version=\"1.0\" encoding=\"" + this.getEncoding() + "\"?>");
        } else {
            writer.println("<?xml version=\"1.0\"?>");
        }
        writer.println("<!DOCTYPE plist SYSTEM \"file://localhost/System/Library/DTDs/PropertyList.dtd\">");
        writer.println("<plist version=\"1.0\">");
        this.printNode(writer, 1, this.getRoot());
        writer.println("</plist>");
        writer.flush();
    }

    private void printNode(PrintWriter out, int indentLevel, HierarchicalConfiguration.Node node) {
        List children;
        String padding = StringUtils.repeat((String)" ", (int)(indentLevel * 4));
        if (node.getName() != null) {
            out.println(padding + "<key>" + StringEscapeUtils.escapeXml((String)node.getName()) + "</key>");
        }
        if (!(children = node.getChildren()).isEmpty()) {
            out.println(padding + "<dict>");
            Iterator it = children.iterator();
            while (it.hasNext()) {
                HierarchicalConfiguration.Node child = (HierarchicalConfiguration.Node)it.next();
                this.printNode(out, indentLevel + 1, child);
                if (!it.hasNext()) continue;
                out.println();
            }
            out.println(padding + "</dict>");
        } else {
            Object value = node.getValue();
            this.printValue(out, indentLevel, value);
        }
    }

    private void printValue(PrintWriter out, int indentLevel, Object value) {
        String padding = StringUtils.repeat((String)" ", (int)(indentLevel * 4));
        if (value instanceof Date) {
            out.println(padding + "<date>" + PListNode.format.format((Date)value) + "</date>");
        } else if (value instanceof Calendar) {
            this.printValue(out, indentLevel, ((Calendar)value).getTime());
        } else if (value instanceof Number) {
            if (value instanceof Double || value instanceof Float || value instanceof BigDecimal) {
                out.println(padding + "<real>" + value.toString() + "</real>");
            } else {
                out.println(padding + "<integer>" + value.toString() + "</integer>");
            }
        } else if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                out.println(padding + "<true/>");
            } else {
                out.println(padding + "<false/>");
            }
        } else if (value instanceof List) {
            out.println(padding + "<array>");
            Iterator it = ((List)value).iterator();
            while (it.hasNext()) {
                this.printValue(out, indentLevel + 1, it.next());
            }
            out.println(padding + "</array>");
        } else if (value instanceof HierarchicalConfiguration) {
            this.printNode(out, indentLevel, ((HierarchicalConfiguration)value).getRoot());
        } else if (value instanceof Configuration) {
            out.println(padding + "<dict>");
            Configuration config = (Configuration)value;
            Iterator it = config.getKeys();
            while (it.hasNext()) {
                String key = (String)it.next();
                HierarchicalConfiguration.Node node = new HierarchicalConfiguration.Node(key);
                node.setValue(config.getProperty(key));
                this.printNode(out, indentLevel + 1, node);
                if (!it.hasNext()) continue;
                out.println();
            }
            out.println(padding + "</dict>");
        } else if (value instanceof Map) {
            Map map = (Map)value;
            this.printValue(out, indentLevel, new MapConfiguration(map));
        } else if (value instanceof byte[]) {
            String base64 = new String(Base64.encodeBase64((byte[])((byte[])value)));
            out.println(padding + "<data>" + StringEscapeUtils.escapeXml((String)base64) + "</data>");
        } else {
            out.println(padding + "<string>" + StringEscapeUtils.escapeXml((String)String.valueOf(value)) + "</string>");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ArrayNode
    extends PListNode {
        private List list = new ArrayList();

        public void addValue(Object value) {
            this.list.add(value);
        }

        public Object getValue() {
            return this.list;
        }
    }

    public static class PListNode
    extends HierarchicalConfiguration.Node {
        private static DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

        public void addValue(Object value) {
            if (this.getValue() == null) {
                this.setValue(value);
            } else if (this.getValue() instanceof List) {
                List list = (List)this.getValue();
                list.add(value);
            } else {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(this.getValue());
                list.add(value);
                this.setValue(list);
            }
        }

        public void addDateValue(String value) {
            try {
                this.addValue(format.parse(value));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }

        public void addDataValue(String value) {
            this.addValue(Base64.decodeBase64((byte[])value.getBytes()));
        }

        public void addIntegerValue(String value) {
            this.addValue(new Integer(value));
        }

        public void addRealValue(String value) {
            this.addValue(new Double(value));
        }

        public void addTrueValue() {
            this.addValue(Boolean.TRUE);
        }

        public void addFalseValue() {
            this.addValue(Boolean.FALSE);
        }

        public void addList(ArrayNode node) {
            this.addValue(node.getValue());
        }
    }

    private class SetNextAndPopRule
    extends SetNextRule {
        public SetNextAndPopRule(String methodName) {
            super(methodName);
        }

        public void end(String namespace, String name) throws Exception {
            super.end(namespace, name);
            ((Rule)this).digester.pop();
        }
    }
}

