/*
 * Decompiled with CFR 0.152.
 */
package play.modules.greenscript;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.modules.greenscript.utils.DependencyManager;
import play.modules.greenscript.utils.Minimizor;
import play.modules.greenscript.utils.SessionManager;
import play.mvc.Scope;

public class GreenScriptPlugin
extends PlayPlugin {
    private static GreenScriptPlugin instance_ = null;
    private Configuration conf_ = null;
    private static String jsDir_ = "/public/javascripts/";
    private static String cssDir_ = "/public/stylesheets/";
    private static String gsDir_ = "/public/gs/";
    private static String jsUrl_ = jsDir_;
    private static String cssUrl_ = cssDir_;
    private static String gsUrl_ = gsDir_;
    private static boolean minimize_ = false;

    public static GreenScriptPlugin getInstance() {
        return instance_;
    }

    public static String getJsDir() {
        return jsDir_;
    }

    public static String getCssDir() {
        return cssDir_;
    }

    public static String getGsDir() {
        return gsDir_;
    }

    public static String getJsUrl() {
        return jsUrl_;
    }

    public static String getCssUrl() {
        return cssUrl_;
    }

    public static String getGsUrl() {
        return gsUrl_;
    }

    public static boolean getMinimizeSetting() {
        return minimize_;
    }

    public static void setMinimizeSetting(boolean minimize) {
        minimize_ = minimize;
    }

    public static boolean getCacheSetting() {
        return Minimizor.getCacheSetting();
    }

    public static void setCacheSetting(boolean cache) {
        Minimizor.setCacheSetting(cache);
    }

    public static boolean getCompressSetting() {
        return Minimizor.getCompressSetting();
    }

    public static void setCompressSetting(boolean compress) {
        Minimizor.setCompressSetting(compress);
    }

    public void configure(Configuration conf) {
        this.conf_ = conf;
        this.configure_(conf);
    }

    public Configuration getConfiguration() {
        return this.conf_;
    }

    private void configure_(Configuration c) {
        Configuration jsConf = c.subset("js");
        Configuration cssConf = c.subset("css");
        DependencyManager.configDependencies(jsConf, cssConf);
        jsDir_ = c.getString("greenscript.dir.js", "/public/javascripts/");
        if (!jsDir_.endsWith("/")) {
            jsDir_ = jsDir_ + "/";
        }
        if (!(cssDir_ = c.getString("greenscript.dir.css", "/public/stylesheets/")).endsWith("/")) {
            cssDir_ = cssDir_ + "/";
        }
        if (!(gsDir_ = c.getString("greenscript.dir.minimized", "/public/gs/")).endsWith("/")) {
            gsDir_ = gsDir_ + "/";
        }
        Minimizor.setGsDir(gsDir_);
        jsUrl_ = c.getString("greenscript.url.js", jsDir_);
        if (!jsUrl_.endsWith("/")) {
            jsUrl_ = jsUrl_ + "/";
        }
        if (!(cssUrl_ = c.getString("greenscript.url.css", cssDir_)).endsWith("/")) {
            cssUrl_ = cssUrl_ + "/";
        }
        if (!(gsUrl_ = c.getString("greenscript.url.minimized", gsDir_)).endsWith("/")) {
            gsUrl_ = gsUrl_ + "/";
        }
        if (!(minimize_ = c.getBoolean("greenscript.minimize", Play.mode == Play.Mode.PROD))) {
            Logger.warn((String)"GreenScript minimizing disabled", (Object[])new Object[0]);
        } else {
            Logger.info((String)"GreenScript minimizing enabled", (Object[])new Object[0]);
        }
        boolean cache = true;
        if (c.containsKey("greenscript.cache")) {
            cache = c.getBoolean("greenscript.cache");
        } else if (c.containsKey("greenscript.nocache")) {
            cache = !c.getBoolean("greenscript.nocache");
        }
        Minimizor.setCacheSetting(cache);
        boolean compress = c.getBoolean("greenscript.compress", true);
        Minimizor.setCompressSetting(compress);
    }

    public void reloadDependency() {
        PropertiesConfiguration c = null;
        try {
            c = new PropertiesConfiguration("greenscript.conf");
        }
        catch (ConfigurationException e) {
            c = new PropertiesConfiguration();
        }
        Configuration jsConf = c.subset("js");
        Configuration cssConf = c.subset("css");
        DependencyManager.configDependencies(jsConf, cssConf);
        ArrayList<String> toBeRemoved = new ArrayList<String>();
        Iterator itr = this.conf_.getKeys("js");
        while (itr.hasNext()) {
            toBeRemoved.add((String)itr.next());
        }
        itr = this.conf_.getKeys("css");
        while (itr.hasNext()) {
            toBeRemoved.add((String)itr.next());
        }
        for (String s : toBeRemoved) {
            this.conf_.clearProperty(s);
        }
        itr = c.getKeys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            this.conf_.addProperty(key, c.getProperty(key));
        }
    }

    public void onConfigurationRead() {
        instance_ = this;
        PropertiesConfiguration c = null;
        try {
            c = new PropertiesConfiguration("greenscript.conf");
        }
        catch (ConfigurationException e) {
            c = new PropertiesConfiguration();
        }
        for (Object key : Play.configuration.keySet()) {
            String ks = (String)key;
            if (!ks.startsWith("greenscript.")) continue;
            String v = Play.configuration.getProperty(ks);
            Logger.debug((String)"[GreenScript]Loading application configuration: %1$s = %2$s", (Object[])new Object[]{ks, v});
            c.setProperty(ks, (Object)v);
        }
        this.configure((Configuration)c);
        Logger.info((String)"GreenScript module initialized", (Object[])new Object[0]);
    }

    public void beforeActionInvocation(Method actionMethod) {
        Scope.RenderArgs.current().put("gsSM", (Object)new SessionManager(jsUrl_, cssUrl_, minimize_));
    }
}

