/*
 * Decompiled with CFR 0.152.
 */
package play.modules.greenscript.utils;

import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import play.Logger;
import play.Play;
import play.exceptions.UnexpectedException;
import play.modules.greenscript.GreenScriptPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Minimizor {
    private static FileCache_ jsBag_ = new FileCache_();
    private static FileCache_ cssBag_ = new FileCache_();
    private static boolean cache_ = true;
    private static boolean compress_ = true;
    private static String gsDir_ = "/public/gs/";
    private static ErrorReporter er_ = new ErrorReporter(){

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0) {
                Logger.warn((String)("[MINIMIZOR.WARNING] " + message), (Object[])new Object[0]);
            } else {
                Logger.warn((String)"[MINIMIZOR.WARNING] %1$s: %2$s: %3$s", (Object[])new Object[]{line, lineOffset, message});
            }
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0) {
                Logger.error((String)("[MINIMIZOR.ERROR] " + message), (Object[])new Object[0]);
            } else {
                Logger.error((String)"[MINIMIZOR.ERROR] %1$s: %2$s: %3$s", (Object[])new Object[]{line, lineOffset, message});
            }
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            this.error(message, sourceName, line, lineSource, lineOffset);
            return new EvaluatorException(message);
        }
    };

    public static String gsDir() {
        return gsDir_;
    }

    public static void setGsDir(String gsDir) {
        if (!gsDir.endsWith("/")) {
            gsDir = gsDir + "/";
        }
        gsDir_ = gsDir.startsWith("/") ? gsDir : "/public/" + gsDir;
    }

    public static boolean getCacheSetting() {
        return cache_;
    }

    public static void setCacheSetting(boolean cache) {
        cache_ = cache;
    }

    public static boolean getCompressSetting() {
        return compress_;
    }

    public static void setCompressSetting(boolean compress) {
        if (compress != compress_) {
            jsBag_.clear();
            cssBag_.clear();
            compress_ = compress;
        }
    }

    public static String minimizeJs(String jsNames) {
        if (null == jsNames) {
            return "";
        }
        return Minimizor.minimizeJs(Arrays.asList(jsNames.split("[,; ]")));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String minimize_(List<String> names, boolean isJs) {
        File outFile;
        FileCache_ fc;
        block11: {
            String fn;
            if (names.size() == 0) {
                return "";
            }
            FileCache_ fileCache_ = fc = isJs ? jsBag_ : cssBag_;
            if (cache_ && null != (fn = fc.get(names))) {
                return fn;
            }
            outFile = Minimizor.randomFile(isJs ? ".js" : ".css");
            Writer out = null;
            try {
                out = new BufferedWriter(new FileWriter(outFile, true));
                for (String s : names) {
                    Minimizor.compress_(s, out, isJs);
                }
                if (out == null) break block11;
            }
            catch (IOException e) {
                try {
                    throw new UnexpectedException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (out == null) throw throwable;
                    try {
                        out.close();
                        throw throwable;
                    }
                    catch (IOException e2) {
                        Logger.warn((String)"cannot close output in minimizor", (Object[])new Object[]{e2});
                    }
                    throw throwable;
                }
            }
            try {
                out.close();
            }
            catch (IOException e) {
                Logger.warn((String)"cannot close output in minimizor", (Object[])new Object[]{e});
            }
        }
        String fn = outFile.getName();
        fc.put(names, fn);
        return fn;
    }

    public static String minimizeJs(List<String> jsNames) {
        return Minimizor.minimize_(jsNames, true);
    }

    public static String minimizeCss(List<String> cssNames) {
        return Minimizor.minimize_(cssNames, false);
    }

    private static String getFullPath_(String fn, boolean isJs) {
        if (isJs && !fn.endsWith(".js")) {
            fn = fn + ".js";
        }
        if (!isJs && !fn.endsWith(".css")) {
            fn = fn + ".css";
        }
        if (fn.startsWith("/")) {
            return fn;
        }
        return isJs ? Minimizor.getJsPath_() + fn : Minimizor.getCssPath_() + fn;
    }

    private static String getJsPath_() {
        return GreenScriptPlugin.getJsDir();
    }

    private static String getCssPath_() {
        return GreenScriptPlugin.getCssDir();
    }

    private static void compress_(String fn, Writer out, boolean isJs) {
        block7: {
            try {
                Logger.trace((String)"minizing... %1$s.%2$s", (Object[])new Object[]{fn, isJs ? "js" : "css"});
                if (fn.startsWith("http")) {
                    return;
                }
                fn = Minimizor.getFullPath_(fn, isJs);
                File inFile = Play.getFile((String)fn);
                BufferedReader in = new BufferedReader(new FileReader(inFile));
                if (compress_) {
                    try {
                        if (isJs) {
                            JavaScriptCompressor compressor = new JavaScriptCompressor((Reader)in, er_);
                            compressor.compress(out, -1, true, false, false, false);
                            break block7;
                        }
                        CssCompressor compressor = new CssCompressor((Reader)in);
                        compressor.compress(out, -1);
                    }
                    catch (Exception e) {
                        Logger.error((String)"error minimizing %2$s file %1$s", (Object[])new Object[]{fn, isJs ? "javascript" : "stylesheet"});
                        in = new BufferedReader(new FileReader(inFile));
                        Minimizor.copy_(in, out, fn);
                    }
                    break block7;
                }
                Minimizor.copy_(in, out, fn);
            }
            catch (IOException e) {
                Logger.error((Throwable)e, (String)"error processing javascript file file %1$s", (Object[])new Object[]{fn});
            }
        }
    }

    private static void copy_(BufferedReader in, Writer out, String fn) throws IOException {
        String line = null;
        PrintWriter writer = new PrintWriter(out);
        while ((line = in.readLine()) != null) {
            writer.println(line);
        }
    }

    private static File tmpDir() {
        File gsDir = Play.getFile((String)gsDir_);
        if (!gsDir.exists()) {
            gsDir.mkdir();
        }
        return gsDir;
    }

    private static File randomFile(String suffix) {
        try {
            return File.createTempFile("gstmp", suffix, Minimizor.tmpDir());
        }
        catch (IOException e) {
            String msg = "Error create temp file for minimizor";
            throw new UnexpectedException(msg, (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileCache_ {
        Map<List<String>, String> m_ = new HashMap<List<String>, String>();

        private FileCache_() {
        }

        private File f_(String fn) {
            return Play.getFile((String)(gsDir_ + fn));
        }

        public String get(List<String> key) {
            String fn = this.m_.get(key);
            if (null == fn) {
                return null;
            }
            if (!this.f_(fn).exists()) {
                this.m_.remove(key);
                return null;
            }
            return fn;
        }

        public String put(List<String> key, String fileName) {
            String old = this.remove(key);
            this.m_.put(key, fileName);
            return old;
        }

        public String remove(List<String> key) {
            String fn = this.m_.remove(key);
            if (null == fn) {
                return null;
            }
            this.delFile_(fn);
            return fn;
        }

        public void clear() {
            for (String fn : this.m_.values()) {
                this.delFile_(fn);
            }
            this.m_.clear();
        }

        private void delFile_(String fn) {
            File f = this.f_(fn);
            if (f.exists() && !f.delete()) {
                f.deleteOnExit();
            }
        }
    }
}

