/*
 * Decompiled with CFR 0.152.
 */
package play.modules.greenscript.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import play.modules.greenscript.GreenScriptPlugin;
import play.modules.greenscript.utils.DependencyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionManager {
    private Set<String> jsLoaded_ = new HashSet<String>();
    private Set<String> jsGlobalLoaded_ = new HashSet<String>();
    private Set<String> jsMissing_ = new HashSet<String>();
    private List<String> cssScrn_ = new ArrayList<String>();
    private List<String> cssPrit_ = new ArrayList<String>();
    private final boolean minimize_;
    private final String jsUrl_;
    private final String cssUrl_;

    public SessionManager(String jsUrl, String cssUrl, boolean minimize) {
        this.jsUrl_ = jsUrl;
        this.cssUrl_ = cssUrl;
        this.minimize_ = minimize;
    }

    public String jsUrl() {
        return this.jsUrl_;
    }

    public String jsUrl(String fn) {
        if (fn.startsWith("http")) {
            return fn;
        }
        fn = fn.startsWith("/") ? fn : this.jsUrl_ + fn;
        fn = fn.endsWith(".js") ? fn : fn + ".js";
        return fn;
    }

    public String cssUrl() {
        return this.cssUrl_;
    }

    public String cssUrl(String fn) {
        if (fn.startsWith("http")) {
            return fn;
        }
        fn = fn.startsWith("/") ? fn : this.cssUrl_ + fn;
        fn = fn.endsWith(".css") ? fn : fn + ".css";
        return fn;
    }

    public boolean minimize() {
        return this.minimize_;
    }

    private boolean addToList_(List<String> list, String name) {
        for (String s : list) {
            if (!s.equalsIgnoreCase(name)) continue;
            return false;
        }
        list.add(name);
        return true;
    }

    public void addCss(List<String> names) {
        this.addCss(names, null);
    }

    public void addCss(List<String> names, String media) {
        List<String> l = "print".equalsIgnoreCase(media) ? this.cssPrit_ : this.cssScrn_;
        for (String nm : names) {
            this.addToList_(l, nm);
        }
    }

    public void addCss(String name) {
        this.addCss(name, null);
    }

    public void addCss(String name, String media) {
        if (null == name) {
            return;
        }
        this.addCss(Arrays.asList(name.split("[,; ]")), media);
    }

    public List<String> addJsLoaded(String name) {
        return this.addJsLoaded(Arrays.asList(name.split("[,; ]")));
    }

    public List<String> addJsLoaded(Collection<String> loaded) {
        ArrayList<String> l = new ArrayList<String>();
        for (String name : loaded) {
            this.jsGlobalLoaded_.add(name);
            if (!this.jsLoaded_.add(name)) continue;
            l.add(name);
            this.jsMissing_.remove(name);
        }
        return l;
    }

    public void clearLoaded() {
        this.jsLoaded_.clear();
    }

    public void addJsMissings(Collection<String> missings) {
        if (null == missings) {
            return;
        }
        this.jsMissing_.addAll(missings);
        this.jsMissing_.removeAll(this.jsGlobalLoaded_);
    }

    public void addJsMissings(String name) {
        if (null == name) {
            return;
        }
        this.addJsMissings(Arrays.asList(name.split("[,; ]")));
    }

    public List<String> getJsMissings() {
        List<String> ret = DependencyManager.JS_DEP_MGR.comprehend(this.jsMissing_, true);
        return ret;
    }

    public List<String> getCssList(String media) {
        List<String> l = this.comprehend_(media);
        return l;
    }

    private List<String> comprehend_(String media) {
        return DependencyManager.CSS_DEP_MGR.comprehend("print".equalsIgnoreCase(media) ? this.cssPrit_ : this.cssScrn_);
    }

    public Collection<String> asList(Object o) {
        if (null == o) {
            return Collections.emptyList();
        }
        if (o instanceof Collection) {
            return (Collection)o;
        }
        return Arrays.asList(o.toString().split("[,; ]"));
    }

    public String gsUrl() {
        return GreenScriptPlugin.getGsUrl();
    }

    public String gsUrl(String fn) {
        return GreenScriptPlugin.getGsUrl() + fn;
    }

    public List<String> getCdnItems(Collection<String> list) {
        ArrayList<String> l = new ArrayList<String>();
        for (String s : list) {
            if (!s.startsWith("http")) continue;
            l.add(s);
        }
        return l;
    }
}

