/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.rhino.Node;
import java.util.List;

class AstChangeProxy {
    private final List<ChangeListener> listeners = Lists.newArrayList();

    AstChangeProxy() {
    }

    final void registerListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    final void unregisterListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void notifyOfRemoval(Node node) {
        for (ChangeListener changeListener : this.listeners) {
            changeListener.nodeRemoved(node);
        }
    }

    final void removeChild(Node node, Node node2) {
        node.removeChild(node2);
        this.notifyOfRemoval(node2);
    }

    final void replaceWith(Node node, Node node2, Node node3) {
        this.replaceWith(node, node2, Lists.newArrayList((Object[])new Node[]{node3}));
    }

    final void replaceWith(Node node, Node node2, List<Node> list) {
        Preconditions.checkNotNull(list, (Object)"\"replacements\" is null.");
        int n = list.size();
        if (n == 1 && node2.checkTreeEqualsSilent(list.get(0))) {
            return;
        }
        int n2 = node.getType();
        Preconditions.checkState((n == 1 || n2 == 125 || n2 == 132 || n2 == 126 ? 1 : 0) != 0);
        if (n2 == 126 && n != 1) {
            Node node3 = new Node(125);
            for (Node node4 : list) {
                node4.copyInformationFrom(node2);
                Node node5 = node4.getParent();
                node3.addChildToBack(node4);
            }
            node.replaceChild(node2, node3);
        } else {
            for (Node node6 : list) {
                node6.copyInformationFrom(node2);
                Node node7 = node6.getParent();
                node.addChildBefore(node6, node2);
            }
            node.removeChild(node2);
        }
        this.notifyOfRemoval(node2);
    }

    static interface ChangeListener {
        public void nodeRemoved(Node var1);
    }
}

