/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CombinedCompilerPass;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

final class ClosureCodeRemoval
implements CompilerPass {
    private final AbstractCompiler compiler;
    static final String ABSTRACT_METHOD_NAME = "goog.abstractMethod";
    private final boolean removeAbstractMethods;
    private final boolean removeAssertionCalls;
    private final List<RemovableAssignment> abstractMethodAssignmentNodes = Lists.newArrayList();
    private final List<Node> assertionCalls = Lists.newArrayList();

    ClosureCodeRemoval(AbstractCompiler abstractCompiler, boolean bl, boolean bl2) {
        this.compiler = abstractCompiler;
        this.removeAbstractMethods = bl;
        this.removeAssertionCalls = bl2;
    }

    @Override
    public void process(Node node, Node node2) {
        ArrayList arrayList = Lists.newArrayList();
        if (this.removeAbstractMethods) {
            arrayList.add(new FindAbstractMethods());
        }
        if (this.removeAssertionCalls) {
            arrayList.add(new FindAssertionCalls());
        }
        CombinedCompilerPass.traverse(this.compiler, node2, arrayList);
        for (RemovableAssignment object : this.abstractMethodAssignmentNodes) {
            object.remove();
        }
        for (Node node3 : this.assertionCalls) {
            Node node4 = node3.getParent();
            if (NodeUtil.isExpressionNode(node4)) {
                node4.getParent().removeChild(node4);
            } else {
                Node node5 = node3.getFirstChild().getNext();
                if (node5 == null) {
                    node4.replaceChild(node3, NodeUtil.newUndefinedNode(node3));
                } else {
                    node4.replaceChild(node3, node5.detachFromParent());
                }
            }
            this.compiler.reportCodeChange();
        }
    }

    private class FindAssertionCalls
    extends NodeTraversal.AbstractPostOrderCallback {
        Set<String> assertionNames = Sets.newHashSet();

        FindAssertionCalls() {
            for (CodingConvention.AssertionFunctionSpec assertionFunctionSpec : ClosureCodeRemoval.this.compiler.getCodingConvention().getAssertionFunctions()) {
                this.assertionNames.add(assertionFunctionSpec.getFunctionName());
            }
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            String string;
            if (node.getType() == 37 && this.assertionNames.contains(string = node.getFirstChild().getQualifiedName())) {
                ClosureCodeRemoval.this.assertionCalls.add(node);
            }
        }
    }

    private class FindAbstractMethods
    extends NodeTraversal.AbstractPostOrderCallback {
        private FindAbstractMethods() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node.getType() == 86) {
                Node node3 = node.getFirstChild();
                Node node4 = node.getLastChild();
                if (node3.isQualifiedName() && node4.isQualifiedName() && ClosureCodeRemoval.ABSTRACT_METHOD_NAME.equals(node4.getQualifiedName())) {
                    ClosureCodeRemoval.this.abstractMethodAssignmentNodes.add(new RemovableAssignment(node.getFirstChild(), node, nodeTraversal));
                }
            }
        }
    }

    private class RemovableAssignment {
        final Node node;
        final Node parent;
        final List<Node> assignAncestors = Lists.newArrayList();
        final Node lastAncestor;

        public RemovableAssignment(Node node, Node node2, NodeTraversal nodeTraversal) {
            this.node = node;
            this.parent = node2;
            Node node3 = node2;
            do {
                node3 = node3.getParent();
                this.assignAncestors.add(node3);
            } while (node3.getType() == 86 && node3.getFirstChild().isQualifiedName());
            this.lastAncestor = node3.getParent();
        }

        public void remove() {
            Node node = this.node.getNext();
            Node node2 = this.parent;
            for (Node node3 : this.assignAncestors) {
                if (NodeUtil.isExpressionNode(node3)) {
                    this.lastAncestor.removeChild(node3);
                } else {
                    node.detachFromParent();
                    node3.replaceChild(node2, node);
                }
                node2 = node3;
            }
            ClosureCodeRemoval.this.compiler.reportCodeChange();
        }
    }
}

