/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.LiveVariablesAnalysis;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.Graph;
import com.google.javascript.jscomp.graph.GraphColoring;
import com.google.javascript.jscomp.graph.GraphNode;
import com.google.javascript.jscomp.graph.LinkedUndirectedGraph;
import com.google.javascript.jscomp.graph.UndiGraph;
import com.google.javascript.rhino.Node;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

class CoalesceVariableNames
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass,
NodeTraversal.ScopedCallback {
    private final AbstractCompiler compiler;
    private final Deque<GraphColoring<Scope.Var, Void>> colorings;
    private final boolean usePseudoNames;
    private static final Comparator<Scope.Var> coloringTieBreaker = new Comparator<Scope.Var>(){

        @Override
        public int compare(Scope.Var var, Scope.Var var2) {
            return var.index - var2.index;
        }
    };

    CoalesceVariableNames(AbstractCompiler abstractCompiler, boolean bl) {
        Preconditions.checkState((!abstractCompiler.isNormalized() ? 1 : 0) != 0);
        this.compiler = abstractCompiler;
        this.colorings = Lists.newLinkedList();
        this.usePseudoNames = bl;
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node2, this);
    }

    @Override
    public void enterScope(NodeTraversal nodeTraversal) {
        if (nodeTraversal.inGlobalScope()) {
            return;
        }
        Scope scope = nodeTraversal.getScope();
        ControlFlowGraph<Node> controlFlowGraph = nodeTraversal.getControlFlowGraph();
        LiveVariablesAnalysis liveVariablesAnalysis = new LiveVariablesAnalysis(controlFlowGraph, scope, this.compiler);
        if (scope.getRootNode().getFirstChild().getNext().getChildCount() == 2) {
            liveVariablesAnalysis.markAllParametersEscaped();
        }
        liveVariablesAnalysis.analyze();
        UndiGraph<Scope.Var, Void> undiGraph = this.computeVariableNamesInterferenceGraph(nodeTraversal, controlFlowGraph, liveVariablesAnalysis.getEscapedLocals());
        GraphColoring.GreedyGraphColoring<Scope.Var, Void> greedyGraphColoring = new GraphColoring.GreedyGraphColoring<Scope.Var, Void>(undiGraph, coloringTieBreaker);
        ((GraphColoring)greedyGraphColoring).color();
        this.colorings.push(greedyGraphColoring);
    }

    @Override
    public void exitScope(NodeTraversal nodeTraversal) {
        if (nodeTraversal.inGlobalScope()) {
            return;
        }
        this.colorings.pop();
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        if (this.colorings.isEmpty() || !NodeUtil.isName(node) || NodeUtil.isFunction(node2)) {
            return;
        }
        Scope.Var var = nodeTraversal.getScope().getVar(node.getString());
        GraphNode<Scope.Var, Void> graphNode = this.colorings.peek().getGraph().getNode(var);
        if (graphNode == null) {
            return;
        }
        Scope.Var var2 = this.colorings.peek().getPartitionSuperNode(var);
        if (!this.usePseudoNames) {
            if (graphNode.getValue().equals(var2)) {
                return;
            }
            node.setString(var2.name);
            this.compiler.reportCodeChange();
            if (NodeUtil.isVar(node2)) {
                this.removeVarDeclaration(node);
            }
        } else {
            String string = null;
            TreeSet treeSet = Sets.newTreeSet();
            Iterator<Scope.Var> iterator = nodeTraversal.getScope().getVars();
            while (iterator.hasNext()) {
                Scope.Var var3 = iterator.next();
                if (this.colorings.peek().getGraph().getNode(var3) == null || !var2.equals(this.colorings.peek().getPartitionSuperNode(var3))) continue;
                treeSet.add(var3.name);
            }
            if (treeSet.size() == 1) {
                return;
            }
            string = Joiner.on((String)"_").join((Iterable)treeSet);
            while (nodeTraversal.getScope().isDeclared(string, true)) {
                string = string + "$";
            }
            node.setString(string);
            this.compiler.reportCodeChange();
            if (!graphNode.getValue().equals(var2) && NodeUtil.isVar(node2)) {
                this.removeVarDeclaration(node);
            }
        }
    }

    private UndiGraph<Scope.Var, Void> computeVariableNamesInterferenceGraph(NodeTraversal nodeTraversal, ControlFlowGraph<Node> controlFlowGraph, Set<Scope.Var> set) {
        Scope.Var var;
        LinkedUndirectedGraph<Scope.Var, Void> linkedUndirectedGraph = LinkedUndirectedGraph.create();
        Scope scope = nodeTraversal.getScope();
        Iterator<Scope.Var> iterator = scope.getVars();
        while (iterator.hasNext()) {
            var = iterator.next();
            if (set.contains(var) || NodeUtil.isFunction(var.getParentNode())) continue;
            ((Graph)linkedUndirectedGraph).createNode(var);
        }
        iterator = scope.getVars();
        while (iterator.hasNext()) {
            var = iterator.next();
            Iterator<Scope.Var> iterator2 = scope.getVars();
            block2: while (iterator2.hasNext()) {
                DataFlowAnalysis.FlowState flowState;
                Scope.Var var2 = iterator2.next();
                if (var.index >= var2.index || !linkedUndirectedGraph.hasNode(var) || !linkedUndirectedGraph.hasNode(var2)) continue;
                if (var.getParentNode().getType() == 83 && var2.getParentNode().getType() == 83) {
                    linkedUndirectedGraph.connectIfNotFound(var, null, var2);
                    continue;
                }
                for (DiGraph.DiGraphNode diGraphNode : controlFlowGraph.getDirectedGraphNodes()) {
                    if (controlFlowGraph.isImplicitReturn(diGraphNode) || (!((LiveVariablesAnalysis.LiveVariableLattice)(flowState = (DataFlowAnalysis.FlowState)diGraphNode.getAnnotation()).getIn()).isLive(var) || !((LiveVariablesAnalysis.LiveVariableLattice)flowState.getIn()).isLive(var2)) && (!((LiveVariablesAnalysis.LiveVariableLattice)flowState.getOut()).isLive(var) || !((LiveVariablesAnalysis.LiveVariableLattice)flowState.getOut()).isLive(var2))) continue;
                    linkedUndirectedGraph.connectIfNotFound(var, null, var2);
                    continue block2;
                }
                for (DiGraph.DiGraphNode diGraphNode : controlFlowGraph.getDirectedGraphNodes()) {
                    if (controlFlowGraph.isImplicitReturn(diGraphNode)) continue;
                    flowState = (DataFlowAnalysis.FlowState)diGraphNode.getAnnotation();
                    boolean bl = ((LiveVariablesAnalysis.LiveVariableLattice)flowState.getOut()).isLive(var);
                    boolean bl2 = ((LiveVariablesAnalysis.LiveVariableLattice)flowState.getOut()).isLive(var2);
                    CombinedLiveRangeChecker combinedLiveRangeChecker = new CombinedLiveRangeChecker(new LiveRangeChecker(var, bl2 ? null : var2), new LiveRangeChecker(var2, bl ? null : var));
                    NodeTraversal.traverse(this.compiler, (Node)diGraphNode.getValue(), combinedLiveRangeChecker);
                    if (!combinedLiveRangeChecker.connectIfCrossed(linkedUndirectedGraph)) continue;
                    continue block2;
                }
            }
        }
        return linkedUndirectedGraph;
    }

    private void removeVarDeclaration(Node node) {
        Node node2 = node.getParent();
        Node node3 = node2.getParent();
        if (NodeUtil.isForIn(node3)) {
            node2.removeChild(node);
            node3.replaceChild(node2, node);
        } else if (node2.hasOneChild()) {
            if (node.hasChildren()) {
                Node node4 = node.removeFirstChild();
                node2.removeChild(node);
                Node node5 = new Node(86, node, node4).copyInformationFrom(node);
                if (node3.getType() != 115) {
                    node5 = NodeUtil.newExpr(node5);
                }
                node3.replaceChild(node2, node5);
            } else {
                NodeUtil.removeChild(node3, node2);
            }
        } else if (!node.hasChildren()) {
            node2.removeChild(node);
        }
    }

    private static class LiveRangeChecker
    extends ControlFlowGraph.AbstractCfgNodeTraversalCallback {
        boolean defFound = false;
        boolean crossed = false;
        private final Scope.Var def;
        private final Scope.Var use;

        public LiveRangeChecker(Scope.Var var, Scope.Var var2) {
            this.def = var;
            this.use = var2;
        }

        Scope.Var getDef() {
            return this.def;
        }

        public static boolean shouldVisit(Node node) {
            return NodeUtil.isName(node) || node.hasChildren() && NodeUtil.isName(node.getFirstChild());
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (!this.defFound && LiveRangeChecker.isAssignTo(this.def, node, node2)) {
                this.defFound = true;
            }
            if (this.defFound && (this.use == null || LiveRangeChecker.isReadFrom(this.use, node))) {
                this.crossed = true;
            }
        }

        private static boolean isAssignTo(Scope.Var var, Node node, Node node2) {
            if (NodeUtil.isName(node) && var.getName().equals(node.getString()) && node2 != null) {
                if (node2.getType() == 83) {
                    return true;
                }
                if (NodeUtil.isVar(node2)) {
                    return node.hasChildren();
                }
                return false;
            }
            Node node3 = node.getFirstChild();
            return node3 != null && NodeUtil.isName(node3) && var.getName().equals(node3.getString()) && NodeUtil.isAssignmentOp(node);
        }

        private static boolean isReadFrom(Scope.Var var, Node node) {
            return node != null && NodeUtil.isName(node) && var.getName().equals(node.getString()) && !NodeUtil.isLhs(node, node.getParent());
        }
    }

    private static class CombinedLiveRangeChecker
    extends ControlFlowGraph.AbstractCfgNodeTraversalCallback {
        private final LiveRangeChecker callback1;
        private final LiveRangeChecker callback2;

        CombinedLiveRangeChecker(LiveRangeChecker liveRangeChecker, LiveRangeChecker liveRangeChecker2) {
            this.callback1 = liveRangeChecker;
            this.callback2 = liveRangeChecker2;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (LiveRangeChecker.shouldVisit(node)) {
                this.callback1.visit(nodeTraversal, node, node2);
                this.callback2.visit(nodeTraversal, node, node2);
            }
        }

        boolean connectIfCrossed(UndiGraph<Scope.Var, Void> undiGraph) {
            if (this.callback1.crossed || this.callback2.crossed) {
                Scope.Var var = this.callback1.getDef();
                Scope.Var var2 = this.callback2.getDef();
                undiGraph.connectIfNotFound(var, null, var2);
                return true;
            }
            return false;
        }
    }
}

