/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CombinedCompilerPass;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.List;
import java.util.Set;

class CollapseVariableDeclarations
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final List<Collapse> collapses = Lists.newArrayList();
    private final Set<Node> nodesToCollapse = Sets.newHashSet();

    CollapseVariableDeclarations(AbstractCompiler abstractCompiler) {
        Preconditions.checkState((!abstractCompiler.isNormalized() ? 1 : 0) != 0);
        this.compiler = abstractCompiler;
    }

    @Override
    public void process(Node node, Node node2) {
        this.collapses.clear();
        this.nodesToCollapse.clear();
        NodeTraversal.traverse(this.compiler, node2, new CombinedCompilerPass(this.compiler, new ExploitAssigns(), new GatherCollapses()));
        if (!this.collapses.isEmpty()) {
            this.applyCollapses();
            this.compiler.reportCodeChange();
        }
    }

    private boolean isSafeReplacement(Node node, Node node2) {
        if (node.getType() == 38) {
            return true;
        }
        Preconditions.checkArgument((node.getType() == 33 ? 1 : 0) != 0);
        Node node3 = node.getFirstChild();
        return node3.getType() != 38 || !this.isNameAssignedTo(node3.getString(), node2);
    }

    private boolean isNameAssignedTo(String string, Node node) {
        Node node2;
        for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            if (!this.isNameAssignedTo(string, node2)) continue;
            return true;
        }
        return node.getType() == 38 && (node2 = node.getParent()).getType() == 86 && node2.getFirstChild() == node && string.equals(node.getString());
    }

    private void applyCollapses() {
        for (Collapse collapse : this.collapses) {
            Node node = collapse.firstVarNode;
            while (node.getNext() != null && node.getNext().getType() == 118) {
                Node node2 = collapse.parent.removeChildAfter(node);
                node.addChildrenToBack(node2.removeChildren());
            }
        }
    }

    private class GatherCollapses
    extends NodeTraversal.AbstractPostOrderCallback {
        private GatherCollapses() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node.getType() != 118) {
                return;
            }
            if (CollapseVariableDeclarations.this.nodesToCollapse.contains(node)) {
                return;
            }
            if (node2.getType() == 108) {
                return;
            }
            Node node3 = node;
            boolean bl = false;
            for (node = node.getNext(); node != null && node.getType() == 118; node = node.getNext()) {
                CollapseVariableDeclarations.this.nodesToCollapse.add(node);
                bl = true;
            }
            if (bl) {
                CollapseVariableDeclarations.this.nodesToCollapse.add(node3);
                CollapseVariableDeclarations.this.collapses.add(new Collapse(node3, node2));
            }
        }
    }

    private class ExploitAssigns
    extends NodeTraversal.AbstractPostOrderCallback {
        private ExploitAssigns() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (!NodeUtil.isExprAssign(node)) {
                return;
            }
            this.collapseAssign(nodeTraversal, node.getFirstChild(), node, node2);
        }

        private void collapseAssign(NodeTraversal nodeTraversal, Node node, Node node2, Node node3) {
            Node node4 = node.getFirstChild();
            Node node5 = node4.getNext();
            if (this.isCollapsibleValue(node4, true) && this.collapseAssignEqualTo(node2, node3, node4)) {
                nodeTraversal.getCompiler().reportCodeChange();
            } else if (this.isCollapsibleValue(node5, false) && this.collapseAssignEqualTo(node2, node3, node5)) {
                nodeTraversal.getCompiler().reportCodeChange();
            } else if (node5.getType() == 86) {
                this.collapseAssign(nodeTraversal, node5, node2, node3);
            }
        }

        private boolean isCollapsibleValue(Node node, boolean bl) {
            switch (node.getType()) {
                case 33: {
                    return !bl || node.getFirstChild().getType() == 42;
                }
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 43: 
                case 44: {
                    return true;
                }
            }
            return false;
        }

        private boolean collapseAssignEqualTo(Node node, Node node2, Node node3) {
            Node node4 = node.getFirstChild();
            Node node5 = node2;
            Node node6 = node.getNext();
            block7: while (node6 != null) {
                switch (node6.getType()) {
                    case 4: 
                    case 98: 
                    case 100: 
                    case 101: 
                    case 108: 
                    case 130: {
                        node5 = node6;
                        node6 = node6.getFirstChild();
                        continue block7;
                    }
                    case 118: {
                        if (node6.getFirstChild().hasChildren()) {
                            node5 = node6.getFirstChild();
                            node6 = node5.getFirstChild();
                            continue block7;
                        }
                        return false;
                    }
                    case 33: 
                    case 38: {
                        Object object;
                        if (node6.isQualifiedName()) {
                            object = node6.getQualifiedName();
                            if (node3.isQualifiedName() && ((String)object).equals(node3.getQualifiedName())) {
                                if (!CollapseVariableDeclarations.this.isSafeReplacement(node6, node4)) {
                                    return false;
                                }
                                node2.removeChild(node);
                                node.removeChild(node4);
                                node5.replaceChild(node6, node4);
                                return true;
                            }
                        }
                        return false;
                    }
                    case 39: 
                    case 40: 
                    case 41: 
                    case 43: 
                    case 44: {
                        if (node3.getType() == node6.getType()) {
                            if (!(node6.getType() != 40 && node6.getType() != 39 || node6.isEquivalentTo(node3))) {
                                return false;
                            }
                            node2.removeChild(node);
                            node.removeChild(node4);
                            node5.replaceChild(node6, node4);
                            return true;
                        }
                        return false;
                    }
                    case 86: {
                        Object object = node6.getFirstChild();
                        if (((Node)object).getType() == 38 || ((Node)object).getType() == 33 && ((Node)object).getFirstChild().getType() == 42) {
                            node5 = node6;
                            node6 = ((Node)object).getNext();
                            continue block7;
                        }
                        return false;
                    }
                }
                return false;
            }
            return false;
        }
    }

    private static class Collapse {
        final Node firstVarNode;
        final Node parent;

        Collapse(Node node, Node node2) {
            this.firstVarNode = node;
            this.parent = node2;
        }
    }
}

