/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.ReferenceCollectingCallback;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.VariableVisibilityAnalysis;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class SideEffectsAnalysis
implements CompilerPass {
    private static final Predicate<Node> NOT_FUNCTION_PREDICATE = new Predicate<Node>(){

        public boolean apply(Node node) {
            return !NodeUtil.isFunction(node);
        }
    };
    private AbstractCompiler compiler;
    private LocationAbstraction locationAbstraction;
    private final LocationAbstractionMode locationAbstractionIdentifier;

    public SideEffectsAnalysis(AbstractCompiler abstractCompiler, LocationAbstractionMode locationAbstractionMode) {
        this.compiler = abstractCompiler;
        this.locationAbstractionIdentifier = locationAbstractionMode;
    }

    public SideEffectsAnalysis(AbstractCompiler abstractCompiler) {
        this(abstractCompiler, LocationAbstractionMode.DEGENERATE);
    }

    @Override
    public void process(Node node, Node node2) {
        switch (this.locationAbstractionIdentifier) {
            case DEGENERATE: {
                this.locationAbstraction = new DegenerateLocationAbstraction();
                break;
            }
            case VISIBILITY_BASED: {
                this.locationAbstraction = this.createVisibilityAbstraction(node, node2);
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized location abstraction identifier: " + (Object)((Object)this.locationAbstractionIdentifier));
            }
        }
    }

    private LocationAbstraction createVisibilityAbstraction(Node node, Node node2) {
        VariableVisibilityAnalysis variableVisibilityAnalysis = new VariableVisibilityAnalysis(this.compiler);
        variableVisibilityAnalysis.process(node, node2);
        VariableUseDeclarationMap variableUseDeclarationMap = new VariableUseDeclarationMap(this.compiler);
        variableUseDeclarationMap.mapUses(node2);
        return new VisibilityLocationAbstraction(this.compiler, variableVisibilityAnalysis, variableUseDeclarationMap);
    }

    public boolean safeToMoveBefore(Node node, AbstractMotionEnvironment abstractMotionEnvironment, Node node2) {
        Preconditions.checkNotNull((Object)this.locationAbstraction);
        Preconditions.checkArgument((!SideEffectsAnalysis.nodeHasAncestor(node2, node) ? 1 : 0) != 0);
        if (this.isPure(node)) {
            return true;
        }
        if (this.nodeHasCall(node)) {
            return false;
        }
        LocationSummary locationSummary = this.locationAbstraction.calculateLocationSummary(node);
        EffectLocation effectLocation = locationSummary.getModSet();
        if (!effectLocation.isEmpty() && !SideEffectsAnalysis.nodesHaveSameControlFlow(node, node2)) {
            return false;
        }
        EffectLocation effectLocation2 = locationSummary.getRefSet();
        Set<Node> set = abstractMotionEnvironment.calculateEnvironment();
        for (Node object2 : set) {
            if (!this.nodeHasCall(object2)) continue;
            return false;
        }
        LocationSummary locationSummary2 = this.locationAbstraction.calculateLocationSummary(set);
        EffectLocation effectLocation3 = locationSummary2.getModSet();
        EffectLocation effectLocation4 = locationSummary2.getRefSet();
        return !effectLocation3.intersectsLocation(effectLocation2) && !effectLocation4.intersectsLocation(effectLocation) && !effectLocation3.intersectsLocation(effectLocation);
    }

    private boolean isPure(Node node) {
        return false;
    }

    private static boolean nodesHaveSameControlFlow(Node node, Node node2) {
        Node node3;
        Node node4 = SideEffectsAnalysis.closestControlDependentAncestor(node);
        if (node4 == (node3 = SideEffectsAnalysis.closestControlDependentAncestor(node2))) {
            if (node3 != null) {
                if (node3.getType() == 111) {
                    return false;
                }
                Predicate<Node> predicate = new Predicate<Node>(){

                    public boolean apply(Node node) {
                        int n = node.getType();
                        return n == 4 || n == 116 || n == 117;
                    }
                };
                return !NodeUtil.has(node3, predicate, NOT_FUNCTION_PREDICATE);
            }
            return true;
        }
        return false;
    }

    private static boolean isControlDependentChild(Node node) {
        Node node2 = node.getParent();
        if (node2 == null) {
            return false;
        }
        ArrayList arrayList = Lists.newArrayList(node2.children());
        int n = arrayList.indexOf(node);
        switch (node2.getType()) {
            case 98: 
            case 108: {
                return n == 1 || n == 2;
            }
            case 113: 
            case 114: {
                return true;
            }
            case 115: {
                return n != 0;
            }
            case 110: {
                return n > 0;
            }
            case 101: {
                return true;
            }
            case 100: {
                return true;
            }
            case 105: {
                return true;
            }
        }
        return false;
    }

    private static Node closestControlDependentAncestor(Node node) {
        if (SideEffectsAnalysis.isControlDependentChild(node)) {
            return node;
        }
        for (Node node2 : node.getAncestors()) {
            if (!SideEffectsAnalysis.isControlDependentChild(node2)) continue;
            return node2;
        }
        return null;
    }

    private static boolean nodeHasAncestor(Node node, Node node2) {
        for (Node node3 : node.getAncestors()) {
            if (node3 != node2) continue;
            return true;
        }
        return false;
    }

    private boolean nodeHasCall(Node node) {
        return NodeUtil.has(node, new Predicate<Node>(){

            public boolean apply(Node node) {
                return NodeUtil.isCall(node) || NodeUtil.isNew(node);
            }
        }, NOT_FUNCTION_PREDICATE);
    }

    private static class VariableUseDeclarationMap {
        private AbstractCompiler compiler;
        private Map<Node, Node> referencesByNameNode;

        public VariableUseDeclarationMap(AbstractCompiler abstractCompiler) {
            this.compiler = abstractCompiler;
        }

        public void mapUses(Node node) {
            this.referencesByNameNode = Maps.newHashMap();
            ReferenceCollectingCallback referenceCollectingCallback = new ReferenceCollectingCallback(this.compiler, ReferenceCollectingCallback.DO_NOTHING_BEHAVIOR);
            NodeTraversal.traverse(this.compiler, node, referenceCollectingCallback);
            for (Scope.Var var : referenceCollectingCallback.getReferencedVariables()) {
                ReferenceCollectingCallback.ReferenceCollection referenceCollection = referenceCollectingCallback.getReferenceCollection(var);
                for (ReferenceCollectingCallback.Reference reference : referenceCollection.references) {
                    Node node2 = reference.getNameNode();
                    this.referencesByNameNode.put(node2, var.getNameNode());
                }
            }
        }

        public Node findDeclaringNameNodeForUse(Node node) {
            Preconditions.checkArgument((boolean)NodeUtil.isName(node));
            return this.referencesByNameNode.get(node);
        }
    }

    private static class VisibilityLocationAbstraction
    extends LocationAbstraction {
        private static final int VISIBILITY_LOCATION_NONE = 0;
        private static final int UNKNOWN_LOCATION_MASK = -1;
        private static final int LOCAL_VARIABLE_LOCATION_MASK = 2;
        private static final int CAPTURED_LOCAL_VARIABLE_LOCATION_MASK = 4;
        private static final int GLOBAL_VARIABLE_LOCATION_MASK = 8;
        private static final int HEAP_LOCATION_MASK = 16;
        AbstractCompiler compiler;
        VariableVisibilityAnalysis variableVisibilityAnalysis;
        VariableUseDeclarationMap variableUseMap;

        private VisibilityLocationAbstraction(AbstractCompiler abstractCompiler, VariableVisibilityAnalysis variableVisibilityAnalysis, VariableUseDeclarationMap variableUseDeclarationMap) {
            this.compiler = abstractCompiler;
            this.variableVisibilityAnalysis = variableVisibilityAnalysis;
            this.variableUseMap = variableUseDeclarationMap;
        }

        @Override
        LocationSummary calculateLocationSummary(Node node) {
            int n = 0;
            int n2 = 0;
            for (Node object2 : this.findStorageLocationReferences(node)) {
                int n3 = NodeUtil.isName(object2) ? this.effectMaskForVariableReference(object2) : 16;
                if (VisibilityLocationAbstraction.storageNodeIsLValue(object2)) {
                    n2 |= n3;
                }
                if (!VisibilityLocationAbstraction.storageNodeIsRValue(object2)) continue;
                n |= n3;
            }
            VisibilityBasedEffectLocation visibilityBasedEffectLocation = new VisibilityBasedEffectLocation(n2);
            VisibilityBasedEffectLocation visibilityBasedEffectLocation2 = new VisibilityBasedEffectLocation(n);
            return new LocationSummary(visibilityBasedEffectLocation, visibilityBasedEffectLocation2);
        }

        private Set<Node> findStorageLocationReferences(Node node) {
            final HashSet hashSet = Sets.newHashSet();
            NodeTraversal.traverse(this.compiler, node, new NodeTraversal.AbstractShallowCallback(){

                @Override
                public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
                    if (NodeUtil.isGet(node) || NodeUtil.isName(node) && !NodeUtil.isFunction(node2)) {
                        hashSet.add(node);
                    }
                }
            });
            return hashSet;
        }

        private int effectMaskForVariableReference(Node node) {
            Preconditions.checkArgument((boolean)NodeUtil.isName(node));
            int n = 0;
            Node node2 = this.variableUseMap.findDeclaringNameNodeForUse(node);
            if (node2 != null) {
                VariableVisibilityAnalysis.VariableVisibility variableVisibility = this.variableVisibilityAnalysis.getVariableVisibility(node2);
                switch (variableVisibility) {
                    case LOCAL: {
                        n = 2;
                        break;
                    }
                    case CAPTURED_LOCAL: {
                        n = 4;
                        break;
                    }
                    case PARAMETER: {
                        n = 16;
                        break;
                    }
                    case GLOBAL: {
                        n = 8;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unrecognized variable visibility: " + (Object)((Object)variableVisibility));
                    }
                }
            } else {
                n = -1;
            }
            return n;
        }

        @Override
        EffectLocation getBottomLocation() {
            return new VisibilityBasedEffectLocation(0);
        }

        private static boolean isStorageNode(Node node) {
            return NodeUtil.isName(node) || NodeUtil.isGet(node);
        }

        private static boolean storageNodeIsRValue(Node node) {
            Preconditions.checkArgument((boolean)VisibilityLocationAbstraction.isStorageNode(node));
            Node node2 = node.getParent();
            if (VisibilityLocationAbstraction.storageNodeIsLValue(node)) {
                boolean bl = NodeUtil.isAssignmentOp(node2) && node2.getType() != 86;
                return bl || node2.getType() == 103 || node2.getType() == 102;
            }
            return true;
        }

        private static boolean storageNodeIsLValue(Node node) {
            Preconditions.checkArgument((boolean)VisibilityLocationAbstraction.isStorageNode(node));
            Node node2 = node.getParent();
            return NodeUtil.isAssignmentOp(node2) && node2.getFirstChild() == node || NodeUtil.isForIn(node2) && node2.getFirstChild() == node || NodeUtil.isVar(node2) || node2.getType() == 103 || node2.getType() == 102;
        }

        private static class VisibilityBasedEffectLocation
        implements EffectLocation {
            int visibilityMask = 0;

            public VisibilityBasedEffectLocation(int n) {
                this.visibilityMask = n;
            }

            @Override
            public boolean intersectsLocation(EffectLocation effectLocation) {
                Preconditions.checkArgument((boolean)(effectLocation instanceof VisibilityBasedEffectLocation));
                int n = ((VisibilityBasedEffectLocation)effectLocation).visibilityMask;
                return (this.visibilityMask & n) > 0;
            }

            @Override
            public boolean isEmpty() {
                return this.visibilityMask == 0;
            }

            @Override
            public EffectLocation join(EffectLocation effectLocation) {
                Preconditions.checkArgument((boolean)(effectLocation instanceof VisibilityBasedEffectLocation));
                int n = ((VisibilityBasedEffectLocation)effectLocation).visibilityMask;
                int n2 = this.visibilityMask | n;
                return new VisibilityBasedEffectLocation(n2);
            }
        }
    }

    private static class DegenerateLocationAbstraction
    extends LocationAbstraction {
        private static final EffectLocation EVERY_LOCATION = new DegenerateEffectLocation();
        private static final EffectLocation NO_LOCATION = new DegenerateEffectLocation();

        private DegenerateLocationAbstraction() {
        }

        @Override
        EffectLocation getBottomLocation() {
            return NO_LOCATION;
        }

        @Override
        public LocationSummary calculateLocationSummary(Node node) {
            return new LocationSummary(this.calculateModSet(node), this.calculateRefSet(node));
        }

        EffectLocation calculateRefSet(Node node) {
            if (NodeUtil.canBeSideEffected(node)) {
                return EVERY_LOCATION;
            }
            return NO_LOCATION;
        }

        EffectLocation calculateModSet(Node node) {
            if (NodeUtil.mayHaveSideEffects(node)) {
                return EVERY_LOCATION;
            }
            return NO_LOCATION;
        }

        private static class DegenerateEffectLocation
        implements EffectLocation {
            private DegenerateEffectLocation() {
            }

            @Override
            public EffectLocation join(EffectLocation effectLocation) {
                if (effectLocation == EVERY_LOCATION) {
                    return effectLocation;
                }
                return this;
            }

            @Override
            public boolean intersectsLocation(EffectLocation effectLocation) {
                return this == EVERY_LOCATION && effectLocation == EVERY_LOCATION;
            }

            @Override
            public boolean isEmpty() {
                return this == NO_LOCATION;
            }
        }
    }

    private static abstract class LocationAbstraction {
        private LocationAbstraction() {
        }

        abstract LocationSummary calculateLocationSummary(Node var1);

        abstract EffectLocation getBottomLocation();

        public LocationSummary calculateLocationSummary(Set<Node> set) {
            EffectLocation effectLocation = this.getBottomLocation();
            EffectLocation effectLocation2 = this.getBottomLocation();
            for (Node node : set) {
                LocationSummary locationSummary = this.calculateLocationSummary(node);
                effectLocation = effectLocation.join(locationSummary.getModSet());
                effectLocation2 = effectLocation2.join(locationSummary.getRefSet());
            }
            return new LocationSummary(effectLocation, effectLocation2);
        }
    }

    private static interface EffectLocation {
        public boolean intersectsLocation(EffectLocation var1);

        public EffectLocation join(EffectLocation var1);

        public boolean isEmpty();
    }

    private static class LocationSummary {
        private EffectLocation modSet;
        private EffectLocation refSet;

        public LocationSummary(EffectLocation effectLocation, EffectLocation effectLocation2) {
            this.modSet = effectLocation;
            this.refSet = effectLocation2;
        }

        public EffectLocation getModSet() {
            return this.modSet;
        }

        public EffectLocation getRefSet() {
            return this.refSet;
        }
    }

    public static class RawMotionEnvironment
    extends AbstractMotionEnvironment {
        Set<Node> environment;

        public RawMotionEnvironment(Set<Node> set) {
            this.environment = set;
        }

        @Override
        public Set<Node> calculateEnvironment() {
            return this.environment;
        }
    }

    public static class CrossModuleMotionEnvironment
    extends AbstractMotionEnvironment {
        public CrossModuleMotionEnvironment(Node node, JSModule jSModule, Node node2, JSModule jSModule2, JSModuleGraph jSModuleGraph) {
        }

        @Override
        public Set<Node> calculateEnvironment() {
            return null;
        }
    }

    public static class IntraproceduralMotionEnvironment
    extends AbstractMotionEnvironment {
        public IntraproceduralMotionEnvironment(ControlFlowGraph<Node> controlFlowGraph, Node node, Node node2) {
        }

        @Override
        public Set<Node> calculateEnvironment() {
            return null;
        }
    }

    public static abstract class AbstractMotionEnvironment {
        public abstract Set<Node> calculateEnvironment();
    }

    static enum LocationAbstractionMode {
        DEGENERATE,
        VISIBILITY_BASED;

    }
}

