/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;

class SyntacticScopeCreator
implements ScopeCreator {
    private final AbstractCompiler compiler;
    private Scope scope;
    private String sourceName;
    private final RedeclarationHandler redeclarationHandler;
    private static final String ARGUMENTS = "arguments";
    public static final DiagnosticType VAR_MULTIPLY_DECLARED_ERROR = DiagnosticType.error("JSC_VAR_MULTIPLY_DECLARED_ERROR", "Variable {0} first declared in {1}");
    public static final DiagnosticType VAR_ARGUMENTS_SHADOWED_ERROR = DiagnosticType.error("JSC_VAR_ARGUMENTS_SHADOWED_ERROR", "Shadowing \"arguments\" is not allowed");

    SyntacticScopeCreator(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
        this.redeclarationHandler = new DefaultRedeclarationHandler();
    }

    SyntacticScopeCreator(AbstractCompiler abstractCompiler, RedeclarationHandler redeclarationHandler) {
        this.compiler = abstractCompiler;
        this.redeclarationHandler = redeclarationHandler;
    }

    @Override
    public Scope createScope(Node node, Scope scope) {
        this.sourceName = null;
        this.scope = scope == null ? new Scope(node, this.compiler) : new Scope(scope, node);
        this.scanRoot(node, scope);
        this.sourceName = null;
        Scope scope2 = this.scope;
        this.scope = null;
        return scope2;
    }

    private void scanRoot(Node node, Scope scope) {
        if (node.getType() == 105) {
            this.sourceName = (String)node.getProp(16);
            Node node2 = node.getFirstChild();
            Node node3 = node2.getNext();
            Node node4 = node3.getNext();
            String string = node2.getString();
            if (!string.isEmpty() && NodeUtil.isFunctionExpression(node)) {
                this.declareVar(string, node2, node, null, null, node);
            }
            Preconditions.checkState((node3.getType() == 83 ? 1 : 0) != 0);
            for (Node node5 = node3.getFirstChild(); node5 != null; node5 = node5.getNext()) {
                Preconditions.checkState((node5.getType() == 38 ? 1 : 0) != 0);
                this.declareVar(node5.getString(), node5, node3, node, null, node);
            }
            this.scanVars(node4, node);
        } else {
            Preconditions.checkState((this.scope.getParent() == null ? 1 : 0) != 0);
            this.scanVars(node, null);
        }
    }

    private void scanVars(Node node, Node node2) {
        switch (node.getType()) {
            case 118: {
                Node node3 = node.getFirstChild();
                while (node3 != null) {
                    Node node4 = node3.getNext();
                    Preconditions.checkState((node3.getType() == 38 ? 1 : 0) != 0);
                    String string = node3.getString();
                    this.declareVar(string, node3, node, node2, null, node);
                    node3 = node4;
                }
                return;
            }
            case 105: {
                if (NodeUtil.isFunctionExpression(node)) {
                    return;
                }
                String string = node.getFirstChild().getString();
                if (string.isEmpty()) {
                    return;
                }
                this.declareVar(string, node.getFirstChild(), node, node2, null, node);
                return;
            }
            case 120: {
                Preconditions.checkState((node.getChildCount() == 2 ? 1 : 0) != 0);
                Preconditions.checkState((node.getFirstChild().getType() == 38 ? 1 : 0) != 0);
                Node node5 = node.getFirstChild();
                Node node6 = node5.getNext();
                this.declareVar(node5.getString(), node5, node, node2, null, node);
                this.scanVars(node6, node);
                return;
            }
            case 132: {
                this.sourceName = (String)node.getProp(16);
            }
        }
        if (NodeUtil.isControlStructure(node) || NodeUtil.isStatementBlock(node)) {
            Node node7 = node.getFirstChild();
            while (node7 != null) {
                Node node8 = node7.getNext();
                this.scanVars(node7, node);
                node7 = node8;
            }
        }
    }

    private void declareVar(String string, Node node, Node node2, Node node3, JSType jSType, Node node4) {
        if (this.scope.isDeclared(string, false) || this.scope.isLocal() && string.equals(ARGUMENTS)) {
            this.redeclarationHandler.onRedeclaration(this.scope, string, node, node2, node3, node4);
        } else {
            this.scope.declare(string, node, jSType, this.compiler.getInput(this.sourceName));
        }
    }

    private class DefaultRedeclarationHandler
    implements RedeclarationHandler {
        private DefaultRedeclarationHandler() {
        }

        @Override
        public void onRedeclaration(Scope scope, String string, Node node, Node node2, Node node3, Node node4) {
            if (SyntacticScopeCreator.this.scope.isGlobal()) {
                Scope.Var var = SyntacticScopeCreator.this.scope.getVar(string);
                Node node5 = var.getParentNode();
                if (node5.getType() == 120 && node2.getType() == 120) {
                    return;
                }
                boolean bl = false;
                JSDocInfo jSDocInfo = node.getJSDocInfo();
                if (jSDocInfo == null) {
                    jSDocInfo = node2.getJSDocInfo();
                }
                boolean bl2 = bl = jSDocInfo != null && jSDocInfo.getSuppressions().contains("duplicate");
                if (!bl) {
                    SyntacticScopeCreator.this.compiler.report(JSError.make(SyntacticScopeCreator.this.sourceName, node4, VAR_MULTIPLY_DECLARED_ERROR, string, var.input != null ? var.input.getName() : "??"));
                }
            } else if (string.equals(SyntacticScopeCreator.ARGUMENTS) && !NodeUtil.isVarDeclaration(node)) {
                SyntacticScopeCreator.this.compiler.report(JSError.make(SyntacticScopeCreator.this.sourceName, node4, VAR_ARGUMENTS_SHADOWED_ERROR, new String[0]));
            }
        }
    }

    static interface RedeclarationHandler {
        public void onRedeclaration(Scope var1, String var2, Node var3, Node var4, Node var5, Node var6);
    }
}

