/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.TernaryValue;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.Set;

public class EnumElementType
extends ObjectType {
    private static final long serialVersionUID = 1L;
    private JSType primitiveType;
    private ObjectType primitiveObjectType;
    private final String name;

    EnumElementType(JSTypeRegistry jSTypeRegistry, JSType jSType, String string) {
        super(jSTypeRegistry);
        this.primitiveType = jSType;
        this.primitiveObjectType = jSType.toObjectType();
        this.name = string;
    }

    @Override
    public boolean isEnumElementType() {
        return true;
    }

    @Override
    public boolean matchesNumberContext() {
        return this.primitiveType.matchesNumberContext();
    }

    @Override
    public boolean matchesStringContext() {
        return this.primitiveType.matchesStringContext();
    }

    @Override
    public boolean matchesObjectContext() {
        return this.primitiveType.matchesObjectContext();
    }

    @Override
    public boolean canBeCalled() {
        return this.primitiveType.canBeCalled();
    }

    @Override
    public boolean isObject() {
        return this.primitiveType.isObject();
    }

    @Override
    public TernaryValue testForEquality(JSType jSType) {
        return this.primitiveType.testForEquality(jSType);
    }

    @Override
    public boolean isNullable() {
        return this.primitiveType.isNullable();
    }

    @Override
    public boolean isNominalType() {
        return this.hasReferenceName();
    }

    @Override
    public boolean isEquivalentTo(JSType jSType) {
        ObjectType objectType;
        if (this == jSType) {
            return true;
        }
        if (this.isNominalType() && (objectType = ObjectType.cast(jSType)) != null && objectType.isNominalType()) {
            return this.getReferenceName().equals(objectType.getReferenceName());
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.hasReferenceName()) {
            return this.getReferenceName().hashCode();
        }
        return super.hashCode();
    }

    public String toString() {
        return this.getReferenceName() + ".<" + this.primitiveType + ">";
    }

    @Override
    public String getReferenceName() {
        return this.name;
    }

    @Override
    public boolean hasReferenceName() {
        return true;
    }

    @Override
    public boolean isSubtype(JSType jSType) {
        if (JSType.isSubtype(this, jSType)) {
            return true;
        }
        return this.primitiveType.isSubtype(jSType);
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseEnumElementType(this);
    }

    @Override
    boolean defineProperty(String string, JSType jSType, boolean bl, boolean bl2) {
        return true;
    }

    @Override
    public boolean isPropertyTypeDeclared(String string) {
        return this.primitiveObjectType == null ? false : this.primitiveObjectType.isPropertyTypeDeclared(string);
    }

    @Override
    public boolean isPropertyTypeInferred(String string) {
        return this.primitiveObjectType == null ? false : this.primitiveObjectType.isPropertyTypeInferred(string);
    }

    @Override
    public ObjectType getImplicitPrototype() {
        return null;
    }

    @Override
    public int getPropertiesCount() {
        return this.primitiveObjectType == null ? 0 : this.primitiveObjectType.getPropertiesCount();
    }

    @Override
    void collectPropertyNames(Set<String> set) {
        if (this.primitiveObjectType != null) {
            this.primitiveObjectType.collectPropertyNames(set);
        }
    }

    @Override
    public JSType findPropertyType(String string) {
        return this.primitiveType.findPropertyType(string);
    }

    @Override
    public JSType getPropertyType(String string) {
        return this.primitiveObjectType == null ? this.getNativeType(JSTypeNative.UNKNOWN_TYPE) : this.primitiveObjectType.getPropertyType(string);
    }

    @Override
    public boolean hasProperty(String string) {
        return this.primitiveObjectType == null ? false : this.primitiveObjectType.hasProperty(string);
    }

    @Override
    public FunctionType getConstructor() {
        return this.primitiveObjectType == null ? null : this.primitiveObjectType.getConstructor();
    }

    @Override
    public JSType autoboxesTo() {
        return this.primitiveType.autoboxesTo();
    }

    public JSType getPrimitiveType() {
        return this.primitiveType;
    }

    @Override
    JSType resolveInternal(ErrorReporter errorReporter, StaticScope<JSType> staticScope) {
        this.primitiveType = this.primitiveType.resolve(errorReporter, staticScope);
        this.primitiveObjectType = (ObjectType)EnumElementType.safeResolve(this.primitiveObjectType, errorReporter, staticScope);
        return this;
    }
}

