/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.Set;

class ExpressionDecomposer {
    private final AbstractCompiler compiler;
    private final Supplier<String> safeNameIdSupplier;
    private final Set<String> knownConstants;
    private static final int MAX_INTERATIONS = 100;
    private String tempNamePrefix = "JSCompiler_temp";

    public ExpressionDecomposer(AbstractCompiler abstractCompiler, Supplier<String> supplier, Set<String> set) {
        Preconditions.checkNotNull((Object)abstractCompiler);
        Preconditions.checkNotNull(supplier);
        Preconditions.checkNotNull(set);
        this.compiler = abstractCompiler;
        this.safeNameIdSupplier = supplier;
        this.knownConstants = set;
    }

    void maybeDecomposeExpression(Node node) {
        int n = 0;
        while (DecompositionType.DECOMPOSABLE == this.canExposeExpression(node)) {
            this.exposeExpression(node);
            if (++n <= 100) continue;
            throw new IllegalStateException("DecomposeExpression depth exceeded on :\n" + node.toStringTree());
        }
    }

    void exposeExpression(Node node) {
        Node node2 = ExpressionDecomposer.findExpressionRoot(node);
        Preconditions.checkState((node2 != null ? 1 : 0) != 0);
        this.exposeExpression(node2, node);
        this.compiler.reportCodeChange();
    }

    void moveExpression(Node node) {
        String string = this.getTempValueName();
        Node node2 = ExpressionDecomposer.findInjectionPoint(node);
        Preconditions.checkNotNull((Object)node2);
        Node node3 = node2.getParent();
        Preconditions.checkNotNull((Object)node3);
        Preconditions.checkState((boolean)NodeUtil.isStatementBlock(node3));
        Node node4 = node.getParent();
        node4.replaceChild(node, Node.newString(38, string));
        Node node5 = NodeUtil.newVarNode(string, node);
        node3.addChildBefore(node5, node2);
        this.compiler.reportCodeChange();
    }

    private void exposeExpression(Node node, Node node2) {
        Node node3 = ExpressionDecomposer.findNonconditionalParent(node2, node);
        boolean bl = NodeUtil.mayHaveSideEffects(node3);
        Node node4 = ExpressionDecomposer.findInjectionPoint(node3);
        DecompositionState decompositionState = new DecompositionState();
        decompositionState.sideEffects = bl;
        decompositionState.extractBeforeStatement = node4;
        Node node5 = node3;
        Node node6 = node5.getParent();
        while (node6 != node) {
            Node node7;
            int n = node6.getType();
            Preconditions.checkState((!ExpressionDecomposer.isConditionalOp(node6) || node5 == node6.getFirstChild() ? 1 : 0) != 0);
            if (n == 86) {
                if (!this.isSafeAssign(node6, decompositionState.sideEffects)) {
                    node7 = node6.getFirstChild();
                    int n2 = node7.getType();
                    if (node7 != node5) {
                        Preconditions.checkState((boolean)NodeUtil.isGet(node7));
                        if (n2 == 35) {
                            this.decomposeSubExpressions(node7.getLastChild(), null, decompositionState);
                        }
                        this.decomposeSubExpressions(node7.getFirstChild(), null, decompositionState);
                    }
                }
            } else if (n == 37 && NodeUtil.isGet(node6.getFirstChild())) {
                if (!this.maybeExternMethod(node6.getFirstChild())) {
                    throw new IllegalStateException("External object method calls can not be decomposed.");
                }
                node7 = node6.getFirstChild();
                this.decomposeSubExpressions(node7.getNext(), node5, decompositionState);
                if (this.isExpressionTreeUnsafe(node7, decompositionState.sideEffects)) {
                    Node node8;
                    decompositionState.sideEffects = true;
                    node6 = node8 = this.rewriteCallExpression(node6, decompositionState);
                }
            } else if (n == 64) {
                this.decomposeObjectLiteralKeys(node6.getFirstChild(), node5, decompositionState);
            } else {
                this.decomposeSubExpressions(node6.getFirstChild(), node5, decompositionState);
            }
            node5 = node6;
            node6 = node5.getParent();
        }
        if (node3 != node2) {
            node5 = node3.getParent();
            boolean bl2 = node5.getType() != 130;
            Node node9 = this.extractConditional(node3, node4, bl2);
        }
    }

    private boolean maybeExternMethod(Node node) {
        return true;
    }

    private static Node findNonconditionalParent(Node node, Node node2) {
        Node node3 = node;
        Node node4 = node;
        Node node5 = node4.getParent();
        while (node5 != node2) {
            if (ExpressionDecomposer.isConditionalOp(node5) && node4 != node5.getFirstChild()) {
                node3 = node5;
            }
            node4 = node5;
            node5 = node4.getParent();
        }
        return node3;
    }

    private void decomposeObjectLiteralKeys(Node node, Node node2, DecompositionState decompositionState) {
        if (node == null || node == node2) {
            return;
        }
        this.decomposeObjectLiteralKeys(node.getNext(), node2, decompositionState);
        this.decomposeSubExpressions(node.getFirstChild(), node2, decompositionState);
    }

    private void decomposeSubExpressions(Node node, Node node2, DecompositionState decompositionState) {
        if (node == null || node == node2) {
            return;
        }
        Preconditions.checkState((!NodeUtil.isObjectLitKey(node, node.getParent()) ? 1 : 0) != 0);
        this.decomposeSubExpressions(node.getNext(), node2, decompositionState);
        if (this.isExpressionTreeUnsafe(node, decompositionState.sideEffects)) {
            decompositionState.sideEffects = true;
            decompositionState.extractBeforeStatement = this.extractExpression(node, decompositionState.extractBeforeStatement);
        }
    }

    private Node extractConditional(Node node, Node node2, boolean bl) {
        Node node3 = node.getParent();
        String string = this.getTempValueName();
        Node node4 = node.getFirstChild();
        Node node5 = node4.getNext();
        Node node6 = node.getLastChild();
        node.detachChildren();
        Node node7 = null;
        Node node8 = new Node(125).copyInformationFrom(node);
        Node node9 = new Node(125).copyInformationFrom(node);
        switch (node.getType()) {
            case 98: {
                node7 = node4;
                node8.addChildToFront(NodeUtil.newExpr(ExpressionDecomposer.buildResultExpression(node5, bl, string)));
                node9.addChildToFront(NodeUtil.newExpr(ExpressionDecomposer.buildResultExpression(node6, bl, string)));
                break;
            }
            case 101: {
                node7 = ExpressionDecomposer.buildResultExpression(node4, bl, string);
                node8.addChildToFront(NodeUtil.newExpr(ExpressionDecomposer.buildResultExpression(node6, bl, string)));
                break;
            }
            case 100: {
                node7 = ExpressionDecomposer.buildResultExpression(node4, bl, string);
                node9.addChildToFront(NodeUtil.newExpr(ExpressionDecomposer.buildResultExpression(node6, bl, string)));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected.");
            }
        }
        Node node10 = node9.hasChildren() ? new Node(108, node7, node8, node9) : new Node(108, node7, node8);
        node10.copyInformationFrom(node);
        if (bl) {
            Node node11 = NodeUtil.newVarNode(string, null).copyInformationFromForTree(node);
            Node node12 = node2.getParent();
            node12.addChildBefore(node11, node2);
            node12.addChildAfter(node10, node11);
            Node node13 = Node.newString(38, string);
            node3.replaceChild(node, node13);
        } else {
            Preconditions.checkArgument((node3.getType() == 130 ? 1 : 0) != 0);
            Node node14 = node3.getParent();
            node14.replaceChild(node3, node10);
        }
        return node10;
    }

    private static Node buildResultExpression(Node node, boolean bl, String string) {
        if (bl) {
            return new Node(86, Node.newString(38, string), node).copyInformationFromForTree(node);
        }
        return node;
    }

    private boolean isConstantName(Node node, Set<String> set) {
        return NodeUtil.isName(node) && (NodeUtil.isConstantName(node) || set.contains(node.getString()));
    }

    private Node extractExpression(Node node, Node node2) {
        Node node3;
        Node node4;
        Node node5;
        Node node62;
        Node node7 = node.getParent();
        boolean bl = NodeUtil.isAssignmentOp(node7) && !NodeUtil.isAssign(node7) && node7.getFirstChild() == node;
        Node node8 = null;
        if (bl && NodeUtil.isGet(node)) {
            for (Node node62 : node.children()) {
                if (node62.getType() == 40 || this.isConstantName(node62, this.knownConstants)) continue;
                node5 = this.extractExpression(node62, node2);
                if (node8 != null) continue;
                node8 = node5;
            }
        }
        String string = this.getTempConstantValueName();
        node62 = Node.newString(38, string).copyInformationFrom(node);
        if (bl) {
            Preconditions.checkState((NodeUtil.isName(node) || NodeUtil.isGet(node) ? 1 : 0) != 0);
            node4 = new Node(NodeUtil.getOpFromAssignmentOp(node7)).copyInformationFrom(node7);
            node3 = node7.getLastChild();
            node7.setType(86);
            node7.replaceChild(node3, node4);
            node4.addChildToFront(node62);
            node4.addChildToBack(node3);
            node5 = node.cloneTree();
        } else {
            node7.replaceChild(node, node62);
            node5 = node;
        }
        node4 = NodeUtil.newVarNode(string, node5);
        node3 = node2.getParent();
        node3.addChildBefore(node4, node2);
        if (node8 == null) {
            node8 = node4;
        }
        return node8;
    }

    private Node rewriteCallExpression(Node node, DecompositionState decompositionState) {
        Node node2;
        Node node3;
        Preconditions.checkArgument((node.getType() == 37 ? 1 : 0) != 0);
        Node node4 = node.getFirstChild();
        Preconditions.checkArgument((boolean)NodeUtil.isGet(node4));
        decompositionState.extractBeforeStatement = node3 = this.extractExpression(node4, decompositionState.extractBeforeStatement);
        Node node5 = node3.getFirstChild().getFirstChild();
        Preconditions.checkArgument((boolean)NodeUtil.isGet(node5));
        decompositionState.extractBeforeStatement = node2 = this.extractExpression(node5.getFirstChild(), decompositionState.extractBeforeStatement);
        Node node6 = node2.getFirstChild();
        Node node7 = node3.getFirstChild();
        Node node8 = new Node(37, new Node(33, node7.cloneNode(), Node.newString("call")), node6.cloneNode(), node.getLineno(), node.getCharno());
        node.removeFirstChild();
        if (node.hasChildren()) {
            node8.addChildrenToBack(node.removeChildren());
        }
        Node node9 = node.getParent();
        node9.replaceChild(node, node8);
        return node8;
    }

    @VisibleForTesting
    public void setTempNamePrefix(String string) {
        this.tempNamePrefix = string;
    }

    private String getTempValueName() {
        return this.tempNamePrefix + "$$" + (String)this.safeNameIdSupplier.get();
    }

    private String getTempConstantValueName() {
        String string = this.tempNamePrefix + "_const" + "$$" + (String)this.safeNameIdSupplier.get();
        this.knownConstants.add(string);
        return string;
    }

    static Node findInjectionPoint(Node node) {
        Node node2 = ExpressionDecomposer.findExpressionRoot(node);
        Preconditions.checkNotNull((Object)node2);
        Node node3 = node2;
        Node node4 = node3.getParent();
        while (node4.getType() == 126) {
            node3 = node4;
            node4 = node3.getParent();
        }
        Preconditions.checkState((boolean)NodeUtil.isStatementBlock(node3.getParent()));
        return node3;
    }

    private static boolean isConditionalOp(Node node) {
        switch (node.getType()) {
            case 98: 
            case 100: 
            case 101: {
                return true;
            }
        }
        return false;
    }

    static Node findExpressionRoot(Node node) {
        Node node2 = node;
        for (Node node3 : node2.getAncestors()) {
            int n = node3.getType();
            switch (n) {
                case 4: 
                case 108: 
                case 110: 
                case 118: 
                case 130: {
                    Preconditions.checkState((node2 == node3.getFirstChild() ? 1 : 0) != 0);
                    return node3;
                }
                case 111: 
                case 112: 
                case 125: 
                case 126: 
                case 132: {
                    return null;
                }
            }
            node2 = node3;
        }
        throw new IllegalStateException("Unexpected AST structure.");
    }

    DecompositionType canExposeExpression(Node node) {
        Node node2 = ExpressionDecomposer.findExpressionRoot(node);
        if (node2 != null) {
            return this.isSubexpressionMovable(node2, node);
        }
        return DecompositionType.UNDECOMPOSABLE;
    }

    private DecompositionType isSubexpressionMovable(Node node, Node node2) {
        boolean bl = false;
        boolean bl2 = NodeUtil.mayHaveSideEffects(node2);
        Node node3 = node2;
        for (Node node4 : node3.getAncestors()) {
            if (node4 == node) {
                return bl ? DecompositionType.DECOMPOSABLE : DecompositionType.MOVABLE;
            }
            int n = node4.getType();
            if (ExpressionDecomposer.isConditionalOp(node4)) {
                if (node3 != node4.getFirstChild()) {
                    bl = true;
                }
            } else if (!this.isSafeAssign(node4, bl2)) {
                for (Node node5 : node4.children()) {
                    if (node5 == node3) break;
                    if (!this.isExpressionTreeUnsafe(node5, bl2)) continue;
                    bl2 = true;
                    bl = true;
                }
                Node node6 = node4.getFirstChild();
                if (bl && node4.getType() == 37 && NodeUtil.isGet(node6)) {
                    if (this.maybeExternMethod(node6)) {
                        return DecompositionType.UNDECOMPOSABLE;
                    }
                    return DecompositionType.DECOMPOSABLE;
                }
            }
            node3 = node4;
        }
        throw new IllegalStateException("Unexpected.");
    }

    private boolean isSafeAssign(Node node, boolean bl) {
        if (node.getType() == 86) {
            Node node2 = node.getFirstChild();
            switch (node2.getType()) {
                case 38: {
                    return true;
                }
                case 33: {
                    return !this.isExpressionTreeUnsafe(node2.getFirstChild(), bl);
                }
                case 35: {
                    return !this.isExpressionTreeUnsafe(node2.getFirstChild(), bl) && !this.isExpressionTreeUnsafe(node2.getLastChild(), bl);
                }
            }
        }
        return false;
    }

    private boolean isExpressionTreeUnsafe(Node node, boolean bl) {
        if (bl) {
            return NodeUtil.canBeSideEffected(node, this.knownConstants);
        }
        return NodeUtil.mayHaveSideEffects(node);
    }

    private static class DecompositionState {
        boolean sideEffects;
        Node extractBeforeStatement;

        private DecompositionState() {
        }
    }

    static enum DecompositionType {
        UNDECOMPOSABLE,
        MOVABLE,
        DECOMPOSABLE;

    }
}

