/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.ExpressionDecomposer;
import com.google.javascript.jscomp.FunctionArgumentInjector;
import com.google.javascript.jscomp.FunctionToBlockMutator;
import com.google.javascript.jscomp.InlineCostEstimator;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

class FunctionInjector {
    private final AbstractCompiler compiler;
    private final Supplier<String> safeNameIdSupplier;
    private final boolean allowDecomposition;
    private Set<String> knownConstants = Sets.newHashSet();
    private static final int NAME_COST_ESTIMATE = InlineCostEstimator.ESTIMATED_IDENTIFIER_COST;
    private static final int COMMA_COST = 1;
    private static final int PAREN_COST = 2;

    public FunctionInjector(AbstractCompiler abstractCompiler, Supplier<String> supplier, boolean bl) {
        Preconditions.checkNotNull((Object)abstractCompiler);
        Preconditions.checkNotNull(supplier);
        this.compiler = abstractCompiler;
        this.safeNameIdSupplier = supplier;
        this.allowDecomposition = bl;
    }

    boolean doesFunctionMeetMinimumRequirements(String string, Node node) {
        Node node2 = NodeUtil.getFunctionBody(node);
        if (NodeUtil.isNameReferenced(node2, string)) {
            return false;
        }
        String string2 = node.getFirstChild().getString();
        if (string2 != null && !string2.isEmpty() && !string2.equals(string) && NodeUtil.isNameReferenced(node2, string2)) {
            return false;
        }
        return !NodeUtil.isNameReferenced(node2, "arguments");
    }

    CanInlineResult canInlineReferenceToFunction(NodeTraversal nodeTraversal, Node node, Node node2, Set<String> set, InliningMode inliningMode, boolean bl, boolean bl2) {
        if (!this.isSupportedCallType(node)) {
            return CanInlineResult.NO;
        }
        if (bl2 && !nodeTraversal.inGlobalScope()) {
            return CanInlineResult.NO;
        }
        if (bl && !NodeUtil.isFunctionObjectCall(node)) {
            return CanInlineResult.NO;
        }
        if (inliningMode == InliningMode.DIRECT) {
            return this.canInlineReferenceDirectly(node, node2);
        }
        return this.canInlineReferenceAsStatementBlock(nodeTraversal, node, node2, set);
    }

    private boolean isSupportedCallType(Node node) {
        Node node2;
        return node.getFirstChild().getType() == 38 || !(NodeUtil.isFunctionObjectCall(node) ? (node2 = node.getFirstChild().getNext()) == null || node2.getType() != 42 : NodeUtil.isFunctionObjectApply(node));
    }

    Node inline(NodeTraversal nodeTraversal, Node node, String string, Node node2, InliningMode inliningMode) {
        Preconditions.checkState((boolean)this.compiler.isNormalized());
        if (inliningMode == InliningMode.DIRECT) {
            return this.inlineReturnValue(node, node2);
        }
        return this.inlineFunction(node, node2, string);
    }

    private Node inlineReturnValue(Node node, Node node2) {
        Node node3;
        Node node4 = node2.getLastChild();
        Node node5 = node.getParent();
        LinkedHashMap<String, Node> linkedHashMap = FunctionArgumentInjector.getFunctionCallParameterMap(node2, node, this.safeNameIdSupplier);
        if (!node4.hasChildren()) {
            Node node6 = node4;
            node3 = NodeUtil.newUndefinedNode(node6);
        } else {
            Node node7 = node4.getFirstChild();
            Preconditions.checkArgument((node7.getType() == 4 ? 1 : 0) != 0);
            Node node8 = node7.cloneTree();
            Node node9 = FunctionArgumentInjector.inject(node8, null, linkedHashMap);
            Preconditions.checkArgument((node8 == node9 ? 1 : 0) != 0);
            node3 = node8.removeFirstChild();
        }
        node5.replaceChild(node, node3);
        return node3;
    }

    private CallSiteType classifyCallSite(Node node) {
        Node node2 = node.getParent();
        Node node3 = node2.getParent();
        if (NodeUtil.isExprCall(node2)) {
            return CallSiteType.SIMPLE_CALL;
        }
        if (NodeUtil.isExprAssign(node3) && !NodeUtil.isLhs(node, node2) && node2.getFirstChild().getType() == 38 && !NodeUtil.isConstantName(node2.getFirstChild())) {
            return CallSiteType.SIMPLE_ASSIGNMENT;
        }
        if (node2.getType() == 38 && !NodeUtil.isConstantName(node2) && node3.getType() == 118 && node3.hasOneChild()) {
            return CallSiteType.VAR_DECL_SIMPLE_ASSIGNMENT;
        }
        Node node4 = ExpressionDecomposer.findExpressionRoot(node);
        if (node4 != null) {
            ExpressionDecomposer expressionDecomposer = new ExpressionDecomposer(this.compiler, this.safeNameIdSupplier, this.knownConstants);
            ExpressionDecomposer.DecompositionType decompositionType = expressionDecomposer.canExposeExpression(node);
            if (decompositionType == ExpressionDecomposer.DecompositionType.MOVABLE) {
                return CallSiteType.EXPRESSION;
            }
            if (decompositionType == ExpressionDecomposer.DecompositionType.DECOMPOSABLE) {
                return CallSiteType.DECOMPOSABLE_EXPRESSION;
            }
            Preconditions.checkState((decompositionType == ExpressionDecomposer.DecompositionType.UNDECOMPOSABLE ? 1 : 0) != 0);
        }
        return CallSiteType.UNSUPPORTED;
    }

    private Node inlineFunction(Node node, Node node2, String string) {
        Node node3 = node.getParent();
        Node node4 = node3.getParent();
        CallSiteType callSiteType = this.classifyCallSite(node);
        Preconditions.checkArgument((callSiteType != CallSiteType.UNSUPPORTED ? 1 : 0) != 0);
        String string2 = null;
        boolean bl = true;
        switch (callSiteType) {
            case SIMPLE_ASSIGNMENT: {
                string2 = node3.getFirstChild().getString();
                break;
            }
            case VAR_DECL_SIMPLE_ASSIGNMENT: {
                string2 = node3.getString();
                break;
            }
            case SIMPLE_CALL: {
                string2 = null;
                bl = false;
                break;
            }
            case EXPRESSION: {
                string2 = this.getUniqueResultName();
                bl = false;
                break;
            }
            case DECOMPOSABLE_EXPRESSION: {
                throw new IllegalStateException("Decomposable expressions must decomposed before inlining.");
            }
            default: {
                throw new IllegalStateException("Unexpected call site type.");
            }
        }
        boolean bl2 = NodeUtil.isWithinLoop(node);
        FunctionToBlockMutator functionToBlockMutator = new FunctionToBlockMutator(this.compiler, this.safeNameIdSupplier);
        Node node5 = functionToBlockMutator.mutate(string, node2, node, string2, bl, bl2);
        Node node6 = node4.getParent();
        switch (callSiteType) {
            case VAR_DECL_SIMPLE_ASSIGNMENT: {
                node3.removeChild(node3.getFirstChild());
                Preconditions.checkState((node3.getFirstChild() == null ? 1 : 0) != 0);
                node6.addChildAfter(node5, node4);
                break;
            }
            case SIMPLE_ASSIGNMENT: {
                Preconditions.checkState((boolean)NodeUtil.isExpressionNode(node4));
                node6.replaceChild(node4, node5);
                break;
            }
            case SIMPLE_CALL: {
                Preconditions.checkState((boolean)NodeUtil.isExpressionNode(node3));
                node4.replaceChild(node3, node5);
                break;
            }
            case EXPRESSION: {
                Node node7 = ExpressionDecomposer.findInjectionPoint(node);
                Preconditions.checkNotNull((Object)node7);
                Node node8 = node7.getParent();
                Preconditions.checkNotNull((Object)node8);
                Preconditions.checkState((boolean)NodeUtil.isStatementBlock(node8));
                node5.addChildrenToFront(NodeUtil.newVarNode(string2, null).copyInformationFromForTree(node));
                node8.addChildBefore(node5, node7);
                node3.replaceChild(node, Node.newString(38, string2));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected call site type.");
            }
        }
        return node5;
    }

    boolean isDirectCallNodeReplacementPossible(Node node) {
        Node node2 = NodeUtil.getFunctionBody(node);
        if (!node2.hasChildren()) {
            return true;
        }
        return node2.hasOneChild() && node2.getFirstChild().getType() == 4 && node2.getFirstChild().getFirstChild() != null;
    }

    private CanInlineResult canInlineReferenceAsStatementBlock(NodeTraversal nodeTraversal, Node node, Node node2, Set<String> set) {
        CallSiteType callSiteType = this.classifyCallSite(node);
        if (callSiteType == CallSiteType.UNSUPPORTED) {
            return CanInlineResult.NO;
        }
        if (!this.allowDecomposition && callSiteType == CallSiteType.DECOMPOSABLE_EXPRESSION) {
            return CanInlineResult.NO;
        }
        if (!this.callMeetsBlockInliningRequirements(nodeTraversal, node, node2, set)) {
            return CanInlineResult.NO;
        }
        if (callSiteType == CallSiteType.DECOMPOSABLE_EXPRESSION) {
            return CanInlineResult.AFTER_DECOMPOSITION;
        }
        return CanInlineResult.YES;
    }

    private boolean callMeetsBlockInliningRequirements(NodeTraversal nodeTraversal, Node node, Node node2, Set<String> set) {
        Cloneable cloneable;
        boolean bl = NodeUtil.has(NodeUtil.getFunctionBody(node2), new NodeUtil.MatchDeclaration(), new NodeUtil.MatchShallowStatement());
        boolean bl2 = false;
        if (!nodeTraversal.inGlobalScope()) {
            cloneable = nodeTraversal.getScopeRoot();
            Node node3 = ((Node)cloneable).getLastChild();
            bl2 = NodeUtil.containsFunction(node3);
        }
        if (bl && bl2) {
            return false;
        }
        if (bl2) {
            boolean bl3;
            cloneable = FunctionArgumentInjector.getFunctionCallParameterMap(node2, node, this.safeNameIdSupplier);
            boolean bl4 = bl3 = !cloneable.isEmpty();
            if (bl3) {
                HashSet hashSet = Sets.newHashSet(set);
                FunctionArgumentInjector.maybeAddTempsForCallArguments(node2, (Map<String, Node>)((Object)cloneable), hashSet, this.compiler.getCodingConvention());
                if (!hashSet.isEmpty()) {
                    return false;
                }
            }
        }
        return true;
    }

    private CanInlineResult canInlineReferenceDirectly(Node node, Node node2) {
        if (!this.isDirectCallNodeReplacementPossible(node2)) {
            return CanInlineResult.NO;
        }
        Node node3 = node2.getLastChild();
        Node node4 = node.getFirstChild().getNext();
        if (node.getFirstChild().getType() != 38) {
            if (NodeUtil.isFunctionObjectCall(node)) {
                Preconditions.checkNotNull((Object)node4);
                Preconditions.checkState((node4.getType() == 42 ? 1 : 0) != 0);
                node4 = node4.getNext();
            } else {
                Preconditions.checkState((!NodeUtil.isFunctionObjectApply(node) ? 1 : 0) != 0);
            }
        }
        Node node5 = NodeUtil.getFnParameters(node2).getFirstChild();
        while (node4 != null || node5 != null) {
            if (node5 != null) {
                if (node4 != null && NodeUtil.mayEffectMutableState(node4) && NodeUtil.getNameReferenceCount(node3, node5.getString()) > 1) {
                    return CanInlineResult.NO;
                }
                node5 = node5.getNext();
            }
            if (node4 == null) continue;
            if (NodeUtil.mayHaveSideEffects(node4)) {
                return CanInlineResult.NO;
            }
            node4 = node4.getNext();
        }
        return CanInlineResult.YES;
    }

    private String getUniqueResultName() {
        return "JSCompiler_inline_result$$" + (String)this.safeNameIdSupplier.get();
    }

    boolean inliningLowersCost(JSModule jSModule, Node node, Collection<? extends Reference> collection, Set<String> set, boolean bl, boolean bl2) {
        int n = collection.size();
        if (n == 0) {
            return true;
        }
        int n2 = 0;
        boolean bl3 = bl && jSModule != null;
        JSModuleGraph jSModuleGraph = this.compiler.getModuleGraph();
        for (Reference reference : collection) {
            if (reference.mode == InliningMode.BLOCK) {
                ++n2;
            }
            if (!bl3 || reference.module == null || reference.module == jSModule || jSModuleGraph.dependsOn(reference.module, jSModule)) continue;
            bl = false;
            bl3 = false;
        }
        int n3 = n - n2;
        if (n == 1 && bl && n3 == 1) {
            return true;
        }
        int n4 = FunctionInjector.estimateCallCost(node, bl2);
        int n5 = n4 * n;
        int n6 = FunctionInjector.inlineCostDelta(node, set, InliningMode.DIRECT);
        int n7 = FunctionInjector.inlineCostDelta(node, set, InliningMode.BLOCK);
        return this.doesLowerCost(node, n5, n3, n6, n2, n7, bl);
    }

    private boolean doesLowerCost(Node node, int n, int n2, int n3, int n4, int n5, boolean bl) {
        int n6 = n2 + n4 - (bl ? 1 : 0);
        if (n6 == 0) {
            return n4 <= 0 || n5 <= 0;
        }
        int n7 = n2 * n3 + n4 * n5;
        int n8 = (n - n7) / n6;
        return InlineCostEstimator.getCost(node, n8 + 1) <= n8;
    }

    private static int estimateCallCost(Node node, boolean bl) {
        Node node2 = NodeUtil.getFnParameters(node);
        int n = node2.getChildCount();
        int n2 = NAME_COST_ESTIMATE + 2;
        if (n > 0) {
            n2 += n * NAME_COST_ESTIMATE + (n - 1) * 1;
        }
        if (bl) {
            n2 += 10;
        }
        return n2;
    }

    private static int inlineCostDelta(Node node, Set<String> set, InliningMode inliningMode) {
        int n = NodeUtil.getFnParameters(node).getChildCount();
        int n2 = n > 1 ? n - 1 : 0;
        int n3 = 15 + n2 + n * InlineCostEstimator.ESTIMATED_IDENTIFIER_COST;
        Node node2 = node.getLastChild();
        if (!node2.hasChildren()) {
            return -n3;
        }
        if (inliningMode == InliningMode.DIRECT) {
            return -(n3 + 7);
        }
        int n4 = set.size();
        int n5 = NodeUtil.getNodeTypeReferenceCount(node2, 4, new NodeUtil.MatchShallowStatement());
        int n6 = n5 > 0 ? n5 - 1 : 0;
        int n7 = n5 > 0 ? 4 : 0;
        int n8 = n7 + n5 * 2 + n6 * 3 + n4 * 3;
        return n8 - n3;
    }

    public void setKnownConstants(Set<String> set) {
        Preconditions.checkState((boolean)this.knownConstants.isEmpty());
        this.knownConstants = set;
    }

    static enum CanInlineResult {
        YES,
        AFTER_DECOMPOSITION,
        NO;

    }

    private static enum CallSiteType {
        UNSUPPORTED,
        SIMPLE_CALL,
        SIMPLE_ASSIGNMENT,
        VAR_DECL_SIMPLE_ASSIGNMENT,
        EXPRESSION,
        DECOMPOSABLE_EXPRESSION;

    }

    static class Reference {
        final Node callNode;
        final JSModule module;
        final InliningMode mode;

        Reference(Node node, JSModule jSModule, InliningMode inliningMode) {
            this.callNode = node;
            this.module = jSModule;
            this.mode = inliningMode;
        }
    }

    static enum InliningMode {
        DIRECT,
        BLOCK;

    }
}

