/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.ClosureCodingConvention;
import com.google.javascript.rhino.Node;
import java.util.regex.Pattern;

public class GoogleCodingConvention
extends ClosureCodingConvention {
    private static final long serialVersionUID = 1L;
    private static final String OPTIONAL_ARG_PREFIX = "opt_";
    private static final String VAR_ARGS_NAME = "var_args";
    private static final Pattern ENUM_KEY_PATTERN = Pattern.compile("[A-Z0-9][A-Z0-9_]*");

    @Override
    public boolean isConstant(String string) {
        if (string.length() <= 1) {
            return false;
        }
        int n = string.lastIndexOf(36);
        if (n >= 0 && (string = string.substring(n + 1)).length() == 0) {
            return false;
        }
        return this.isConstantKey(string);
    }

    @Override
    public boolean isConstantKey(String string) {
        if (string.isEmpty() || !Character.isUpperCase(string.charAt(0))) {
            return false;
        }
        return string.toUpperCase().equals(string);
    }

    @Override
    public boolean isValidEnumKey(String string) {
        return ENUM_KEY_PATTERN.matcher(string).matches();
    }

    @Override
    public boolean isOptionalParameter(Node node) {
        return node.getString().startsWith(OPTIONAL_ARG_PREFIX);
    }

    @Override
    public boolean isVarArgsParameter(Node node) {
        return VAR_ARGS_NAME.equals(node.getString());
    }

    @Override
    public boolean isExported(String string, boolean bl) {
        return !bl && string.startsWith("_");
    }

    @Override
    public boolean isPrivate(String string) {
        return string.endsWith("_") && !this.isExported(string);
    }
}

