/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.EnumType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.ObjectType;
import javax.annotation.Nullable;

class InferJSDocInfo
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private AbstractCompiler compiler;
    private boolean inExterns;

    InferJSDocInfo(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
    }

    @Override
    public void process(Node node, Node node2) {
        if (node != null) {
            this.inExterns = true;
            NodeTraversal.traverse(this.compiler, node, this);
        }
        if (node2 != null) {
            this.inExterns = false;
            NodeTraversal.traverse(this.compiler, node2, this);
        }
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        switch (node.getType()) {
            case 38: {
                JSType jSType;
                if (node2 == null) {
                    return;
                }
                if (!(node2.getType() == 118 || NodeUtil.isFunctionDeclaration(node2) || node2.getType() == 86 && node == node2.getFirstChild())) {
                    return;
                }
                JSDocInfo jSDocInfo = node.getJSDocInfo();
                if (jSDocInfo == null && (node2.getType() != 118 || node2.hasOneChild())) {
                    jSDocInfo = node2.getJSDocInfo();
                }
                if ((jSType = node.getJSType()) == null && node2.getType() == 105) {
                    jSType = node2.getJSType();
                }
                if (jSType == null || jSDocInfo == null) {
                    return;
                }
                ObjectType objectType = this.dereferenceToObject(jSType);
                if (objectType == null || objectType.getJSDocInfo() != null) {
                    return;
                }
                this.attachJSDocInfoToNominalTypeOrShape(objectType, jSDocInfo, node.getString());
                break;
            }
            case 33: {
                ObjectType objectType;
                ObjectType objectType2;
                if (!NodeUtil.isExpressionNode(node2) && (node2.getType() != 86 || node2.getFirstChild() != node)) break;
                JSDocInfo jSDocInfo = node.getJSDocInfo();
                if (jSDocInfo == null) {
                    jSDocInfo = node2.getJSDocInfo();
                }
                if (jSDocInfo == null || (objectType2 = this.dereferenceToObject(node.getFirstChild().getJSType())) == null) break;
                String string = node.getLastChild().getString();
                if (objectType2.hasOwnProperty(string)) {
                    objectType2.setPropertyJSDocInfo(string, jSDocInfo, this.inExterns);
                }
                if ((objectType = this.dereferenceToObject(objectType2.getPropertyType(string))) == null) break;
                this.attachJSDocInfoToNominalTypeOrShape(objectType, jSDocInfo, node.getQualifiedName());
            }
        }
    }

    private ObjectType dereferenceToObject(JSType jSType) {
        return ObjectType.cast(jSType == null ? null : jSType.dereference());
    }

    private void attachJSDocInfoToNominalTypeOrShape(ObjectType objectType, JSDocInfo jSDocInfo, @Nullable String string) {
        if (objectType.isConstructor() || objectType.isEnumType() || objectType.isInterface()) {
            if (objectType.hasReferenceName() && objectType.getReferenceName().equals(string)) {
                objectType.setJSDocInfo(jSDocInfo);
                if (objectType.isConstructor() || objectType.isInterface()) {
                    ((FunctionType)objectType).getInstanceType().setJSDocInfo(jSDocInfo);
                } else if (objectType instanceof EnumType) {
                    ((EnumType)objectType).getElementsType().setJSDocInfo(jSDocInfo);
                }
            }
        } else if (!objectType.isNativeObjectType() && objectType.isFunctionType()) {
            objectType.setJSDocInfo(jSDocInfo);
        }
    }
}

