/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.InlineCostEstimator;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.TernaryValue;
import java.util.LinkedList;

public class PeepholeFoldConstants
extends AbstractPeepholeOptimization {
    static final DiagnosticType DIVIDE_BY_0_ERROR = DiagnosticType.error("JSC_DIVIDE_BY_0_ERROR", "Divide by 0");
    static final DiagnosticType INVALID_GETELEM_INDEX_ERROR = DiagnosticType.error("JSC_INVALID_GETELEM_INDEX_ERROR", "Array index not integer: {0}");
    static final DiagnosticType INDEX_OUT_OF_BOUNDS_ERROR = DiagnosticType.error("JSC_INDEX_OUT_OF_BOUNDS_ERROR", "Array index out of bounds: {0}");
    static final DiagnosticType NEGATING_A_NON_NUMBER_ERROR = DiagnosticType.error("JSC_NEGATING_A_NON_NUMBER_ERROR", "Can't negate non-numeric value: {0}");
    static final DiagnosticType BITWISE_OPERAND_OUT_OF_RANGE = DiagnosticType.error("JSC_BITWISE_OPERAND_OUT_OF_RANGE", "Operand out of range, bitwise operation will lose information: {0}");
    static final DiagnosticType SHIFT_AMOUNT_OUT_OF_BOUNDS = DiagnosticType.error("JSC_SHIFT_AMOUNT_OUT_OF_BOUNDS", "Shift amount out of bounds: {0}");
    static final DiagnosticType FRACTIONAL_BITWISE_OPERAND = DiagnosticType.error("JSC_FRACTIONAL_BITWISE_OPERAND", "Fractional bitwise operand: {0}");
    private static final double MAX_FOLD_NUMBER = Math.pow(2.0, 53.0);

    @Override
    Node optimizeSubtree(Node node) {
        switch (node.getType()) {
            case 37: {
                return this.tryFoldKnownMethods(node);
            }
            case 30: {
                return this.tryFoldCtorCall(node);
            }
            case 32: {
                return this.tryFoldTypeof(node);
            }
            case 26: 
            case 27: 
            case 29: {
                return this.tryFoldUnaryOperator(node);
            }
        }
        return this.tryFoldBinaryOperator(node);
    }

    private Node tryFoldBinaryOperator(Node node) {
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return node;
        }
        Node node3 = node2.getNext();
        if (node3 == null) {
            return node;
        }
        switch (node.getType()) {
            case 33: {
                return this.tryFoldGetProp(node, node2, node3);
            }
            case 35: {
                return this.tryFoldGetElem(node, node2, node3);
            }
            case 52: {
                return this.tryFoldInstanceof(node, node2, node3);
            }
            case 100: 
            case 101: {
                return this.tryFoldAndOr(node, node2, node3);
            }
            case 18: 
            case 19: 
            case 20: {
                return this.tryFoldShift(node, node2, node3);
            }
            case 86: {
                return this.tryFoldAssign(node, node2, node3);
            }
            case 21: {
                return this.tryFoldAdd(node, node2, node3);
            }
            case 22: 
            case 24: 
            case 25: {
                return this.tryFoldArithmeticOp(node, node2, node3);
            }
            case 9: 
            case 11: 
            case 23: {
                if (node2.getType() == 39 && node3.getType() == 39) {
                    return this.tryFoldArithmeticOp(node, node2, node3);
                }
                return this.tryFoldLeftChildOp(node, node2, node3);
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 45: 
            case 46: {
                return this.tryFoldComparison(node, node2, node3);
            }
        }
        return node;
    }

    private Node tryFoldTypeof(Node node) {
        Preconditions.checkArgument((node.getType() == 32 ? 1 : 0) != 0);
        Node node2 = node.getFirstChild();
        if (node2 == null || !NodeUtil.isLiteralValue(node2, true)) {
            return node;
        }
        String string = null;
        switch (node2.getType()) {
            case 105: {
                string = "function";
                break;
            }
            case 40: {
                string = "string";
                break;
            }
            case 39: {
                string = "number";
                break;
            }
            case 43: 
            case 44: {
                string = "boolean";
                break;
            }
            case 41: 
            case 63: 
            case 64: {
                string = "object";
                break;
            }
            case 122: {
                string = "undefined";
                break;
            }
            case 38: {
                if (!"undefined".equals(node2.getString())) break;
                string = "undefined";
            }
        }
        if (string != null) {
            Node node3 = Node.newString(string);
            node.getParent().replaceChild(node, node3);
            this.reportCodeChange();
            return node3;
        }
        return node;
    }

    private Node tryFoldUnaryOperator(Node node) {
        Preconditions.checkState((boolean)node.hasOneChild());
        Node node2 = node.getFirstChild();
        Node node3 = node.getParent();
        if (node2 == null) {
            return node;
        }
        TernaryValue ternaryValue = NodeUtil.getBooleanValue(node2);
        if (ternaryValue == TernaryValue.UNKNOWN) {
            return node;
        }
        switch (node.getType()) {
            case 26: {
                int n = ternaryValue.toBoolean(true) ? 43 : 44;
                Node node4 = new Node(n);
                node3.replaceChild(node, node4);
                this.reportCodeChange();
                return node4;
            }
            case 29: {
                try {
                    if (node2.getType() == 38) {
                        if (node2.getString().equals("Infinity")) {
                            return node;
                        }
                        if (node2.getString().equals("NaN")) {
                            node.removeChild(node2);
                            node3.replaceChild(node, node2);
                            this.reportCodeChange();
                            return node2;
                        }
                    }
                    double d = -node2.getDouble();
                    Node node5 = Node.newNumber(d);
                    node3.replaceChild(node, node5);
                    this.reportCodeChange();
                    return node5;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    this.error(NEGATING_A_NON_NUMBER_ERROR, node2);
                    return node;
                }
            }
            case 27: {
                try {
                    double d = node2.getDouble();
                    if (d >= -2.147483648E9 && d <= 2.147483647E9) {
                        int n = (int)d;
                        if ((double)n == d) {
                            Node node6 = Node.newNumber(~n);
                            node3.replaceChild(node, node6);
                            this.reportCodeChange();
                            return node6;
                        }
                        this.error(FRACTIONAL_BITWISE_OPERAND, node2);
                        return node;
                    }
                    this.error(BITWISE_OPERAND_OUT_OF_RANGE, node2);
                    return node;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    this.error(NEGATING_A_NON_NUMBER_ERROR, node2);
                    return node;
                }
            }
        }
        return node;
    }

    private Node tryFoldInstanceof(Node node, Node node2, Node node3) {
        Preconditions.checkArgument((node.getType() == 52 ? 1 : 0) != 0);
        if (NodeUtil.isLiteralValue(node2, true) && !this.mayHaveSideEffects(node3)) {
            Node node4 = null;
            if (NodeUtil.isImmutableValue(node2)) {
                node4 = new Node(43);
            } else if (node3.getType() == 38 && "Object".equals(node3.getString())) {
                node4 = new Node(44);
            }
            if (node4 != null) {
                node.getParent().replaceChild(node, node4);
                this.reportCodeChange();
                return node4;
            }
        }
        return node;
    }

    private Node tryFoldAssign(Node node, Node node2, Node node3) {
        Preconditions.checkArgument((node.getType() == 86 ? 1 : 0) != 0);
        if (!node3.hasChildren() || node3.getFirstChild().getNext() != node3.getLastChild()) {
            return node;
        }
        if (this.mayHaveSideEffects(node2)) {
            return node;
        }
        Node node4 = node3.getFirstChild();
        if (!this.areNodesEqualForInlining(node2, node4)) {
            return node;
        }
        int n = -1;
        switch (node3.getType()) {
            case 21: {
                n = 93;
                break;
            }
            case 11: {
                n = 89;
                break;
            }
            case 9: {
                n = 87;
                break;
            }
            case 10: {
                n = 88;
                break;
            }
            case 24: {
                n = 96;
                break;
            }
            case 18: {
                n = 90;
                break;
            }
            case 25: {
                n = 97;
                break;
            }
            case 23: {
                n = 95;
                break;
            }
            case 19: {
                n = 91;
                break;
            }
            case 22: {
                n = 94;
                break;
            }
            case 20: {
                n = 92;
                break;
            }
            default: {
                return node;
            }
        }
        Node node5 = new Node(n, node2.detachFromParent(), node3.getLastChild().detachFromParent());
        node.getParent().replaceChild(node, node5);
        this.reportCodeChange();
        return node5;
    }

    private Node tryFoldAndOr(Node node, Node node2, Node node3) {
        Node node4 = node.getParent();
        Node node5 = null;
        int n = node.getType();
        TernaryValue ternaryValue = NodeUtil.getBooleanValue(node2);
        if (ternaryValue != TernaryValue.UNKNOWN) {
            boolean bl = ternaryValue.toBoolean(true);
            node5 = bl && n == 100 || !bl && n == 101 ? node2 : node3;
        }
        if (node5 != null) {
            node.removeChild(node5);
            node4.replaceChild(node, node5);
            this.reportCodeChange();
            return node5;
        }
        return node;
    }

    private Node tryFoldLeftChildAdd(Node node, Node node2, Node node3) {
        if (NodeUtil.isLiteralValue(node3, false) && node2.getType() == 21 && node2.getChildCount() == 2) {
            Node node4 = node2.getFirstChild();
            Node node5 = node4.getNext();
            if (node5.getType() != 40) {
                return node;
            }
            String string = NodeUtil.getStringValue(node5);
            String string2 = NodeUtil.getStringValue(node3);
            if (string != null && string2 != null) {
                node2.removeChild(node4);
                String string3 = string + string2;
                node.replaceChild(node2, node4);
                node.replaceChild(node3, Node.newString(string3));
                this.reportCodeChange();
            }
        }
        return node;
    }

    private Node tryFoldAddConstant(Node node, Node node2, Node node3) {
        if (node2.getType() == 40 || node3.getType() == 40) {
            String string = NodeUtil.getStringValue(node2);
            String string2 = NodeUtil.getStringValue(node3);
            if (string != null && string2 != null) {
                Node node4 = Node.newString(string + string2);
                node.getParent().replaceChild(node, node4);
                this.reportCodeChange();
                return node4;
            }
        } else {
            return this.tryFoldArithmeticOp(node, node2, node3);
        }
        return node;
    }

    private Node tryFoldArithmeticOp(Node node, Node node2, Node node3) {
        Node node4;
        if (node2.getType() == 39 && node3.getType() == 39 && (node4 = this.performArithmeticOp(node.getType(), node2, node3)) != null) {
            node.getParent().replaceChild(node, node4);
            this.reportCodeChange();
            return node4;
        }
        return node;
    }

    private Node performArithmeticOp(int n, Node node, Node node2) {
        double d;
        Preconditions.checkState((node.getType() == 39 ? 1 : 0) != 0);
        Preconditions.checkState((node2.getType() == 39 ? 1 : 0) != 0);
        double d2 = node.getDouble();
        double d3 = node2.getDouble();
        switch (n) {
            case 11: {
                if (!this.areValidInts(d2, d3)) {
                    return null;
                }
                d = (int)d2 & (int)d3;
                break;
            }
            case 9: {
                if (!this.areValidInts(d2, d3)) {
                    return null;
                }
                d = (int)d2 | (int)d3;
                break;
            }
            case 21: {
                d = d2 + d3;
                break;
            }
            case 22: {
                d = d2 - d3;
                break;
            }
            case 23: {
                d = d2 * d3;
                break;
            }
            case 25: {
                if (d3 == 0.0) {
                    this.error(DIVIDE_BY_0_ERROR, node2);
                    return null;
                }
                d = d2 % d3;
                break;
            }
            case 24: {
                if (d3 == 0.0) {
                    this.error(DIVIDE_BY_0_ERROR, node2);
                    return null;
                }
                d = d2 / d3;
                break;
            }
            default: {
                throw new Error("Unexpected arithmetic operator");
            }
        }
        if (String.valueOf(d).length() <= String.valueOf(d2).length() + String.valueOf(d3).length() + 1 && Math.abs(d) <= MAX_FOLD_NUMBER) {
            Node node3 = Node.newNumber(d);
            return node3;
        }
        return null;
    }

    private boolean isValidInt(double d) {
        return !(d < -2.147483648E9) && !(d > 2.147483647E9) && d == (double)((int)d);
    }

    private boolean areValidInts(double d, double d2) {
        return this.isValidInt(d) && this.isValidInt(d2);
    }

    private Node tryFoldLeftChildOp(Node node, Node node2, Node node3) {
        int n = node.getType();
        Preconditions.checkState((NodeUtil.isAssociative(n) && NodeUtil.isCommutative(n) ? 1 : 0) != 0);
        if (node3.getType() == 39 && node2.getType() == n) {
            Node node4;
            Preconditions.checkState((node2.getChildCount() == 2 ? 1 : 0) != 0);
            Node node5 = node2.getFirstChild();
            Node node6 = node5.getNext();
            if (node5.getType() == 39) {
                node4 = node5;
            } else if (node6.getType() == 39) {
                node4 = node6;
            } else {
                return node;
            }
            Node node7 = this.performArithmeticOp(n, node4, node3);
            if (node7 != null) {
                node2.removeChild(node4);
                node.replaceChild(node2, node2.removeFirstChild());
                node.replaceChild(node3, node7);
                this.reportCodeChange();
            }
        }
        return node;
    }

    private Node tryFoldAdd(Node node, Node node2, Node node3) {
        Preconditions.checkArgument((node.getType() == 21 ? 1 : 0) != 0);
        if (NodeUtil.isLiteralValue(node2, false) && NodeUtil.isLiteralValue(node3, false)) {
            return this.tryFoldAddConstant(node, node2, node3);
        }
        return this.tryFoldLeftChildAdd(node, node2, node3);
    }

    private Node tryFoldShift(Node node, Node node2, Node node3) {
        if (node2.getType() == 39 && node3.getType() == 39) {
            double d;
            double d2 = node2.getDouble();
            double d3 = node3.getDouble();
            if (!(d2 >= -2.147483648E9) || !(d2 <= 2.147483647E9)) {
                this.error(BITWISE_OPERAND_OUT_OF_RANGE, node2);
                return node;
            }
            if (!(d3 >= 0.0) || !(d3 < 32.0)) {
                this.error(SHIFT_AMOUNT_OUT_OF_BOUNDS, node3);
                return node;
            }
            int n = (int)d2;
            if ((double)n != d2) {
                this.error(FRACTIONAL_BITWISE_OPERAND, node2);
                return node;
            }
            int n2 = (int)d3;
            if ((double)n2 != d3) {
                this.error(FRACTIONAL_BITWISE_OPERAND, node3);
                return node;
            }
            switch (node.getType()) {
                case 18: {
                    d = n << n2;
                    break;
                }
                case 19: {
                    d = n >> n2;
                    break;
                }
                case 20: {
                    long l = (long)n & 0xFFFFFFFFL;
                    d = l >>> n2;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown shift operator: " + Node.tokenToName(node.getType())));
                }
            }
            Node node4 = Node.newNumber(d);
            node.getParent().replaceChild(node, node4);
            this.reportCodeChange();
            return node4;
        }
        return node;
    }

    private Node tryFoldComparison(Node node, Node node2, Node node3) {
        boolean bl;
        if (!(NodeUtil.isLiteralValue(node2, false) && NodeUtil.isLiteralValue(node3, false) || node.getType() == 16 || node.getType() == 14)) {
            return node;
        }
        int n = node.getType();
        boolean bl2 = NodeUtil.isLiteralValue(node3, false);
        boolean bl3 = 38 == node3.getType() && node3.getString().equals("undefined") || 122 == node3.getType() && NodeUtil.isLiteralValue(node3.getFirstChild(), false);
        block0 : switch (node2.getType()) {
            case 122: {
                if (!NodeUtil.isLiteralValue(node2.getFirstChild(), false)) {
                    return node;
                }
                if (!bl2) {
                    return node;
                }
                bl = this.compareToUndefined(node3, n);
                break;
            }
            case 41: {
                if (bl3) {
                    bl = this.compareToUndefined(node2, n);
                    break;
                }
            }
            case 43: 
            case 44: {
                if (bl3) {
                    bl = this.compareToUndefined(node2, n);
                    break;
                }
            }
            case 42: {
                int n2 = node3.getType();
                if (n2 != 42 && n2 != 44 && n2 != 43 && n2 != 41) {
                    return node;
                }
                switch (n) {
                    case 12: 
                    case 45: {
                        bl = node2.getType() == node3.getType();
                        break block0;
                    }
                    case 13: 
                    case 46: {
                        bl = node2.getType() != node3.getType();
                        break block0;
                    }
                }
                return node;
            }
            case 40: {
                if (bl3) {
                    bl = this.compareToUndefined(node2, n);
                    break;
                }
                if (40 != node3.getType()) {
                    return node;
                }
                switch (n) {
                    case 12: 
                    case 45: {
                        bl = node2.getString().equals(node3.getString());
                        break block0;
                    }
                    case 13: 
                    case 46: {
                        bl = !node2.getString().equals(node3.getString());
                        break block0;
                    }
                }
                return node;
            }
            case 39: {
                if (bl3) {
                    bl = this.compareToUndefined(node2, n);
                    break;
                }
                if (39 != node3.getType()) {
                    return node;
                }
                double d = node2.getDouble();
                double d2 = node3.getDouble();
                switch (n) {
                    case 12: 
                    case 45: {
                        bl = d == d2;
                        break block0;
                    }
                    case 13: 
                    case 46: {
                        bl = d != d2;
                        break block0;
                    }
                    case 15: {
                        bl = d <= d2;
                        break block0;
                    }
                    case 14: {
                        bl = d < d2;
                        break block0;
                    }
                    case 17: {
                        bl = d >= d2;
                        break block0;
                    }
                    case 16: {
                        bl = d > d2;
                        break block0;
                    }
                }
                return node;
            }
            case 38: {
                String string;
                boolean bl4;
                if (bl3) {
                    bl = this.compareToUndefined(node2, n);
                    break;
                }
                if (bl2 && (bl4 = node2.getString().equals("undefined"))) {
                    bl = this.compareToUndefined(node3, n);
                    break;
                }
                if (38 != node3.getType()) {
                    return node;
                }
                String string2 = node2.getString();
                if (!string2.equals(string = node3.getString())) {
                    return node;
                }
                switch (n) {
                    case 14: 
                    case 16: {
                        bl = false;
                        break block0;
                    }
                }
                return node;
            }
            default: {
                return node;
            }
        }
        Node node4 = new Node(bl ? 44 : 43);
        node.getParent().replaceChild(node, node4);
        this.reportCodeChange();
        return node4;
    }

    private boolean compareToUndefined(Node node, int n) {
        boolean bl = 38 == node.getType() && node.getString().equals("undefined") || 122 == node.getType() && NodeUtil.isLiteralValue(node.getFirstChild(), false);
        boolean bl2 = 41 == node.getType();
        boolean bl3 = bl || bl2;
        switch (n) {
            case 12: {
                return bl3;
            }
            case 13: {
                return !bl3;
            }
            case 45: {
                return bl;
            }
            case 46: {
                return !bl;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return false;
            }
        }
        throw new IllegalStateException("unexpected.");
    }

    private Node tryFoldCtorCall(Node node) {
        Preconditions.checkArgument((node.getType() == 30 ? 1 : 0) != 0);
        if (this.inForcedStringContext(node)) {
            return this.tryFoldInForcedStringContext(node);
        }
        return node;
    }

    private boolean inForcedStringContext(Node node) {
        return node.getParent().getType() == 35 && node.getParent().getLastChild() == node;
    }

    private Node tryFoldInForcedStringContext(Node node) {
        Preconditions.checkArgument((node.getType() == 30 ? 1 : 0) != 0);
        Node node2 = node.getFirstChild();
        if (node2.getType() != 38) {
            return node;
        }
        if (node2.getString().equals("String")) {
            Node node3 = node2.getNext();
            String string = null;
            if (node3 == null) {
                string = "";
            } else {
                if (!NodeUtil.isImmutableValue(node3)) {
                    return node;
                }
                string = NodeUtil.getStringValue(node3);
            }
            if (string == null) {
                return node;
            }
            Node node4 = node.getParent();
            Node node5 = Node.newString(string);
            node4.replaceChild(node, node5);
            node5.copyInformationFrom(node4);
            this.reportCodeChange();
            return node5;
        }
        return node;
    }

    private Node tryFoldKnownMethods(Node node) {
        if ((node = this.tryFoldArrayJoin(node)).getType() == 37) {
            node = this.tryFoldKnownStringMethods(node);
        }
        return node;
    }

    private Node tryFoldKnownStringMethods(Node node) {
        Preconditions.checkArgument((node.getType() == 37 ? 1 : 0) != 0);
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return node;
        }
        Node node3 = node2.getNext();
        if (node3 == null) {
            return node;
        }
        if (!NodeUtil.isGet(node2) || !NodeUtil.isImmutableValue(node3)) {
            return node;
        }
        Node node4 = node2.getFirstChild();
        Node node5 = node4.getNext();
        if (node4.getType() != 40 || node5.getType() != 40) {
            return node;
        }
        String string = node5.getString();
        if (string.equals("indexOf") || string.equals("lastIndexOf")) {
            node = this.tryFoldStringIndexOf(node, string, node4, node3);
        } else if (string.equals("substr")) {
            node = this.tryFoldStringSubstr(node, node4, node3);
        } else if (string.equals("substring")) {
            node = this.tryFoldStringSubstring(node, node4, node3);
        }
        return node;
    }

    private Node tryFoldStringIndexOf(Node node, String string, Node node2, Node node3) {
        int n;
        Preconditions.checkArgument((node.getType() == 37 ? 1 : 0) != 0);
        Preconditions.checkArgument((node2.getType() == 40 ? 1 : 0) != 0);
        String string2 = NodeUtil.getStringValue(node2);
        boolean bl = string.equals("indexOf");
        Node node4 = node3.getNext();
        String string3 = NodeUtil.getStringValue(node3);
        if (string3 == null) {
            return node;
        }
        int n2 = n = bl ? 0 : string2.length();
        if (node4 != null) {
            if (node4.getNext() != null || node4.getType() != 39) {
                return node;
            }
            n = (int)node4.getDouble();
        }
        int n3 = bl ? string2.indexOf(string3, n) : string2.lastIndexOf(string3, n);
        Node node5 = Node.newNumber(n3);
        node.getParent().replaceChild(node, node5);
        this.reportCodeChange();
        return node5;
    }

    private Node tryFoldArrayJoin(Node node) {
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return node;
        }
        Node node3 = node2.getNext();
        if (node3 == null) {
            return node;
        }
        if (!NodeUtil.isGetProp(node2) || !NodeUtil.isImmutableValue(node3)) {
            return node;
        }
        Node node4 = node2.getFirstChild();
        Node node5 = node4.getNext();
        if (node4.getType() != 63 || !node5.getString().equals("join")) {
            return node;
        }
        String string = NodeUtil.getStringValue(node3);
        LinkedList linkedList = Lists.newLinkedList();
        StringBuilder stringBuilder = null;
        int n = 0;
        Node node6 = null;
        for (Node node7 = node4.getFirstChild(); node7 != null; node7 = node7.getNext()) {
            if (NodeUtil.isImmutableValue(node7)) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                } else {
                    stringBuilder.append(string);
                }
                stringBuilder.append(NodeUtil.getStringValue(node7));
            } else {
                if (stringBuilder != null) {
                    Preconditions.checkNotNull(node6);
                    n += stringBuilder.length() + 2;
                    linkedList.add(Node.newString(stringBuilder.toString()).copyInformationFrom(node6));
                    stringBuilder = null;
                }
                n += InlineCostEstimator.getCost(node7);
                linkedList.add(node7);
            }
            node6 = node7;
        }
        if (stringBuilder != null) {
            Preconditions.checkNotNull(node6);
            n += stringBuilder.length() + 2;
            linkedList.add(Node.newString(stringBuilder.toString()).copyInformationFrom(node6));
        }
        n += linkedList.size() - 1;
        int n2 = InlineCostEstimator.getCost(node);
        switch (linkedList.size()) {
            case 0: {
                Node node8 = Node.newString("");
                node.getParent().replaceChild(node, node8);
                this.reportCodeChange();
                return node8;
            }
            case 1: {
                Node node9 = (Node)linkedList.remove(0);
                if (n > n2) {
                    return node;
                }
                node4.detachChildren();
                if (node9.getType() != 40) {
                    Node node10;
                    node9 = node10 = new Node(21, Node.newString("").copyInformationFrom(node3), node9);
                }
                node.getParent().replaceChild(node, node9);
                this.reportCodeChange();
                return node9;
            }
        }
        if (linkedList.size() == node4.getChildCount()) {
            return node;
        }
        int n3 = "[].join()".length();
        n += n3;
        if ((n += InlineCostEstimator.getCost(node3)) > n2) {
            return node;
        }
        node4.detachChildren();
        for (Node node11 : linkedList) {
            node4.addChildToBack(node11);
        }
        this.reportCodeChange();
        return node;
    }

    private Node tryFoldStringSubstr(Node node, Node node2, Node node3) {
        int n;
        Preconditions.checkArgument((node.getType() == 37 ? 1 : 0) != 0);
        Preconditions.checkArgument((node2.getType() == 40 ? 1 : 0) != 0);
        String string = node2.getString();
        if (node3 == null || node3.getType() != 39) {
            return node;
        }
        int n2 = (int)node3.getDouble();
        Node node4 = node3.getNext();
        if (node4 != null) {
            if (node4.getType() != 39) {
                return node;
            }
            n = (int)node4.getDouble();
            if (node4.getNext() != null) {
                return node;
            }
        } else {
            n = string.length() - n2;
        }
        if (n2 + n > string.length() || n < 0 || n2 < 0) {
            return node;
        }
        String string2 = string.substring(n2, n2 + n);
        Node node5 = Node.newString(string2);
        Node node6 = node.getParent();
        node6.replaceChild(node, node5);
        this.reportCodeChange();
        return node5;
    }

    private Node tryFoldStringSubstring(Node node, Node node2, Node node3) {
        int n;
        Preconditions.checkArgument((node.getType() == 37 ? 1 : 0) != 0);
        Preconditions.checkArgument((node2.getType() == 40 ? 1 : 0) != 0);
        String string = node2.getString();
        if (node3 == null || node3.getType() != 39) {
            return node;
        }
        int n2 = (int)node3.getDouble();
        Node node4 = node3.getNext();
        if (node4 != null) {
            if (node4.getType() != 39) {
                return node;
            }
            n = (int)node4.getDouble();
            if (node4.getNext() != null) {
                return node;
            }
        } else {
            n = string.length();
        }
        if (n > string.length() || n2 > string.length() || n < 0 || n2 < 0) {
            return node;
        }
        String string2 = string.substring(n2, n);
        Node node5 = Node.newString(string2);
        Node node6 = node.getParent();
        node6.replaceChild(node, node5);
        this.reportCodeChange();
        return node5;
    }

    private Node tryFoldGetElem(Node node, Node node2, Node node3) {
        Preconditions.checkArgument((node.getType() == 35 ? 1 : 0) != 0);
        if (node2.getType() == 63) {
            if (node3.getType() != 39) {
                return node;
            }
            double d = node3.getDouble();
            int n = (int)d;
            if ((double)n != d) {
                this.error(INVALID_GETELEM_INDEX_ERROR, node3);
                return node;
            }
            if (n < 0) {
                this.error(INDEX_OUT_OF_BOUNDS_ERROR, node3);
                return node;
            }
            Node node4 = node2.getFirstChild();
            for (int n2 = 0; node4 != null && n2 < n; node4 = node4.getNext(), ++n2) {
            }
            if (node4 == null) {
                this.error(INDEX_OUT_OF_BOUNDS_ERROR, node3);
                return node;
            }
            node2.removeChild(node4);
            node.getParent().replaceChild(node, node4);
            this.reportCodeChange();
            return node4;
        }
        return node;
    }

    private Node tryFoldGetProp(Node node, Node node2, Node node3) {
        Preconditions.checkArgument((node.getType() == 33 ? 1 : 0) != 0);
        if (node3.getType() == 40 && node3.getString().equals("length")) {
            int n = -1;
            switch (node2.getType()) {
                case 63: {
                    if (this.mayHaveSideEffects(node2)) {
                        return node;
                    }
                    n = node2.getChildCount();
                    break;
                }
                case 40: {
                    n = node2.getString().length();
                    break;
                }
                default: {
                    return node;
                }
            }
            Preconditions.checkState((n != -1 ? 1 : 0) != 0);
            Node node4 = Node.newNumber(n);
            node.getParent().replaceChild(node, node4);
            this.reportCodeChange();
            return node4;
        }
        return node;
    }
}

