/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.jsonml;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.jsonml.JsonML;
import com.google.javascript.jscomp.jsonml.JsonMLException;
import com.google.javascript.jscomp.jsonml.JsonMLUtil;
import com.google.javascript.jscomp.jsonml.TagAttr;
import com.google.javascript.jscomp.jsonml.TagType;
import com.google.javascript.jscomp.jsonml.Validator;
import com.google.javascript.rhino.Node;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Reader {
    static final DiagnosticType JSONML_SYNTAX = DiagnosticType.error("JSONML_SYNTAX", "Syntax error: {0}");
    private JsonML rootElement;
    private String sourceName;
    private ErrorReporter errorReporter;
    private final Set<String> ALLOWED_DIRECTIVES = Sets.newHashSet((Object[])new String[]{"use strict"});
    private int nodeIndex;
    private boolean insertExprResultState = true;

    public void setRootElement(JsonML jsonML) {
        this.rootElement = jsonML;
    }

    public Node parse(AbstractCompiler abstractCompiler) throws JsonMLException {
        if (abstractCompiler == null) {
            return null;
        }
        this.errorReporter = new ErrorReporter(abstractCompiler);
        Node node = new Node(125);
        this.nodeIndex = -1;
        this.transformElement(this.rootElement, node);
        return node;
    }

    private <T> T getOptionalAttribute(JsonML jsonML, TagAttr tagAttr, Class<T> clazz) throws JsonMLException {
        return this.getAttribute(jsonML, tagAttr, clazz, true);
    }

    private <T> T getAttribute(JsonML jsonML, TagAttr tagAttr, Class<T> clazz) throws JsonMLException {
        return this.getAttribute(jsonML, tagAttr, clazz, false);
    }

    private <T> T getAttribute(JsonML jsonML, TagAttr tagAttr, Class<T> clazz, boolean bl) throws JsonMLException {
        Object object = jsonML.getAttribute(tagAttr);
        if (object == null) {
            if (clazz == null || bl) {
                return null;
            }
            throw new JsonMLException("Missing " + tagAttr.name() + " attribute for " + jsonML.getType().name() + " element.");
        }
        if (clazz.equals(Double.class)) {
            if (object instanceof Number) {
                return clazz.cast(((Number)object).doubleValue());
            }
            if (object instanceof String) {
                return clazz.cast(Double.valueOf((String)object));
            }
            throw new JsonMLException("Wrong type of " + tagAttr.name() + " attribute. " + "Received: " + object.getClass() + ". Expected: " + clazz.getName());
        }
        if (clazz.isInstance(object)) {
            return clazz.cast(object);
        }
        throw new JsonMLException("Wrong type of " + tagAttr.name() + "attribute. " + "Received: " + object.getClass() + ". Expected: " + clazz.getName());
    }

    private Object getObjectAttribute(JsonML jsonML, TagAttr tagAttr) throws JsonMLException {
        return this.getAttribute(jsonML, tagAttr, Object.class);
    }

    private String getStringAttribute(JsonML jsonML, TagAttr tagAttr) throws JsonMLException {
        return this.getAttribute(jsonML, tagAttr, String.class);
    }

    private void validate(JsonML jsonML) throws JsonMLException {
        String string = Validator.validate(jsonML);
        if (string != null) {
            this.errorReporter.report(jsonML, new String[]{string});
        }
    }

    private void transformElement(JsonML jsonML, Node node) throws JsonMLException {
        ++this.nodeIndex;
        this.validate(jsonML);
        if (this.insertExprResultState && JsonMLUtil.isExpression(jsonML)) {
            this.transformExpr(jsonML, node);
            return;
        }
        switch (jsonML.getType()) {
            case ArrayExpr: {
                this.transformArrayExpr(jsonML, node);
                break;
            }
            case AssignExpr: {
                this.transformAssignExpr(jsonML, node);
                break;
            }
            case BinaryExpr: {
                this.transformBinaryExpr(jsonML, node);
                break;
            }
            case BlockStmt: {
                this.transformBlock(jsonML, node);
                break;
            }
            case BreakStmt: {
                this.transformBreakStmt(jsonML, node);
                break;
            }
            case CallExpr: {
                this.transformCallExpr(jsonML, node);
                break;
            }
            case Case: {
                this.transformCase(jsonML, node);
                break;
            }
            case CatchClause: {
                this.transformCatchClause(jsonML, node);
                break;
            }
            case ConditionalExpr: {
                this.transformConditionalExpr(jsonML, node);
                break;
            }
            case ContinueStmt: {
                this.transformContinueStmt(jsonML, node);
                break;
            }
            case CountExpr: {
                this.transformCountExpr(jsonML, node);
                break;
            }
            case DataProp: {
                this.transformDataProp(jsonML, node);
                break;
            }
            case DefaultCase: {
                this.transformDefaultCase(jsonML, node);
                break;
            }
            case DeleteExpr: {
                this.transformDeleteExpr(jsonML, node);
                break;
            }
            case DoWhileStmt: {
                this.transformDoWhileStmt(jsonML, node);
                break;
            }
            case Empty: {
                this.transformEmpty(jsonML, node);
                break;
            }
            case EmptyStmt: {
                this.transformEmptyStmt(jsonML, node);
                break;
            }
            case EvalExpr: {
                this.transformEvalExpr(jsonML, node);
                break;
            }
            case ForInStmt: {
                this.transformForInStmt(jsonML, node);
                break;
            }
            case ForStmt: {
                this.transformForStmt(jsonML, node);
                break;
            }
            case FunctionDecl: {
                this.transformFunctionDecl(jsonML, node);
                break;
            }
            case FunctionExpr: {
                this.transformFunctionExpr(jsonML, node);
                break;
            }
            case IdExpr: {
                this.transformIdExpr(jsonML, node);
                break;
            }
            case IdPatt: {
                this.transformIdPatt(jsonML, node);
                break;
            }
            case IfStmt: {
                this.transformIfStmt(jsonML, node);
                break;
            }
            case InitPatt: {
                this.transformInitPatt(jsonML, node);
                break;
            }
            case InvokeExpr: {
                this.transformInvokeExpr(jsonML, node);
                break;
            }
            case LabelledStmt: {
                this.transformLabelledStmt(jsonML, node);
                break;
            }
            case LiteralExpr: {
                this.transformLiteralExpr(jsonML, node);
                break;
            }
            case LogicalAndExpr: {
                this.transformLogicalAndExpr(jsonML, node);
                break;
            }
            case LogicalOrExpr: {
                this.transformLogicalOrExpr(jsonML, node);
                break;
            }
            case MemberExpr: {
                this.transformMemberExpr(jsonML, node);
                break;
            }
            case NewExpr: {
                this.transformNewExpr(jsonML, node);
                break;
            }
            case ObjectExpr: {
                this.transformObjectExpr(jsonML, node);
                break;
            }
            case ParamDecl: {
                this.transformParamDecl(jsonML, node);
                break;
            }
            case Program: {
                this.transformProgram(jsonML, node);
                break;
            }
            case PrologueDecl: {
                this.transformPrologueDecl(jsonML, node);
                break;
            }
            case RegExpExpr: {
                this.transformRegExpExpr(jsonML, node);
                break;
            }
            case ReturnStmt: {
                this.transformReturnStmt(jsonML, node);
                break;
            }
            case SwitchStmt: {
                this.transformSwitchStmt(jsonML, node);
                break;
            }
            case ThisExpr: {
                this.transformThisExpr(jsonML, node);
                break;
            }
            case ThrowStmt: {
                this.transformThrowStmt(jsonML, node);
                break;
            }
            case TryStmt: {
                this.transformTryStmt(jsonML, node);
                break;
            }
            case TypeofExpr: {
                this.transformTypeofExpr(jsonML, node);
                break;
            }
            case UnaryExpr: {
                this.transformUnaryExpr(jsonML, node);
                break;
            }
            case VarDecl: {
                this.transformVarDecl(jsonML, node);
                break;
            }
            case WhileStmt: {
                this.transformWhileStmt(jsonML, node);
                break;
            }
            case WithStmt: {
                this.transformWithStmt(jsonML, node);
            }
        }
    }

    private void transformAllChildren(JsonML jsonML, Node node, boolean bl) throws JsonMLException {
        this.transformElements(jsonML.getChildren(), node, bl);
    }

    private void transformAllChildren(JsonML jsonML, Node node) throws JsonMLException {
        this.transformElements(jsonML.getChildren(), node);
    }

    private void transformAllChildrenFromIndex(JsonML jsonML, Node node, int n, boolean bl) throws JsonMLException {
        this.transformElements(jsonML.getChildren().subList(n, jsonML.childrenSize()), node, bl);
    }

    private void transformAllChildrenFromIndex(JsonML jsonML, Node node, int n) throws JsonMLException {
        this.transformElements(jsonML.getChildren().subList(n, jsonML.childrenSize()), node);
    }

    private void transformElements(List<JsonML> list, Node node, boolean bl) throws JsonMLException {
        boolean bl2 = this.insertExprResultState;
        this.insertExprResultState = bl;
        this.transformElements(list, node);
        this.insertExprResultState = bl2;
    }

    private void transformElements(List<JsonML> list, Node node) throws JsonMLException {
        for (JsonML jsonML : list) {
            this.transformElement(jsonML, node);
        }
    }

    private boolean transformExpr(JsonML jsonML, Node node) throws JsonMLException {
        boolean bl = false;
        if (this.insertExprResultState) {
            Node node2 = new Node(130);
            node.addChildToBack(node2);
            this.insertExprResultState = false;
            --this.nodeIndex;
            this.transformElement(jsonML, node2);
            this.insertExprResultState = true;
            bl = true;
        }
        return bl;
    }

    private void transformForLoop(JsonML jsonML, Node node, int n) throws JsonMLException {
        Preconditions.checkState((this.insertExprResultState ? 1 : 0) != 0);
        this.insertExprResultState = false;
        Node node2 = this.createNode(115, jsonML);
        node.addChildToBack(node2);
        for (int i = 0; i < n; ++i) {
            JsonML jsonML2 = jsonML.getChild(i);
            if (jsonML2.getType() == TagType.EmptyStmt || jsonML2.getType() == TagType.Empty) {
                ++this.nodeIndex;
                node2.addChildToBack(new Node(124));
                continue;
            }
            this.transformElement(jsonML2, node2);
        }
        this.transformPotentiallyUnwrappedBlock(jsonML.getChild(n), node2);
        this.insertExprResultState = true;
    }

    private void transformJumpStmt(JsonML jsonML, Node node, int n) throws JsonMLException {
        Node node2 = this.createNode(n, jsonML);
        node.addChildToBack(node2);
        String string = this.getOptionalAttribute(jsonML, TagAttr.LABEL, String.class);
        if (string != null) {
            node2.addChildToBack(Node.newString(153, string));
        }
    }

    private void transformLogicalExpr(JsonML jsonML, Node node, int n) throws JsonMLException {
        this.transformTwoArgumentExpr(jsonML, node, n);
    }

    private void transformTwoArgumentExpr(JsonML jsonML, Node node, int n) throws JsonMLException {
        Node node2 = this.createNode(n, jsonML);
        node.addChildToBack(node2);
        this.transformAllChildren(jsonML, node2);
    }

    private void transformPotentiallyUnwrappedBlock(JsonML jsonML, Node node) throws JsonMLException {
        if (jsonML.getType() == TagType.EmptyStmt || jsonML.getType() == TagType.Empty) {
            ++this.nodeIndex;
            Node node2 = new Node(125);
            node.addChildToBack(node2);
            node2.putBooleanProp(38, true);
        } else if (jsonML.getType() != TagType.BlockStmt) {
            Node node3 = new Node(125);
            node.addChildToBack(node3);
            boolean bl = this.insertExprResultState;
            this.insertExprResultState = true;
            this.transformElement(jsonML, node3);
            this.insertExprResultState = bl;
        } else {
            ++this.nodeIndex;
            this.transformBlock(jsonML, node);
        }
    }

    private void transformArrayExpr(JsonML jsonML, Node node) throws JsonMLException {
        Node node2 = this.createNode(63, jsonML);
        node.addChildToBack(node2);
        int n = 0;
        for (JsonML jsonML2 : jsonML.getChildren()) {
            if (jsonML2.getType() == TagType.Empty) {
                ++n;
            }
            this.transformElement(jsonML2, node2);
        }
        if (n > 0) {
            Object object = new int[n];
            int n2 = 0;
            int n3 = 0;
            for (JsonML jsonML3 : jsonML.getChildren()) {
                if (jsonML3.getType() == TagType.Empty) {
                    object[n2] = n3;
                    ++n2;
                }
                ++n3;
            }
            node2.putProp(30, object);
        }
    }

    private void transformAssignExpr(JsonML jsonML, Node node) throws JsonMLException {
        String string = this.getStringAttribute(jsonML, TagAttr.OP);
        int n = Operator.getNodeTypeForAssignOp(string);
        this.transformTwoArgumentExpr(jsonML, node, n);
    }

    private void transformBinaryExpr(JsonML jsonML, Node node) throws JsonMLException {
        String string = this.getStringAttribute(jsonML, TagAttr.OP);
        int n = Operator.getNodeTypeForBinaryOp(string);
        this.transformTwoArgumentExpr(jsonML, node, n);
    }

    private void transformBlock(JsonML jsonML, Node node) throws JsonMLException {
        this.transformBlock(jsonML, node, 0, jsonML.childrenSize());
    }

    private void transformBlock(JsonML jsonML, Node node, int n) throws JsonMLException {
        this.transformBlock(jsonML, node, n, jsonML.childrenSize());
    }

    private void transformBlock(JsonML jsonML, Node node, int n, int n2) throws JsonMLException {
        Node node2 = this.createNode(125, jsonML);
        node.addChildToBack(node2);
        this.transformElements(jsonML.getChildren(n, n2), node2, true);
    }

    private void transformBreakStmt(JsonML jsonML, Node node) throws JsonMLException {
        this.transformJumpStmt(jsonML, node, 116);
    }

    private void transformCallExpr(JsonML jsonML, Node node) throws JsonMLException {
        Node node2 = this.createNode(37, jsonML);
        node.addChildToBack(node2);
        this.transformAllChildren(jsonML, node2);
    }

    private void transformCase(JsonML jsonML, Node node) throws JsonMLException {
        Node node2 = this.createNode(111, jsonML);
        node.addChildToBack(node2);
        JsonML jsonML2 = jsonML.getChild(0);
        this.transformElement(jsonML2, node2);
        Node node3 = new Node(125);
        node2.addChildToBack(node3);
        this.transformAllChildrenFromIndex(jsonML, node3, 1, true);
    }

    private void transformCatchClause(JsonML jsonML, Node node) throws JsonMLException {
        Node node2 = this.createNode(120, jsonML);
        node.addChildToBack(node2);
        JsonML jsonML2 = jsonML.getChild(0);
        this.transformElement(jsonML2, node2);
        jsonML2 = jsonML.getChild(1);
        this.transformElement(jsonML2, node2);
    }

    private void transformConditionalExpr(JsonML jsonML, Node node) throws JsonMLException {
        Node node2 = this.createNode(98, jsonML);
        node.addChildToBack(node2);
        this.transformAllChildren(jsonML, node2);
    }

    private void transformContinueStmt(JsonML jsonML, Node node) throws JsonMLException {
        this.transformJumpStmt(jsonML, node, 117);
    }

    private void transformCountExpr(JsonML jsonML, Node node) throws JsonMLException {
        String string = this.getStringAttribute(jsonML, TagAttr.OP);
        int n = Operator.getNodeTypeForCountOp(string);
        Boolean bl = this.getAttribute(jsonML, TagAttr.IS_PREFIX, Boolean.class);
        Node node2 = this.createNode(n, jsonML);
        node2.putIntProp(31, bl != false ? 0 : 1);
        node.addChildToBack(node2);
        this.transformElement(jsonML.getChild(0), node2);
    }

    private void transformDataProp(JsonML jsonML, Node node) throws JsonMLException {
        Object object = this.getObjectAttribute(jsonML, TagAttr.NAME);
        Node node2 = null;
        if (object instanceof Number) {
            node2 = Node.newNumber(((Number)object).doubleValue());
        } else if (object instanceof String) {
            node2 = Node.newString(40, (String)object);
        } else {
            throw new IllegalStateException("The name of the property has invalid type.");
        }
        this.setPosition(node2);
        node.addChildToBack(node2);
        this.transformElement(jsonML.getChild(0), node);
    }

    private void transformDefaultCase(JsonML jsonML, Node node) throws JsonMLException {
        Node node2 = this.createNode(112, jsonML);
        node.addChildToBack(node2);
        Node node3 = new Node(125);
        node2.addChildToBack(node3);
        this.transformAllChildren(jsonML, node3, true);
    }

    private void transformDeleteExpr(JsonML jsonML, Node node) throws JsonMLException {
        Node node2 = this.createNode(31, jsonML);
        node.addChildToBack(node2);
        this.transformElement(jsonML.getChild(0), node2);
    }

    private void transformDoWhileStmt(JsonML jsonML, Node node) throws JsonMLException {
        Preconditions.checkState((this.insertExprResultState ? 1 : 0) != 0);
        this.insertExprResultState = false;
        Node node2 = this.createNode(114, jsonML);
        node.addChildToBack(node2);
        JsonML jsonML2 = jsonML.getChild(0);
        this.transformPotentiallyUnwrappedBlock(jsonML2, node2);
        jsonML2 = jsonML.getChild(1);
        this.transformElement(jsonML2, node2);
        this.insertExprResultState = true;
    }

    private void transformEmpty(JsonML jsonML, Node node) {
        switch (node.getType()) {
            case 63: {
                break;
            }
            case 105: {
                node.addChildToBack(Node.newString(38, ""));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected Empty element.");
            }
        }
    }

    private void transformEmptyStmt(JsonML jsonML, Node node) {
        Preconditions.checkState((node.getType() == 125 || node.getType() == 132 ? 1 : 0) != 0);
        node.addChildToBack(new Node(124));
    }

    private void transformEvalExpr(JsonML jsonML, Node node) throws JsonMLException {
        Node node2 = this.createNode(37, jsonML);
        node.addChildToBack(node2);
        Node node3 = Node.newString(38, "eval");
        node3.putBooleanProp(48, true);
        node2.addChildToBack(node3);
        this.transformAllChildren(jsonML, node2);
    }

    private void transformForInStmt(JsonML jsonML, Node node) throws JsonMLException {
        this.transformForLoop(jsonML, node, 2);
    }

    private void transformForStmt(JsonML jsonML, Node node) throws JsonMLException {
        this.transformForLoop(jsonML, node, 3);
    }

    private void transformFunction(JsonML jsonML, Node node, boolean bl) throws JsonMLException {
        Node node2 = this.createNode(105, jsonML);
        node.addChildToBack(node2);
        JsonML jsonML2 = jsonML.getChild(0);
        String string = "";
        this.transformElement(jsonML.getChild(0), node2);
        this.transformElement(jsonML.getChild(1), node2);
        this.transformBlock(jsonML, node2, 2);
    }

    private void transformFunctionDecl(JsonML jsonML, Node node) throws JsonMLException {
        this.transformFunction(jsonML, node, true);
    }

    private void transformFunctionExpr(JsonML jsonML, Node node) throws JsonMLException {
        this.transformFunction(jsonML, node, false);
    }

    private void transformIdExpr(JsonML jsonML, Node node) throws JsonMLException {
        String string = this.getStringAttribute(jsonML, TagAttr.NAME);
        Node node2 = Node.newString(38, string);
        this.setPosition(node2);
        node.addChildToBack(node2);
    }

    private void transformInitPatt(JsonML jsonML, Node node) throws JsonMLException {
        JsonML jsonML2 = jsonML.getChild(0);
        ++this.nodeIndex;
        Node node2 = Node.newString(38, this.getAttribute(jsonML2, TagAttr.NAME, String.class));
        this.setPosition(node2);
        node.addChildToBack(node2);
        jsonML2 = jsonML.getChild(1);
        this.transformElement(jsonML2, node2);
    }

    private void transformIdPatt(JsonML jsonML, Node node) throws JsonMLException {
        Node node2 = Node.newString(38, this.getStringAttribute(jsonML, TagAttr.NAME));
        this.setPosition(node2);
        node.addChildToBack(node2);
    }

    private void transformIfStmt(JsonML jsonML, Node node) throws JsonMLException {
        Preconditions.checkState((this.insertExprResultState ? 1 : 0) != 0);
        this.insertExprResultState = false;
        Node node2 = this.createNode(108, jsonML);
        node.addChildToBack(node2);
        JsonML jsonML2 = jsonML.getChild(0);
        this.transformElement(jsonML2, node2);
        jsonML2 = jsonML.getChild(1);
        this.transformPotentiallyUnwrappedBlock(jsonML2, node2);
        jsonML2 = jsonML.getChild(2);
        if (jsonML2.getType() != TagType.EmptyStmt && jsonML2.getType() != TagType.Empty) {
            this.transformPotentiallyUnwrappedBlock(jsonML2, node2);
        } else {
            ++this.nodeIndex;
        }
        this.insertExprResultState = true;
    }

    private void transformInvokeExpr(JsonML jsonML, Node node) throws JsonMLException {
        Node node2 = this.createNode(37, jsonML);
        node.addChildToBack(node2);
        this.transformMemberExpr(jsonML, node2);
        this.transformElements(jsonML.getChildren(2, jsonML.childrenSize()), node2);
    }

    private void transformLabelledStmt(JsonML jsonML, Node node) throws JsonMLException {
        String string = this.getStringAttribute(jsonML, TagAttr.LABEL);
        Node node2 = this.createNode(126, jsonML);
        node2.addChildToBack(Node.newString(153, string));
        node.addChildToBack(node2);
        JsonML jsonML2 = jsonML.getChild(0);
        if (jsonML2.getType() == TagType.EmptyStmt) {
            ++this.nodeIndex;
            node2.addChildToBack(new Node(124));
        } else {
            this.transformElement(jsonML.getChild(0), node2);
        }
    }

    private void transformLiteralExpr(JsonML jsonML, Node node) throws JsonMLException {
        Node node2 = null;
        Type type = Type.get(this.getStringAttribute(jsonML, TagAttr.TYPE));
        switch (type) {
            case BOOLEAN: {
                Boolean bl = this.getAttribute(jsonML, TagAttr.VALUE, Boolean.class);
                if (bl.booleanValue()) {
                    node2 = new Node(44);
                    break;
                }
                node2 = new Node(43);
                break;
            }
            case NULL: {
                this.getAttribute(jsonML, TagAttr.VALUE, null);
                node2 = new Node(41);
                break;
            }
            case NUMBER: {
                Double d = this.getAttribute(jsonML, TagAttr.VALUE, Double.class);
                node2 = Node.newNumber(d);
                break;
            }
            case STRING: {
                String string = this.getStringAttribute(jsonML, TagAttr.VALUE);
                node2 = Node.newString(string);
                break;
            }
            default: {
                throw new JsonMLException("Unrecognized type attribute.");
            }
        }
        this.setPosition(node2);
        node.addChildToBack(node2);
    }

    private void transformLogicalAndExpr(JsonML jsonML, Node node) throws JsonMLException {
        this.transformLogicalExpr(jsonML, node, 101);
    }

    private void transformLogicalOrExpr(JsonML jsonML, Node node) throws JsonMLException {
        this.transformLogicalExpr(jsonML, node, 100);
    }

    private void transformMemberExpr(JsonML jsonML, Node node) throws JsonMLException {
        int n;
        String string = this.getAttribute(jsonML, TagAttr.OP, String.class);
        if (string.equals(".")) {
            n = 33;
        } else if (string.equals("[]")) {
            n = 35;
        } else {
            throw new JsonMLException("Invalid OP argument: " + string);
        }
        Node node2 = this.createNode(n, jsonML);
        node.addChildToBack(node2);
        this.transformElement(jsonML.getChild(0), node2);
        this.transformElement(jsonML.getChild(1), node2);
    }

    private void transformNewExpr(JsonML jsonML, Node node) throws JsonMLException {
        Node node2 = this.createNode(30, jsonML);
        node.addChildToBack(node2);
        this.transformAllChildren(jsonML, node2);
    }

    private void transformObjectExpr(JsonML jsonML, Node node) throws JsonMLException {
        Node node2 = this.createNode(64, jsonML);
        node.addChildToBack(node2);
        this.transformAllChildren(jsonML, node2);
    }

    private void transformParamDecl(JsonML jsonML, Node node) throws JsonMLException {
        Node node2 = this.createNode(83, jsonML);
        node.addChildToBack(node2);
        this.transformAllChildren(jsonML, node2);
    }

    private void transformProgram(JsonML jsonML, Node node) throws JsonMLException {
        Preconditions.checkNotNull((Object)node);
        this.insertExprResultState = true;
        Node node2 = new Node(132);
        node2.setIsSyntheticBlock(true);
        node.addChildToBack(node2);
        for (JsonML jsonML2 : jsonML.getChildren()) {
            this.transformElement(jsonML2, node2);
        }
    }

    private void transformPrologueDecl(JsonML jsonML, Node node) throws JsonMLException {
        String string = this.getStringAttribute(jsonML, TagAttr.DIRECTIVE);
        if (this.ALLOWED_DIRECTIVES.contains(string)) {
            HashSet hashSet = node.getDirectives();
            if (hashSet == null) {
                hashSet = Sets.newHashSet();
            }
            hashSet.add(string);
            node.setDirectives(hashSet);
        } else {
            Node node2 = new Node(130);
            node.addChildToBack(node2);
            node2.addChildToBack(Node.newString(40, string));
        }
    }

    private void transformRegExpExpr(JsonML jsonML, Node node) throws JsonMLException {
        Node node2 = this.createNode(47, jsonML);
        node.addChildToBack(node2);
        String string = this.getStringAttribute(jsonML, TagAttr.BODY);
        node2.addChildToBack(Node.newString(40, string));
        String string2 = this.getStringAttribute(jsonML, TagAttr.FLAGS);
        if (!string2.equals("")) {
            node2.addChildToBack(Node.newString(40, string2));
        }
    }

    private void transformReturnStmt(JsonML jsonML, Node node) throws JsonMLException {
        Preconditions.checkState((this.insertExprResultState ? 1 : 0) != 0);
        Node node2 = this.createNode(4, jsonML);
        node.addChildToBack(node2);
        if (jsonML.hasChildren()) {
            this.insertExprResultState = false;
            this.transformElement(jsonML.getChild(0), node2);
            this.insertExprResultState = true;
        }
    }

    private void transformSwitchStmt(JsonML jsonML, Node node) throws JsonMLException {
        Preconditions.checkState((this.insertExprResultState ? 1 : 0) != 0);
        this.insertExprResultState = false;
        Node node2 = this.createNode(110, jsonML);
        node.addChildToBack(node2);
        JsonML jsonML2 = jsonML.getChild(0);
        this.transformElement(jsonML2, node2);
        for (int i = 1; i < jsonML.childrenSize(); ++i) {
            jsonML2 = jsonML.getChild(i);
            this.transformElement(jsonML2, node2);
        }
        this.insertExprResultState = true;
    }

    private void transformThisExpr(JsonML jsonML, Node node) throws JsonMLException {
        node.addChildToBack(this.createNode(42, jsonML));
    }

    private void transformThrowStmt(JsonML jsonML, Node node) throws JsonMLException {
        Preconditions.checkState((this.insertExprResultState ? 1 : 0) != 0);
        Node node2 = this.createNode(49, jsonML);
        node.addChildToBack(node2);
        this.insertExprResultState = false;
        this.transformElement(jsonML.getChild(0), node2);
        this.insertExprResultState = true;
    }

    private void transformTryStmt(JsonML jsonML, Node node) throws JsonMLException {
        Preconditions.checkState((this.insertExprResultState ? 1 : 0) != 0);
        Node node2 = this.createNode(77, jsonML);
        node.addChildToBack(node2);
        JsonML jsonML2 = jsonML.getChild(0);
        this.transformElement(jsonML2, node2);
        Node node3 = new Node(125);
        node2.addChildToBack(node3);
        jsonML2 = jsonML.getChild(1);
        if (jsonML2.getType() == TagType.CatchClause) {
            this.transformElement(jsonML2, node3);
        } else {
            ++this.nodeIndex;
        }
        if (jsonML.childrenSize() == 3) {
            jsonML2 = jsonML.getChild(2);
            this.transformElement(jsonML2, node2);
        }
    }

    private void transformTypeofExpr(JsonML jsonML, Node node) throws JsonMLException {
        Node node2 = this.createNode(32, jsonML);
        node.addChildToBack(node2);
        this.transformElement(jsonML.getChild(0), node2);
    }

    private void transformUnaryExpr(JsonML jsonML, Node node) throws JsonMLException {
        String string = this.getStringAttribute(jsonML, TagAttr.OP);
        int n = Operator.getNodeTypeForUnaryOp(string);
        Node node2 = this.createNode(n, jsonML);
        node.addChildToBack(node2);
        this.transformAllChildren(jsonML, node2);
    }

    private void transformVarDecl(JsonML jsonML, Node node) throws JsonMLException {
        Node node2 = this.createNode(118, jsonML);
        node.addChildToBack(node2);
        this.transformAllChildren(jsonML, node2, false);
    }

    private void transformWhileStmt(JsonML jsonML, Node node) throws JsonMLException {
        Preconditions.checkState((this.insertExprResultState ? 1 : 0) != 0);
        this.insertExprResultState = false;
        Node node2 = this.createNode(113, jsonML);
        node.addChildToBack(node2);
        JsonML jsonML2 = jsonML.getChild(0);
        this.transformElement(jsonML2, node2);
        jsonML2 = jsonML.getChild(1);
        this.transformPotentiallyUnwrappedBlock(jsonML2, node2);
        this.insertExprResultState = true;
    }

    private void transformWithStmt(JsonML jsonML, Node node) throws JsonMLException {
        Preconditions.checkState((this.insertExprResultState ? 1 : 0) != 0);
        this.insertExprResultState = false;
        Node node2 = this.createNode(119, jsonML);
        node.addChildToBack(node2);
        JsonML jsonML2 = jsonML.getChild(0);
        this.transformElement(jsonML2, node2);
        jsonML2 = jsonML.getChild(1);
        this.transformPotentiallyUnwrappedBlock(jsonML2, node2);
        this.insertExprResultState = true;
    }

    private Node createNode(int n, JsonML jsonML) {
        return new Node(n, this.nodeIndex, -1);
    }

    private void setPosition(Node node) {
        node.setLineno(this.nodeIndex);
    }

    private static enum Type {
        BOOLEAN("boolean"),
        NULL("null"),
        NUMBER("number"),
        STRING("string");

        private final String name;
        private static Map<String, Type> lookup;

        private String getName() {
            return this.name;
        }

        private Type(String string2) {
            this.name = string2;
        }

        private static Type get(String string) {
            return lookup.get(string);
        }

        static {
            lookup = new HashMap<String, Type>();
            for (Type type : Type.values()) {
                lookup.put(type.getName(), type);
            }
        }
    }

    private static enum Operator {
        ASSIGN("="),
        ASSIGN_BITOR("|="),
        ASSIGN_BITXOR("^="),
        ASSIGN_BITAND("&="),
        ASSIGN_LSH("<<="),
        ASSIGN_RSH(">>="),
        ASSIGN_URSH(">>>="),
        ASSIGN_ADD("+="),
        ASSIGN_SUB("-="),
        ASSIGN_MUL("*="),
        ASSIGN_DIV("/="),
        ASSIGN_MOD("%="),
        BITOR("|"),
        BITXOR("^"),
        BITAND("&"),
        EQ("=="),
        NE("!="),
        LT("<"),
        LE("<="),
        GT(">"),
        GE(">="),
        LSH("<<"),
        RSH(">>"),
        URSH(">>>"),
        ADD("+"),
        SUB("-"),
        MUL("*"),
        DIV("/"),
        MOD("%"),
        SHEQ("==="),
        SHNE("!=="),
        COMMA(","),
        INSTANCEOF("instanceof"),
        IN("in"),
        DEC("--"),
        INC("++"),
        NOT("!"),
        BITNOT("~"),
        POS("+_unary"),
        NEG("-_unary"),
        VOID("void");

        private final String name;
        private static Map<String, Operator> lookup;

        private String getName() {
            return this.name;
        }

        private Operator(String string2) {
            this.name = string2;
        }

        private static Operator get(String string) {
            return lookup.get(string);
        }

        private static int getNodeTypeForAssignOp(String string) {
            int n;
            Operator operator = Operator.get(string);
            if (operator == null) {
                return -1;
            }
            switch (operator) {
                case ASSIGN: {
                    n = 86;
                    break;
                }
                case ASSIGN_BITOR: {
                    n = 87;
                    break;
                }
                case ASSIGN_BITXOR: {
                    n = 88;
                    break;
                }
                case ASSIGN_BITAND: {
                    n = 89;
                    break;
                }
                case ASSIGN_LSH: {
                    n = 90;
                    break;
                }
                case ASSIGN_RSH: {
                    n = 91;
                    break;
                }
                case ASSIGN_URSH: {
                    n = 92;
                    break;
                }
                case ASSIGN_ADD: {
                    n = 93;
                    break;
                }
                case ASSIGN_SUB: {
                    n = 94;
                    break;
                }
                case ASSIGN_MUL: {
                    n = 95;
                    break;
                }
                case ASSIGN_DIV: {
                    n = 96;
                    break;
                }
                case ASSIGN_MOD: {
                    n = 97;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid type of assign expression.");
                }
            }
            return n;
        }

        private static int getNodeTypeForBinaryOp(String string) {
            int n;
            Operator operator = Operator.get(string);
            switch (operator) {
                case BITOR: {
                    n = 9;
                    break;
                }
                case BITXOR: {
                    n = 10;
                    break;
                }
                case BITAND: {
                    n = 11;
                    break;
                }
                case EQ: {
                    n = 12;
                    break;
                }
                case NE: {
                    n = 13;
                    break;
                }
                case LT: {
                    n = 14;
                    break;
                }
                case LE: {
                    n = 15;
                    break;
                }
                case GT: {
                    n = 16;
                    break;
                }
                case GE: {
                    n = 17;
                    break;
                }
                case LSH: {
                    n = 18;
                    break;
                }
                case RSH: {
                    n = 19;
                    break;
                }
                case URSH: {
                    n = 20;
                    break;
                }
                case ADD: {
                    n = 21;
                    break;
                }
                case SUB: {
                    n = 22;
                    break;
                }
                case MUL: {
                    n = 23;
                    break;
                }
                case DIV: {
                    n = 24;
                    break;
                }
                case MOD: {
                    n = 25;
                    break;
                }
                case SHEQ: {
                    n = 45;
                    break;
                }
                case SHNE: {
                    n = 46;
                    break;
                }
                case COMMA: {
                    n = 85;
                    break;
                }
                case INSTANCEOF: {
                    n = 52;
                    break;
                }
                case IN: {
                    n = 51;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid type of binary expression.");
                }
            }
            return n;
        }

        private static int getNodeTypeForCountOp(String string) {
            int n;
            Operator operator = Operator.get(string);
            if (operator == null) {
                return -1;
            }
            switch (operator) {
                case DEC: {
                    n = 103;
                    break;
                }
                case INC: {
                    n = 102;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid type of count expression.");
                }
            }
            return n;
        }

        private static int getNodeTypeForUnaryOp(String string) {
            int n;
            String string2 = new String(string);
            if (string.equals("+") || string.equals("-")) {
                string2 = string2 + "_unary";
            }
            Operator operator = Operator.get(string2);
            switch (operator) {
                case NOT: {
                    n = 26;
                    break;
                }
                case BITNOT: {
                    n = 27;
                    break;
                }
                case POS: {
                    n = 28;
                    break;
                }
                case NEG: {
                    n = 29;
                    break;
                }
                case VOID: {
                    n = 122;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid type of unary expression.");
                }
            }
            return n;
        }

        static {
            lookup = Maps.newHashMap();
            for (Operator operator : Operator.values()) {
                lookup.put(operator.getName(), operator);
            }
        }
    }

    private class ErrorReporter {
        private AbstractCompiler compiler;

        ErrorReporter(AbstractCompiler abstractCompiler) {
            this.compiler = abstractCompiler;
        }

        private void report(JsonML jsonML, String ... stringArray) throws JsonMLException {
            this.report(JSONML_SYNTAX, jsonML, stringArray);
        }

        private void report(DiagnosticType diagnosticType, JsonML jsonML, String ... stringArray) throws JsonMLException {
            int n = Reader.this.nodeIndex;
            int n2 = -1;
            this.report(JSError.make(Reader.this.sourceName, n, n2, diagnosticType, stringArray));
        }

        private void report(DiagnosticType diagnosticType, String ... stringArray) throws JsonMLException {
            this.report(JSError.make(diagnosticType, stringArray));
        }

        private void report(JSError jSError) throws JsonMLException {
            this.report(jSError, true);
        }

        private void report(JSError jSError, boolean bl) throws JsonMLException {
            this.compiler.report(jSError);
            if (bl) {
                throw new JsonMLException();
            }
        }
    }
}

