/*
 * Decompiled with CFR 0.152.
 */
package com.asual.lesscss;

import com.asual.lesscss.Engine;
import com.asual.lesscss.EngineException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import java.util.zip.GZIPOutputStream;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EngineServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Engine engine;
    private int cache = 31556926;
    private int milliseconds = 1000;

    @PostConstruct
    public void init() {
        if (this.engine == null) {
            this.engine = new Engine();
        }
    }

    @PreDestroy
    public void destroy() {
        if (this.engine != null) {
            this.engine.destroy();
        }
    }

    public final void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("META-INF" + request.getRequestURI());
        if (url == null) {
            url = ((Object)((Object)this)).getClass().getClassLoader().getResource("META-INF/resources" + request.getRequestURI());
        }
        File file = null;
        try {
            file = new File(this.getServletContext().getRealPath(request.getRequestURI()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (url != null || file != null && file.exists()) {
            Long lastModified = url != null ? url.openConnection().getLastModified() : file.lastModified();
            Long ifModifiedSince = request.getDateHeader("If-Modified-Since");
            if (ifModifiedSince != null && ifModifiedSince / (long)this.milliseconds == lastModified / (long)this.milliseconds) {
                response.setStatus(304);
                return;
            }
            String compiled = null;
            try {
                compiled = url != null ? this.engine.compile(url) : this.engine.compile(file);
            }
            catch (EngineException ce) {
                this.logger.error((Object)("Error processing: " + request.getRequestURI()));
                throw new ServletException(ce.getMessage(), (Throwable)ce);
            }
            response.setContentType("text/css");
            response.addDateHeader("Expires", new Date().getTime() + (long)(this.cache * this.milliseconds));
            response.addDateHeader("Cache-control: max-age=", (long)this.cache);
            response.addDateHeader("Last-Modified", lastModified.longValue());
            if ("true".equals(this.getInitParameter("gzip"))) {
                response.setHeader("Content-Encoding", "gzip");
                GZIPOutputStream gz = new GZIPOutputStream((OutputStream)response.getOutputStream());
                gz.write(compiled.getBytes());
                gz.close();
            } else {
                response.getOutputStream().print(compiled);
            }
            response.getOutputStream().close();
        } else {
            this.logger.error((Object)("Error processing: " + request.getRequestURI()));
            response.setStatus(404);
        }
    }
}

