/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AnonymousFunctionNamingPolicy;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ComposeWarningsGuard;
import com.google.javascript.jscomp.CssRenamingMap;
import com.google.javascript.jscomp.CustomPassExecutionTime;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticGroupWarningsGuard;
import com.google.javascript.jscomp.ErrorFormat;
import com.google.javascript.jscomp.MessageBundle;
import com.google.javascript.jscomp.PropertyRenamingPolicy;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.VariableRenamingPolicy;
import com.google.javascript.jscomp.WarningsGuard;
import com.google.javascript.rhino.Node;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CompilerOptions
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 7L;
    LanguageMode languageIn;
    public boolean ideMode;
    boolean skipAllPasses = false;
    boolean nameAnonymousFunctionsOnly = false;
    DevMode devMode;
    boolean manageClosureDependencies = false;
    List<String> manageClosureDependenciesEntryPoints = ImmutableList.of();
    public transient MessageBundle messageBundle = null;
    public boolean checkSymbols = false;
    public CheckLevel checkShadowVars;
    public CheckLevel aggressiveVarCheck;
    public CheckLevel checkFunctions;
    public CheckLevel checkMethods;
    public boolean checkDuplicateMessages = false;
    public boolean allowLegacyJsMessages = false;
    public boolean strictMessageReplacement = false;
    public boolean checkSuspiciousCode = false;
    public boolean checkControlStructures = false;
    public CheckLevel checkUndefinedProperties;
    public boolean checkUnusedPropertiesEarly = false;
    public boolean checkTypes = false;
    public boolean tightenTypes = false;
    public boolean inferTypesInGlobalScope = false;
    public boolean checkTypedPropertyCalls = false;
    public CheckLevel reportMissingOverride;
    public CheckLevel reportUnknownTypes;
    public CheckLevel checkRequires;
    public CheckLevel checkProvides;
    public CheckLevel checkGlobalNamesLevel;
    public CheckLevel brokenClosureRequiresLevel;
    public CheckLevel checkGlobalThisLevel;
    public CheckLevel checkMissingGetCssNameLevel;
    public String checkMissingGetCssNameBlacklist = null;
    public boolean checkEs5Strict = false;
    public boolean checkCaja = false;
    public boolean foldConstants = false;
    public boolean deadAssignmentElimination = false;
    public boolean inlineConstantVars = false;
    public boolean inlineFunctions = false;
    public boolean decomposeExpressions;
    public boolean inlineAnonymousFunctionExpressions;
    public boolean inlineLocalFunctions = false;
    public boolean crossModuleCodeMotion = false;
    public boolean coalesceVariableNames = false;
    public boolean crossModuleMethodMotion = false;
    public boolean inlineGetters = false;
    public boolean inlineVariables = false;
    public boolean inlineLocalVariables = false;
    public boolean flowSensitiveInlineVariables;
    public boolean smartNameRemoval = false;
    public boolean removeDeadCode = false;
    public CheckLevel checkUnreachableCode;
    public CheckLevel checkMissingReturn;
    public boolean extractPrototypeMemberDeclarations = false;
    public boolean removeEmptyFunctions;
    public boolean removeUnusedPrototypeProperties = false;
    public boolean removeUnusedPrototypePropertiesInExterns = false;
    public boolean removeUnusedVars = false;
    public boolean removeUnusedLocalVars = false;
    public boolean aliasExternals = false;
    public String aliasableGlobals;
    public String unaliasableGlobals;
    public boolean collapseVariableDeclarations = false;
    public boolean groupVariableDeclarations = false;
    public boolean collapseAnonymousFunctions = false;
    public Set<String> aliasableStrings;
    public String aliasStringsBlacklist = "";
    public boolean aliasAllStrings = false;
    boolean outputJsStringUsage = false;
    public boolean convertToDottedProperties = false;
    public boolean rewriteFunctionExpressions = false;
    public boolean optimizeParameters = false;
    public boolean optimizeReturns = false;
    public boolean optimizeCalls;
    public boolean optimizeArgumentsArray;
    boolean chainCalls = false;
    public VariableRenamingPolicy variableRenaming;
    public PropertyRenamingPolicy propertyRenaming;
    public boolean labelRenaming = false;
    public boolean reserveRawExports;
    public boolean generatePseudoNames = false;
    public String renamePrefix = null;
    public boolean aliasKeywords = false;
    public boolean collapseProperties = false;
    boolean collapsePropertiesOnExternTypes = false;
    public boolean devirtualizePrototypeMethods = false;
    public boolean computeFunctionSideEffects = false;
    public String debugFunctionSideEffectsPath = null;
    public boolean disambiguateProperties = false;
    public boolean ambiguateProperties = false;
    public AnonymousFunctionNamingPolicy anonymousFunctionNaming;
    public byte[] inputVariableMapSerialized;
    public byte[] inputPropertyMapSerialized;
    public boolean exportTestFunctions = false;
    public boolean specializeInitialModule;
    boolean runtimeTypeCheck = false;
    String runtimeTypeCheckLogFunction = null;
    private CodingConvention codingConvention;
    public boolean instrumentForCoverage = false;
    public boolean instrumentForCoverageOnly = false;
    public boolean ignoreCajaProperties = false;
    public String syntheticBlockStartMarker = null;
    public String syntheticBlockEndMarker = null;
    public String locale = null;
    public boolean markAsCompiled = false;
    public boolean removeTryCatchFinally = false;
    public boolean closurePass = false;
    boolean rewriteNewDateGoogNow = true;
    boolean removeAbstractMethods = true;
    boolean removeClosureAsserts = false;
    public boolean gatherCssNames;
    public Set<String> stripTypes;
    public Set<String> stripNameSuffixes;
    public Set<String> stripNamePrefixes;
    public Set<String> stripTypePrefixes;
    public transient Multimap<CustomPassExecutionTime, CompilerPass> customPasses = null;
    public boolean markNoSideEffectCalls = false;
    private Map<String, Object> defineReplacements;
    public boolean moveFunctionDeclarations = false;
    public String instrumentationTemplate = null;
    public String appNameStr = "";
    public boolean recordFunctionInformation = false;
    public boolean generateExports = false;
    public CssRenamingMap cssRenamingMap = null;
    boolean processObjectPropertyString = false;
    Set<String> idGenerators;
    List<String> replaceStringsFunctionDescriptions;
    String replaceStringsPlaceholderToken = "";
    public boolean prettyPrint = false;
    public boolean lineBreak = false;
    public boolean printInputDelimiter = false;
    public String inputDelimiter = "// Input %num%";
    public String reportPath = null;
    public TracerMode tracer;
    private boolean colorizeErrorOutput = false;
    public ErrorFormat errorFormat;
    public String jsOutputFile = "";
    private transient ComposeWarningsGuard warningsGuard = null;
    int summaryDetailLevel = 1;
    private boolean externExports = false;
    String externExportsPath;
    public String nameReferenceReportPath = null;
    public String nameReferenceGraphPath = null;
    public String sourceMapOutputPath;
    public SourceMap.DetailLevel sourceMapDetailLevel = SourceMap.DetailLevel.SYMBOLS;
    public SourceMap.Format sourceMapFormat = SourceMap.Format.LEGACY;
    String outputCharset;
    boolean looseTypes;

    public CompilerOptions() {
        this.languageIn = LanguageMode.ECMASCRIPT3;
        this.devMode = DevMode.OFF;
        this.checkShadowVars = CheckLevel.OFF;
        this.aggressiveVarCheck = CheckLevel.OFF;
        this.checkFunctions = CheckLevel.OFF;
        this.checkMethods = CheckLevel.OFF;
        this.checkUndefinedProperties = CheckLevel.OFF;
        this.reportMissingOverride = CheckLevel.OFF;
        this.reportUnknownTypes = CheckLevel.OFF;
        this.checkRequires = CheckLevel.OFF;
        this.checkProvides = CheckLevel.OFF;
        this.checkGlobalNamesLevel = CheckLevel.OFF;
        this.brokenClosureRequiresLevel = CheckLevel.ERROR;
        this.checkGlobalThisLevel = CheckLevel.OFF;
        this.checkUnreachableCode = CheckLevel.OFF;
        this.checkMissingReturn = CheckLevel.OFF;
        this.checkMissingGetCssNameLevel = CheckLevel.OFF;
        this.aliasableStrings = Collections.emptySet();
        this.variableRenaming = VariableRenamingPolicy.OFF;
        this.propertyRenaming = PropertyRenamingPolicy.OFF;
        this.anonymousFunctionNaming = AnonymousFunctionNamingPolicy.OFF;
        this.stripTypes = Collections.emptySet();
        this.stripNameSuffixes = Collections.emptySet();
        this.stripNamePrefixes = Collections.emptySet();
        this.stripTypePrefixes = Collections.emptySet();
        this.defineReplacements = Maps.newHashMap();
        this.idGenerators = Collections.emptySet();
        this.replaceStringsFunctionDescriptions = Collections.emptyList();
        this.tracer = TracerMode.OFF;
        this.errorFormat = ErrorFormat.SINGLELINE;
    }

    public Map<String, Node> getDefineReplacements() {
        HashMap hashMap = Maps.newHashMap();
        for (Map.Entry<String, Object> entry : this.defineReplacements.entrySet()) {
            String string = entry.getKey();
            Object object = entry.getValue();
            if (object instanceof Boolean) {
                hashMap.put(string, (Boolean)object != false ? new Node(44) : new Node(43));
                continue;
            }
            if (object instanceof Integer) {
                hashMap.put(string, Node.newNumber(((Integer)object).intValue()));
                continue;
            }
            if (object instanceof Double) {
                hashMap.put(string, Node.newNumber((Double)object));
                continue;
            }
            Preconditions.checkState((boolean)(object instanceof String));
            hashMap.put(string, Node.newString((String)object));
        }
        return hashMap;
    }

    public void setDefineToBooleanLiteral(String string, boolean bl) {
        this.defineReplacements.put(string, new Boolean(bl));
    }

    public void setDefineToStringLiteral(String string, String string2) {
        this.defineReplacements.put(string, string2);
    }

    public void setDefineToNumberLiteral(String string, int n) {
        this.defineReplacements.put(string, new Integer(n));
    }

    public void setDefineToDoubleLiteral(String string, double d) {
        this.defineReplacements.put(string, new Double(d));
    }

    public void skipAllCompilerPasses() {
        this.skipAllPasses = true;
    }

    boolean enables(DiagnosticGroup diagnosticGroup) {
        return this.warningsGuard != null && this.warningsGuard.enables(diagnosticGroup);
    }

    boolean disables(DiagnosticGroup diagnosticGroup) {
        return this.warningsGuard != null && this.warningsGuard.disables(diagnosticGroup);
    }

    public void setWarningLevel(DiagnosticGroup diagnosticGroup, CheckLevel checkLevel) {
        this.addWarningsGuard(new DiagnosticGroupWarningsGuard(diagnosticGroup, checkLevel));
    }

    WarningsGuard getWarningsGuard() {
        return this.warningsGuard;
    }

    public void addWarningsGuard(WarningsGuard warningsGuard) {
        if (this.warningsGuard == null) {
            this.warningsGuard = new ComposeWarningsGuard(warningsGuard);
        } else {
            this.warningsGuard.addGuard(warningsGuard);
        }
    }

    public void setRenamingPolicy(VariableRenamingPolicy variableRenamingPolicy, PropertyRenamingPolicy propertyRenamingPolicy) {
        this.variableRenaming = variableRenamingPolicy;
        this.propertyRenaming = propertyRenamingPolicy;
    }

    public void setCollapsePropertiesOnExternTypes(boolean bl) {
        this.collapsePropertiesOnExternTypes = bl;
    }

    public void setProcessObjectPropertyString(boolean bl) {
        this.processObjectPropertyString = bl;
    }

    public void setIdGenerators(Set<String> set) {
        this.idGenerators = Sets.newHashSet(set);
    }

    public void setReplaceStringsConfiguration(String string, List<String> list) {
        this.replaceStringsPlaceholderToken = string;
        this.replaceStringsFunctionDescriptions = Lists.newArrayList(list);
    }

    public void setRewriteNewDateGoogNow(boolean bl) {
        this.rewriteNewDateGoogNow = bl;
    }

    public void setRemoveAbstractMethods(boolean bl) {
        this.removeAbstractMethods = bl;
    }

    public void setRemoveClosureAsserts(boolean bl) {
        this.removeClosureAsserts = bl;
    }

    public void setNameAnonymousFunctionsOnly(boolean bl) {
        this.nameAnonymousFunctionsOnly = bl;
    }

    public void setColorizeErrorOutput(boolean bl) {
        this.colorizeErrorOutput = bl;
    }

    public boolean shouldColorizeErrorOutput() {
        return this.colorizeErrorOutput;
    }

    public void setChainCalls(boolean bl) {
        this.chainCalls = bl;
    }

    public void enableRuntimeTypeCheck(String string) {
        this.runtimeTypeCheck = true;
        this.runtimeTypeCheckLogFunction = string;
    }

    public void disableRuntimeTypeCheck() {
        this.runtimeTypeCheck = false;
    }

    public void setCodingConvention(CodingConvention codingConvention) {
        this.codingConvention = codingConvention;
    }

    public CodingConvention getCodingConvention() {
        return this.codingConvention;
    }

    public void setManageClosureDependencies(boolean bl) {
        this.manageClosureDependencies = bl;
    }

    public void setManageClosureDependencies(List<String> list) {
        Preconditions.checkNotNull(list);
        this.manageClosureDependencies = true;
        this.manageClosureDependenciesEntryPoints = list;
    }

    public void setSummaryDetailLevel(int n) {
        this.summaryDetailLevel = n;
    }

    public void enableExternExports(boolean bl) {
        this.externExports = bl;
    }

    public boolean isExternExportsEnabled() {
        return this.externExports;
    }

    public void setOutputCharset(String string) {
        this.outputCharset = string;
    }

    public void setLooseTypes(boolean bl) {
        this.looseTypes = bl;
    }

    public Object clone() throws CloneNotSupportedException {
        CompilerOptions compilerOptions = (CompilerOptions)super.clone();
        return compilerOptions;
    }

    public static enum TracerMode {
        ALL,
        FAST,
        OFF;


        boolean isOn() {
            return this != OFF;
        }
    }

    static enum DevMode {
        OFF,
        START,
        START_AND_END,
        EVERY_PASS;

    }

    static enum LanguageMode {
        ECMASCRIPT3,
        ECMASCRIPT5;

    }
}

