/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.FunctionInformationMap;
import com.google.javascript.jscomp.FunctionNames;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;

class RecordFunctionInformation
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final Compiler compiler;
    private final FunctionNames functionNames;
    private final JSModuleGraph moduleGraph;
    private final FunctionInformationMap.Builder mapBuilder;

    RecordFunctionInformation(Compiler compiler, FunctionNames functionNames) {
        this.compiler = compiler;
        this.moduleGraph = compiler.getModuleGraph();
        this.functionNames = functionNames;
        this.mapBuilder = FunctionInformationMap.newBuilder();
    }

    FunctionInformationMap getMap() {
        return this.mapBuilder.build();
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node2, this);
        if (this.moduleGraph == null) {
            this.addModuleInformation(null);
        } else {
            TreeSet treeSet = Sets.newTreeSet((Comparator)new Comparator<JSModule>(){

                @Override
                public int compare(JSModule jSModule, JSModule jSModule2) {
                    return jSModule.getName().compareTo(jSModule2.getName());
                }
            });
            Iterables.addAll((Collection)treeSet, this.moduleGraph.getAllModules());
            for (JSModule jSModule : treeSet) {
                this.addModuleInformation(jSModule);
            }
        }
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        if (node.getType() != 105) {
            return;
        }
        int n = this.functionNames.getFunctionId(node);
        if (n < 0) {
            return;
        }
        String string = this.compiler.toSource(node);
        JSModule jSModule = nodeTraversal.getModule();
        this.mapBuilder.addEntry(FunctionInformationMap.Entry.newBuilder().setId(n).setSourceName(NodeUtil.getSourceName(node)).setLineNumber(node.getLineno()).setModuleName(this.moduleGraph == null ? "" : jSModule.getName()).setSize(string.length()).setName(this.functionNames.getFunctionName(node)).setCompiledSource(string).build());
    }

    private void addModuleInformation(JSModule jSModule) {
        String string;
        String string2;
        if (jSModule != null) {
            string2 = jSModule.getName();
            string = this.compiler.toSource(jSModule);
        } else {
            string2 = "";
            string = this.compiler.toSource();
        }
        this.mapBuilder.addModule(FunctionInformationMap.Module.newBuilder().setName(string2).setCompiledSource(string).build());
    }
}

