/*
 * Decompiled with CFR 0.152.
 */
package play.modules.greenscript;

import com.greenscriptool.DependenceManager;
import com.greenscriptool.IDependenceManager;
import com.greenscriptool.IFileLocator;
import com.greenscriptool.IMinimizer;
import com.greenscriptool.IRenderSession;
import com.greenscriptool.Minimizer;
import com.greenscriptool.RenderSession;
import com.greenscriptool.ResourceType;
import com.greenscriptool.utils.BufferResource;
import com.greenscriptool.utils.IBufferLocator;
import com.greenscriptool.utils.YUICompressor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.cache.Cache;
import play.exceptions.UnexpectedException;
import play.mvc.Http;
import play.mvc.Router;
import play.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GreenScriptPlugin
extends PlayPlugin {
    public static final String VERSION = "1.2.5";
    private Minimizer jsM_;
    private Minimizer cssM_;
    private IDependenceManager jsD_;
    private IDependenceManager cssD_;
    private Properties depConf_;
    private Properties minConf_;
    private HashMap<String, Long> configFiles_;
    private static Properties defProps_ = new Properties();
    private static ThreadLocal<IRenderSession> sessJs_;
    private static ThreadLocal<IRenderSession> sessCss_;
    private static YUICompressor jsC_;
    private static YUICompressor cssC_;
    public static final String CACHE_KEY_BUFFER = "greenscript.buffer";
    protected boolean inMemoryCache = false;
    private IBufferLocator bufferLocator_ = new IBufferLocator(){

        private String key_(String key) {
            return String.format("%s.%s", GreenScriptPlugin.CACHE_KEY_BUFFER, key);
        }

        public BufferResource locate(String key) {
            return (BufferResource)Cache.get((String)this.key_(key), BufferResource.class);
        }

        public BufferResource newBuffer(String extension) {
            String key = UUID.randomUUID().toString() + extension;
            BufferResource buffer = new BufferResource(key);
            Cache.set((String)this.key_(key), (Object)buffer);
            return buffer;
        }
    };

    private static String msg_(String msg, Object ... args) {
        return String.format("GreenScript-1.2.5> %1$s", String.format(msg, args));
    }

    private static void info_(String msg, Object ... args) {
        Logger.info((String)GreenScriptPlugin.msg_(msg, args), (Object[])new Object[0]);
    }

    private static void trace_(String msg, Object ... args) {
        Logger.trace((String)GreenScriptPlugin.msg_(msg, args), (Object[])new Object[0]);
    }

    public GreenScriptPlugin() {
        this.minConf_ = new Properties();
        this.minConf_.putAll((Map<?, ?>)defProps_);
    }

    public void onConfigurationRead() {
        this.loadDependencies();
        this.InitializeMinimizers();
        GreenScriptPlugin.info_("initialized", new Object[0]);
    }

    private void updateRoute_() {
        if (this.inMemoryCache) {
            String url = this.fetchProp_(Play.configuration, "greenscript.url.minimized");
            Router.addRoute((int)0, (String)"GET", (String)(url + "/{key}"), (String)"greenscript.Service.getInMemoryCache", null, null);
        } else {
            Router.load((String)Play.ctxPath);
        }
    }

    public void onApplicationStart() {
        this.updateRoute_();
    }

    public void onApplicationStop() {
        this.cleanUp_();
    }

    public String jsDebugString() {
        return ((DependenceManager)this.jsD_).debugString();
    }

    public String cssDebugString() {
        return ((DependenceManager)this.cssD_).debugString();
    }

    public static IRenderSession session(String type) {
        ResourceType rt = ResourceType.valueOf((String)type.toUpperCase());
        switch (rt) {
            case JS: {
                return GreenScriptPlugin.jsSession();
            }
            case CSS: {
                return GreenScriptPlugin.cssSession();
            }
        }
        throw new UnexpectedException("unknown resource type: " + rt.name());
    }

    public static IRenderSession jsSession() {
        return sessJs_.get();
    }

    public static IRenderSession cssSession() {
        return sessCss_.get();
    }

    public void beforeActionInvocation(Method actionMethod) {
        sessJs_.set(this.newSession_(ResourceType.JS));
        sessCss_.set(this.newSession_(ResourceType.CSS));
    }

    public boolean serveStatic(VirtualFile file, Http.Request request, Http.Response response) {
        String fn = file.getName();
        if (this.jsM_.isMinimizeEnabled() && fn.endsWith(".js")) {
            return this.compressStatic_(file, response, ResourceType.JS);
        }
        if (this.cssM_.isMinimizeEnabled() && fn.endsWith("css")) {
            return this.compressStatic_(file, response, ResourceType.CSS);
        }
        return super.serveStatic(file, request, response);
    }

    private boolean compressStatic_(VirtualFile file, Http.Response resp, ResourceType type) {
        IRenderSession sess;
        IRenderSession iRenderSession = sess = type == ResourceType.JS ? GreenScriptPlugin.jsSession() : GreenScriptPlugin.cssSession();
        if (null != sess && sess.hasDeclared()) {
            return false;
        }
        if (Play.mode == Play.Mode.PROD) {
            resp.cacheFor("1h");
        }
        YUICompressor comp = type == ResourceType.JS ? jsC_ : cssC_;
        try {
            StringWriter w = new StringWriter();
            comp.compress(file.getRealFile(), (Writer)w);
            resp.contentType = type == ResourceType.JS ? "text/javascript" : "text/css";
            resp.status = 200;
            resp.print((Object)w);
            return true;
        }
        catch (Exception e) {
            Logger.warn((Throwable)e, (String)"error compress file %1$s", (Object[])new Object[]{file.getName()});
            return false;
        }
    }

    private HashMap<String, Long> currentConfigFiles() {
        HashMap<String, Long> files = new HashMap<String, Long>();
        for (VirtualFile vf : Play.roots) {
            VirtualFile conf = vf.child("conf/greenscript.conf");
            if (!conf.exists()) continue;
            files.put(conf.getRealFile().getAbsolutePath(), conf.getRealFile().lastModified());
        }
        return files;
    }

    private boolean filesChanged(HashMap<String, Long> oldFiles, HashMap<String, Long> newFiles) {
        if (oldFiles.size() != newFiles.size()) {
            return true;
        }
        for (Map.Entry<String, Long> entry : oldFiles.entrySet()) {
            Long newTime = newFiles.get(entry.getKey());
            if (newTime != null && newTime.equals(entry.getValue())) continue;
            return true;
        }
        return false;
    }

    public void detectChange() {
        if (Play.mode == Play.Mode.PROD) {
            return;
        }
        if (this.filesChanged(this.configFiles_, this.currentConfigFiles())) {
            Logger.debug((String)"greenscript: config files changed, reloading dependencies", (Object[])new Object[0]);
            GreenScriptPlugin.reloadDependencies();
        }
    }

    public void loadDependencies() {
        Properties p = new Properties();
        for (VirtualFile vf : Play.roots) {
            VirtualFile conf = vf.child("conf/greenscript.conf");
            if (!conf.exists()) continue;
            GreenScriptPlugin.trace_("loading dependency configuration from %1$s", conf.getRealFile().getAbsolutePath());
            try {
                p.load(new BufferedInputStream(conf.inputstream()));
            }
            catch (Exception e) {
                throw new UnexpectedException("error loading conf/greenscript.conf");
            }
        }
        this.configFiles_ = this.currentConfigFiles();
        this.jsD_ = new DependenceManager(this.loadDepProp_(p, "js"));
        this.cssD_ = new DependenceManager(this.loadDepProp_(p, "css"));
        this.depConf_ = p;
        GreenScriptPlugin.info_("dependency loaded", new Object[0]);
    }

    public void InitializeMinimizers() {
        Properties p = Play.configuration;
        for (String key : p.stringPropertyNames()) {
            if (!key.startsWith("greenscript.")) continue;
            String v = p.getProperty(key);
            this.minConf_.setProperty(key, p.getProperty(key));
            GreenScriptPlugin.trace_("[greenscript]set %1$s to %2$s", v, key);
        }
        this.jsM_ = this.initializeMinimizer_(this.minConf_, ResourceType.JS);
        this.cssM_ = this.initializeMinimizer_(this.minConf_, ResourceType.CSS);
        if (p.containsKey("greenscript.useGoogleClosure")) {
            System.setProperty("greenscript.useGoogleClosure", p.getProperty("greenscript.useGoogleClosure"));
        }
        GreenScriptPlugin.info_("minimizer initialized", new Object[0]);
    }

    private IRenderSession newSession_(ResourceType type) {
        return type == ResourceType.JS ? new RenderSession((IMinimizer)this.jsM_, this.jsD_, type) : new RenderSession((IMinimizer)this.cssM_, this.cssD_, type);
    }

    public Properties getDependencyConfig() {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)this.depConf_);
        return p;
    }

    public Properties getMinimizerConfig() {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)this.minConf_);
        return p;
    }

    private String join_(Collection<String> c) {
        boolean first = true;
        StringBuffer sb = new StringBuffer();
        for (String s : c) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append(s);
        }
        return sb.toString();
    }

    private void mergeProperties_(Properties p, String k, String v) {
        String oldV = p.getProperty(k);
        if (null == oldV) {
            p.setProperty(k, v);
        } else {
            HashSet<String> oldS = new HashSet<String>();
            oldS.addAll(Arrays.asList(oldV.split("[ ,;<>]")));
            HashSet<String> newS = new HashSet<String>();
            newS.addAll(Arrays.asList(v.split("[ ,;<>]")));
            oldS.addAll(newS);
            p.setProperty(k, this.join_(oldS));
        }
    }

    private Properties loadDepProp_(Properties p, String type) {
        Properties p0 = new Properties();
        String prefix = type + ".";
        for (String k : p.stringPropertyNames()) {
            if (!k.startsWith(prefix)) continue;
            String k0 = k.replace(prefix, "");
            String v = p.getProperty(k);
            if (k0.matches(".*\\s*\\-\\s*$")) {
                k0 = k0.replaceAll("\\s*\\-\\s*$", "");
                for (String s : v.replaceAll("\\s+", "").split("[ ,;<>]")) {
                    this.mergeProperties_(p0, s, k0);
                }
            } else {
                this.mergeProperties_(p0, k0, v);
            }
            GreenScriptPlugin.trace_("Found one %1$s dependency: %2$s depends on '%3$s'", type, k0, v);
        }
        return p0;
    }

    private Minimizer initializeMinimizer_(Properties p, ResourceType type) {
        Minimizer m = new Minimizer(type);
        String ext = type.getExtension();
        String rootDir = this.fetchProp_(p, "greenscript.dir.root");
        String resourceDir = this.fetchProp_(p, "greenscript.dir" + ext);
        String cacheDir = this.fetchProp_(p, "greenscript.dir.minimized");
        String urlRoot = this.fetchProp_(p, "greenscript.url.root");
        String resourceUrl = this.fetchProp_(p, "greenscript.url" + ext);
        String cacheUrl = this.fetchProp_(p, "greenscript.url.minimized");
        m.setCacheDir(Play.getFile((String)cacheDir));
        m.setCacheUrlPath(cacheUrl);
        m.setResourceDir(resourceDir);
        m.setResourceUrlRoot(urlRoot);
        m.setResourceUrlPath(resourceUrl);
        m.setRootDir(rootDir);
        boolean minimize = this.getBooleanProp_(p, "greenscript.minimize", Play.mode == Play.Mode.PROD);
        boolean compress = this.getBooleanProp_(p, "greenscript.compress", true);
        boolean cache = this.getBooleanProp_(p, "greenscript.cache", true);
        this.inMemoryCache = this.getBooleanProp_(p, "greenscript.cache.inmemory", false);
        m.enableDisableMinimize(minimize);
        m.enableDisableCompress(compress);
        m.enableDisableCache(cache);
        m.enableDisableInMemoryCache(this.inMemoryCache);
        m.setFileLocator(new IFileLocator(){

            public File locate(String path) {
                VirtualFile vf = VirtualFile.search((Collection)Play.roots, (String)path);
                return vf == null ? null : vf.getRealFile();
            }
        });
        m.setBufferLocator(this.bufferLocator_);
        GreenScriptPlugin.trace_("minimizer for %1$s loaded", type.name());
        return m;
    }

    public String getInMemoryFileContent(String key) {
        BufferResource br = this.bufferLocator_.locate(key);
        return null == br ? null : br.toString();
    }

    private String fetchProp_(Properties p, String key) {
        String val = p.getProperty(key);
        if (null == val) {
            val = defProps_.getProperty(key);
        }
        return val;
    }

    private boolean getBooleanProp_(Properties p, String key, boolean def) {
        try {
            String s = p.containsKey(key) ? p.getProperty(key) : (defProps_.containsKey(key) ? defProps_.getProperty(key) : String.valueOf(def));
            p.setProperty(key, s);
            return Boolean.parseBoolean(s);
        }
        catch (Exception e) {
            p.setProperty(key, String.valueOf(def));
            return def;
        }
    }

    private void cleanUp_() {
        if (null != this.jsM_) {
            this.jsM_.clearCache();
        }
        if (null != this.cssM_) {
            this.cssM_.clearCache();
        }
    }

    public static GreenScriptPlugin getInstance() {
        for (PlayPlugin pp : Play.pluginCollection.getEnabledPlugins()) {
            if (!(pp instanceof GreenScriptPlugin)) continue;
            return (GreenScriptPlugin)pp;
        }
        return null;
    }

    public static void updateMinimizer(boolean minimize, boolean compress, boolean cache, boolean inMemoryCache) {
        GreenScriptPlugin gs = GreenScriptPlugin.getInstance();
        gs.jsM_.enableDisableMinimize(minimize);
        gs.jsM_.enableDisableCompress(compress);
        gs.jsM_.enableDisableCache(cache);
        gs.jsM_.enableDisableInMemoryCache(inMemoryCache);
        gs.cssM_.enableDisableMinimize(minimize);
        gs.cssM_.enableDisableCompress(compress);
        gs.cssM_.enableDisableCache(cache);
        gs.cssM_.enableDisableInMemoryCache(inMemoryCache);
        gs.inMemoryCache = inMemoryCache;
        gs.updateRoute_();
        gs.minConf_.setProperty("greenscript.minimize", String.valueOf(minimize));
        gs.minConf_.setProperty("greenscript.compress", String.valueOf(compress));
        gs.minConf_.setProperty("greenscript.cache", String.valueOf(cache));
        gs.minConf_.setProperty("greenscript.cache.inmemory", String.valueOf(inMemoryCache));
    }

    public static void enableDisableMinimize(boolean minimize) {
        GreenScriptPlugin gs = GreenScriptPlugin.getInstance();
        gs.jsM_.enableDisableMinimize(minimize);
        gs.minConf_.setProperty("greenscript.minimize", String.valueOf(minimize));
        GreenScriptPlugin.info_("minimize %s", minimize ? "enabled" : "disabled");
    }

    public static void enableDisableCompress(boolean compress) {
        GreenScriptPlugin gs = GreenScriptPlugin.getInstance();
        gs.jsM_.enableDisableCompress(compress);
        gs.minConf_.setProperty("greenscript.compress", String.valueOf(compress));
        GreenScriptPlugin.info_("compress %s", compress ? "enabled" : "disabled");
    }

    public static void enableDisableCache(boolean cache) {
        GreenScriptPlugin gs = GreenScriptPlugin.getInstance();
        gs.jsM_.enableDisableCache(cache);
        gs.minConf_.setProperty("greenscript.cache", String.valueOf(cache));
        GreenScriptPlugin.info_("cache %s", cache ? "enabled" : "disabled");
    }

    public static void reloadDependencies() {
        GreenScriptPlugin gs = GreenScriptPlugin.getInstance();
        gs.loadDependencies();
        GreenScriptPlugin.info_("dependency reloaded", new Object[0]);
    }

    static {
        defProps_.put("greenscript.dir.root", "/public");
        defProps_.put("greenscript.dir.js", "javascripts");
        defProps_.put("greenscript.dir.css", "stylesheets");
        defProps_.put("greenscript.dir.minimized", "/public/gs");
        defProps_.put("greenscript.url.root", "/public");
        defProps_.put("greenscript.url.js", "/public/javascripts");
        defProps_.put("greenscript.url.css", "/public/stylesheets");
        defProps_.put("greenscript.url.minimized", "/public/gs");
        defProps_.setProperty("greenscript.minimize", Play.mode == Play.Mode.PROD ? "true" : "false");
        defProps_.setProperty("greenscript.compress", "true");
        defProps_.setProperty("greenscript.cache", "true");
        defProps_.setProperty("greenscript.cache.inmemory", "false");
        sessJs_ = new ThreadLocal();
        sessCss_ = new ThreadLocal();
        jsC_ = new YUICompressor(ResourceType.JS);
        cssC_ = new YUICompressor(ResourceType.CSS);
    }
}

