/*
 * Decompiled with CFR 0.152.
 */
package com.asual.lesscss;

import com.asual.lesscss.LessException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.shell.Global;

public class LessEngine {
    private final Log logger = LogFactory.getLog(this.getClass());
    private Scriptable scope;
    private Function cs;
    private Function cf;

    public static void main(String[] args) throws LessException, IOException {
        LessEngine engine = new LessEngine();
        if (args.length == 1) {
            System.out.println(engine.compile(args[0]));
        } else if (args.length == 2) {
            engine.compile(new File(args[0]), new File(args[1]));
        } else {
            System.err.println("Usage: java -jar lesscss-engine.jar <input_file> [<output_file>]");
        }
    }

    public LessEngine() {
        try {
            this.logger.debug((Object)"Initializing LESS Engine.");
            URL browser = this.getClass().getClassLoader().getResource("META-INF/browser.js");
            URL less = this.getClass().getClassLoader().getResource("META-INF/less.js");
            URL engine = this.getClass().getClassLoader().getResource("META-INF/engine.js");
            Context cx = Context.enter();
            this.logger.warn((Object)("Using implementation version: " + cx.getImplementationVersion()));
            cx.setOptimizationLevel(9);
            Global global = new Global();
            global.init(cx);
            this.scope = cx.initStandardObjects((ScriptableObject)global);
            cx.evaluateReader(this.scope, (Reader)new InputStreamReader(browser.openConnection().getInputStream()), browser.getFile(), 1, null);
            cx.evaluateReader(this.scope, (Reader)new InputStreamReader(less.openConnection().getInputStream()), less.getFile(), 1, null);
            cx.evaluateReader(this.scope, (Reader)new InputStreamReader(engine.openConnection().getInputStream()), engine.getFile(), 1, null);
            this.cs = (Function)this.scope.get("compileString", this.scope);
            this.cf = (Function)this.scope.get("compileFile", this.scope);
            Context.exit();
        }
        catch (Exception e) {
            this.logger.error((Object)"LESS Engine intialization failed.", (Throwable)e);
        }
    }

    public String compile(String input) throws LessException {
        try {
            long time = System.currentTimeMillis();
            String result = this.call(this.cs, new Object[]{input});
            this.logger.debug((Object)("The compilation of '" + input + "' took " + (System.currentTimeMillis() - time) + " ms."));
            return result;
        }
        catch (Exception e) {
            throw this.parseLessException(e);
        }
    }

    public String compile(URL input) throws LessException {
        try {
            long time = System.currentTimeMillis();
            this.logger.debug((Object)("Compiling URL: " + input.getProtocol() + ":" + input.getFile()));
            String result = this.call(this.cf, new Object[]{input.getProtocol() + ":" + input.getFile(), this.getClass().getClassLoader()});
            this.logger.debug((Object)("The compilation of '" + input + "' took " + (System.currentTimeMillis() - time) + " ms."));
            return result;
        }
        catch (Exception e) {
            throw this.parseLessException(e);
        }
    }

    public String compile(File input) throws LessException {
        try {
            long time = System.currentTimeMillis();
            this.logger.debug((Object)("Compiling File: file:" + input.getAbsolutePath()));
            String result = this.call(this.cf, new Object[]{"file:" + input.getAbsolutePath(), this.getClass().getClassLoader()});
            this.logger.debug((Object)("The compilation of '" + input + "' took " + (System.currentTimeMillis() - time) + " ms."));
            return result;
        }
        catch (Exception e) {
            throw this.parseLessException(e);
        }
    }

    public void compile(File input, File output) throws LessException, IOException {
        try {
            String content = this.compile(input);
            if (!output.exists()) {
                output.createNewFile();
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(output));
            bw.write(content);
            bw.close();
        }
        catch (Exception e) {
            throw this.parseLessException(e);
        }
    }

    private synchronized String call(Function fn, Object[] args) {
        return (String)Context.call(null, (Callable)fn, (Scriptable)this.scope, (Scriptable)this.scope, (Object[])args);
    }

    private LessException parseLessException(Exception root) throws LessException {
        this.logger.debug((Object)"Parsing LESS Exception", (Throwable)root);
        if (root instanceof JavaScriptException) {
            Scriptable value = (Scriptable)((JavaScriptException)root).getValue();
            boolean hasName = ScriptableObject.hasProperty((Scriptable)value, (String)"name");
            boolean hasType = ScriptableObject.hasProperty((Scriptable)value, (String)"type");
            if (hasName || hasType) {
                Object prop;
                String errorType = "Error";
                if (hasName) {
                    String type = (String)ScriptableObject.getProperty((Scriptable)value, (String)"name");
                    errorType = "ParseError".equals(type) ? "Parse Error" : type + " Error";
                } else if (hasType && (prop = ScriptableObject.getProperty((Scriptable)value, (String)"type")) instanceof String) {
                    errorType = (String)prop + " Error";
                }
                String message = (String)ScriptableObject.getProperty((Scriptable)value, (String)"message");
                String filename = "";
                if (ScriptableObject.hasProperty((Scriptable)value, (String)"filename")) {
                    filename = (String)ScriptableObject.getProperty((Scriptable)value, (String)"filename");
                }
                int line = -1;
                if (ScriptableObject.hasProperty((Scriptable)value, (String)"line")) {
                    line = ((Double)ScriptableObject.getProperty((Scriptable)value, (String)"line")).intValue();
                }
                int column = -1;
                if (ScriptableObject.hasProperty((Scriptable)value, (String)"column")) {
                    column = ((Double)ScriptableObject.getProperty((Scriptable)value, (String)"column")).intValue();
                }
                ArrayList<String> extractList = new ArrayList<String>();
                if (ScriptableObject.hasProperty((Scriptable)value, (String)"extract")) {
                    NativeArray extract = (NativeArray)ScriptableObject.getProperty((Scriptable)value, (String)"extract");
                    int i = 0;
                    while ((long)i < extract.getLength()) {
                        if (extract.get(i, (Scriptable)extract) instanceof String) {
                            extractList.add(((String)extract.get(i, (Scriptable)extract)).replace("\t", " "));
                        }
                        ++i;
                    }
                }
                throw new LessException(message, errorType, filename, line, column, extractList);
            }
        }
        throw new LessException(root);
    }
}

