/*
 * Decompiled with CFR 0.152.
 */
package com.asual.lesscss;

import com.asual.lesscss.LessException;
import com.asual.lesscss.LessOptions;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.shell.Global;

public class LessEngine {
    private final Log logger = LogFactory.getLog(this.getClass());
    private Scriptable scope;
    private ClassLoader classLoader;
    private Function compileString;
    private Function compileFile;

    public LessEngine() {
        this(new LessOptions());
    }

    public LessEngine(LessOptions options) {
        try {
            this.logger.debug((Object)"Initializing LESS Engine.");
            this.classLoader = this.getClass().getClassLoader();
            URL less = options.getLess();
            URL env = this.classLoader.getResource("META-INF/env.js");
            URL engine = this.classLoader.getResource("META-INF/engine.js");
            Context cx = Context.enter();
            this.logger.debug((Object)("Using implementation version: " + cx.getImplementationVersion()));
            cx.setOptimizationLevel(9);
            Global global = new Global();
            global.init(cx);
            this.scope = cx.initStandardObjects((ScriptableObject)global);
            cx.evaluateReader(this.scope, (Reader)new InputStreamReader(env.openConnection().getInputStream()), env.getFile(), 1, null);
            cx.evaluateString(this.scope, "lessenv.charset = '" + options.getCharset() + "';", "charset", 1, null);
            cx.evaluateString(this.scope, "lessenv.css = " + options.isCss() + ";", "css", 1, null);
            cx.evaluateReader(this.scope, (Reader)new InputStreamReader(less.openConnection().getInputStream()), less.getFile(), 1, null);
            cx.evaluateReader(this.scope, (Reader)new InputStreamReader(engine.openConnection().getInputStream()), engine.getFile(), 1, null);
            this.compileString = (Function)this.scope.get("compileString", this.scope);
            this.compileFile = (Function)this.scope.get("compileFile", this.scope);
            Context.exit();
        }
        catch (Exception e) {
            this.logger.error((Object)"LESS Engine intialization failed.", (Throwable)e);
        }
    }

    public String compile(String input) throws LessException {
        try {
            long time = System.currentTimeMillis();
            String result = this.call(this.compileString, new Object[]{input});
            this.logger.debug((Object)("The compilation of '" + input + "' took " + (System.currentTimeMillis() - time) + " ms."));
            return result;
        }
        catch (Exception e) {
            throw this.parseLessException(e);
        }
    }

    public String compile(URL input) throws LessException {
        try {
            long time = System.currentTimeMillis();
            this.logger.debug((Object)("Compiling URL: " + input.getProtocol() + ":" + input.getFile()));
            String result = this.call(this.compileFile, new Object[]{input.getProtocol() + ":" + input.getFile(), this.classLoader});
            this.logger.debug((Object)("The compilation of '" + input + "' took " + (System.currentTimeMillis() - time) + " ms."));
            return result;
        }
        catch (Exception e) {
            throw this.parseLessException(e);
        }
    }

    public String compile(File input) throws LessException {
        try {
            long time = System.currentTimeMillis();
            this.logger.debug((Object)("Compiling File: file:" + input.getAbsolutePath()));
            String result = this.call(this.compileFile, new Object[]{"file:" + input.getAbsolutePath(), this.classLoader});
            this.logger.debug((Object)("The compilation of '" + input + "' took " + (System.currentTimeMillis() - time) + " ms."));
            return result;
        }
        catch (Exception e) {
            throw this.parseLessException(e);
        }
    }

    public void compile(File input, File output) throws LessException, IOException {
        try {
            String content = this.compile(input);
            if (!output.exists()) {
                output.createNewFile();
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(output));
            bw.write(content);
            bw.close();
        }
        catch (Exception e) {
            throw this.parseLessException(e);
        }
    }

    private synchronized String call(Function fn, Object[] args) {
        return (String)Context.call(null, (Callable)fn, (Scriptable)this.scope, (Scriptable)this.scope, (Object[])args);
    }

    private LessException parseLessException(Exception root) throws LessException {
        this.logger.debug((Object)"Parsing LESS Exception", (Throwable)root);
        if (root instanceof JavaScriptException) {
            Scriptable value = (Scriptable)((JavaScriptException)root).getValue();
            boolean hasName = ScriptableObject.hasProperty((Scriptable)value, (String)"name");
            boolean hasType = ScriptableObject.hasProperty((Scriptable)value, (String)"type");
            if (hasName || hasType) {
                Object prop;
                String errorType = "Error";
                if (hasName) {
                    String type = (String)ScriptableObject.getProperty((Scriptable)value, (String)"name");
                    errorType = "ParseError".equals(type) ? "Parse Error" : type + " Error";
                } else if (hasType && (prop = ScriptableObject.getProperty((Scriptable)value, (String)"type")) instanceof String) {
                    errorType = (String)prop + " Error";
                }
                String message = (String)ScriptableObject.getProperty((Scriptable)value, (String)"message");
                String filename = "";
                if (ScriptableObject.hasProperty((Scriptable)value, (String)"filename")) {
                    filename = (String)ScriptableObject.getProperty((Scriptable)value, (String)"filename");
                }
                int line = -1;
                if (ScriptableObject.hasProperty((Scriptable)value, (String)"line")) {
                    line = ((Double)ScriptableObject.getProperty((Scriptable)value, (String)"line")).intValue();
                }
                int column = -1;
                if (ScriptableObject.hasProperty((Scriptable)value, (String)"column")) {
                    column = ((Double)ScriptableObject.getProperty((Scriptable)value, (String)"column")).intValue();
                }
                ArrayList<String> extractList = new ArrayList<String>();
                if (ScriptableObject.hasProperty((Scriptable)value, (String)"extract")) {
                    NativeArray extract = (NativeArray)ScriptableObject.getProperty((Scriptable)value, (String)"extract");
                    int i = 0;
                    while ((long)i < extract.getLength()) {
                        if (extract.get(i, (Scriptable)extract) instanceof String) {
                            extractList.add(((String)extract.get(i, (Scriptable)extract)).replace("\t", " "));
                        }
                        ++i;
                    }
                }
                throw new LessException(message, errorType, filename, line, column, extractList);
            }
        }
        throw new LessException(root);
    }

    public static void main(String[] args) throws LessException, URISyntaxException {
        Options cmdOptions = new Options();
        cmdOptions.addOption("charset", true, "Input file charset encoding. Defaults to UTF-8.");
        cmdOptions.addOption("css", false, "Flag that enables compilation of .css files.");
        cmdOptions.addOption("less", true, "Path to a custom less.js for Rhino version.");
        try {
            GnuParser cmdParser = new GnuParser();
            CommandLine cmdLine = cmdParser.parse(cmdOptions, args);
            LessOptions options = new LessOptions();
            if (cmdLine.hasOption("charset")) {
                options.setCharset(cmdLine.getOptionValue("charset"));
            }
            if (cmdLine.hasOption("css")) {
                options.setCss(true);
            }
            if (cmdLine.hasOption("less")) {
                options.setLess(new File(cmdLine.getOptionValue("less")).toURI().toURL());
            }
            LessEngine engine = new LessEngine(options);
            String[] files = cmdLine.getArgs();
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            StringWriter sw = new StringWriter();
            char[] buffer = new char[1024];
            int n = 0;
            while (-1 != (n = in.read(buffer))) {
                sw.write(buffer, 0, n);
            }
            String src = sw.toString();
            if (!src.isEmpty()) {
                System.out.println(engine.compile(src));
                System.exit(0);
            }
            if (files.length == 1) {
                System.out.println(engine.compile(new File(files[0])));
                System.exit(0);
            }
            if (files.length == 2) {
                engine.compile(new File(files[0]), new File(files[1]));
                System.exit(0);
            }
        }
        catch (IOException ioe) {
            System.err.println("Error opening input file.");
        }
        catch (ParseException pe) {
            System.err.println("Error parsing arguments.");
        }
        String[] paths = LessEngine.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath().split(File.separator);
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java -jar " + paths[paths.length - 1] + " input [output] [options]", cmdOptions);
        System.exit(1);
    }
}

