/*
 * Decompiled with CFR 0.152.
 */
package org.jcoffeescript;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import org.jcoffeescript.JCoffeeScriptCompileException;
import org.jcoffeescript.Option;
import org.jcoffeescript.Options;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCoffeeScriptCompiler {
    private final Scriptable globalScope;
    private final Options options;

    public JCoffeeScriptCompiler() {
        this(Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCoffeeScriptCompiler(Collection<Option> options) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("org/jcoffeescript/coffee-script.js");
        try {
            try {
                InputStreamReader reader = new InputStreamReader(inputStream, "UTF-8");
                try {
                    Context context = Context.enter();
                    context.setOptimizationLevel(-1);
                    try {
                        this.globalScope = context.initStandardObjects();
                        context.evaluateReader(this.globalScope, (Reader)reader, "coffee-script.js", 0, null);
                    }
                    finally {
                        Context.exit();
                    }
                }
                finally {
                    ((Reader)reader).close();
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new Error(e);
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
        this.options = new Options(options);
    }

    public String compile(String coffeeScriptSource) throws JCoffeeScriptCompileException {
        Context context = Context.enter();
        try {
            Scriptable compileScope = context.newObject(this.globalScope);
            compileScope.setParentScope(this.globalScope);
            compileScope.put("coffeeScriptSource", compileScope, (Object)coffeeScriptSource);
            try {
                String string = (String)context.evaluateString(compileScope, String.format("CoffeeScript.compile(coffeeScriptSource, %s);", this.options.toJavaScript()), "JCoffeeScriptCompiler", 0, null);
                return string;
            }
            catch (JavaScriptException e) {
                throw new JCoffeeScriptCompileException(e);
            }
        }
        finally {
            Context.exit();
        }
    }
}

