/*
 * Decompiled with CFR 0.152.
 */
package org.jcoffeescript;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Collection;
import java.util.LinkedList;
import org.jcoffeescript.JCoffeeScriptCompileException;
import org.jcoffeescript.JCoffeeScriptCompiler;
import org.jcoffeescript.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    private static final int BUFFER_SIZE = 262144;
    private static final int BUFFER_OFFSET = 0;

    public static void main(String[] args) {
        new Main().execute(args, System.out, System.in);
    }

    public void execute(String[] args, PrintStream out, InputStream in) {
        Collection<Option> options = this.readOptionsFrom(args);
        try {
            out.print(new JCoffeeScriptCompiler(options).compile(this.readSourceFrom(in)));
        }
        catch (JCoffeeScriptCompileException e) {
            System.err.println(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readSourceFrom(InputStream inputStream) {
        String string;
        InputStreamReader streamReader = new InputStreamReader(inputStream);
        try {
            StringBuilder builder = new StringBuilder(262144);
            char[] buffer = new char[262144];
            int numCharsRead = streamReader.read(buffer, 0, 262144);
            while (numCharsRead >= 0) {
                builder.append(buffer, 0, numCharsRead);
                numCharsRead = streamReader.read(buffer, 0, 262144);
            }
            string = builder.toString();
        }
        catch (Throwable throwable) {
            try {
                streamReader.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        streamReader.close();
        return string;
    }

    private Collection<Option> readOptionsFrom(String[] args) {
        LinkedList<Option> options = new LinkedList<Option>();
        if (args.length == 1 && args[0].equals("--bare")) {
            options.add(Option.BARE);
        }
        return options;
    }
}

