/*
 * Decompiled with CFR 0.152.
 */
package com.greenscriptool;

import com.greenscriptool.CircularDependenceException;
import com.greenscriptool.IDependenceManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependenceManager
implements IDependenceManager {
    private Map<String, Node> dependencies_;
    private Set<String> inlineDepDeclarations = new HashSet<String>();

    public String debugString() {
        StringBuilder sb = new StringBuilder();
        sb.append("===============================================================").append("\n DependencyManager debug information ");
        for (Node n : this.dependencies_.values()) {
            sb.append(String.format("\n\n node info: %1$s\n", n.name_)).append(n.debugString());
        }
        return sb.toString();
    }

    public DependenceManager(Properties dependencies) {
        this.dependencies_ = new HashMap<String, Node>();
        for (String s : dependencies.stringPropertyNames()) {
            String v = dependencies.getProperty(s, "");
            if (null != v && !v.trim().equals("")) {
                this.processInlineDependency(v);
                List<String> l = Arrays.asList(v.replaceAll("\\s+", "").split("[ ,;<>]"));
                this.createNode_(s, l);
                continue;
            }
            this.processInlineDependency(s);
        }
        for (Node n : this.dependencies_.values()) {
            n.rectify();
        }
    }

    @Override
    public List<String> comprehend(Collection<String> resourceNames) {
        return this.comprehend(resourceNames, false);
    }

    @Override
    public List<String> comprehend(Collection<String> resourceNames, boolean withDefault) {
        Node def;
        if (resourceNames.isEmpty() && !withDefault) {
            return Collections.emptyList();
        }
        ArrayList<String> retList = new ArrayList<String>();
        HashMap<String, Node> nodes = new HashMap<String, Node>();
        ArrayList<String> undefs = new ArrayList<String>();
        for (String name : resourceNames) {
            if (null == name || "".equals(name = name.trim())) continue;
            Node n = this.dependencies_.get(name);
            if (n != null) {
                nodes.put(name, n);
                continue;
            }
            if (undefs.contains(name)) continue;
            undefs.add(name);
        }
        TreeSet<Node> defs = new TreeSet<Node>();
        if ((withDefault || nodes.containsKey("default")) && null != (def = this.dependencies_.get("default"))) {
            nodes.remove("default");
            defs.addAll(def.allDependOns());
            for (Node n : defs) {
                retList.add(n.name_);
            }
        }
        TreeSet<Node> all = new TreeSet<Node>();
        for (Node n : nodes.values()) {
            all.addAll(n.allDependOns());
        }
        all.removeAll(defs);
        for (Node n : all) {
            retList.add(n.name_);
        }
        retList.addAll(undefs);
        return retList;
    }

    @Override
    public List<String> comprehend(String resourceNames) {
        return this.comprehend(resourceNames, false);
    }

    @Override
    public List<String> comprehend(String resourceNames, boolean withDefault) {
        if (null == resourceNames) {
            return this.comprehend(new ArrayList<String>(), withDefault);
        }
        this.processInlineDependency(resourceNames);
        List<String> l = Arrays.asList(resourceNames.split("[ ,;<>]"));
        return this.comprehend(l, withDefault);
    }

    @Override
    public List<String> comprehend() {
        return this.comprehend("default", false);
    }

    @Override
    public final void addDependency(String dependent, Collection<String> dependsOn) {
        this.createNode_(dependent, dependsOn);
        for (Node n : this.dependencies_.values()) {
            n.rectify();
        }
    }

    @Override
    public void processInlineDependency(String dependency) {
        if (this.inlineDepDeclarations.contains(dependency)) {
            return;
        }
        this.inlineDepDeclarations.add(dependency);
        dependency = " " + dependency;
        Pattern p = Pattern.compile("(?=[\\s,;]+|(?<![\\w\\/\\-\\.:])([\\w\\/\\-\\.:]+\\s*[<>]\\s*[\\w\\/\\-\\.:]+))");
        Matcher m = p.matcher(dependency);
        boolean found = false;
        while (m.find()) {
            String g = m.group(1);
            if (null == g) continue;
            found = true;
            String[] relation = g.split("[<>]");
            String a = relation[0].trim();
            String b = relation[1].trim();
            if (g.indexOf(60) > -1) {
                this.createNode_(a, Arrays.asList(b));
                continue;
            }
            this.createNode_(b, Arrays.asList(a));
        }
        if (found) {
            for (Node n : this.dependencies_.values()) {
                n.rectify();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        String s = "http://ahost.com/something.js > http://zbc-1.com.au/some/path/to/x19-v1.0.js < y < z < a > b > c > d";
        String regex = "(?=[\\s,;]+|(?<![\\w\\/\\-\\.:])([\\w\\/\\-\\.:]+\\s*[<>]\\s*[\\w\\/\\-\\.:]+))";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(s);
        while (m.find()) {
            String d = m.group(1);
            if (d == null) continue;
            System.out.println(d);
        }
    }

    private Node createNode_(String dependent, Collection<String> dependsOn) {
        Node n = this.dependencies_.get(dependent);
        if (null == n) {
            n = new Node(dependent);
            this.dependencies_.put(dependent, n);
        }
        List<String> e = Collections.emptyList();
        for (String s : dependsOn) {
            Node n0 = this.createNode_(s, e);
            n.addDependOn(n0);
        }
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node
    implements Comparable<Node> {
        private final String name_;
        private final Map<String, Node> dependOns_;
        private long weight_ = 1L;
        private static final int STEP_ = 10;
        private boolean dirty_ = true;

        private Node(String name) {
            this.name_ = name;
            this.dependOns_ = new HashMap<String, Node>();
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            if (!(that instanceof Node)) {
                return false;
            }
            return this.name_.equals(((Node)that).name_);
        }

        public int hashCode() {
            return this.name_.hashCode();
        }

        public String toString() {
            return this.name_;
        }

        public String debugString() {
            String openTag = String.format("<node name='%1$s' weight='%2$s'>", this.name_, this.weight_);
            String closeTag = "\n</node>";
            StringBuilder sb = new StringBuilder();
            sb.append(openTag);
            for (Node n : this.dependOns_.values()) {
                sb.append("\n\t").append(n.debugString());
            }
            sb.append(closeTag);
            return sb.toString();
        }

        @Override
        public int compareTo(Node o) {
            if (null == o) {
                return -1;
            }
            if (this.equals(o)) {
                return 0;
            }
            if (this.weight_ == o.weight_) {
                return o.name_.compareTo(this.name_);
            }
            long l = o.weight_ - this.weight_;
            return l > 0L ? 1 : (l < 0L ? -1 : 0);
        }

        void addDependOn(Node dependOn) {
            if (dependOn.dependOn_(this)) {
                throw new CircularDependenceException(this.name_, dependOn.name_);
            }
            this.dependOns_.put(dependOn.name_, dependOn);
            this.dirty_ = true;
        }

        Set<Node> allDependOns() {
            HashSet<Node> all = new HashSet<Node>();
            if (this.dirty_) {
                if (!this.dependOns_.isEmpty()) {
                    for (Node n0 : this.dependOns_.values()) {
                        all.addAll(n0.allDependOns());
                        all.add(n0);
                    }
                }
            } else {
                all.addAll(this.dependOns_.values());
            }
            all.add(this);
            return all;
        }

        void rectify() {
            this.flatten_();
            this.updateDependOnWeights_();
            this.dirty_ = false;
        }

        private void flatten_() {
            for (Node n0 : this.dependOns_.values()) {
                n0.flatten_();
            }
            for (Node n0 : new HashSet<Node>(this.dependOns_.values())) {
                this.dependOns_.putAll(n0.dependOns_);
            }
        }

        void updateDependOnWeights_() {
            this.incWeightOn_(null);
        }

        private void incWeightOn_(Node node) {
            if (null != node && this.weight_ <= node.weight_) {
                this.weight_ = node.weight_ + 10L;
            }
            for (Node dependOn : this.dependOns_.values()) {
                dependOn.incWeightOn_(this);
            }
        }

        private boolean dependOn_(Node node) {
            if (this.dependOns_.containsKey(node.name_)) {
                return true;
            }
            if (this.dirty_) {
                for (Node n0 : this.dependOns_.values()) {
                    if (!n0.dependOn_(node)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

