/*
 * Decompiled with CFR 0.152.
 */
package com.greenscriptool.utils;

import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSSourceFile;
import com.google.javascript.jscomp.Result;
import com.greenscriptool.ResourceType;
import com.greenscriptool.utils.ICompressor;
import com.greenscriptool.utils.ReaderInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClosureCompressor
implements ICompressor {
    private static Log logger_ = LogFactory.getLog(ICompressor.class);
    CompilerOptions options = new CompilerOptions();
    private ResourceType type_;
    private List<JSSourceFile> externalJavascriptFiles = new ArrayList<JSSourceFile>();

    public ClosureCompressor(ResourceType type) {
        if (ResourceType.JS != type) {
            throw new IllegalArgumentException("ClosureCompressor does not support CSS compression");
        }
        this.type_ = type;
        Compiler.setLoggingLevel((Level)Level.FINE);
        CompilationLevel.SIMPLE_OPTIMIZATIONS.setOptionsForCompilationLevel(this.options);
    }

    public void compress(Reader r, Writer w) throws Exception {
        Compiler compiler = new Compiler();
        JSSourceFile file = JSSourceFile.fromInputStream((String)"greenscript.js", (InputStream)new ReaderInputStream(r));
        ArrayList<JSSourceFile> files = new ArrayList<JSSourceFile>();
        files.add(file);
        Result result = compiler.compile(this.externalJavascriptFiles, files, this.options);
        if (!result.success) {
            throw new Exception("error compile javascript");
        }
        w.write(compiler.toSource());
    }
}

