/*
 * Decompiled with CFR 0.152.
 */
package com.greenscriptool.utils;

import com.greenscriptool.ResourceType;
import com.greenscriptool.utils.ICompressor;
import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class YUICompressor
implements ICompressor {
    private static Log logger_ = LogFactory.getLog(ICompressor.class);
    private ResourceType type_;
    private static ErrorReporter er_ = new ErrorReporter(){

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0) {
                logger_.warn((Object)("[MINIMIZOR.WARNING] " + message));
            } else {
                logger_.warn((Object)String.format("[MINIMIZOR.WARNING] %1$s: %2$s: %3$s", line, lineOffset, message));
            }
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0) {
                logger_.error((Object)("[MINIMIZOR.ERROR] " + message));
            } else {
                logger_.error((Object)String.format("[MINIMIZOR.ERROR] %1$s: %2$s: %3$s", line, lineOffset, message));
            }
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            this.error(message, sourceName, line, lineSource, lineOffset);
            return new EvaluatorException(message);
        }
    };

    public YUICompressor(ResourceType type) {
        this.type_ = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void compress(Reader r, Writer w) throws Exception {
        try {
            switch (this.type_) {
                case CSS: {
                    new CssCompressor(r).compress(w, -1);
                    return;
                }
                case JS: {
                    new JavaScriptCompressor(r, er_).compress(w, -1, true, false, false, false);
                    return;
                }
                default: {
                    throw new RuntimeException("Resource type not recognized: " + this.type_.name());
                }
            }
        }
        finally {
            if (null != r) {
                try {
                    r.close();
                }
                catch (IOException e) {
                    logger_.warn((Object)"error closing file: ", (Throwable)e);
                }
            }
        }
    }
}

