/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.CodeGenerator;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.TernaryValue;
import java.util.regex.Pattern;

class PeepholeSubstituteAlternateSyntax
extends AbstractPeepholeOptimization {
    private static final int AND_PRECEDENCE = NodeUtil.precedence(101);
    private static final int OR_PRECEDENCE = NodeUtil.precedence(100);
    private static final int NOT_PRECEDENCE = NodeUtil.precedence(26);
    private final boolean late;
    private final int STRING_SPLIT_OVERHEAD = ".split('.')".length();
    static final DiagnosticType INVALID_REGULAR_EXPRESSION_FLAGS = DiagnosticType.error("JSC_INVALID_REGULAR_EXPRESSION_FLAGS", "Invalid flags to RegExp constructor: {0}");
    static final Predicate<Node> DONT_TRAVERSE_FUNCTIONS_PREDICATE = new Predicate<Node>(){

        public boolean apply(Node input) {
            return !input.isFunction();
        }
    };
    private static final ImmutableSet<String> STANDARD_OBJECT_CONSTRUCTORS = ImmutableSet.of((Object)"Object", (Object)"Array", (Object)"RegExp", (Object)"Error");
    private static final Pattern REGEXP_FLAGS_RE = Pattern.compile("^[gmi]*$");

    PeepholeSubstituteAlternateSyntax(boolean late) {
        this.late = late;
    }

    @Override
    public Node optimizeSubtree(Node node) {
        switch (node.getType()) {
            case 4: {
                Node result = this.tryRemoveRedundantExit(node);
                if (result != node) {
                    return result;
                }
                result = this.tryReplaceExitWithBreak(node);
                if (result != node) {
                    return result;
                }
                return this.tryReduceReturn(node);
            }
            case 49: {
                Node result = this.tryRemoveRedundantExit(node);
                if (result != node) {
                    return result;
                }
                return this.tryReplaceExitWithBreak(node);
            }
            case 26: {
                this.tryMinimizeCondition(node.getFirstChild());
                return this.tryMinimizeNot(node);
            }
            case 108: {
                this.tryMinimizeCondition(node.getFirstChild());
                return this.tryMinimizeIf(node);
            }
            case 130: {
                this.tryMinimizeCondition(node.getFirstChild());
                return node;
            }
            case 98: {
                this.tryMinimizeCondition(node.getFirstChild());
                return node;
            }
            case 113: 
            case 114: {
                this.tryMinimizeCondition(NodeUtil.getConditionExpression(node));
                return node;
            }
            case 115: {
                if (!NodeUtil.isForIn(node)) {
                    this.tryJoinForCondition(node);
                    this.tryMinimizeCondition(NodeUtil.getConditionExpression(node));
                }
                return node;
            }
            case 43: 
            case 44: {
                return this.reduceTrueFalse(node);
            }
            case 30: {
                node = this.tryFoldStandardConstructors(node);
                if (!node.isCall()) {
                    return node;
                }
            }
            case 37: {
                Node result = this.tryFoldLiteralConstructor(node);
                if (result == node && (result = this.tryFoldSimpleFunctionCall(node)) == node) {
                    result = this.tryFoldImmediateCallToBoundFunction(node);
                }
                return result;
            }
            case 85: {
                return this.trySplitComma(node);
            }
            case 38: {
                return this.tryReplaceUndefined(node);
            }
            case 125: {
                return this.tryReplaceIf(node);
            }
            case 63: {
                return this.tryMinimizeArrayLiteral(node);
            }
        }
        return node;
    }

    private void tryJoinForCondition(Node n) {
        Node maybeBreak;
        if (!this.late) {
            return;
        }
        Node block = n.getLastChild();
        Node maybeIf = block.getFirstChild();
        if (maybeIf != null && maybeIf.isIf() && (maybeBreak = maybeIf.getChildAtIndex(1).getFirstChild()) != null && maybeBreak.isBreak() && !maybeBreak.hasChildren()) {
            if (maybeIf.getChildCount() == 3) {
                block.replaceChild(maybeIf, maybeIf.getLastChild().detachFromParent());
            } else {
                block.removeFirstChild();
            }
            Node ifCondition = maybeIf.removeFirstChild();
            Node fixedIfCondition = IR.not(ifCondition).srcref(ifCondition);
            Node forCondition = NodeUtil.getConditionExpression(n);
            if (forCondition.isEmpty()) {
                n.replaceChild(forCondition, fixedIfCondition);
            } else {
                Node replacement = new Node(101);
                n.replaceChild(forCondition, replacement);
                replacement.addChildToBack(forCondition);
                replacement.addChildToBack(fixedIfCondition);
            }
            this.reportCodeChange();
        }
    }

    private Node tryFoldSimpleFunctionCall(Node n) {
        Node value;
        Preconditions.checkState((boolean)n.isCall());
        Node callTarget = n.getFirstChild();
        if (callTarget != null && callTarget.isName() && callTarget.getString().equals("String") && (value = callTarget.getNext()) != null) {
            Node addition = IR.add(IR.string("").srcref(callTarget), value.detachFromParent());
            n.getParent().replaceChild(n, addition);
            this.reportCodeChange();
            return addition;
        }
        return n;
    }

    private Node tryFoldImmediateCallToBoundFunction(Node n) {
        Preconditions.checkState((boolean)n.isCall());
        Node callTarget = n.getFirstChild();
        CodingConvention.Bind bind = this.getCodingConvention().describeFunctionBind(callTarget);
        if (bind != null) {
            bind.target.detachFromParent();
            n.replaceChild(callTarget, bind.target);
            callTarget = bind.target;
            this.addParameterAfter(bind.parameters, callTarget);
            if (bind.thisValue != null && !NodeUtil.isUndefined(bind.thisValue)) {
                Node newCallTarget = IR.getprop(callTarget.cloneTree(), IR.string("call").srcref(callTarget));
                n.replaceChild(callTarget, newCallTarget);
                n.addChildAfter(bind.thisValue.cloneTree(), newCallTarget);
                n.putBooleanProp(50, false);
            } else {
                n.putBooleanProp(50, true);
            }
            this.reportCodeChange();
        }
        return n;
    }

    private void addParameterAfter(Node parameterList, Node after) {
        if (parameterList != null) {
            this.addParameterAfter(parameterList.getNext(), after);
            after.getParent().addChildAfter(parameterList.cloneTree(), after);
        }
    }

    private Node trySplitComma(Node n) {
        if (!this.late) {
            return n;
        }
        Node parent = n.getParent();
        Node left = n.getFirstChild();
        Node right = n.getLastChild();
        if (parent.isExprResult() && !parent.getParent().isLabel()) {
            n.detachChildren();
            parent.replaceChild(n, left);
            Node newStatement = IR.exprResult(right);
            newStatement.copyInformationFrom(n);
            parent.getParent().addChildAfter(newStatement, parent);
            this.reportCodeChange();
            return left;
        }
        return n;
    }

    private Node tryReplaceIf(Node n) {
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            if (!child.isIf()) continue;
            Node cond = child.getFirstChild();
            Node thenBranch = cond.getNext();
            Node elseBranch = thenBranch.getNext();
            Node nextNode = child.getNext();
            if (nextNode != null && elseBranch == null && this.isReturnBlock(thenBranch) && nextNode.isIf()) {
                Node newCond;
                Node nextCond = nextNode.getFirstChild();
                Node nextThen = nextCond.getNext();
                Node nextElse = nextThen.getNext();
                if (thenBranch.isEquivalentToTyped(nextThen)) {
                    child.detachFromParent();
                    child.detachChildren();
                    newCond = new Node(100, cond);
                    nextNode.replaceChild(nextCond, newCond);
                    newCond.addChildToBack(nextCond);
                    this.reportCodeChange();
                    continue;
                }
                if (nextElse == null || !thenBranch.isEquivalentToTyped(nextElse)) continue;
                child.detachFromParent();
                child.detachChildren();
                newCond = new Node(101, IR.not(cond).srcref(cond));
                nextNode.replaceChild(nextCond, newCond);
                newCond.addChildToBack(nextCond);
                this.reportCodeChange();
                continue;
            }
            if (nextNode != null && elseBranch == null && this.isReturnBlock(thenBranch) && this.isReturnExpression(nextNode)) {
                Node thenExpr = null;
                if (this.isReturnExpressBlock(thenBranch)) {
                    thenExpr = this.getBlockReturnExpression(thenBranch);
                    thenExpr.detachFromParent();
                } else {
                    thenExpr = NodeUtil.newUndefinedNode(child);
                }
                Node elseExpr = nextNode.getFirstChild();
                cond.detachFromParent();
                elseExpr.detachFromParent();
                Node returnNode = IR.returnNode(IR.hook(cond, thenExpr, elseExpr).srcref(child));
                n.replaceChild(child, returnNode);
                n.removeChild(nextNode);
                this.reportCodeChange();
                continue;
            }
            if (elseBranch == null || !this.statementMustExitParent(thenBranch)) continue;
            child.removeChild(elseBranch);
            n.addChildAfter(elseBranch, child);
            this.reportCodeChange();
        }
        return n;
    }

    private boolean statementMustExitParent(Node n) {
        switch (n.getType()) {
            case 4: 
            case 49: {
                return true;
            }
            case 125: {
                if (n.hasChildren()) {
                    Node child = n.getLastChild();
                    return this.statementMustExitParent(child);
                }
                return false;
            }
        }
        return false;
    }

    private Node tryReplaceUndefined(Node n) {
        if (this.isASTNormalized() && NodeUtil.isUndefined(n) && !NodeUtil.isLValue(n)) {
            Node replacement = NodeUtil.newUndefinedNode(n);
            n.getParent().replaceChild(n, replacement);
            this.reportCodeChange();
            return replacement;
        }
        return n;
    }

    private Node tryReduceReturn(Node n) {
        Node result = n.getFirstChild();
        if (result != null) {
            switch (result.getType()) {
                case 122: {
                    Node operand = result.getFirstChild();
                    if (this.mayHaveSideEffects(operand)) break;
                    n.removeFirstChild();
                    this.reportCodeChange();
                    break;
                }
                case 38: {
                    String name = result.getString();
                    if (!name.equals("undefined")) break;
                    n.removeFirstChild();
                    this.reportCodeChange();
                }
            }
        }
        return n;
    }

    private Node tryReplaceExitWithBreak(Node n) {
        Node result = n.getFirstChild();
        Node breakTarget = n;
        while (!ControlFlowAnalysis.isBreakTarget(breakTarget, null)) {
            if (breakTarget.isFunction() || breakTarget.isScript()) {
                return n;
            }
            breakTarget = breakTarget.getParent();
        }
        Node follow = ControlFlowAnalysis.computeFollowNode(breakTarget);
        Node prefinallyFollows = follow;
        if (prefinallyFollows != (follow = this.skipFinallyNodes(follow)) && !this.isPure(result)) {
            return n;
        }
        if (follow == null && (n.isThrow() || result != null)) {
            return n;
        }
        if (follow == null || this.areMatchingExits(n, follow)) {
            Node replacement = IR.breakNode();
            n.getParent().replaceChild(n, replacement);
            this.reportCodeChange();
            return replacement;
        }
        return n;
    }

    private Node tryRemoveRedundantExit(Node n) {
        Node exitExpr = n.getFirstChild();
        Node follow = ControlFlowAnalysis.computeFollowNode(n);
        Node prefinallyFollows = follow;
        if (prefinallyFollows != (follow = this.skipFinallyNodes(follow)) && !this.isPure(exitExpr)) {
            return n;
        }
        if (follow == null && (n.isThrow() || exitExpr != null)) {
            return n;
        }
        if (follow == null || this.areMatchingExits(n, follow)) {
            n.detachFromParent();
            this.reportCodeChange();
            return null;
        }
        return n;
    }

    boolean isPure(Node n) {
        return n == null || !NodeUtil.canBeSideEffected(n) && !NodeUtil.mayHaveSideEffects(n);
    }

    Node skipFinallyNodes(Node n) {
        while (n != null && NodeUtil.isTryFinallyNode(n.getParent(), n)) {
            n = ControlFlowAnalysis.computeFollowNode(n);
        }
        return n;
    }

    boolean areMatchingExits(Node nodeThis, Node nodeThat) {
        return nodeThis.isEquivalentTo(nodeThat) && (!this.isExceptionPossible(nodeThis) || this.getExceptionHandler(nodeThis) == this.getExceptionHandler(nodeThat));
    }

    boolean isExceptionPossible(Node n) {
        Preconditions.checkState((n.isReturn() || n.isThrow() ? 1 : 0) != 0);
        return n.isThrow() || n.hasChildren() && !NodeUtil.isLiteralValue(n.getLastChild(), true);
    }

    Node getExceptionHandler(Node n) {
        return ControlFlowAnalysis.getExceptionHandler(n);
    }

    private Node tryMinimizeNot(Node n) {
        int complementOperator;
        Node parent = n.getParent();
        Node notChild = n.getFirstChild();
        switch (notChild.getType()) {
            case 12: {
                complementOperator = 13;
                break;
            }
            case 13: {
                complementOperator = 12;
                break;
            }
            case 45: {
                complementOperator = 46;
                break;
            }
            case 46: {
                complementOperator = 45;
                break;
            }
            default: {
                return n;
            }
        }
        Node newOperator = n.removeFirstChild();
        newOperator.setType(complementOperator);
        parent.replaceChild(n, newOperator);
        this.reportCodeChange();
        return newOperator;
    }

    private Node tryMinimizeIf(Node n) {
        Node parent = n.getParent();
        Node cond = n.getFirstChild();
        if (NodeUtil.isLiteralValue(cond, true)) {
            return n;
        }
        Node thenBranch = cond.getNext();
        Node elseBranch = thenBranch.getNext();
        if (elseBranch == null) {
            Node innerCond;
            Node innerThenBranch;
            Node innerElseBranch;
            Node innerIf;
            if (this.isFoldableExpressBlock(thenBranch)) {
                Node expr = this.getBlockExpression(thenBranch);
                if (!this.late && this.isPropertyAssignmentInExpression(expr)) {
                    return n;
                }
                if (cond.isNot()) {
                    if (this.isLowerPrecedenceInExpression(cond, OR_PRECEDENCE) && this.isLowerPrecedenceInExpression(expr.getFirstChild(), OR_PRECEDENCE)) {
                        return n;
                    }
                    Node or = IR.or(cond.removeFirstChild(), expr.removeFirstChild()).srcref(n);
                    Node newExpr = NodeUtil.newExpr(or);
                    parent.replaceChild(n, newExpr);
                    this.reportCodeChange();
                    return newExpr;
                }
                if (this.isLowerPrecedenceInExpression(cond, AND_PRECEDENCE) && this.isLowerPrecedenceInExpression(expr.getFirstChild(), AND_PRECEDENCE)) {
                    return n;
                }
                n.removeChild(cond);
                Node and = IR.and(cond, expr.removeFirstChild()).srcref(n);
                Node newExpr = NodeUtil.newExpr(and);
                parent.replaceChild(n, newExpr);
                this.reportCodeChange();
                return newExpr;
            }
            if (NodeUtil.isStatementBlock(thenBranch) && thenBranch.hasOneChild() && (innerIf = thenBranch.getFirstChild()).isIf() && (innerElseBranch = (innerThenBranch = (innerCond = innerIf.getFirstChild()).getNext()).getNext()) == null && (!this.isLowerPrecedenceInExpression(cond, AND_PRECEDENCE) || !this.isLowerPrecedenceInExpression(innerCond, AND_PRECEDENCE))) {
                n.detachChildren();
                n.addChildToBack(IR.and(cond, innerCond.detachFromParent()).srcref(cond));
                n.addChildrenToBack(innerThenBranch.detachFromParent());
                this.reportCodeChange();
                return n;
            }
            return n;
        }
        this.tryRemoveRepeatedStatements(n);
        if (cond.isNot() && !this.consumesDanglingElse(elseBranch)) {
            n.replaceChild(cond, cond.removeFirstChild());
            n.removeChild(thenBranch);
            n.addChildToBack(thenBranch);
            this.reportCodeChange();
            return n;
        }
        if (this.isReturnExpressBlock(thenBranch) && this.isReturnExpressBlock(elseBranch)) {
            Node thenExpr = this.getBlockReturnExpression(thenBranch);
            Node elseExpr = this.getBlockReturnExpression(elseBranch);
            n.removeChild(cond);
            thenExpr.detachFromParent();
            elseExpr.detachFromParent();
            Node returnNode = IR.returnNode(IR.hook(cond, thenExpr, elseExpr).srcref(n));
            parent.replaceChild(n, returnNode);
            this.reportCodeChange();
            return returnNode;
        }
        boolean thenBranchIsExpressionBlock = this.isFoldableExpressBlock(thenBranch);
        boolean elseBranchIsExpressionBlock = this.isFoldableExpressBlock(elseBranch);
        if (thenBranchIsExpressionBlock && elseBranchIsExpressionBlock) {
            Node lhs;
            Node thenOp = this.getBlockExpression(thenBranch).getFirstChild();
            Node elseOp = this.getBlockExpression(elseBranch).getFirstChild();
            if (thenOp.getType() == elseOp.getType() && NodeUtil.isAssignmentOp(thenOp) && this.areNodesEqualForInlining(lhs = thenOp.getFirstChild(), elseOp.getFirstChild()) && !this.mayEffectMutableState(lhs)) {
                n.removeChild(cond);
                Node assignName = thenOp.removeFirstChild();
                Node thenExpr = thenOp.removeFirstChild();
                Node elseExpr = elseOp.getLastChild();
                elseOp.removeChild(elseExpr);
                Node hookNode = IR.hook(cond, thenExpr, elseExpr).srcref(n);
                Node assign = new Node(thenOp.getType(), assignName, hookNode).srcref(thenOp);
                Node expr = NodeUtil.newExpr(assign);
                parent.replaceChild(n, expr);
                this.reportCodeChange();
                return expr;
            }
            n.removeChild(cond);
            thenOp.detachFromParent();
            elseOp.detachFromParent();
            Node expr = IR.exprResult(IR.hook(cond, thenOp, elseOp).srcref(n));
            parent.replaceChild(n, expr);
            this.reportCodeChange();
            return expr;
        }
        boolean thenBranchIsVar = this.isVarBlock(thenBranch);
        boolean elseBranchIsVar = this.isVarBlock(elseBranch);
        if (thenBranchIsVar && elseBranchIsExpressionBlock && this.getBlockExpression(elseBranch).getFirstChild().isAssign()) {
            Node var = this.getBlockVar(thenBranch);
            Node elseAssign = this.getBlockExpression(elseBranch).getFirstChild();
            Node name1 = var.getFirstChild();
            Node maybeName2 = elseAssign.getFirstChild();
            if (name1.hasChildren() && maybeName2.isName() && name1.getString().equals(maybeName2.getString())) {
                Node thenExpr = name1.removeChildren();
                Node elseExpr = elseAssign.getLastChild().detachFromParent();
                cond.detachFromParent();
                Node hookNode = IR.hook(cond, thenExpr, elseExpr).srcref(n);
                var.detachFromParent();
                name1.addChildrenToBack(hookNode);
                parent.replaceChild(n, var);
                this.reportCodeChange();
                return var;
            }
        } else if (elseBranchIsVar && thenBranchIsExpressionBlock && this.getBlockExpression(thenBranch).getFirstChild().isAssign()) {
            Node var = this.getBlockVar(elseBranch);
            Node thenAssign = this.getBlockExpression(thenBranch).getFirstChild();
            Node maybeName1 = thenAssign.getFirstChild();
            Node name2 = var.getFirstChild();
            if (name2.hasChildren() && maybeName1.isName() && maybeName1.getString().equals(name2.getString())) {
                Node thenExpr = thenAssign.getLastChild().detachFromParent();
                Node elseExpr = name2.removeChildren();
                cond.detachFromParent();
                Node hookNode = IR.hook(cond, thenExpr, elseExpr).srcref(n);
                var.detachFromParent();
                name2.addChildrenToBack(hookNode);
                parent.replaceChild(n, var);
                this.reportCodeChange();
                return var;
            }
        }
        return n;
    }

    private void tryRemoveRepeatedStatements(Node n) {
        Preconditions.checkState((boolean)n.isIf());
        Node parent = n.getParent();
        if (!NodeUtil.isStatementBlock(parent)) {
            return;
        }
        Node cond = n.getFirstChild();
        Node trueBranch = cond.getNext();
        Node falseBranch = trueBranch.getNext();
        Preconditions.checkNotNull((Object)trueBranch);
        Preconditions.checkNotNull((Object)falseBranch);
        while (true) {
            Node lastTrue = trueBranch.getLastChild();
            Node lastFalse = falseBranch.getLastChild();
            if (lastTrue == null || lastFalse == null || !this.areNodesEqualForInlining(lastTrue, lastFalse)) break;
            lastTrue.detachFromParent();
            lastFalse.detachFromParent();
            parent.addChildAfter(lastTrue, n);
            this.reportCodeChange();
        }
    }

    private boolean isFoldableExpressBlock(Node n) {
        if (n.isBlock() && n.hasOneChild()) {
            Node maybeExpr = n.getFirstChild();
            if (maybeExpr.isExprResult()) {
                if (maybeExpr.getFirstChild().isCall()) {
                    Node calledFn = maybeExpr.getFirstChild().getFirstChild();
                    if (calledFn.isGetElem()) {
                        return false;
                    }
                    if (calledFn.isGetProp() && calledFn.getLastChild().getString().startsWith("on")) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private Node getBlockExpression(Node n) {
        Preconditions.checkState((boolean)this.isFoldableExpressBlock(n));
        return n.getFirstChild();
    }

    private boolean isReturnBlock(Node n) {
        if (n.isBlock() && n.hasOneChild()) {
            Node first = n.getFirstChild();
            return first.isReturn();
        }
        return false;
    }

    private boolean isReturnExpressBlock(Node n) {
        Node first;
        if (n.isBlock() && n.hasOneChild() && (first = n.getFirstChild()).isReturn()) {
            return first.hasOneChild();
        }
        return false;
    }

    private boolean isReturnExpression(Node n) {
        if (n.isReturn()) {
            return n.hasOneChild();
        }
        return false;
    }

    private Node getBlockReturnExpression(Node n) {
        Preconditions.checkState((boolean)this.isReturnExpressBlock(n));
        return n.getFirstChild().getFirstChild();
    }

    private boolean isVarBlock(Node n) {
        Node first;
        if (n.isBlock() && n.hasOneChild() && (first = n.getFirstChild()).isVar()) {
            return first.hasOneChild();
        }
        return false;
    }

    private Node getBlockVar(Node n) {
        Preconditions.checkState((boolean)this.isVarBlock(n));
        return n.getFirstChild();
    }

    private boolean consumesDanglingElse(Node n) {
        block4: while (true) {
            switch (n.getType()) {
                case 108: {
                    if (n.getChildCount() < 3) {
                        return true;
                    }
                    n = n.getLastChild();
                    continue block4;
                }
                case 113: 
                case 115: 
                case 119: {
                    n = n.getLastChild();
                    continue block4;
                }
            }
            break;
        }
        return false;
    }

    private boolean isLowerPrecedenceInExpression(Node n, final int precedence) {
        Predicate<Node> isLowerPrecedencePredicate = new Predicate<Node>(){

            public boolean apply(Node input) {
                return NodeUtil.precedence(input.getType()) < precedence;
            }
        };
        return NodeUtil.has(n, isLowerPrecedencePredicate, DONT_TRAVERSE_FUNCTIONS_PREDICATE);
    }

    private boolean isLowerPrecedence(Node n, int precedence) {
        return NodeUtil.precedence(n.getType()) < precedence;
    }

    private boolean isHigherPrecedence(Node n, int precedence) {
        return NodeUtil.precedence(n.getType()) > precedence;
    }

    private boolean isPropertyAssignmentInExpression(Node n) {
        Predicate<Node> isPropertyAssignmentInExpressionPredicate = new Predicate<Node>(){

            public boolean apply(Node input) {
                return input.isGetProp() && input.getParent().isAssign();
            }
        };
        return NodeUtil.has(n, isPropertyAssignmentInExpressionPredicate, DONT_TRAVERSE_FUNCTIONS_PREDICATE);
    }

    private Node tryMinimizeCondition(Node n) {
        Node parent = n.getParent();
        switch (n.getType()) {
            case 26: {
                Node first = n.getFirstChild();
                switch (first.getType()) {
                    case 26: {
                        Node newRoot = first.removeFirstChild();
                        parent.replaceChild(n, newRoot);
                        this.reportCodeChange();
                        return newRoot;
                    }
                    case 100: 
                    case 101: {
                        Node right;
                        Node left;
                        Node leftParent = first.getFirstChild();
                        Node rightParent = first.getLastChild();
                        if (!leftParent.isNot() && !rightParent.isNot()) {
                            int op_precedence = NodeUtil.precedence(first.getType());
                            if (this.isLowerPrecedence(leftParent, NOT_PRECEDENCE) && this.isHigherPrecedence(leftParent, op_precedence) || this.isLowerPrecedence(rightParent, NOT_PRECEDENCE) && this.isHigherPrecedence(rightParent, op_precedence)) {
                                return n;
                            }
                        }
                        if (leftParent.isNot()) {
                            left = leftParent.removeFirstChild();
                        } else {
                            leftParent.detachFromParent();
                            left = IR.not(leftParent).srcref(leftParent);
                        }
                        if (rightParent.isNot()) {
                            right = rightParent.removeFirstChild();
                        } else {
                            rightParent.detachFromParent();
                            right = IR.not(rightParent).srcref(rightParent);
                        }
                        int newOp = first.isAnd() ? 100 : 101;
                        Node newRoot = new Node(newOp, left, right);
                        parent.replaceChild(n, newRoot);
                        this.reportCodeChange();
                        return newRoot;
                    }
                }
                TernaryValue nVal = NodeUtil.getPureBooleanValue(first);
                if (nVal != TernaryValue.UNKNOWN) {
                    boolean result = nVal.not().toBoolean(true);
                    int equivalentResult = result ? 1 : 0;
                    return this.maybeReplaceChildWithNumber(n, parent, equivalentResult);
                }
                return n;
            }
            case 100: 
            case 101: {
                Node left = n.getFirstChild();
                Node right = n.getLastChild();
                left = this.tryMinimizeCondition(left);
                right = this.tryMinimizeCondition(right);
                TernaryValue rightVal = NodeUtil.getPureBooleanValue(right);
                if (NodeUtil.getPureBooleanValue(right) != TernaryValue.UNKNOWN) {
                    int type = n.getType();
                    Node replacement = null;
                    boolean rval = rightVal.toBoolean(true);
                    if (type == 100 && !rval || type == 101 && rval) {
                        replacement = left;
                    } else if (!this.mayHaveSideEffects(left)) {
                        replacement = right;
                    }
                    if (replacement != null) {
                        n.detachChildren();
                        parent.replaceChild(n, replacement);
                        this.reportCodeChange();
                        return replacement;
                    }
                }
                return n;
            }
            case 98: {
                Node condition = n.getFirstChild();
                Node trueNode = n.getFirstChild().getNext();
                Node falseNode = n.getLastChild();
                trueNode = this.tryMinimizeCondition(trueNode);
                falseNode = this.tryMinimizeCondition(falseNode);
                Node replacement = null;
                TernaryValue trueNodeVal = NodeUtil.getPureBooleanValue(trueNode);
                TernaryValue falseNodeVal = NodeUtil.getPureBooleanValue(falseNode);
                if (trueNodeVal == TernaryValue.TRUE && falseNodeVal == TernaryValue.FALSE) {
                    condition.detachFromParent();
                    replacement = condition;
                } else if (trueNodeVal == TernaryValue.FALSE && falseNodeVal == TernaryValue.TRUE) {
                    condition.detachFromParent();
                    replacement = IR.not(condition);
                } else if (trueNodeVal == TernaryValue.TRUE) {
                    n.detachChildren();
                    replacement = IR.or(condition, falseNode);
                } else if (falseNodeVal == TernaryValue.FALSE) {
                    n.detachChildren();
                    replacement = IR.and(condition, trueNode);
                }
                if (replacement != null) {
                    parent.replaceChild(n, replacement);
                    n = replacement;
                    this.reportCodeChange();
                }
                return n;
            }
        }
        TernaryValue nVal = NodeUtil.getPureBooleanValue(n);
        if (nVal != TernaryValue.UNKNOWN) {
            boolean result = nVal.toBoolean(true);
            int equivalentResult = result ? 1 : 0;
            return this.maybeReplaceChildWithNumber(n, parent, equivalentResult);
        }
        return n;
    }

    private Node maybeReplaceChildWithNumber(Node n, Node parent, int num) {
        Node newNode = IR.number(num);
        if (!newNode.isEquivalentTo(n)) {
            parent.replaceChild(n, newNode);
            this.reportCodeChange();
            return newNode;
        }
        return n;
    }

    private Node tryFoldStandardConstructors(Node n) {
        String className;
        Preconditions.checkState((boolean)n.isNew());
        if (this.isASTNormalized() && n.getFirstChild().isName() && STANDARD_OBJECT_CONSTRUCTORS.contains((Object)(className = n.getFirstChild().getString()))) {
            n.setType(37);
            n.putBooleanProp(50, true);
            this.reportCodeChange();
        }
        return n;
    }

    private Node tryFoldLiteralConstructor(Node n) {
        Preconditions.checkArgument((n.isCall() || n.isNew() ? 1 : 0) != 0);
        Node constructorNameNode = n.getFirstChild();
        Node newLiteralNode = null;
        if (this.isASTNormalized() && 38 == constructorNameNode.getType()) {
            Node arg0;
            FoldArrayAction action;
            boolean constructorHasArgs;
            String className = constructorNameNode.getString();
            if ("RegExp".equals(className)) {
                return this.tryFoldRegularExpressionConstructor(n);
            }
            boolean bl = constructorHasArgs = constructorNameNode.getNext() != null;
            if ("Object".equals(className) && !constructorHasArgs) {
                newLiteralNode = IR.objectlit(new Node[0]);
            } else if ("Array".equals(className) && ((action = this.isSafeToFoldArrayConstructor(arg0 = constructorNameNode.getNext())) == FoldArrayAction.SAFE_TO_FOLD_WITH_ARGS || action == FoldArrayAction.SAFE_TO_FOLD_WITHOUT_ARGS)) {
                newLiteralNode = IR.arraylit(new Node[0]);
                n.removeChildren();
                if (action == FoldArrayAction.SAFE_TO_FOLD_WITH_ARGS) {
                    newLiteralNode.addChildrenToFront(arg0);
                }
            }
            if (newLiteralNode != null) {
                n.getParent().replaceChild(n, newLiteralNode);
                this.reportCodeChange();
                return newLiteralNode;
            }
        }
        return n;
    }

    private FoldArrayAction isSafeToFoldArrayConstructor(Node arg) {
        FoldArrayAction action = FoldArrayAction.NOT_SAFE_TO_FOLD;
        if (arg == null) {
            action = FoldArrayAction.SAFE_TO_FOLD_WITHOUT_ARGS;
        } else if (arg.getNext() != null) {
            action = FoldArrayAction.SAFE_TO_FOLD_WITH_ARGS;
        } else {
            switch (arg.getType()) {
                case 40: {
                    action = FoldArrayAction.SAFE_TO_FOLD_WITH_ARGS;
                    break;
                }
                case 39: {
                    if (arg.getDouble() != 0.0) break;
                    action = FoldArrayAction.SAFE_TO_FOLD_WITHOUT_ARGS;
                    break;
                }
                case 63: {
                    action = FoldArrayAction.SAFE_TO_FOLD_WITH_ARGS;
                    break;
                }
            }
        }
        return action;
    }

    private Node tryFoldRegularExpressionConstructor(Node n) {
        Node flags;
        Node parent = n.getParent();
        Node constructor = n.getFirstChild();
        Node pattern = constructor.getNext();
        Node node = flags = null != pattern ? pattern.getNext() : null;
        if (null == pattern || null != flags && null != flags.getNext()) {
            return n;
        }
        if (!(!pattern.isString() || "".equals(pattern.getString()) || pattern.getString().length() >= 100 || null != flags && !flags.isString() || !this.isEcmaScript5OrGreater() && PeepholeSubstituteAlternateSyntax.containsUnicodeEscape(pattern.getString()))) {
            Node regexLiteral;
            pattern = PeepholeSubstituteAlternateSyntax.makeForwardSlashBracketSafe(pattern);
            if (null == flags || "".equals(flags.getString())) {
                regexLiteral = IR.regexp(pattern);
            } else {
                if (!PeepholeSubstituteAlternateSyntax.areValidRegexpFlags(flags.getString())) {
                    this.error(INVALID_REGULAR_EXPRESSION_FLAGS, flags);
                    return n;
                }
                if (!this.areSafeFlagsToFold(flags.getString())) {
                    return n;
                }
                n.removeChild(flags);
                regexLiteral = IR.regexp(pattern, flags);
            }
            parent.replaceChild(n, regexLiteral);
            this.reportCodeChange();
            return regexLiteral;
        }
        return n;
    }

    private Node reduceTrueFalse(Node n) {
        if (this.late) {
            Node not = IR.not(IR.number(n.isTrue() ? 0.0 : 1.0));
            not.copyInformationFromForTree(n);
            n.getParent().replaceChild(n, not);
            this.reportCodeChange();
            return not;
        }
        return n;
    }

    private Node tryMinimizeArrayLiteral(Node n) {
        boolean allStrings = true;
        for (Node cur = n.getFirstChild(); cur != null; cur = cur.getNext()) {
            if (cur.isString()) continue;
            allStrings = false;
        }
        if (allStrings) {
            return this.tryMinimizeStringArrayLiteral(n);
        }
        return n;
    }

    private Node tryMinimizeStringArrayLiteral(Node n) {
        if (!this.late) {
            return n;
        }
        int numElements = n.getChildCount();
        int saving = numElements * 2 - this.STRING_SPLIT_OVERHEAD;
        if (saving <= 0) {
            return n;
        }
        Object[] strings = new String[n.getChildCount()];
        int idx = 0;
        for (Node cur = n.getFirstChild(); cur != null; cur = cur.getNext()) {
            strings[idx++] = cur.getString();
        }
        block1: for (char delimiter : new char[]{',', ' ', ';', '{', '}'}) {
            for (String string : strings) {
                if (string.indexOf(delimiter) != -1) continue block1;
            }
            String template = Joiner.on((char)delimiter).join(strings);
            Node call = IR.call(IR.getprop(IR.string(template), IR.string("split")), IR.string("" + delimiter));
            call.copyInformationFromForTree(n);
            n.getParent().replaceChild(n, call);
            this.reportCodeChange();
            return call;
        }
        return n;
    }

    private static boolean areValidRegexpFlags(String flags) {
        return REGEXP_FLAGS_RE.matcher(flags).matches();
    }

    private boolean areSafeFlagsToFold(String flags) {
        return this.isEcmaScript5OrGreater() || flags.indexOf(103) < 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Node makeForwardSlashBracketSafe(Node n) {
        String s = n.getString();
        StringBuilder sb = null;
        int pos = 0;
        boolean isEscaped = false;
        boolean inCharset = false;
        block13: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\\': {
                    isEscaped = !isEscaped;
                    continue block13;
                }
                case '/': {
                    if (isEscaped || inCharset) break;
                    if (null == sb) {
                        sb = new StringBuilder(s.length() + 16);
                    }
                    sb.append(s, pos, i).append('\\');
                    pos = i;
                    break;
                }
                case '[': {
                    if (isEscaped) break;
                    inCharset = true;
                    break;
                }
                case ']': {
                    if (isEscaped) break;
                    inCharset = false;
                    break;
                }
                case '\n': 
                case '\r': 
                case '\u2028': 
                case '\u2029': {
                    if (null == sb) {
                        sb = new StringBuilder(s.length() + 16);
                    }
                    if (isEscaped) {
                        sb.append(s, pos, i - 1);
                    } else {
                        sb.append(s, pos, i);
                    }
                    switch (ch) {
                        case '\r': {
                            sb.append("\\r");
                            break;
                        }
                        case '\n': {
                            sb.append("\\n");
                            break;
                        }
                        case '\u2028': {
                            sb.append("\\u2028");
                            break;
                        }
                        case '\u2029': {
                            sb.append("\\u2029");
                            break;
                        }
                    }
                    pos = i + 1;
                }
            }
            isEscaped = false;
        }
        if (null == sb) {
            return n.cloneTree();
        }
        sb.append(s, pos, s.length());
        return IR.string(sb.toString()).srcref(n);
    }

    static boolean containsUnicodeEscape(String s) {
        String esc = CodeGenerator.regexpEscape(s);
        int i = -1;
        while ((i = esc.indexOf("\\u", i + 1)) >= 0) {
            int nSlashes = 0;
            while (i - nSlashes > 0 && '\\' == esc.charAt(i - nSlashes - 1)) {
                ++nSlashes;
            }
            if (0 != (nSlashes & 1)) continue;
            return true;
        }
        return false;
    }

    private static enum FoldArrayAction {
        NOT_SAFE_TO_FOLD,
        SAFE_TO_FOLD_WITH_ARGS,
        SAFE_TO_FOLD_WITHOUT_ARGS;

    }
}

