/*
 * Decompiled with CFR 0.152.
 */
package play.modules.greenscript;

import com.greenscriptool.DependenceManager;
import com.greenscriptool.IDependenceManager;
import com.greenscriptool.IFileLocator;
import com.greenscriptool.IMinimizer;
import com.greenscriptool.IRenderSession;
import com.greenscriptool.IRouteMapper;
import com.greenscriptool.Minimizer;
import com.greenscriptool.RenderSession;
import com.greenscriptool.ResourceType;
import com.greenscriptool.utils.BufferResource;
import com.greenscriptool.utils.IBufferLocator;
import java.io.BufferedInputStream;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.cache.Cache;
import play.exceptions.NoRouteFoundException;
import play.exceptions.UnexpectedException;
import play.jobs.Job;
import play.jobs.JobsPlugin;
import play.libs.Time;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Router;
import play.mvc.Scope;
import play.mvc.results.NotFound;
import play.mvc.results.RenderStatic;
import play.templates.Template;
import play.utils.Utils;
import play.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GreenScriptPlugin
extends PlayPlugin {
    public static final String VERSION = "1.2.8a";
    private Minimizer jsM_;
    private Minimizer cssM_;
    private IDependenceManager jsD_;
    private IDependenceManager cssD_;
    private Properties depConf_;
    private Properties minConf_;
    private HashMap<String, Long> configFiles_;
    private boolean eTag_ = false;
    private boolean rythmPresented_ = false;
    public static final String RESOURCES_PARAM = "resources";
    private static Properties defProps_ = new Properties();
    private boolean stopRouteUpdate_ = false;
    private static final Template VOID_RYTHM_TMPL;
    private final Pattern P = Pattern.compile(".*tags.rythm.greenscript.*");
    private static ThreadLocal<IRenderSession> sessJs_;
    private static ThreadLocal<IRenderSession> sessCss_;
    public static final String CACHE_KEY_BUFFER = "greenscript.buffer";
    protected boolean inMemoryCache = false;
    private static Map<String, String> resourceUrl_;
    private IBufferLocator bufferLocator_ = new IBufferLocator(){

        private String key_(String key) {
            return String.format("%s.%s", GreenScriptPlugin.CACHE_KEY_BUFFER, key);
        }

        public BufferResource locate(String key) {
            return (BufferResource)Cache.get((String)this.key_(key), BufferResource.class);
        }

        public BufferResource newBuffer(List<String> resourceNames, String extension) {
            StringBuilder builder = new StringBuilder();
            for (String resourceName : resourceNames) {
                builder.append(resourceName);
            }
            String key = UUID.nameUUIDFromBytes(builder.toString().getBytes()).toString() + extension;
            Logger.trace((String)"Created key '%s' from resources '%s' and extension '%s'", (Object[])new Object[]{key, builder.toString(), extension});
            BufferResource buffer = new BufferResource(key);
            Cache.set((String)this.key_(key), (Object)buffer);
            return buffer;
        }
    };

    private static String msg_(String msg, Object ... args) {
        return String.format("GreenScript-1.2.8a> %1$s", String.format(msg, args));
    }

    private static void info_(String msg, Object ... args) {
        Logger.info((String)GreenScriptPlugin.msg_(msg, args), (Object[])new Object[0]);
    }

    private static void trace_(String msg, Object ... args) {
        Logger.trace((String)GreenScriptPlugin.msg_(msg, args), (Object[])new Object[0]);
    }

    private static void debug_(String msg, Object ... args) {
        Logger.info((String)GreenScriptPlugin.msg_(msg, args), (Object[])new Object[0]);
    }

    public GreenScriptPlugin() {
        this.minConf_ = new Properties();
        this.minConf_.putAll((Map<?, ?>)defProps_);
    }

    public void onLoad() {
        try {
            Class.forName("com.greenlaw110.rythm.play.RythmPlugin");
            this.rythmPresented_ = true;
            GreenScriptPlugin.debug_("rythm presented", new Object[0]);
        }
        catch (Exception e) {
            GreenScriptPlugin.debug_("rythm not presented", new Object[0]);
        }
    }

    public void onConfigurationRead() {
        this.loadDependencies();
        this.eTag_ = Play.configuration.getProperty("http.useETag", "true").equalsIgnoreCase("true");
        GreenScriptPlugin.info_("initialized", new Object[0]);
    }

    private synchronized void updateRoute_() {
        if (this.inMemoryCache) {
            String url = this.cacheUrlPath_();
            Router.addRoute((int)0, (String)"GET", (String)(url + "{key}"), (String)"greenscript.Service.getInMemoryCache", null, null);
            Logger.debug((String)"route added: %s handled by %s", (Object[])new Object[]{url + "{key}", "greenscript.Service.getInMemoryCache"});
        } else {
            this.stopRouteUpdate_ = true;
            Router.load((String)Play.ctxPath);
            this.stopRouteUpdate_ = false;
        }
    }

    public synchronized void onRoutesLoaded() {
        if (this.stopRouteUpdate_) {
            return;
        }
        this.InitializeMinimizers();
        this.updateRoute_();
    }

    public void afterApplicationStart() {
        Properties p = Play.configuration;
        for (ResourceType type : ResourceType.values()) {
            int i;
            final Minimizer m = type == ResourceType.JS ? this.jsM_ : this.cssM_;
            String s = GreenScriptPlugin.fetchProp_(p, String.format("greenscript%s.cache.check", type.getExtension()));
            int n = i = "never".equalsIgnoreCase(s) ? -1 : Time.parseDuration((String)s);
            if (-1 == i) continue;
            Job<Object> j = new Job<Object>(){

                public void doJob() {
                    m.checkCache();
                }
            };
            JobsPlugin.executor.scheduleWithFixedDelay((Runnable)j, i, i, TimeUnit.SECONDS);
        }
    }

    public Template loadTemplate(VirtualFile file) {
        if (this.rythmPresented_) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        if (this.P.matcher(file.relativePath()).matches()) {
            return VOID_RYTHM_TMPL;
        }
        return null;
    }

    public void onApplicationStop() {
        this.cleanUp_();
    }

    public String jsDebugString() {
        return ((DependenceManager)this.jsD_).debugString();
    }

    public String cssDebugString() {
        return ((DependenceManager)this.cssD_).debugString();
    }

    public static IRenderSession session(String type) {
        ResourceType rt = ResourceType.valueOf((String)type.toUpperCase());
        switch (rt) {
            case JS: {
                return GreenScriptPlugin.jsSession();
            }
            case CSS: {
                return GreenScriptPlugin.cssSession();
            }
        }
        throw new UnexpectedException("unknown resource type: " + rt.name());
    }

    public static IRenderSession jsSession() {
        return sessJs_.get();
    }

    public static IRenderSession cssSession() {
        return sessCss_.get();
    }

    public void beforeActionInvocation(Method actionMethod) {
        IRenderSession sess = this.newSession_(ResourceType.JS);
        sessJs_.set(sess);
        String def = ResourceResolver.def(ResourceType.JS);
        sess.declare(def, null, null);
        sess = this.newSession_(ResourceType.CSS);
        sessCss_.set(sess);
        def = ResourceResolver.def(ResourceType.CSS);
        sess.declare(def, null, null);
    }

    public boolean serveStatic(VirtualFile file, Http.Request request, Http.Response response) {
        String fn;
        if (null == this.jsM_) {
            if (Play.mode == Play.Mode.DEV) {
                Play.start();
            } else {
                throw new UnexpectedException("Minimizer not initialized");
            }
        }
        if ((fn = file.getName()).endsWith(".coffee") || fn.endsWith(".js") && this.jsM_.isMinimizeEnabled() && !file.relativePath().startsWith(this.cacheUrlPath_())) {
            return this.processStatic_(file, request, response, ResourceType.JS);
        }
        if ((fn.endsWith("css") || fn.endsWith("less")) && this.cssM_.isMinimizeEnabled() && !file.relativePath().startsWith(this.cacheUrlPath_())) {
            return this.processStatic_(file, request, response, ResourceType.CSS);
        }
        if (fn.endsWith(".css") || fn.endsWith(".js")) {
            long l = file.lastModified();
            String etag = "\"" + l + "-" + file.hashCode() + "\"";
            Map headers = request.headers;
            if (headers.containsKey("if-none-match") && headers.containsKey("if-modified-since") && "GET".equalsIgnoreCase(request.method)) {
                response.status = 304;
                response.cacheFor(etag, "100d", l);
                this.keepFlash_();
                return true;
            }
        }
        return false;
    }

    private void keepFlash_() {
        Scope.Flash f = Scope.Flash.current();
        if (f != null) {
            f.keep();
        }
    }

    private boolean processStatic_(VirtualFile file, Http.Request req, Http.Response resp, ResourceType type) {
        if (Play.mode == Play.Mode.PROD) {
            resp.cacheFor("1h");
        }
        Minimizer min = type == ResourceType.CSS ? this.cssM_ : this.jsM_;
        long l = min.getLastModified(file.getRealFile());
        String etag = "\"" + l + "-" + file.hashCode() + "\"";
        if (!req.isModified(etag, l)) {
            if (req.method.equalsIgnoreCase("GET")) {
                resp.status = 304;
                if (this.eTag_) {
                    resp.setHeader("ETag", etag);
                }
                this.keepFlash_();
                return true;
            }
            return false;
        }
        try {
            String content = min.processStatic(file.getRealFile());
            resp.contentType = type == ResourceType.JS ? "text/javascript" : "text/css";
            resp.status = 200;
            resp.print((Object)content);
            resp.setHeader("Last-Modified", Utils.getHttpDateFormatter().format(new Date(l + 1000L)));
            if (this.eTag_) {
                resp.setHeader("ETag", etag);
            }
            this.keepFlash_();
            return true;
        }
        catch (Exception e) {
            Logger.error((Throwable)e, (String)"error compress file %1$s", (Object[])new Object[]{file.getName()});
            return false;
        }
    }

    private HashMap<String, Long> currentConfigFiles() {
        HashMap<String, Long> files = new HashMap<String, Long>();
        for (VirtualFile vf : Play.roots) {
            VirtualFile conf = vf.child("conf/greenscript.conf");
            if (!conf.exists()) continue;
            files.put(conf.getRealFile().getAbsolutePath(), conf.getRealFile().lastModified());
        }
        return files;
    }

    private boolean filesChanged(HashMap<String, Long> oldFiles, HashMap<String, Long> newFiles) {
        if (oldFiles.size() != newFiles.size()) {
            return true;
        }
        for (Map.Entry<String, Long> entry : oldFiles.entrySet()) {
            Long newTime = newFiles.get(entry.getKey());
            if (newTime != null && newTime.equals(entry.getValue())) continue;
            return true;
        }
        return false;
    }

    public void detectChange() {
        if (Play.mode == Play.Mode.PROD) {
            return;
        }
        if (this.filesChanged(this.configFiles_, this.currentConfigFiles())) {
            Logger.debug((String)"greenscript: config files changed, reloading dependencies", (Object[])new Object[0]);
            GreenScriptPlugin.reloadDependencies();
        }
    }

    public void loadDependencies() {
        Properties p = new Properties();
        for (VirtualFile vf : Play.roots) {
            VirtualFile conf = vf.child("conf/greenscript.conf");
            if (!conf.exists()) continue;
            GreenScriptPlugin.trace_("loading dependency configuration from %1$s", conf.getRealFile().getAbsolutePath());
            try {
                p.load(new BufferedInputStream(conf.inputstream()));
            }
            catch (Exception e) {
                throw new UnexpectedException("error loading conf/greenscript.conf");
            }
        }
        this.configFiles_ = this.currentConfigFiles();
        this.jsD_ = new DependenceManager(this.loadDepProp_(p, "js"));
        this.cssD_ = new DependenceManager(this.loadDepProp_(p, "css"));
        this.depConf_ = p;
        GreenScriptPlugin.info_("dependency loaded", new Object[0]);
    }

    public void InitializeMinimizers() {
        Properties p = Play.configuration;
        for (String key : p.stringPropertyNames()) {
            if (!key.startsWith("greenscript.")) continue;
            String v = p.getProperty(key);
            this.minConf_.setProperty(key, p.getProperty(key));
            GreenScriptPlugin.trace_("[greenscript]set %1$s to %2$s", v, key);
        }
        this.jsM_ = this.initializeMinimizer_(this.minConf_, ResourceType.JS);
        this.cssM_ = this.initializeMinimizer_(this.minConf_, ResourceType.CSS);
        if (p.containsKey("greenscript.coffee.enabled")) {
            System.setProperty("greenscript.coffee.enabled", p.getProperty("greenscript.coffee.enabled"));
        }
        if (p.containsKey("greenscript.less.enabled")) {
            System.setProperty("greenscript.less.enabled", p.getProperty("greenscript.less.enabled"));
        }
        GreenScriptPlugin.info_("minimizer initialized", new Object[0]);
    }

    private IRenderSession newSession_(ResourceType type) {
        return type == ResourceType.JS ? new RenderSession((IMinimizer)this.jsM_, this.jsD_, type) : new RenderSession((IMinimizer)this.cssM_, this.cssD_, type);
    }

    public Properties getDependencyConfig() {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)this.depConf_);
        return p;
    }

    public Properties getMinimizerConfig() {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)this.minConf_);
        return p;
    }

    private String join_(Collection<String> c) {
        boolean first = true;
        StringBuffer sb = new StringBuffer();
        for (String s : c) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append(s);
        }
        return sb.toString();
    }

    private void mergeProperties_(Properties p, String k, String v) {
        String oldV = p.getProperty(k);
        if (null == oldV) {
            p.setProperty(k, v);
        } else {
            HashSet<String> oldS = new HashSet<String>();
            oldS.addAll(Arrays.asList(oldV.split("[ ,;<>]")));
            HashSet<String> newS = new HashSet<String>();
            newS.addAll(Arrays.asList(v.split("[ ,;<>]")));
            oldS.addAll(newS);
            p.setProperty(k, this.join_(oldS));
        }
    }

    private Properties loadDepProp_(Properties p, String type) {
        Properties p0 = new Properties();
        String prefix = type + ".";
        for (String k : p.stringPropertyNames()) {
            if (!k.startsWith(prefix)) continue;
            String k0 = k.replace(prefix, "");
            String v = p.getProperty(k);
            if (k0.matches(".*\\s*\\-\\s*$")) {
                k0 = k0.replaceAll("\\s*\\-\\s*$", "");
                for (String s : v.replaceAll("\\s+", "").split("[ ,;<>]")) {
                    this.mergeProperties_(p0, s, k0);
                }
            } else {
                this.mergeProperties_(p0, k0, v);
            }
            GreenScriptPlugin.trace_("Found one %1$s dependency: %2$s depends on '%3$s'", type, k0, v);
        }
        return p0;
    }

    private void setResourceUrlPath_(String resourceUrlRoot, String resourceUrlPath, String ext) {
        String path = null;
        String ctxPath = Play.ctxPath;
        if (!resourceUrlPath.endsWith("/")) {
            resourceUrlPath = resourceUrlPath + "/";
        }
        path = resourceUrlPath.startsWith("/") ? (resourceUrlPath.startsWith(ctxPath) ? resourceUrlPath : ctxPath + resourceUrlPath) : resourceUrlRoot + resourceUrlPath;
        resourceUrl_.put(ext, path);
    }

    private String resourceUrlRoot_() {
        Properties p = this.minConf_;
        String urlRoot = GreenScriptPlugin.fetchProp_(p, "greenscript.url.root");
        if (!urlRoot.startsWith("/")) {
            throw new IllegalArgumentException("url root must start with /");
        }
        if (!urlRoot.endsWith("/")) {
            urlRoot = urlRoot + "/";
        }
        return urlRoot.startsWith(Play.ctxPath) ? urlRoot : Play.ctxPath + urlRoot;
    }

    private String cacheUrlPath_() {
        String resourceUrlRoot = this.resourceUrlRoot_();
        if (null == resourceUrlRoot) {
            throw new IllegalStateException("resourceUrlRoot must be initiated first");
        }
        Properties p = Play.configuration;
        String urlPath = GreenScriptPlugin.fetchProp_(p, "greenscript.url.minimized");
        String ctxPath = Play.ctxPath;
        if (!urlPath.endsWith("/")) {
            urlPath = urlPath + "/";
        }
        if (urlPath.startsWith("/")) {
            return urlPath.startsWith(ctxPath) ? urlPath : ctxPath + urlPath;
        }
        return resourceUrlRoot + urlPath;
    }

    private Minimizer initializeMinimizer_(Properties p, ResourceType type) {
        Minimizer m = new Minimizer(type);
        m.setFileLocator(new IFileLocator(){

            public File locate(String path) {
                VirtualFile vf = VirtualFile.search((Collection)Play.roots, (String)path);
                return vf == null ? null : vf.getRealFile();
            }
        });
        m.setBufferLocator(this.bufferLocator_);
        boolean routerMapping = this.getBooleanProp_(p, "greenscript.router.mapping", false);
        if (routerMapping) {
            m.setRouteMapper(new IRouteMapper(){

                public String reverse(String fileName) {
                    try {
                        String url = Router.reverseWithCheck((String)fileName, (VirtualFile)Play.getVirtualFile((String)fileName), (boolean)false);
                        if (fileName.endsWith("/") && !url.endsWith("/")) {
                            url = url + "/";
                        }
                        return url;
                    }
                    catch (NoRouteFoundException e) {
                        return fileName;
                    }
                }

                public String route(String url) {
                    try {
                        Map args = Router.route((String)"GET", (String)url);
                        return (String)args.get("action");
                    }
                    catch (RenderStatic rs) {
                        String fileName = rs.file;
                        if (url.startsWith("/") && !fileName.startsWith("/")) {
                            fileName = "/" + fileName;
                        }
                        return fileName;
                    }
                    catch (NotFound ex) {
                        return url;
                    }
                }
            });
        }
        String ext = type.getExtension();
        String rootDir = GreenScriptPlugin.fetchProp_(p, "greenscript.dir.root");
        String resourceDir = GreenScriptPlugin.fetchProp_(p, "greenscript.dir" + ext);
        String cacheDir = GreenScriptPlugin.fetchProp_(p, "greenscript.dir.minimized");
        String urlRoot = this.resourceUrlRoot_();
        String resourceUrl = GreenScriptPlugin.fetchProp_(p, "greenscript.url" + ext);
        String cacheUrl = this.cacheUrlPath_();
        this.setResourceUrlPath_(urlRoot, resourceUrl, ext);
        m.setUrlContextPath(Play.ctxPath);
        m.setResourceUrlRoot(urlRoot);
        m.setResourceUrlPath(resourceUrl);
        m.setCacheUrlPath(cacheUrl);
        m.setRootDir(rootDir);
        m.setCacheDir(Play.getFile((String)cacheDir));
        m.setResourceDir(resourceDir);
        boolean resourcesParameter = this.getBooleanProp_(p, "greenscript.resources.param.enabled", false);
        m.setResourcesParam(resourcesParameter ? RESOURCES_PARAM : null);
        boolean minimize = this.getBooleanProp_(p, "greenscript.minimize", Play.mode == Play.Mode.PROD);
        boolean compress = this.getBooleanProp_(p, "greenscript.compress", true);
        boolean cache = this.getBooleanProp_(p, "greenscript.cache", true);
        this.inMemoryCache = this.getBooleanProp_(p, "greenscript.cache.inmemory", false);
        boolean processInline = this.getBooleanProp_(p, "greenscript.inline.process", false);
        System.setProperty("greenscript.lessCompile.postMerge", GreenScriptPlugin.fetchProp_(p, "greenscript.lessCompile.postMerge"));
        m.enableDisableMinimize(minimize);
        m.enableDisableCompress(compress);
        m.enableDisableCache(cache);
        m.enableDisableInMemoryCache(this.inMemoryCache);
        m.enableDisableProcessInline(processInline);
        GreenScriptPlugin.trace_("minimizer for %1$s loaded", type.name());
        return m;
    }

    public String getInMemoryFileContent(String key, String resourceNames) {
        BufferResource resource = this.bufferLocator_.locate(key);
        if (resource == null && resourceNames != null) {
            Minimizer minimizer = null;
            if (key.endsWith(".js")) {
                minimizer = this.jsM_;
            } else if (key.endsWith(".css")) {
                minimizer = this.cssM_;
            }
            resource = minimizer.minimize(resourceNames);
        }
        return null == resource ? null : resource.toString();
    }

    private static String fetchProp_(Properties p, String key) {
        String val = p.getProperty(key);
        if (null == val) {
            val = defProps_.getProperty(key);
        }
        return val;
    }

    private boolean getBooleanProp_(Properties p, String key, boolean def) {
        try {
            String s = p.containsKey(key) ? p.getProperty(key) : (defProps_.containsKey(key) ? defProps_.getProperty(key) : String.valueOf(def));
            p.setProperty(key, s);
            return Boolean.parseBoolean(s);
        }
        catch (Exception e) {
            p.setProperty(key, String.valueOf(def));
            return def;
        }
    }

    private void cleanUp_() {
        if (null != this.jsM_) {
            this.jsM_.clearCache();
        }
        if (null != this.cssM_) {
            this.cssM_.clearCache();
        }
    }

    public static GreenScriptPlugin getInstance() {
        for (PlayPlugin pp : Play.pluginCollection.getEnabledPlugins()) {
            if (!(pp instanceof GreenScriptPlugin)) continue;
            return (GreenScriptPlugin)pp;
        }
        return null;
    }

    public static void updateMinimizer(boolean minimize, boolean compress, boolean cache, boolean inMemoryCache) {
        GreenScriptPlugin gs = GreenScriptPlugin.getInstance();
        gs.jsM_.enableDisableMinimize(minimize);
        gs.jsM_.enableDisableCompress(compress);
        gs.jsM_.enableDisableCache(cache);
        gs.jsM_.enableDisableInMemoryCache(inMemoryCache);
        gs.cssM_.enableDisableMinimize(minimize);
        gs.cssM_.enableDisableCompress(compress);
        gs.cssM_.enableDisableCache(cache);
        gs.cssM_.enableDisableInMemoryCache(inMemoryCache);
        gs.inMemoryCache = inMemoryCache;
        gs.updateRoute_();
        gs.minConf_.setProperty("greenscript.minimize", String.valueOf(minimize));
        gs.minConf_.setProperty("greenscript.compress", String.valueOf(compress));
        gs.minConf_.setProperty("greenscript.cache", String.valueOf(cache));
        gs.minConf_.setProperty("greenscript.cache.inmemory", String.valueOf(inMemoryCache));
    }

    public static void enableDisableMinimize(boolean minimize) {
        GreenScriptPlugin gs = GreenScriptPlugin.getInstance();
        gs.jsM_.enableDisableMinimize(minimize);
        gs.minConf_.setProperty("greenscript.minimize", String.valueOf(minimize));
        GreenScriptPlugin.info_("minimize %s", minimize ? "enabled" : "disabled");
    }

    public static void enableDisableCompress(boolean compress) {
        GreenScriptPlugin gs = GreenScriptPlugin.getInstance();
        gs.jsM_.enableDisableCompress(compress);
        gs.minConf_.setProperty("greenscript.compress", String.valueOf(compress));
        GreenScriptPlugin.info_("compress %s", compress ? "enabled" : "disabled");
    }

    public static void enableDisableCache(boolean cache) {
        GreenScriptPlugin gs = GreenScriptPlugin.getInstance();
        gs.jsM_.enableDisableCache(cache);
        gs.minConf_.setProperty("greenscript.cache", String.valueOf(cache));
        GreenScriptPlugin.info_("cache %s", cache ? "enabled" : "disabled");
    }

    public static void reloadDependencies() {
        GreenScriptPlugin gs = GreenScriptPlugin.getInstance();
        gs.loadDependencies();
        GreenScriptPlugin.info_("dependency reloaded", new Object[0]);
    }

    public static String lessImport(String fns) {
        String[] sa;
        GreenScriptPlugin gs = GreenScriptPlugin.getInstance();
        Properties p = gs.minConf_;
        String rootDir = GreenScriptPlugin.fetchProp_(p, "greenscript.dir.root");
        String resourceDir = GreenScriptPlugin.fetchProp_(p, "greenscript.dir.css");
        StringBuilder sb = new StringBuilder();
        for (String fn : sa = fns.split("[ ,;]")) {
            String string = fn = fn.endsWith(".css") ? fn : fn + ".css";
            String path = fn.startsWith("/") ? (!fn.startsWith(rootDir) ? rootDir + fn.replaceFirst("/", "") : fn) : rootDir + File.separator + resourceDir + File.separator + fn;
            VirtualFile vf = VirtualFile.search((Collection)Play.roots, (String)path);
            if (null == vf) continue;
            sb.append(vf.contentAsString());
        }
        return sb.toString();
    }

    static {
        defProps_.put("greenscript.dir.root", "/public");
        defProps_.put("greenscript.dir.js", "javascripts");
        defProps_.put("greenscript.dir.css", "stylesheets");
        defProps_.put("greenscript.dir.minimized", "/public/gs");
        defProps_.put("greenscript.url.root", "/public");
        defProps_.put("greenscript.url.js", "/public/javascripts");
        defProps_.put("greenscript.url.css", "/public/stylesheets");
        defProps_.put("greenscript.url.minimized", "/public/gs");
        defProps_.setProperty("greenscript.minimize", Play.mode == Play.Mode.PROD ? "true" : "false");
        defProps_.setProperty("greenscript.compress", Play.mode == Play.Mode.PROD ? "true" : "false");
        defProps_.setProperty("greenscript.cache", Play.mode == Play.Mode.PROD ? "true" : "false");
        defProps_.setProperty("greenscript.cache.inmemory", "true");
        defProps_.setProperty("greenscript.less.enabled", "false");
        defProps_.setProperty("greenscript.coffee.enabled", "false");
        defProps_.setProperty("greenscript.inline.process", "false");
        defProps_.setProperty("greenscript.js.cache.check", "10s");
        defProps_.setProperty("greenscript.css.cache.check", "10s");
        defProps_.setProperty("greenscript.lessCompile.postMerge", "false");
        defProps_.setProperty("greenscript.resources.param.enabled", "false");
        VOID_RYTHM_TMPL = new Template(){

            public void compile() {
            }

            protected String internalRender(Map<String, Object> args) {
                return null;
            }
        };
        sessJs_ = new ThreadLocal();
        sessCss_ = new ThreadLocal();
        resourceUrl_ = new HashMap<String, String>();
    }

    private static class ResourceResolver
    extends Controller {
        private ResourceResolver() {
        }

        public static String def(ResourceType type) {
            String template = Controller.template();
            String urlPath = (String)resourceUrl_.get(type.getExtension());
            return null == template ? null : template.replaceFirst("^views/", urlPath).replaceFirst("\\.[\\w]+$", type.getExtension());
        }
    }
}

