/*
 * Decompiled with CFR 0.152.
 */
package com.greenscriptool;

import com.asual.lesscss.LessEngine;
import com.asual.lesscss.LessException;
import com.greenscriptool.IFileLocator;
import com.greenscriptool.IMinimizer;
import com.greenscriptool.IResource;
import com.greenscriptool.IRouteMapper;
import com.greenscriptool.ResourceType;
import com.greenscriptool.utils.BufferLocator;
import com.greenscriptool.utils.ClosureCompressor;
import com.greenscriptool.utils.FileCache;
import com.greenscriptool.utils.FileResource;
import com.greenscriptool.utils.IBufferLocator;
import com.greenscriptool.utils.ICompressor;
import com.greenscriptool.utils.YUICompressor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jcoffeescript.JCoffeeScriptCompileException;
import org.jcoffeescript.JCoffeeScriptCompiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Minimizer
implements IMinimizer {
    private static Log logger_ = LogFactory.getLog(Minimizer.class);
    private boolean minimize_;
    private boolean compress_;
    private boolean useCache_;
    private boolean inMemory_;
    private boolean processInline_;
    private FileCache cache_ = null;
    private String resourcePath_ = null;
    private String rootDir_ = null;
    private String ctxPath_ = null;
    private String resourceUrlRoot_ = null;
    private String resourceUrlPath_ = null;
    private String cacheUrlPath_ = null;
    private String resourcesParam_ = null;
    private ICompressor compressor_;
    private ResourceType type_;
    private LessEngine less_;
    private JCoffeeScriptCompiler coffee_;
    private IFileLocator fl_ = FileResource.defFileLocator;
    private IBufferLocator bl_ = new BufferLocator();
    private IRouteMapper rm_ = null;
    private static final Pattern P_IMPORT = Pattern.compile("^\\s*@import\\s*\"(.*?)\".*");
    private Map<String, Set<File>> importsCache_ = new HashMap<String, Set<File>>();
    private ConcurrentMap<List<String>, List<String>> processCache_ = new ConcurrentHashMap<List<String>, List<String>>();
    private ConcurrentMap<List<String>, List<String>> processCache2_ = new ConcurrentHashMap<List<String>, List<String>>();
    public static final String SYS_PROP_LESS_ENABLED = "greenscript.less.enabled";
    public static final String SYS_PROP_COFFEE_ENABLED = "greenscript.coffee.enabled";
    private static final Pattern P_URL = Pattern.compile("url\\(['\"]?([^/'\"][^'\"]*?)['\"]?\\)", 194);
    private ConcurrentMap<File, Long> lastModifiedCache_ = new ConcurrentHashMap<File, Long>();
    private static final Pattern P_CDN_PREFIX = Pattern.compile("^https?:");

    private void init_(ICompressor compressor, ResourceType type) {
        if (null == compressor) {
            throw new NullPointerException();
        }
        this.compressor_ = compressor;
        this.type_ = type;
        this.less_ = new LessEngine();
        this.coffee_ = new JCoffeeScriptCompiler();
    }

    public Minimizer(ResourceType type) {
        ICompressor compressor = type == ResourceType.CSS ? new YUICompressor(type) : new ClosureCompressor(type);
        this.init_(compressor, type);
    }

    @Inject
    public Minimizer(ICompressor compressor, ResourceType type) {
        this.init_(compressor, type);
    }

    @Override
    public void enableDisableMinimize(boolean enable) {
        boolean bl = this.minimize_ = enable || ResourceType.CSS == this.type_;
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("minimize " + (enable ? "enabled" : "disabled")));
        }
        this.clearCache();
    }

    @Override
    public void enableDisableCompress(boolean enable) {
        this.compress_ = enable;
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("compress " + (enable ? "enabled" : "disabled")));
        }
        this.clearCache();
    }

    @Override
    public void enableDisableCache(boolean enable) {
        this.useCache_ = enable;
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("cache " + (enable ? "enabled" : "disabled")));
        }
        this.clearCache();
    }

    @Override
    public void enableDisableInMemoryCache(boolean enable) {
        this.inMemory_ = enable;
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("in memory cache " + (enable ? "enabled" : "disabled")));
        }
        this.clearCache();
    }

    @Override
    public void enableDisableProcessInline(boolean enable) {
        this.processInline_ = enable;
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("inline processing " + (enable ? "enabled" : "disabled")));
        }
    }

    @Deprecated
    public void enableDisableVerifyResource(boolean verify) {
    }

    @Override
    public boolean isMinimizeEnabled() {
        return this.minimize_ || ResourceType.CSS == this.type_;
    }

    @Override
    public boolean isCompressEnabled() {
        return this.compress_;
    }

    @Override
    public boolean isCacheEnabled() {
        return this.useCache_;
    }

    @Override
    public void setResourceDir(String dir) {
        this.checkInitialize_(false);
        if (this.rootDir_ == null) {
            throw new IllegalStateException("rootDir need to be intialized first");
        }
        this.resourcePath_ = dir.startsWith(this.rootDir_) ? dir : (dir.startsWith("/") ? this.rootDir_ + dir : this.rootDir_ + "/" + dir);
        File f = this.fl_.locate(this.resourcePath_);
        if (!f.isDirectory()) {
            throw new IllegalArgumentException("not a directory");
        }
    }

    @Override
    public void setRootDir(String dir) {
        this.checkInitialize_(false);
        if (this.fl_ == null) {
            throw new IllegalStateException("file locator need to initialized first");
        }
        this.rootDir_ = dir.endsWith("/") ? dir.substring(0, dir.length() - 1) : dir;
        File f = this.fl_.locate(this.rootDir_);
        if (!f.isDirectory()) {
            throw new IllegalArgumentException("not a directory");
        }
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)String.format("root dir set to %1$s", dir));
        }
    }

    @Override
    public void setUrlContextPath(String ctxPath) {
        if (null == ctxPath) {
            throw new NullPointerException();
        }
        if (ctxPath.endsWith("/")) {
            ctxPath = ctxPath.substring(0, ctxPath.length() - 1);
        }
        this.ctxPath_ = ctxPath;
    }

    @Override
    public void setCacheDir(File dir) {
        this.checkInitialize_(false);
        this.cache_ = new FileCache(dir);
    }

    @Override
    public void setResourceUrlRoot(String urlRoot) {
        if (this.ctxPath_ == null) {
            throw new IllegalStateException("ctxPath must be intialized first");
        }
        if (!urlRoot.startsWith("/")) {
            throw new IllegalArgumentException("url root must start with /");
        }
        if (!urlRoot.endsWith("/")) {
            urlRoot = urlRoot + "/";
        }
        String string = this.resourceUrlRoot_ = urlRoot.startsWith(this.ctxPath_) ? urlRoot : this.ctxPath_ + urlRoot;
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)String.format("url root set to %1$s", urlRoot));
        }
    }

    @Override
    public void setResourceUrlPath(String urlPath) {
        this.checkInitialize_(false);
        if (null == this.resourceUrlRoot_) {
            throw new IllegalStateException("resourceUrlRoot must be initiated first");
        }
        if (!urlPath.endsWith("/")) {
            urlPath = urlPath + "/";
        }
        this.resourceUrlPath_ = urlPath.startsWith("/") ? (urlPath.startsWith(this.ctxPath_) ? urlPath : this.ctxPath_ + urlPath) : this.resourceUrlRoot_ + urlPath;
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)String.format("url path set to %1$s", urlPath));
        }
    }

    @Override
    public void setCacheUrlPath(String urlPath) {
        this.checkInitialize_(false);
        if (null == this.resourceUrlRoot_) {
            throw new IllegalStateException("resourceUrlRoot must be initiated first");
        }
        if (!urlPath.endsWith("/")) {
            urlPath = urlPath + "/";
        }
        this.cacheUrlPath_ = urlPath.startsWith("/") ? (urlPath.startsWith(this.ctxPath_) ? urlPath : this.ctxPath_ + urlPath) : this.resourceUrlRoot_ + urlPath;
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)String.format("cache url root set to %1$s", urlPath));
        }
    }

    @Override
    public void clearCache() {
        this.cache_.clear();
        this.processCache2_.clear();
        this.processCache_.clear();
    }

    @Override
    public void setFileLocator(IFileLocator fileLocator) {
        if (null == fileLocator) {
            throw new NullPointerException();
        }
        this.fl_ = fileLocator;
    }

    @Override
    public void setBufferLocator(IBufferLocator bufferLocator) {
        if (null == bufferLocator) {
            throw new NullPointerException();
        }
        this.bl_ = bufferLocator;
    }

    @Override
    public void setRouteMapper(IRouteMapper routeMapper) {
        if (null == routeMapper) {
            throw new NullPointerException();
        }
        this.rm_ = routeMapper;
    }

    private Set<File> imports_(File file) {
        Set<File> files;
        block5: {
            String key = "less_imports_" + file.getPath() + file.lastModified();
            files = this.importsCache_.get(key);
            if (null == files) {
                files = new HashSet<File>();
                try {
                    List<String> lines = this.fileToLines_(file);
                    for (String line : lines) {
                        Matcher m = P_IMPORT.matcher(line);
                        while (m.find()) {
                            File f = new File(file.getParentFile(), m.group(1));
                            files.add(f);
                            files.addAll(this.imports_(f));
                        }
                    }
                }
                catch (Exception e) {
                    if (!logger_.isErrorEnabled()) break block5;
                    logger_.error((Object)String.format("Error occurred getting @imports from resource: $s", file), (Throwable)e);
                }
            }
        }
        return files;
    }

    @Override
    public long getLastModified(File file) {
        long l = file.lastModified();
        if (ResourceType.CSS == this.type_) {
            for (File f : this.imports_(file)) {
                l = Math.max(l, f.lastModified());
            }
        }
        return l;
    }

    @Override
    public void checkCache() {
        block0: for (List l : this.processCache_.keySet()) {
            for (String s : l) {
                long ts2;
                long ts1;
                File f;
                if (this.isCDN_(s) || null == (f = this.getFileFromURL_(s)) || !f.exists() || (ts1 = this.getLastModified(f)) <= (ts2 = ((Long)this.lastModifiedCache_.get(f)).longValue())) continue;
                this.processCache_.remove(l);
                continue block0;
            }
        }
    }

    @Override
    public List<String> process(List<String> resourceNames) {
        this.checkInitialize_(true);
        if (resourceNames.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.minimize_ || ResourceType.CSS == this.type_) {
            List l;
            if (this.useCache_ && this.processCache_.containsKey(resourceNames) && null != (l = (List)this.processCache_.get(resourceNames))) {
                return new ArrayList<String>(l);
            }
            ArrayList<String> retLst = new ArrayList<String>();
            ArrayList<String> tmpLst = new ArrayList<String>();
            for (String fn : resourceNames) {
                if (!this.isCDN_(fn)) {
                    tmpLst.add(fn);
                    continue;
                }
                if (tmpLst.size() > 0) {
                    retLst.add(this.minimize_(tmpLst));
                    tmpLst.clear();
                }
                retLst.add(fn);
            }
            if (tmpLst.size() > 0) {
                retLst.add(this.minimize_(tmpLst));
                tmpLst.clear();
            }
            this.processCache_.put(resourceNames, retLst);
            return retLst;
        }
        List<String> retLst = this.processWithoutMinimize(resourceNames);
        return retLst;
    }

    private final String getExtension_(String path) {
        int pos = path.lastIndexOf(".");
        return -1 == pos ? "" : path.substring(pos, path.length());
    }

    @Override
    public List<String> processWithoutMinimize(List<String> resourceNames) {
        List<String> l;
        this.checkInitialize_(true);
        if (resourceNames.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.useCache_ && this.processCache2_.containsKey(resourceNames) && null != (l = (List)this.processCache2_.get(resourceNames))) {
            return new ArrayList<String>(l);
        }
        l = new ArrayList();
        for (String fn : resourceNames) {
            if (this.isCDN_(fn)) {
                l.add(fn);
                continue;
            }
            String s = fn.replace(this.type_.getExtension(), "");
            File f = null;
            if (s.equalsIgnoreCase("default") || s.endsWith(".bundle") || null == (f = this.getFile_(fn)) || !f.isFile()) continue;
            String ext = this.getExtension_(f.getName());
            fn = fn.endsWith(ext) ? fn : fn + ext;
            fn = this.getUrl_(fn);
            l.add(fn);
        }
        if (l.isEmpty()) {
            logger_.warn((Object)("Empty resource list found when processing " + resourceNames));
        }
        this.processCache2_.put(resourceNames, l);
        return l;
    }

    private String compress(String content) {
        try {
            StringReader r = new StringReader(content);
            StringWriter w = new StringWriter();
            this.compressor_.compress(r, w);
            return w.toString();
        }
        catch (Exception e) {
            logger_.warn((Object)"error compress resource", (Throwable)e);
            return content;
        }
    }

    private void compress(File file, Writer out) {
        try {
            BufferedReader r = new BufferedReader(new FileReader(file));
            try {
                this.compressor_.compress(r, out);
            }
            catch (Exception e) {
                logger_.warn((Object)("error compress resource " + file.getPath()), (Throwable)e);
                Minimizer.copy_(file, out);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void compress(String content, Writer out) {
        StringReader r = new StringReader(content);
        try {
            this.compressor_.compress(r, out);
        }
        catch (Exception e) {
            logger_.warn((Object)"error compress resource", (Throwable)e);
            Minimizer.copy_(content, out);
        }
    }

    @Override
    public String processInline(String content) {
        if (!this.processInline_) {
            return content;
        }
        try {
            content = this.preprocess_(content);
            if (this.compress_) {
                return this.compress(content);
            }
            return content;
        }
        catch (StackOverflowError e) {
            logger_.error((Object)("fatal error compressing inline content:" + e.getMessage()));
            return content;
        }
        catch (Exception e) {
            logger_.error((Object)"error processing inline content", (Throwable)e);
            return content;
        }
    }

    @Override
    public String processStatic(File file) {
        String content = null;
        try {
            content = this.preprocess_(file);
        }
        catch (IOException e2) {
            logger_.error((Object)("error preprocess static file: " + file.getPath()));
            return "";
        }
        try {
            if (this.compress_) {
                return this.compress(content);
            }
            return content;
        }
        catch (StackOverflowError e) {
            logger_.error((Object)("fatal error compressing static file: " + file.getName()));
            return content;
        }
        catch (Exception e) {
            logger_.warn((Object)("error processing static file: " + file.getPath()), (Throwable)e);
            try {
                return this.fileToString_(file);
            }
            catch (IOException e1) {
                return "";
            }
        }
    }

    private static String dos2unix_(String s) {
        return s.replaceAll("\r\n", "\n");
    }

    private String compileLess_(String s) throws LessException {
        return this.less_.compile(Minimizer.dos2unix_(s)).replace("\\n", "\n");
    }

    private String compileLess_(File f) throws LessException {
        return this.less_.compile(f).replace("\\n", "\n");
    }

    private String compileCoffee_(String s) throws JCoffeeScriptCompileException {
        return this.coffee_.compile(s);
    }

    private String compileCoffee_(File f) throws JCoffeeScriptCompileException, IOException {
        return this.compileCoffee_(this.fileToString_(f));
    }

    public IResource minimize(String resourceNames) {
        return this.minimize(this.decodeResourceNames(resourceNames));
    }

    private IResource minimize(List<String> resourceNames) {
        IResource rsrc;
        block19: {
            rsrc = this.newCache_(resourceNames);
            Writer out = rsrc.getWriter();
            StringWriter sw = new StringWriter();
            try {
                for (String s : resourceNames) {
                    if (this.isCDN_(s)) {
                        throw new IllegalArgumentException("CDN resource not expected in miminize method");
                    }
                    File f = this.getFileFromURL_(s);
                    if (null == f || !f.exists()) continue;
                    this.merge_(f, sw, s);
                }
                String s = sw.toString();
                if (this.lessEnabled_() && this.postMergeLessCompile_()) {
                    try {
                        s = this.compileLess_(s);
                    }
                    catch (LessException e) {
                        logger_.warn((Object)("Error compile less content: " + e.getMessage()), (Throwable)e);
                    }
                    if (this.compress_) {
                        try {
                            this.compress(s, out);
                        }
                        catch (StackOverflowError e) {
                            logger_.error((Object)("fatal error compressing resource: " + e.getMessage()));
                        }
                    } else {
                        Minimizer.copy_(s, out);
                    }
                    break block19;
                }
                Minimizer.copy_(s, out);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (null != out) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        logger_.warn((Object)"cannot close output in minimizor", (Throwable)e);
                    }
                }
            }
        }
        return rsrc;
    }

    private String minimize_(List<String> resourceNames) {
        String fn;
        FileCache cache = this.cache_;
        if (this.useCache_ && null != (fn = cache.get(resourceNames))) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("cached file returned: " + fn));
            }
            return this.cacheUrlPath_ + fn;
        }
        IResource rsrc = this.minimize(resourceNames);
        String fn2 = rsrc.getKey();
        cache.put(resourceNames, fn2);
        try {
            String resourcesParamValue;
            StringBuilder builder = new StringBuilder();
            builder.append(this.cacheUrlPath_);
            builder.append(fn2);
            if (this.resourcesParam_ != null && (resourcesParamValue = this.encodeResourceNames(resourceNames)) != null) {
                builder.append("?");
                builder.append(this.resourcesParam_);
                builder.append("=");
                builder.append(URLEncoder.encode(resourcesParamValue, "utf8"));
            }
            return builder.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private String encodeResourceNames(List<String> resourceNames) {
        StringBuilder builder = new StringBuilder();
        for (String resourceName : resourceNames) {
            if ((resourceName = StringUtils.stripToNull((String)resourceName)) == null) continue;
            if (builder.length() > 0) {
                builder.append(',');
            }
            if (resourceName.startsWith(this.resourceUrlPath_)) {
                resourceName = resourceName.substring(this.resourceUrlPath_.length());
            }
            builder.append(resourceName);
        }
        return builder.length() > 0 ? builder.toString() : null;
    }

    private List<String> decodeResourceNames(String resourceNames) {
        String[] names = resourceNames.split("[,]");
        if (names.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> l = new ArrayList<String>(names.length);
        for (String name : names) {
            if ((name = StringUtils.stripToNull((String)name)) == null) continue;
            if (!name.startsWith("/")) {
                name = this.resourceUrlPath_ + name;
            }
            if (l.contains(name)) continue;
            l.add(name);
        }
        return l;
    }

    private boolean lessEnabled_() {
        if (ResourceType.CSS != this.type_) {
            return false;
        }
        boolean b = Boolean.parseBoolean(System.getProperty(SYS_PROP_LESS_ENABLED, "false"));
        return b;
    }

    private boolean coffeeEnabled_() {
        if (ResourceType.JS != this.type_) {
            return false;
        }
        boolean b = Boolean.parseBoolean(System.getProperty(SYS_PROP_COFFEE_ENABLED, "false"));
        return b;
    }

    private String processRelativeUrl_(String s, String fn) throws IOException {
        int p;
        if (ResourceType.CSS != this.type_) {
            throw new IllegalStateException("not a css minimizer");
        }
        if (this.rm_ != null) {
            fn = this.rm_.route(fn);
        }
        String string = fn = 0 == (p = fn.lastIndexOf("/") + 1) ? this.resourceUrlPath_ : fn.substring(0, p);
        String prefix = fn.startsWith("/") ? (fn.startsWith(this.resourceUrlPath_) ? fn : (fn.startsWith(this.resourceUrlRoot_) ? fn : this.resourceUrlRoot_ + fn.replaceFirst("/", ""))) : this.resourceUrlPath_ + fn;
        if (this.rm_ != null) {
            prefix = this.rm_.reverse(prefix);
        }
        try {
            Matcher m = P_URL.matcher(s);
            s = m.replaceAll("url(" + prefix + "$1)");
            return s;
        }
        catch (Throwable e) {
            System.err.println("Error process relative URL: " + fn);
            e.printStackTrace(System.err);
            return s;
        }
    }

    private String fileToString_(File f) throws IOException {
        BufferedReader r = new BufferedReader(new FileReader(f));
        String l = null;
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        while ((l = r.readLine()) != null) {
            sb.append(l);
            sb.append(ls);
        }
        r.close();
        return sb.toString();
    }

    private List<String> fileToLines_(File f) throws IOException {
        BufferedReader r = new BufferedReader(new FileReader(f));
        String l = null;
        ArrayList<String> lines = new ArrayList<String>();
        while ((l = r.readLine()) != null) {
            lines.add(l);
        }
        r.close();
        return lines;
    }

    private void merge_(File file, Writer out, String originalFn) {
        if (logger_.isTraceEnabled()) {
            logger_.trace((Object)("starting to minimize resource: " + file.getName()));
        }
        this.lastModifiedCache_.put(file, this.getLastModified(file));
        try {
            String s = this.preprocess_(file, originalFn);
            if (!(!this.compress_ || this.lessEnabled_() && this.postMergeLessCompile_())) {
                if (logger_.isTraceEnabled()) {
                    logger_.trace((Object)String.format("compressing %1$s ...", file.getName()));
                }
                if (null != s) {
                    this.compress(s, out);
                } else {
                    this.compress(file, out);
                }
            } else if (null != s) {
                Minimizer.copy_(s, out);
            } else {
                Minimizer.copy_(file, out);
            }
        }
        catch (IOException e) {
            logger_.warn((Object)("error processing javascript file file " + file.getName()), (Throwable)e);
        }
    }

    private String preprocess_(String s) {
        if (this.lessEnabled_()) {
            try {
                s = this.compileLess_(s);
            }
            catch (Exception e) {
                logger_.warn((Object)("process inline content: " + e.getMessage()));
            }
        }
        return s;
    }

    private boolean postMergeLessCompile_() {
        return Boolean.valueOf(System.getProperty("greenscript.lessCompile.postMerge", "false"));
    }

    private String preprocess_(File file) throws IOException {
        String s = null;
        if (this.lessEnabled_() && !this.postMergeLessCompile_()) {
            try {
                s = this.compileLess_(file);
            }
            catch (LessException e) {
                logger_.warn((Object)("error compile less file: " + file.getName() + ", error: " + e.getMessage()), (Throwable)e);
            }
        } else if (file.getName().endsWith(".coffee")) {
            try {
                s = this.coffee_.compile(this.fileToString_(file));
            }
            catch (JCoffeeScriptCompileException e) {
                logger_.error((Object)"error compile coffee script file", (Throwable)e);
            }
        }
        if (null == s) {
            s = this.fileToString_(file);
        }
        return s;
    }

    private String preprocess_(File file, String originalFn) throws IOException {
        String s = null;
        if (this.lessEnabled_() && !this.postMergeLessCompile_()) {
            try {
                s = this.compileLess_(file);
            }
            catch (LessException e) {
                logger_.warn((Object)("error compile less file: " + originalFn + ", error: " + e.getMessage()));
            }
        } else if (this.coffeeEnabled_() && file.getName().endsWith(".coffee")) {
            try {
                s = this.compileCoffee_(file);
            }
            catch (JCoffeeScriptCompileException e) {
                logger_.error((Object)"error compile coffee script file", (Throwable)e);
            }
        }
        if (null == s) {
            s = this.fileToString_(file);
        }
        if (ResourceType.CSS == this.type_) {
            s = this.processRelativeUrl_(s, originalFn);
        }
        return s;
    }

    private String getUrl_(String resourceName) {
        String s;
        String url = null;
        url = !"".equals(this.ctxPath_) && resourceName.startsWith(this.ctxPath_) ? resourceName : (resourceName.startsWith("/") ? ((s = this.ctxPath_ + resourceName).startsWith(this.resourceUrlRoot_) ? s : this.resourceUrlRoot_ + resourceName.substring(1, resourceName.length())) : this.resourceUrlPath_ + resourceName);
        return this.rm_ != null ? this.rm_.reverse(url) : url;
    }

    private File getFileFromURL_(String url) {
        return this.getFile_(this.rm_ != null ? this.rm_.route(url) : url);
    }

    private File getFile_(String resourceName) {
        if (resourceName.startsWith("/") && !resourceName.startsWith(this.ctxPath_)) {
            resourceName = this.ctxPath_ + resourceName;
        }
        if (resourceName.startsWith(this.resourceUrlPath_)) {
            resourceName = resourceName.replaceFirst(this.resourceUrlPath_, "");
        } else if (resourceName.startsWith(this.resourceUrlRoot_)) {
            resourceName = resourceName.replaceFirst(this.resourceUrlRoot_, "/");
        }
        String fn = resourceName;
        String path = fn.startsWith("/") ? (!fn.startsWith(this.rootDir_) ? this.rootDir_ + "/" + fn.replaceFirst("/", "") : fn) : this.resourcePath_ + "/" + fn;
        for (String ext : this.type_.getAllExtensions()) {
            String p = fn.endsWith(ext) ? path : path + ext;
            File f = this.fl_.locate(p);
            if (null == f) continue;
            return f;
        }
        return null;
    }

    private static void copy_(File file, Writer out) throws IOException {
        if (logger_.isTraceEnabled()) {
            logger_.trace((Object)String.format("merging file %1$s ...", file.getName()));
        }
        Minimizer.copy_(new FileReader(file), out);
    }

    public static void copy_(Reader in, Writer out) {
        String line = null;
        BufferedReader r = null;
        try {
            r = new BufferedReader(in);
            PrintWriter w = new PrintWriter(out);
            while ((line = r.readLine()) != null) {
                w.println(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (null != r) {
                try {
                    r.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static void copy_(String s, Writer out) {
        Minimizer.copy_(new StringReader(s), out);
    }

    private IResource newCache_(List<String> resourceNames) {
        if (this.inMemory_) {
            return this.bl_.newBuffer(resourceNames, this.type_.getExtension());
        }
        return new FileResource(this.newCacheFile_(resourceNames));
    }

    private File newCacheFile_(List<String> resourceNames) {
        String extension = this.type_.getExtension();
        return this.cache_.createTempFile(resourceNames, extension);
    }

    private void checkInitialize_(boolean initialized) {
        boolean notInited;
        boolean bl = notInited = this.resourcePath_ == null || this.rootDir_ == null || this.resourceUrlPath_ == null || this.cache_ == null || this.cacheUrlPath_ == null;
        if (initialized == notInited) {
            throw new IllegalStateException(initialized ? "minimizer not initialized" : "minimizer already initialized");
        }
    }

    public ResourceType getType() {
        return this.type_;
    }

    private final boolean isCDN_(String resourceName) {
        if (null == resourceName) {
            return false;
        }
        Matcher m = P_CDN_PREFIX.matcher(resourceName);
        return m.find();
    }

    public void setResourcesParam(String resourcesParam_) {
        this.resourcesParam_ = resourcesParam_;
    }
}

