/*
 * Decompiled with CFR 0.152.
 */
package com.asual.lesscss;

import com.asual.lesscss.EngineCache;
import com.asual.lesscss.EngineException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jruby.Ruby;
import org.jruby.RubyRuntimeAdapter;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaEmbedUtils;

public class Engine {
    private Ruby runtime;
    private RubyRuntimeAdapter adapter;
    private EngineCache cache;
    private final Log logger = LogFactory.getLog(this.getClass());

    public Engine() {
        ArrayList<String> loadPaths = new ArrayList<String>();
        loadPaths.add("META-INF/jruby.home/lib/ruby/site_ruby/1.8");
        loadPaths.add("META-INF/lesscss/lib");
        this.runtime = JavaEmbedUtils.initialize(loadPaths);
        this.adapter = JavaEmbedUtils.newRuntimeAdapter();
        this.cache = new EngineCache();
    }

    public void destroy() {
        JavaEmbedUtils.terminate((Ruby)this.runtime);
    }

    public String parse(String source) throws EngineException {
        try {
            return ((RubyString)this.adapter.eval(this.runtime, "require 'less' \nLess::Engine.new('" + source.replaceAll("'", "\"") + "').to_css")).toString().trim();
        }
        catch (Exception e) {
            this.logger.error((Object)"Compilation error.");
            throw new EngineException("Compilation error.", e);
        }
    }

    public String compile(File source) throws EngineException, IOException {
        return this.compile(source, this.cache);
    }

    public String compile(URL source) throws EngineException, IOException {
        return this.compile(source, this.cache);
    }

    private String compile(File source, EngineCache cache) throws EngineException, IOException {
        String path = source.getAbsolutePath();
        String folder = path.replace(source.getName(), "");
        if (source.exists()) {
            Long lastModified = source.lastModified();
            if (!cache.contains(path) || cache.contains(path) && cache.getLastModified(path) < lastModified || this.areImportsModified(cache.getImports(path))) {
                String content = this.readFile(source);
                Pattern p = Pattern.compile("@import\\s+(\"[^\"]*\"|'[^']*')");
                Matcher m = p.matcher(content);
                while (m.find()) {
                    this.compile(new File(String.valueOf(folder) + m.group(1).replaceAll("\"|'", "")), cache.getImports(path));
                }
                if (cache == this.cache) {
                    this.logger.info((Object)("Compiling '" + path + "'."));
                    cache.setContent(path, ((RubyString)this.adapter.eval(this.runtime, "require 'less' \nLess::Engine.new(File.new('" + path + "')).to_css")).toString().trim()).setLastModified(path, lastModified);
                } else {
                    cache.setContent(path, content).setLastModified(path, lastModified);
                }
            }
            return cache.getContent(path);
        }
        this.logger.error((Object)("The file '" + path + "' doesn't exist."));
        throw new IOException("The file '" + path + "' doesn't exist.");
    }

    private String compile(URL source, EngineCache cache) throws EngineException, IOException {
        if (source != null) {
            String path = source.getFile();
            String folder = path.substring(0, path.lastIndexOf(System.getProperty("file.separator")) + 1);
            Long lastModified = source.openConnection().getLastModified();
            if (!cache.contains(path) || cache.contains(path) && cache.getLastModified(path) < lastModified || this.areImportsModified(cache.getImports(path))) {
                String content = this.readURL(source);
                Pattern p = Pattern.compile("@import\\s+(\"[^\"]*\"|'[^']*')");
                Matcher m = p.matcher(content);
                while (m.find()) {
                    this.compile(new File(String.valueOf(folder) + m.group(1).replaceAll("\"|'", "")), cache.getImports(path));
                }
                if (cache == this.cache) {
                    this.logger.info((Object)("Compiling: " + path));
                    cache.setContent(path, ((RubyString)this.adapter.eval(this.runtime, "require 'less' \nLess::Engine.new(File.new('" + path + "')).to_css")).toString().trim()).setLastModified(path, lastModified);
                } else {
                    cache.setContent(path, content).setLastModified(path, lastModified);
                }
            }
            return cache.getContent(path);
        }
        this.logger.error((Object)"The requested URL doesn't exist.");
        throw new IOException("The requested URL doesn't exist.");
    }

    private boolean areImportsModified(EngineCache cache) {
        for (String key : cache.keySet()) {
            if (new File(key).lastModified() <= cache.getLastModified(key) && !this.areImportsModified(cache.getImports(key))) continue;
            return true;
        }
        return false;
    }

    private String readURL(URL source) throws IOException {
        StringBuilder sb = new StringBuilder();
        URLConnection urlc = source.openConnection();
        BufferedReader br = new BufferedReader(new InputStreamReader(urlc.getInputStream()));
        try {
            String line = "";
            while (line != null) {
                sb.append(line);
                line = br.readLine();
            }
        }
        catch (IOException e) {
            this.logger.error((Object)("Can't read '" + source.getFile() + "'."));
            throw e;
        }
        return sb.toString();
    }

    private String readFile(File source) throws IOException {
        String separator = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        try {
            BufferedReader input = new BufferedReader(new FileReader(source));
            try {
                String line = null;
                while ((line = input.readLine()) != null) {
                    sb.append(line).append(separator);
                }
            }
            finally {
                input.close();
            }
        }
        catch (IOException e) {
            this.logger.error((Object)("Can't read '" + source.getAbsolutePath() + "'."));
            throw e;
        }
        return sb.toString();
    }
}

