/*
 * Decompiled with CFR 0.152.
 */
package com.greenscriptool;

import com.greenscriptool.IFileLocator;
import com.greenscriptool.IMinimizer;
import com.greenscriptool.ResourceType;
import com.greenscriptool.utils.FileCache;
import com.greenscriptool.utils.GreenScriptCompressor;
import com.greenscriptool.utils.ICompressor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Minimizer
implements IMinimizer {
    private static Log logger_ = LogFactory.getLog(Minimizer.class);
    private boolean minimize_;
    private boolean compress_;
    private boolean useCache_;
    private boolean verifyResource_;
    private FileCache cache_;
    private String resourceDir_;
    private String rootDir_;
    private String resourceUrlPath_;
    private String cacheUrlPath_;
    private ICompressor compressor_;
    private ResourceType type_;
    private IFileLocator fl_ = new IFileLocator(){

        public File locate(String path) {
            return new File(path);
        }
    };

    public Minimizer(ResourceType type) {
        this(new GreenScriptCompressor(type), type);
    }

    @Inject
    public Minimizer(ICompressor compressor, ResourceType type) {
        if (null == compressor) {
            throw new NullPointerException();
        }
        this.compressor_ = compressor;
        this.type_ = type;
    }

    @Override
    public void enableDisableMinimize(boolean enable) {
        this.minimize_ = enable;
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("minimize " + (enable ? "enabled" : "disabled")));
        }
    }

    @Override
    public void enableDisableCompress(boolean enable) {
        this.compress_ = enable;
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("compress " + (enable ? "enabled" : "disabled")));
        }
        this.clearCache();
    }

    @Override
    public void enableDisableCache(boolean enable) {
        this.useCache_ = enable;
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("cache " + (enable ? "enabled" : "disabled")));
        }
    }

    public void enableDisableVerifyResource(boolean verify) {
        this.verifyResource_ = verify;
    }

    @Override
    public boolean isMinimizeEnabled() {
        return this.minimize_;
    }

    @Override
    public boolean isCompressEnabled() {
        return this.compress_;
    }

    @Override
    public boolean isCacheEnabled() {
        return this.useCache_;
    }

    @Override
    public void setResourceDir(String dir) {
        this.checkInitialize_(false);
        this.resourceDir_ = dir;
    }

    @Override
    public void setRootDir(String dir) {
        this.checkInitialize_(false);
        this.rootDir_ = dir;
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)String.format("root dir set to %1$s", dir));
        }
    }

    @Override
    public void setCacheDir(File dir) {
        if (!dir.isDirectory() && !dir.mkdir()) {
            throw new IllegalArgumentException("not a dir");
        }
        this.checkInitialize_(false);
        this.cache_ = new FileCache(dir);
    }

    @Override
    public void setResourceUrlPath(String urlPath) {
        if (!urlPath.startsWith("/")) {
            throw new IllegalArgumentException("url path must start with /");
        }
        this.checkInitialize_(false);
        if (!urlPath.endsWith("/")) {
            urlPath = urlPath + "/";
        }
        this.resourceUrlPath_ = urlPath;
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)String.format("url root set to %1$s", urlPath));
        }
    }

    @Override
    public void setCacheUrlPath(String urlPath) {
        if (!urlPath.startsWith("/")) {
            throw new IllegalArgumentException("resource url path must start with /");
        }
        this.checkInitialize_(false);
        if (!urlPath.endsWith("/")) {
            urlPath = urlPath + "/";
        }
        this.cacheUrlPath_ = urlPath;
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)String.format("cache url root set to %1$s", urlPath));
        }
    }

    @Override
    public void clearCache() {
        this.cache_.clear();
    }

    @Override
    public void setFileLocator(IFileLocator fileLocator) {
        if (null == fileLocator) {
            throw new NullPointerException();
        }
        this.fl_ = fileLocator;
    }

    @Override
    public List<String> process(List<String> resourceNames) {
        this.checkInitialize_(true);
        if (resourceNames.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.minimize_) {
            return this.minimize_(resourceNames);
        }
        ArrayList<String> l = new ArrayList<String>();
        String urlPath = this.resourceUrlPath_;
        for (String fn : resourceNames) {
            File f;
            if (fn.startsWith("http")) {
                l.add(fn);
                continue;
            }
            String s = fn.replace(this.type_.getExtension(), "");
            if ((this.verifyResource_ || s.equalsIgnoreCase("default") || s.endsWith(".bundle")) && (null == (f = this.getFile_(fn)) || !f.isFile())) continue;
            String ext = this.type_.getExtension();
            String string = fn = fn.endsWith(ext) ? fn : fn + ext;
            if (fn.startsWith("/")) {
                l.add(fn);
                continue;
            }
            l.add(urlPath + fn);
        }
        return l;
    }

    private List<String> minimize_(List<String> resourceNames) {
        String fn;
        FileCache cache = this.cache_;
        ArrayList<String> l = new ArrayList<String>();
        if (this.useCache_ && null != (fn = cache.get(resourceNames))) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("cached file returned: " + fn));
            }
            l.add(this.cacheUrlPath_ + fn);
            for (String s : resourceNames) {
                if (!s.startsWith("http")) continue;
                l.add(s);
            }
            return l;
        }
        File outFile = this.newCacheFile_();
        Writer out = null;
        try {
            out = new BufferedWriter(new FileWriter(outFile, true));
            for (String s : resourceNames) {
                if (s.startsWith("http:")) {
                    l.add(s);
                    continue;
                }
                File f = this.getFile_(s);
                if (null == f || !f.exists()) continue;
                this.merge_(f, out);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger_.warn((Object)"cannot close output in minimizor", (Throwable)e);
                }
            }
        }
        String fn2 = outFile.getName();
        cache.put(resourceNames, fn2);
        l.add(this.cacheUrlPath_ + fn2);
        return l;
    }

    private void merge_(File file, Writer out) {
        if (logger_.isTraceEnabled()) {
            logger_.trace((Object)("starting to minimize resource: " + file.getName()));
        }
        try {
            if (this.compress_) {
                try {
                    this.compressor_.compress(file, out);
                }
                catch (Exception e) {
                    logger_.warn((Object)String.format("error minimizing file %1$s", file.getName()), (Throwable)e);
                    Minimizer.copy_(file, out);
                }
            } else {
                Minimizer.copy_(file, out);
            }
        }
        catch (IOException e) {
            logger_.warn((Object)("error processing javascript file file " + file.getName()), (Throwable)e);
        }
    }

    private File getFile_(String resourceName) {
        String fn = resourceName;
        String ext = this.type_.getExtension();
        fn = fn.endsWith(ext) ? fn : fn + ext;
        String path = fn.startsWith("/") ? this.rootDir_ + fn : this.rootDir_ + File.separator + this.resourceDir_ + File.separator + fn;
        return this.fl_.locate(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy_(File file, Writer out) throws IOException {
        if (logger_.isTraceEnabled()) {
            logger_.trace((Object)String.format("merging file %1$s ...", file.getName()));
        }
        String line = null;
        BufferedReader r = null;
        try {
            r = new BufferedReader(new FileReader(file));
            PrintWriter writer = new PrintWriter(out);
            while ((line = r.readLine()) != null) {
                writer.println(line);
            }
        }
        finally {
            if (null != r) {
                r.close();
            }
        }
    }

    private File newCacheFile_() {
        String extension = this.type_.getExtension();
        return this.cache_.createTempFile(extension);
    }

    private void checkInitialize_(boolean initialized) {
        boolean notInited;
        boolean bl = notInited = this.resourceDir_ == null || this.rootDir_ == null || this.resourceUrlPath_ == null || this.cache_ == null || this.cacheUrlPath_ == null;
        if (initialized == notInited) {
            throw new IllegalStateException(initialized ? "minimizer not initialized" : "minimizer already initialized");
        }
    }

    public ResourceType getType() {
        return this.type_;
    }
}

