/*
 * Decompiled with CFR 0.152.
 */
package com.greenscriptool;

import com.greenscriptool.IDependenceManager;
import com.greenscriptool.IMinimizer;
import com.greenscriptool.IRenderSession;
import com.greenscriptool.ResourceType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.inject.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderSession
implements IRenderSession {
    private static Log logger_ = LogFactory.getLog(IRenderSession.class);
    private IMinimizer m_ = null;
    private IDependenceManager d_ = null;
    private ResourceType type_ = null;
    private Set<Resource> declared_ = new HashSet<Resource>();
    private Set<String> loaded_ = new HashSet<String>();
    private SortedMap<Integer, StringBuffer> inlines_ = new TreeMap<Integer, StringBuffer>();

    public ResourceType getResourceType() {
        return this.type_;
    }

    @Inject
    public RenderSession(IMinimizer minimizer, IDependenceManager depMgr, ResourceType type) {
        if (null == minimizer || null == depMgr) {
            throw new NullPointerException();
        }
        this.m_ = minimizer;
        this.d_ = depMgr;
        this.type_ = type;
    }

    @Override
    public void declareInline(String inline, int priority) {
        StringBuffer sb = (StringBuffer)this.inlines_.get(priority = -1 * priority);
        if (null == sb) {
            sb = new StringBuffer();
            this.inlines_.put(priority, sb);
        }
        sb.append("\n").append(inline);
    }

    @Override
    public void declare(String nameList, String media, String browser) {
        this.d_.processInlineDependency(nameList);
        String[] sa = nameList.split("[ ,;<>]");
        media = this.canonical_(media);
        browser = this.canonical_(browser);
        for (String name : sa) {
            this.declared_.add(new Resource(name, media, browser));
        }
    }

    @Override
    public void declare(List<String> nameList, String media, String browser) {
        media = this.canonical_(media);
        browser = this.canonical_(browser);
        for (String name : nameList) {
            this.declared_.add(new Resource(name, media, browser));
        }
    }

    @Override
    public List<String> output(String nameList, boolean withDependencies, boolean all, String media, String browser) {
        if (null != nameList) {
            this.declare(nameList, null, null);
        }
        List<String> l = null;
        if (all) {
            l = this.d_.comprehend(this.getByMediaAndBrowser_(media, browser), true);
        } else if (withDependencies) {
            l = this.d_.comprehend(nameList);
        } else if (null != nameList) {
            String[] sa;
            l = new ArrayList<String>();
            for (String s : sa = nameList.split("[ ,;<>]")) {
                if (l.contains(s)) continue;
                l.add(s);
            }
        } else {
            l = Collections.emptyList();
        }
        l = l.isEmpty() ? l : this.m_.process(l);
        l.removeAll(this.loaded_);
        this.loaded_.addAll(l);
        if (logger_.isTraceEnabled()) {
            logger_.trace((Object)("output items: " + l));
        }
        return l;
    }

    @Override
    public String outputInline() {
        StringBuilder all = new StringBuilder();
        for (StringBuffer sb : this.inlines_.values()) {
            all.append(sb);
            sb.delete(0, sb.length());
        }
        return all.toString();
    }

    public boolean isDefault(String s) {
        s = this.canonical_(s);
        return s.equalsIgnoreCase("__def__");
    }

    private String canonical_(String s) {
        if (null == s) {
            return "__def__";
        }
        return s.trim().replaceAll("\\s+", " ");
    }

    private Set<String> getByMediaAndBrowser_(String media, String browser) {
        HashSet<String> set = new HashSet<String>();
        media = this.canonical_(media);
        browser = this.canonical_(browser);
        for (Resource r : this.declared_) {
            if (!r.media.equalsIgnoreCase(media) || !r.browser.equalsIgnoreCase(browser)) continue;
            set.add(r.name);
        }
        set.removeAll(this.loaded_);
        return set;
    }

    @Override
    public Set<String> getMedias(String browser) {
        HashSet<String> set = new HashSet<String>();
        browser = this.canonical_(browser);
        for (Resource r : this.declared_) {
            if (!r.browser.equalsIgnoreCase(browser)) continue;
            set.add(r.media);
        }
        set.remove("__def__");
        return set;
    }

    @Override
    public Set<String> getBrowsers() {
        HashSet<String> set = new HashSet<String>();
        for (Resource r : this.declared_) {
            set.add(r.browser);
        }
        set.remove("__def__");
        return set;
    }

    @Override
    public boolean hasDeclared() {
        return this.declared_.size() > 0;
    }

    private class Resource {
        String name;
        String media;
        String browser;

        public Resource(String name, String media, String browser) {
            if (null == name) {
                throw new NullPointerException();
            }
            this.name = name;
            this.media = null == media ? "__def__" : media;
            this.browser = null == browser ? "__def__" : browser;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Resource)) {
                return false;
            }
            Resource that = (Resource)obj;
            return that.name.equals(this.name) && that.media.equals(this.media) && that.browser.equals(this.browser);
        }

        public int hashCode() {
            int ret = 17;
            ret = ret * 31 + this.name.hashCode();
            ret = ret * 31 + this.media.hashCode();
            ret = ret * 31 + this.browser.hashCode();
            return ret;
        }

        public String toString() {
            return this.name;
        }
    }
}

