/*
 * Decompiled with CFR 0.152.
 */
package play.modules.grizzly;

import com.sun.grizzly.arp.AsyncExecutor;
import java.util.HashMap;
import java.util.Map;
import play.Invoker;
import play.Play;
import play.PlayPlugin;
import play.modules.grizzly.PlayAdapter;
import play.mvc.ActionInvoker;
import play.mvc.Http;
import play.mvc.Router;
import play.mvc.results.NotFound;
import play.mvc.results.RenderStatic;

public class GrizzlyInvocation
extends Invoker.Invocation {
    Map<String, RenderStatic> staticPathsCache = new HashMap<String, RenderStatic>();
    AsyncExecutor asyncExecutor;

    public GrizzlyInvocation(AsyncExecutor ae) {
        this.asyncExecutor = ae;
    }

    public boolean init() {
        try {
            this.asyncExecutor.preExecute();
            this.asyncExecutor.execute();
            Http.Request request = Http.Request.current();
            boolean raw = false;
            for (PlayPlugin plugin : Play.plugins) {
                if (!plugin.rawInvocation(request, Http.Response.current())) continue;
                raw = true;
                break;
            }
            if (raw) {
                PlayAdapter.copyResponse();
                return false;
            }
            if (!request.path.equals("/favicon.ico")) {
                super.init();
            }
            if (Play.mode == Play.Mode.PROD && this.staticPathsCache.containsKey(request.path)) {
                PlayAdapter.serveStatic(this.staticPathsCache.get(request.path));
                return false;
            }
            try {
                Router.routeOnlyStatic((Http.Request)Http.Request.current());
            }
            catch (NotFound e) {
                PlayAdapter.serve404(e);
                return false;
            }
            catch (RenderStatic e) {
                if (Play.mode == Play.Mode.PROD) {
                    this.staticPathsCache.put(request.path, e);
                }
                PlayAdapter.serveStatic(e);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            PlayAdapter.serve500(e);
            return true;
        }
    }

    public void run() {
        try {
            super.run();
        }
        catch (Exception e) {
            PlayAdapter.serve500(e);
            return;
        }
    }

    public void execute() throws Exception {
        ActionInvoker.invoke((Http.Request)Http.Request.current(), (Http.Response)Http.Response.current());
        PlayAdapter.copyResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _finally() {
        try {
            super._finally();
        }
        finally {
            try {
                this.asyncExecutor.postExecute();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String toString() {
        return "Request " + Http.Request.current();
    }
}

