/*
 * Decompiled with CFR 0.152.
 */
package play.modules.grizzly;

import com.sun.grizzly.arp.AsyncExecutor;
import com.sun.grizzly.arp.AsyncFilter;
import com.sun.grizzly.http.embed.GrizzlyWebServer;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Properties;
import java.util.logging.Level;
import play.Invoker;
import play.Logger;
import play.Play;
import play.modules.grizzly.GrizzlyInvocation;
import play.modules.grizzly.PlayAdapter;

public class Server {
    GrizzlyWebServer ws;

    public Server() {
        java.util.logging.Logger.getLogger("").setLevel(Level.OFF);
        Properties p = Play.configuration;
        int httpPort = Integer.parseInt(p.getProperty("http.port", "9000"));
        InetAddress address = null;
        if (System.getProperties().containsKey("http.port")) {
            httpPort = Integer.parseInt(System.getProperty("http.port"));
        }
        try {
            if (p.getProperty("http.address") != null) {
                address = InetAddress.getByName(p.getProperty("http.address"));
            }
            if (System.getProperties().containsKey("http.address")) {
                address = InetAddress.getByName(System.getProperty("http.address"));
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e, (String)"Could not understand http.address", (Object[])new Object[0]);
            System.exit(-1);
        }
        this.ws = new GrizzlyWebServer(httpPort);
        if (Play.mode == Play.Mode.DEV) {
            this.ws.setCoreThreads(1);
            this.ws.setMaxThreads(1);
        }
        this.ws.useAsynchronousWrite(true);
        this.ws.addAsyncFilter(new AsyncFilter(){

            public boolean doFilter(AsyncExecutor ae) {
                Invoker.invoke((Invoker.Invocation)new GrizzlyInvocation(ae));
                return false;
            }
        });
        this.ws.addGrizzlyAdapter((GrizzlyAdapter)new PlayAdapter(), new String[]{"/"});
        try {
            this.ws.start();
            if (Play.mode == Play.Mode.DEV) {
                if (address == null) {
                    Logger.info((String)"Listening for HTTP on port %s (Waiting a first request to start) ...", (Object[])new Object[]{httpPort});
                } else {
                    Logger.info((String)"Listening for HTTP at %2$s:%1$s (Waiting a first request to start) ...", (Object[])new Object[]{httpPort, address});
                }
            } else if (address == null) {
                Logger.info((String)"Listening for HTTP on port %s ...", (Object[])new Object[]{httpPort});
            } else {
                Logger.info((String)"Listening for HTTP at %2$s:%1$s  ...", (Object[])new Object[]{httpPort, address});
            }
        }
        catch (IOException e) {
            Logger.error((String)("Could not bind on port " + httpPort), (Object[])new Object[]{e});
            this.ws.stop();
            System.exit(-1);
        }
    }

    public static void main(String[] args) throws Exception {
        File root = new File(System.getProperty("application.path"));
        Play.init((File)root, (String)System.getProperty("play.id", ""));
        if (System.getProperty("precompile") == null) {
            new Server();
        } else {
            Logger.info((String)"Done.", (Object[])new Object[0]);
        }
    }
}

