/*
 * Decompiled with CFR 0.152.
 */
package play.modules.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.List;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.inject.BeanSource;
import play.inject.Injector;
import play.modules.guice.GuiceSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuicePlugin
extends PlayPlugin
implements BeanSource {
    com.google.inject.Injector injector;

    public void onApplicationStart() {
        ArrayList<Module> modules = new ArrayList<Module>();
        List ll = Play.classloader.getAllClasses();
        Logger.debug((String)"Starting Guice modules scanning", (Object[])new Object[0]);
        Boolean newInjectorNeeded = true;
        StringBuffer moduleList = new StringBuffer();
        for (Class clz : ll) {
            if (clz.getSuperclass() != null && GuiceSupport.class.isAssignableFrom(clz)) {
                try {
                    GuiceSupport gs = (GuiceSupport)clz.newInstance();
                    this.injector = gs.configure();
                    newInjectorNeeded = false;
                    Logger.info((String)("Guice injector was found: " + clz.getName()), (Object[])new Object[0]);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IllegalStateException("Unable to create Guice Injector for " + clz.getName());
                }
            }
            if (clz.getSuperclass() == null || !AbstractModule.class.isAssignableFrom(clz)) continue;
            try {
                modules.add((Module)clz.newInstance());
                moduleList.append(clz.getName() + " ");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalStateException("Unable to create Guice module for " + clz.getName());
            }
        }
        if (newInjectorNeeded.booleanValue() && modules.isEmpty()) {
            throw new IllegalStateException("could not find any custom guice injector or abstract modules. Are you sure you have at least one on the classpath?");
        }
        if (!modules.isEmpty() && newInjectorNeeded.booleanValue()) {
            Logger.info((String)("Guice modules were found: " + moduleList), (Object[])new Object[0]);
            this.injector = Guice.createInjector(modules);
        }
        Injector.inject((BeanSource)this);
    }

    public <T> T getBeanOfType(Class<T> clazz) {
        if (this.injector == null) {
            return null;
        }
        return (T)this.injector.getInstance(clazz);
    }
}

