/*
 * Decompiled with CFR 0.152.
 */
package play.modules.guice;

import com.google.inject.AbstractModule;
import com.google.inject.BindingAnnotation;
import com.google.inject.ConfigurationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Named;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.inject.BeanSource;
import play.modules.guice.GuiceSupport;
import play.modules.guice.InjectSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuicePlugin
extends PlayPlugin
implements BeanSource {
    private Injector injector;
    private final List<Module> modules = new ArrayList<Module>();

    public void onApplicationStart() {
        Logger.debug((String)"Starting Guice modules scanning", (Object[])new Object[0]);
        this.loadInjector();
        play.inject.Injector.inject((BeanSource)this);
        this.injectAnnotated();
    }

    private void loadInjector() {
        try {
            for (Class clazz : Play.classloader.getAllClasses()) {
                if (clazz.getSuperclass() == null) continue;
                if (this.isCustomInjector(clazz)) {
                    this.loadCustomInjector(clazz);
                    return;
                }
                if (!this.isGuiceModule(clazz)) continue;
                this.modules.add((Module)clazz.newInstance());
            }
            this.loadInjectorFromModules();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create Guice injector");
        }
    }

    private boolean isCustomInjector(Class clazz) {
        return GuiceSupport.class.isAssignableFrom(clazz);
    }

    private boolean isGuiceModule(Class clazz) {
        return AbstractModule.class.isAssignableFrom(clazz);
    }

    private void loadCustomInjector(Class clazz) throws InstantiationException, IllegalAccessException {
        GuiceSupport gs = (GuiceSupport)clazz.newInstance();
        this.injector = gs.configure();
        Logger.info((String)("Guice injector created: " + clazz.getName()), (Object[])new Object[0]);
    }

    private void loadInjectorFromModules() {
        if (this.modules.isEmpty()) {
            throw new IllegalStateException("Could not find any custom guice injector or abstract modules. Are you sure you have at least one on the classpath?");
        }
        this.injector = Guice.createInjector(this.modules);
        Logger.info((String)("Guice injector created with modules: " + this.moduleList()), (Object[])new Object[0]);
    }

    private String moduleList() {
        StringBuilder moduleList = new StringBuilder("\n");
        for (Module module : this.modules) {
            moduleList.append(module.getClass());
            moduleList.append("\n");
        }
        return moduleList.toString();
    }

    public <T> T getBeanOfType(Class<T> clazz) {
        if (this.injector == null) {
            return null;
        }
        try {
            return (T)this.injector.getInstance(clazz);
        }
        catch (ConfigurationException e) {
            Logger.error((String)e.getMessage(), (Object[])new Object[0]);
            return null;
        }
    }

    public <T> T getBeanWithKey(Key<T> key) {
        if (this.injector == null) {
            return null;
        }
        return (T)this.injector.getInstance(key);
    }

    private void injectAnnotated() {
        try {
            for (Class clazz : Play.classloader.getAnnotatedClasses(InjectSupport.class)) {
                for (Field field : clazz.getDeclaredFields()) {
                    if (!this.isInjectable(field)) continue;
                    this.inject(field);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error injecting dependencies", e);
        }
    }

    private boolean isInjectable(Field field) {
        return Modifier.isStatic(field.getModifiers()) && field.isAnnotationPresent(Inject.class);
    }

    private void inject(Field field) throws IllegalAccessException {
        field.setAccessible(true);
        Annotation fieldBinding = this.fieldBinding(field);
        if (fieldBinding != null) {
            field.set(null, this.getBeanWithKey(Key.get(field.getType(), (Annotation)fieldBinding)));
        } else {
            field.set(null, this.getBeanOfType(field.getType()));
        }
    }

    private Annotation fieldBinding(Field field) {
        for (Annotation annotation : field.getAnnotations()) {
            if (annotation.annotationType().equals(Named.class)) {
                return annotation;
            }
            for (Annotation internal : annotation.annotationType().getAnnotations()) {
                if (!internal.annotationType().equals(BindingAnnotation.class)) continue;
                return annotation;
            }
        }
        return null;
    }
}

