/*
 * Decompiled with CFR 0.152.
 */
package play.modules.gwt2;

import play.Play;
import play.PlayPlugin;
import play.exceptions.JavaExecutionException;
import play.exceptions.PlayException;
import play.modules.gwt2.GWT2Service;
import play.modules.gwt2.GWT2ServicePath;
import play.mvc.Http;
import play.mvc.Router;
import play.mvc.results.RedirectToStatic;
import play.mvc.results.RenderText;
import play.vfs.VirtualFile;

public class GWT2Plugin
extends PlayPlugin {
    public void onRoutesLoaded() {
        boolean useDefault = true;
        for (Router.Route route : Router.routes) {
            if (!route.action.contains("gwt-public")) continue;
            useDefault = false;
            break;
        }
        if (useDefault) {
            Router.addRoute((String)"GET", (String)"/app", (String)"staticDir:gwt-public");
        }
        Router.addRoute((String)"GET", (String)"/@gwt", (String)"dummy.dummy");
    }

    public void routeRequest(Http.Request request) {
        if (request.path.equals("/@gwt")) {
            throw new RedirectToStatic(Router.reverse((VirtualFile)Play.getVirtualFile((String)"/gwt-public/index.html")));
        }
        if (request.method == "POST") {
            for (Class service : Play.classloader.getAnnotatedClasses(GWT2ServicePath.class)) {
                String path = service.getAnnotation(GWT2ServicePath.class).value();
                if (!request.path.equals("/app" + path)) continue;
                this.invokeService(service);
                break;
            }
        }
    }

    public void invokeService(Class service) {
        String result = "";
        if (GWT2Service.class.isAssignableFrom(service)) {
            try {
                result = ((GWT2Service)service.newInstance()).invoke();
            }
            catch (Exception ex) {
                if (ex instanceof PlayException) {
                    throw (PlayException)ex;
                }
                StackTraceElement element = PlayException.getInterestingStrackTraceElement((Throwable)ex);
                if (element != null) {
                    throw new JavaExecutionException(Play.classes.getApplicationClass(element.getClassName()), Integer.valueOf(element.getLineNumber()), (Throwable)ex);
                }
                throw new JavaExecutionException((Throwable)ex);
            }
        }
        throw new RenderText((CharSequence)result);
    }
}

