/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.impl.MapOperationStatsImpl;
import com.hazelcast.monitor.LocalMapOperationStats;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapOperationsCounter {
    private static final LocalMapOperationStats empty = new MapOperationStatsImpl();
    private final AtomicLong puts = new AtomicLong();
    private final AtomicLong gets = new AtomicLong();
    private final AtomicLong removes = new AtomicLong();
    private final AtomicLong others = new AtomicLong();
    private final AtomicLong events = new AtomicLong();
    private final List<MapOperationsCounter> listOfSubStats = new ArrayList<MapOperationsCounter>();
    private final long interval;
    private final Object lock = new Object();
    private volatile LocalMapOperationStats published = null;
    private long startTime = this.now();
    private long endTime = Long.MAX_VALUE;

    public MapOperationsCounter() {
        this(5000L);
    }

    public MapOperationsCounter(long interval) {
        this.interval = interval;
    }

    private MapOperationsCounter getAndReset() {
        long putsNow = this.puts.getAndSet(0L);
        long getsNow = this.gets.getAndSet(0L);
        long removesNow = this.removes.getAndSet(0L);
        long othersNow = this.others.getAndSet(0L);
        long eventsNow = this.events.getAndSet(0L);
        MapOperationsCounter newOne = new MapOperationsCounter();
        newOne.puts.set(putsNow);
        newOne.gets.set(getsNow);
        newOne.removes.set(removesNow);
        newOne.others.set(othersNow);
        newOne.events.set(eventsNow);
        newOne.startTime = this.startTime;
        this.startTime = newOne.endTime = this.now();
        return newOne;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalMapOperationStats getPublishedStats() {
        if (this.published == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.published == null) {
                    this.published = this.getThis();
                }
            }
        }
        if (this.published.getPeriodEnd() < this.now() - this.interval) {
            return empty;
        }
        return this.published;
    }

    public void incrementPuts() {
        this.puts.incrementAndGet();
        this.publishSubResult();
    }

    public void incrementGets() {
        this.gets.incrementAndGet();
        this.publishSubResult();
    }

    public void incrementRemoves() {
        this.removes.incrementAndGet();
        this.publishSubResult();
    }

    public void incrementOtherOperations() {
        this.others.incrementAndGet();
        this.publishSubResult();
    }

    public void incrementReceivedEvents() {
        this.events.incrementAndGet();
        this.publishSubResult();
    }

    long now() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishSubResult() {
        long subInterval = this.interval / 5L;
        if (this.now() - this.startTime > subInterval) {
            Object object = this.lock;
            synchronized (object) {
                if (this.now() - this.startTime >= subInterval) {
                    MapOperationsCounter copy = this.getAndReset();
                    if (this.listOfSubStats.size() == 5) {
                        this.listOfSubStats.remove(0);
                    }
                    this.listOfSubStats.add(copy);
                    this.published = this.aggregate(this.listOfSubStats);
                }
            }
        }
    }

    private LocalMapOperationStats aggregate(List<MapOperationsCounter> list) {
        MapOperationStatsImpl stats = new MapOperationStatsImpl();
        stats.periodStart = list.get((int)0).startTime;
        for (int i = 0; i < list.size(); ++i) {
            MapOperationsCounter sub = list.get(i);
            stats.numberOfGets += sub.gets.get();
            stats.numberOfPuts += sub.puts.get();
            stats.numberOfRemoves += sub.removes.get();
            stats.numberOfOtherOperations += sub.others.get();
            stats.numberOfEvents += sub.events.get();
            stats.periodEnd = sub.endTime;
        }
        return stats;
    }

    private LocalMapOperationStats getThis() {
        MapOperationStatsImpl stats = new MapOperationStatsImpl();
        stats.periodStart = this.startTime;
        stats.numberOfGets = this.gets.get();
        stats.numberOfPuts = this.puts.get();
        stats.numberOfRemoves = this.removes.get();
        stats.numberOfEvents = this.events.get();
        stats.periodEnd = this.now();
        return stats;
    }

    public String toString() {
        return "MapOperationsCounter{empty=" + empty + ", puts=" + this.puts + ", gets=" + this.gets + ", removes=" + this.removes + ", others=" + this.others + ", events=" + this.events + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", published=" + this.published + ", listOfSubStats=" + this.listOfSubStats + ", lock=" + this.lock + ", interval=" + this.interval + '}';
    }
}

